/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project;

import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.data.ProjectFileManager;
import ghidra.framework.data.TransientDataManager;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.model.ProjectViewListener;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolManager;
import ghidra.framework.model.ToolServices;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.options.SaveState;
import ghidra.framework.project.DefaultProjectManager;
import ghidra.framework.project.tool.GhidraToolTemplate;
import ghidra.framework.project.tool.ToolManagerImpl;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.protocol.ghidra.GhidraURLConnection;
import ghidra.framework.store.LockException;
import ghidra.util.Msg;
import ghidra.util.NotOwnerException;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.xml.GenericXMLOutputter;
import ghidra.util.xml.XmlUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class DefaultProject
implements Project {
    private static final String OPEN_VIEW_XML_NAME = "OPEN_VIEW";
    private static final String OPEN_REPOSITORY_VIEW_XML_NAME = "OPEN_REPOSITORY_VIEW";
    private static final String PROJECT_TOOL_CONFIG_XML_NAME = "PROJECT_TOOL_CONFIG";
    private static final String PROJECT_DATA_XML_NAME = "PROJECT_DATA_XML_NAME";
    private static final String PROJECT_STATE = "projectState";
    private DefaultProjectManager projectManager;
    private ProjectLocator projectLocator;
    private ProjectFileManager fileMgr;
    private ToolManagerImpl toolManager;
    private boolean changed;
    private volatile boolean isClosed;
    private Map<String, SaveState> dataMap = new HashMap<String, SaveState>();
    private Map<String, ToolTemplate> projectConfigMap = new HashMap<String, ToolTemplate>();
    private Map<URL, ProjectFileManager> otherViews = new HashMap<URL, ProjectFileManager>();
    private Set<URL> visibleViews = new HashSet<URL>();
    private WeakSet<ProjectViewListener> viewListeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultProject(DefaultProjectManager projectManager, ProjectLocator projectLocator, RepositoryAdapter repository) throws IOException, LockException {
        this.projectManager = projectManager;
        this.projectLocator = projectLocator;
        boolean success = false;
        try {
            Msg.info((Object)this, (Object)("Creating project: " + projectLocator.toString()));
            this.fileMgr = new ProjectFileManager(projectLocator, repository, true);
            if (!SystemUtilities.isInHeadlessMode()) {
                this.toolManager = new ToolManagerImpl(this);
            }
            success = true;
        }
        finally {
            if (!success && this.fileMgr != null) {
                this.fileMgr.dispose();
            }
        }
        this.initializeNewProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultProject(DefaultProjectManager projectManager, ProjectLocator projectLocator, boolean resetOwner) throws IOException, NotOwnerException, LockException {
        this.projectManager = projectManager;
        this.projectLocator = projectLocator;
        boolean success = false;
        try {
            Msg.info((Object)this, (Object)("Opening project: " + projectLocator.toString()));
            this.fileMgr = new ProjectFileManager(projectLocator, true, resetOwner);
            if (!SystemUtilities.isInHeadlessMode()) {
                this.toolManager = new ToolManagerImpl(this);
            }
            success = true;
        }
        finally {
            if (!success && this.fileMgr != null) {
                this.fileMgr.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultProject(DefaultProjectManager projectManager, GhidraURLConnection connection) throws IOException {
        this.projectManager = projectManager;
        boolean success = false;
        try {
            Msg.info((Object)this, (Object)("Opening project/repository: " + connection.getURL()));
            this.fileMgr = (ProjectFileManager)connection.getProjectData();
            if (this.fileMgr == null) {
                throw new IOException("Failed to open project/repository: " + connection.getURL());
            }
            this.projectLocator = this.fileMgr.getProjectLocator();
            if (!SystemUtilities.isInHeadlessMode()) {
                this.toolManager = new ToolManagerImpl(this);
            }
            success = true;
        }
        finally {
            if (!success && this.fileMgr != null) {
                this.fileMgr.dispose();
            }
        }
        this.initializeNewProject();
    }

    @Override
    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    private void initializeNewProject() {
        if (this.toolManager == null) {
            return;
        }
        try {
            this.toolManager.createWorkspace("Workspace");
            this.toolManager.clearWorkspaceChanged();
        }
        catch (DuplicateNameException e) {
            Msg.showError((Object)this, null, (String)"Duplicate Name", (Object)("Error creating default workspace: " + e.getMessage()));
        }
    }

    @Override
    public ProjectLocator getProjectLocator() {
        return this.projectLocator;
    }

    @Override
    public void addProjectViewListener(ProjectViewListener listener) {
        this.viewListeners.add((Object)listener);
    }

    @Override
    public void removeProjectViewListener(ProjectViewListener listener) {
        this.viewListeners.remove((Object)listener);
    }

    private void notifyVisibleViewAdded(URL projectView) {
        for (ProjectViewListener listener : this.viewListeners) {
            listener.viewedProjectAdded(projectView);
        }
    }

    private void notifyVisibleViewRemoved(URL projectView) {
        for (ProjectViewListener listener : this.viewListeners) {
            listener.viewedProjectRemoved(projectView);
        }
    }

    private ProjectData openProjectView(URL url) throws IOException {
        GhidraURLConnection c = (GhidraURLConnection)url.openConnection();
        c.setAllowUserInteraction(true);
        c.setReadOnly(true);
        GhidraURLConnection.StatusCode responseCode = c.getStatusCode();
        if (responseCode == GhidraURLConnection.StatusCode.NOT_FOUND) {
            throw new IOException("Project/repository not found: " + GhidraURL.getDisplayString(url));
        }
        if (responseCode == GhidraURLConnection.StatusCode.UNAUTHORIZED) {
            return null;
        }
        ProjectFileManager projectData = (ProjectFileManager)c.getProjectData();
        if (projectData == null) {
            throw new IOException("Failed to view specified project/repository: " + GhidraURL.getDisplayString(url));
        }
        url = projectData.getProjectLocator().getURL();
        this.otherViews.put(url, projectData);
        return projectData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectData addProjectView(URL url, boolean visible) throws IOException {
        Map<URL, ProjectFileManager> map = this.otherViews;
        synchronized (map) {
            if (this.isClosed) {
                throw new IOException("project is closed");
            }
            if (!"ghidra".equals(url.getProtocol())) {
                throw new IOException("Invalid Ghidra URL specified: " + url);
            }
            ProjectData projectData = this.otherViews.get(url);
            if (projectData == null) {
                projectData = this.openProjectView(url);
            }
            if (projectData != null && visible && this.visibleViews.add(url)) {
                this.notifyVisibleViewAdded(url);
            }
            return projectData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProjectView(URL url) {
        Map<URL, ProjectFileManager> map = this.otherViews;
        synchronized (map) {
            ProjectFileManager dataMgr = this.otherViews.remove(url);
            if (dataMgr != null) {
                if (this.visibleViews.remove(url)) {
                    this.notifyVisibleViewRemoved(url);
                }
                dataMgr.dispose();
                Msg.info((Object)this, (Object)("Closed project view: " + GhidraURL.getDisplayString(url)));
                this.changed = true;
            }
        }
    }

    @Override
    public ToolServices getToolServices() {
        return this.toolManager != null ? this.toolManager.getToolServices() : null;
    }

    @Override
    public ToolChest getLocalToolChest() {
        return this.projectManager.getUserToolChest();
    }

    @Override
    public String getName() {
        return this.projectLocator.getName();
    }

    @Override
    public ToolManager getToolManager() {
        return this.toolManager;
    }

    @Override
    public boolean hasChanged() {
        return this.changed || this.toolManager != null && this.toolManager.hasChanged();
    }

    @Override
    public ProjectLocator[] getProjectViews() {
        ProjectData[] pd = this.getViewedProjectData();
        ProjectLocator[] views = new ProjectLocator[pd.length];
        for (int i = 0; i < pd.length; ++i) {
            views[i] = pd[i].getProjectLocator();
        }
        return views;
    }

    @Override
    public RepositoryAdapter getRepository() {
        return this.fileMgr.getRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<URL, ProjectFileManager> map = this.otherViews;
        synchronized (map) {
            this.isClosed = true;
            for (ProjectFileManager dataMgr : this.otherViews.values()) {
                if (dataMgr == null) continue;
                dataMgr.dispose();
            }
            this.otherViews.clear();
        }
        try {
            if (this.toolManager != null) {
                this.toolManager.close();
                this.toolManager.dispose();
            }
            if (this.projectManager != null) {
                this.projectManager.projectClosed(this);
            }
        }
        finally {
            this.fileMgr.dispose();
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public boolean saveSessionTools() {
        if (this.toolManager != null) {
            return this.toolManager.saveSessionTools();
        }
        return false;
    }

    @Override
    public void restore() {
        File saveFile = new File(this.fileMgr.getProjectDir(), PROJECT_STATE);
        String errorMsg = null;
        Throwable error = null;
        try {
            if (!saveFile.exists()) {
                this.initializeNewProject();
                return;
            }
            FileInputStream is = new FileInputStream(saveFile);
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            Element root = sax.build((InputStream)is).getRootElement();
            for (Element elem : root.getChildren(PROJECT_TOOL_CONFIG_XML_NAME)) {
                String name = elem.getAttributeValue("NAME");
                Element toolConfigElem = elem.getChild("TOOL_CONFIG");
                GhidraToolTemplate template = new GhidraToolTemplate(toolConfigElem, saveFile.getAbsolutePath());
                this.projectConfigMap.put(name, template);
            }
            List dataChildren = root.getChildren(PROJECT_DATA_XML_NAME);
            for (Object object : dataChildren) {
                Element element = (Element)object;
                String name = element.getAttributeValue("NAME");
                List saveStateChildren = element.getChildren("SAVE_STATE");
                for (Object saveStateObject : saveStateChildren) {
                    SaveState saveState = new SaveState((Element)saveStateObject);
                    this.dataMap.put(name, saveState);
                }
            }
            for (Element elem : root.getChildren(OPEN_VIEW_XML_NAME)) {
                String name = elem.getAttributeValue("NAME");
                String location = elem.getAttributeValue("LOCATION");
                URL url = GhidraURL.makeURL(location, name);
                try {
                    this.addProjectView(url, true);
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)("Project view not opended (" + GhidraURL.getDisplayString(url) + "): " + e.getMessage()));
                }
            }
            for (Element elem : root.getChildren(OPEN_REPOSITORY_VIEW_XML_NAME)) {
                String urlStr = elem.getAttributeValue("URL");
                URL url = new URL(urlStr);
                try {
                    this.addProjectView(url, true);
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)("Project view not opended (" + GhidraURL.getDisplayString(url) + "): " + e.getMessage()));
                }
            }
            if (this.toolManager != null) {
                this.toolManager.restoreFromXml(root.getChild("TOOL_MANAGER"));
            }
            return;
        }
        catch (JDOMException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            StringBuffer sb = new StringBuffer();
            StringTokenizer st = new StringTokenizer(msg, ":");
            while (st.hasMoreTokens()) {
                sb.append(st.nextToken());
                if (!st.hasMoreTokens()) continue;
                sb.append("\n");
            }
            errorMsg = "Invalid XML loading project " + this.projectLocator + ":\n" + sb.toString();
            error = e;
        }
        catch (NoClassDefFoundError e) {
            errorMsg = "Class definition missing: " + e;
            error = e;
        }
        catch (Exception e) {
            errorMsg = "Error restoring project " + this.projectLocator + "\n" + e;
            error = e;
        }
        Msg.showError((Object)this, null, (String)"Error Restoring Project", (Object)errorMsg, (Throwable)error);
        saveFile.delete();
        this.initializeNewProject();
    }

    @Override
    public void save() {
        if (this.toolManager == null) {
            return;
        }
        Element root = new Element("PROJECT");
        Set<Map.Entry<String, ToolTemplate>> configEntrySet = this.projectConfigMap.entrySet();
        for (Map.Entry<String, ToolTemplate> entry : configEntrySet) {
            String string = entry.getKey();
            ToolTemplate template = entry.getValue();
            Element elem = new Element(PROJECT_TOOL_CONFIG_XML_NAME);
            elem.setAttribute("NAME", string);
            elem.addContent((Content)template.saveToXml());
            root.addContent((Content)elem);
        }
        Set<Map.Entry<String, SaveState>> entrySet = this.dataMap.entrySet();
        for (Map.Entry<String, SaveState> entry : entrySet) {
            SaveState saveState = entry.getValue();
            Element element = new Element(PROJECT_DATA_XML_NAME);
            element.setAttribute("NAME", entry.getKey());
            element.addContent((Content)saveState.saveToXml());
            root.addContent((Content)element);
        }
        for (ProjectLocator view : this.getProjectViews()) {
            Element elem;
            if (!view.isTransient()) {
                elem = new Element(OPEN_VIEW_XML_NAME);
                elem.setAttribute("NAME", view.getName());
                elem.setAttribute("LOCATION", view.getLocation());
            } else {
                elem = new Element(OPEN_REPOSITORY_VIEW_XML_NAME);
                elem.setAttribute("URL", view.getURL().toExternalForm());
            }
            root.addContent((Content)elem);
        }
        try {
            root.addContent((Content)this.toolManager.saveToXml());
            File file = new File(this.fileMgr.getProjectDir(), PROJECT_STATE);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Document doc = new Document(root);
            GenericXMLOutputter xmlOut = new GenericXMLOutputter();
            xmlOut.output(doc, (OutputStream)fileOutputStream);
            ((OutputStream)fileOutputStream).close();
            this.changed = false;
        }
        catch (Exception exception) {
            Msg.showError((Object)this, null, (String)"Error", (Object)"Error saving project", (Throwable)exception);
        }
        if (this.projectManager != null) {
            this.projectManager.updatePreferences();
        }
    }

    public String toString() {
        return this.projectLocator.getName();
    }

    @Override
    public void saveToolTemplate(String tag, ToolTemplate template) {
        this.projectConfigMap.put(tag, template);
    }

    @Override
    public ToolTemplate getToolTemplate(String tag) {
        return this.projectConfigMap.get(tag);
    }

    @Override
    public List<DomainFile> getOpenData() {
        ProjectData[] viewedProjs;
        ArrayList<DomainFile> openFiles = new ArrayList<DomainFile>();
        this.fileMgr.findOpenFiles(openFiles);
        for (ProjectData viewedProj : viewedProjs = this.getViewedProjectData()) {
            ((ProjectFileManager)viewedProj).findOpenFiles(openFiles);
        }
        ArrayList<DomainFile> list = new ArrayList<DomainFile>();
        TransientDataManager.getTransients(list);
        for (int i = 0; i < list.size(); ++i) {
            DomainFile df = (DomainFile)list.get(i);
            if (df == null || !df.isOpen()) continue;
            openFiles.add(df);
        }
        return openFiles;
    }

    @Override
    public ProjectFileManager getProjectData() {
        return this.fileMgr;
    }

    @Override
    public void setSaveableData(String key, SaveState saveState) {
        this.dataMap.put(key, saveState);
    }

    @Override
    public SaveState getSaveableData(String key) {
        return this.dataMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectData getProjectData(ProjectLocator locator) {
        if (locator.equals(this.fileMgr.getProjectLocator())) {
            return this.fileMgr;
        }
        Map<URL, ProjectFileManager> map = this.otherViews;
        synchronized (map) {
            for (ProjectData projectData : this.otherViews.values()) {
                if (!locator.equals(projectData.getProjectLocator())) continue;
                return projectData;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectData getProjectData(URL url) {
        if (this.projectLocator.getURL().equals(url)) {
            return this.fileMgr;
        }
        URL remoteURL = this.getProjectData().getRootFolder().getSharedProjectURL();
        if (remoteURL != null) {
            remoteURL = GhidraURL.getProjectURL(url);
        }
        if (remoteURL.equals(url)) {
            return this.fileMgr;
        }
        Map<URL, ProjectFileManager> map = this.otherViews;
        synchronized (map) {
            return this.otherViews.get(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectData[] getViewedProjectData() {
        Map<URL, ProjectFileManager> map = this.otherViews;
        synchronized (map) {
            ArrayList<ProjectData> list = new ArrayList<ProjectData>();
            for (URL url : this.otherViews.keySet()) {
                if (!this.visibleViews.contains(url)) continue;
                list.add(this.otherViews.get(url));
            }
            ProjectData[] projectData = new ProjectData[list.size()];
            list.toArray(projectData);
            return projectData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseFiles(Object consumer) {
        this.fileMgr.releaseDomainFiles(consumer);
        Map<URL, ProjectFileManager> map = this.otherViews;
        synchronized (map) {
            for (ProjectFileManager mgr : this.otherViews.values()) {
                mgr.releaseDomainFiles(consumer);
            }
        }
        TransientDataManager.releaseFiles(consumer);
    }
}

