/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.task;

import generic.concurrent.GThreadPool;
import ghidra.framework.model.DomainObjectClosedListener;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.task.GScheduledTask;
import ghidra.framework.task.GTask;
import ghidra.framework.task.GTaskGroup;
import ghidra.framework.task.GTaskListener;
import ghidra.framework.task.GTaskManagerFactory;
import ghidra.framework.task.GTaskResult;
import ghidra.framework.task.MulticastTaskListener;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class GTaskManager {
    private static final int MAX_RESULTS = 100;
    private UndoableDomainObject domainObject;
    private SortedSet<GScheduledTask> priorityQ = new TreeSet<GScheduledTask>();
    private Deque<GTaskGroup> taskGroupList = new LinkedList<GTaskGroup>();
    private GThreadPool threadPool;
    private ReentrantLock lock = new ReentrantLock(false);
    private Condition notBusy = this.lock.newCondition();
    private Condition isBusy = this.lock.newCondition();
    private GScheduledTask runningTask = null;
    private GTaskGroup runningGroup = null;
    private boolean suspended;
    private Integer currentGroupTransactionID;
    private GTaskListener taskListener = null;
    private Deque<GScheduledTask> delayedTaskStack = new ArrayDeque<GScheduledTask>();
    private Queue<GTaskResult> results = new ArrayDeque<GTaskResult>();

    public GTaskManager(UndoableDomainObject undoableDomainObject, GThreadPool threadPool) {
        this.domainObject = undoableDomainObject;
        this.threadPool = threadPool;
        this.domainObject.addCloseListener(new DomainObjectClosedListener(){

            @Override
            public void domainObjectClosed() {
                GTaskManagerFactory.domainObjectClosed(GTaskManager.this.domainObject);
                GTaskManager.this.domainObject = null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GScheduledTask scheduleTask(GTask task, int priority, boolean useCurrentGroup) {
        GScheduledTask newTask;
        this.lock.lock();
        try {
            if (useCurrentGroup && this.runningGroup != null) {
                newTask = this.runningGroup.doAddTask(task, priority);
                this.priorityQ.add(newTask);
                this.notifyTaskScheduled(newTask);
            } else if (this.taskGroupList.isEmpty() || !useCurrentGroup) {
                GTaskGroup group = new GTaskGroup(task.getName(), true);
                newTask = group.doAddTask(task, priority);
                this.taskGroupList.add(group);
                this.notifyTaskGroupScheduled(group);
            } else {
                GTaskGroup group = this.taskGroupList.getFirst();
                newTask = group.doAddTask(task, priority);
                this.notifyTaskScheduled(newTask);
            }
            this.isBusy.signal();
            this.runNextTaskIfNotBusyOrSuspended();
        }
        finally {
            this.lock.unlock();
        }
        return newTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(GTask task, int priority, String groupName) {
        this.lock.lock();
        try {
            if (this.runningGroup != null && this.runningGroup.getDescription().equals(groupName)) {
                this.scheduleTask(task, priority, true);
                return;
            }
            for (GTaskGroup group : this.taskGroupList) {
                if (!group.getDescription().equals(groupName)) continue;
                GScheduledTask newTask = group.doAddTask(task, priority);
                this.notifyTaskScheduled(newTask);
                this.runNextTaskIfNotBusyOrSuspended();
                return;
            }
            GTaskGroup gTaskGroup = new GTaskGroup(groupName, true);
            gTaskGroup.addTask(task, priority);
            this.taskGroupList.add(gTaskGroup);
            this.notifyTaskGroupScheduled(gTaskGroup);
            this.isBusy.signal();
            this.runNextTaskIfNotBusyOrSuspended();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void scheduleTaskGroup(GTaskGroup group) {
        group.setScheduled();
        this.lock.lock();
        try {
            this.taskGroupList.add(group);
            this.notifyTaskGroupScheduled(group);
            this.isBusy.signal();
            this.runNextTaskIfNotBusyOrSuspended();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setSuspended(boolean b) {
        this.lock.lock();
        try {
            this.suspended = b;
            this.runNextTaskIfNotBusyOrSuspended();
            if (!this.suspended) {
                this.wakeUpWaitingThread();
            }
            this.notifySuspendedStateChanged();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void runNextTaskEvenWhenSuspended() {
        this.lock.lock();
        try {
            this.runNextTaskIfNotBusy();
            this.wakeUpWaitingThread();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addTaskListener(GTaskListener listener) {
        this.lock.lock();
        try {
            this.taskListener = this.taskListener == null ? listener : new MulticastTaskListener(this.taskListener, listener);
            listener.initialize();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeTaskListener(GTaskListener listener) {
        this.lock.lock();
        try {
            if (this.taskListener instanceof MulticastTaskListener) {
                this.taskListener = ((MulticastTaskListener)this.taskListener).removeListener(listener);
            } else if (this.taskListener == listener) {
                this.taskListener = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isBusy() {
        this.lock.lock();
        try {
            if (this.runningTask != null) {
                boolean bl = true;
                return bl;
            }
            if (!this.priorityQ.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            if (!this.taskGroupList.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitWhileBusy(long timeoutMillis) {
        block7: {
            this.lock.lock();
            while (true) {
                if (!this.isBusy()) break block7;
                try {
                    boolean bl = this.notBusy.await(timeoutMillis, TimeUnit.MILLISECONDS);
                    return bl;
                }
                catch (InterruptedException interruptedException) {
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilBusy(long timeoutMillis) {
        block7: {
            this.lock.lock();
            while (true) {
                if (this.isBusy()) break block7;
                try {
                    boolean bl = this.isBusy.await(timeoutMillis, TimeUnit.MILLISECONDS);
                    return bl;
                }
                catch (InterruptedException interruptedException) {
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return true;
    }

    public boolean isRunning() {
        this.lock.lock();
        try {
            boolean bl = this.runningTask != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForHigherPriorityTasks() {
        this.lock.lock();
        try {
            if (this.runningTask == null) {
                return;
            }
            if (!this.runningTask.isRunningInCurrentThread()) {
                throw new IllegalStateException("Can only call this method from a currently running task");
            }
            int currentPriority = this.runningTask.getPriority();
            while (!this.priorityQ.isEmpty()) {
                GScheduledTask nextTask = this.priorityQ.first();
                if (nextTask.getPriority() >= currentPriority) {
                    break;
                }
                this.delayedTaskStack.push(this.runningTask);
                this.runningTask.getTaskMonitor().setMessage("WAITING FOR HIGHER PRIORITY TASKS!");
                if (this.suspended) {
                    this.doWait();
                }
                this.runningTask = nextTask;
                this.priorityQ.remove(nextTask);
                this.lock.unlock();
                GTaskRunnable runnable = new GTaskRunnable(nextTask);
                runnable.run();
                this.lock.lock();
                this.runningTask = this.delayedTaskStack.pop();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<GTaskResult> getTaskResults() {
        this.lock.lock();
        try {
            ArrayList<GTaskResult> arrayList = new ArrayList<GTaskResult>(this.results);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<GScheduledTask> getScheduledTasks() {
        this.lock.lock();
        try {
            ArrayList<GScheduledTask> arrayList = new ArrayList<GScheduledTask>(this.priorityQ);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<GScheduledTask> getDelayedTasks() {
        this.lock.lock();
        try {
            ArrayList<GScheduledTask> arrayList = new ArrayList<GScheduledTask>(this.delayedTaskStack);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public GScheduledTask getRunningTask() {
        this.lock.lock();
        try {
            GScheduledTask gScheduledTask = this.runningTask;
            return gScheduledTask;
        }
        finally {
            this.lock.unlock();
        }
    }

    public GTaskGroup getCurrentGroup() {
        this.lock.lock();
        try {
            GTaskGroup gTaskGroup = this.runningGroup;
            return gTaskGroup;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<GTaskGroup> getScheduledGroups() {
        this.lock.lock();
        try {
            ArrayList<GTaskGroup> arrayList = new ArrayList<GTaskGroup>(this.taskGroupList);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isSuspended() {
        this.lock.lock();
        try {
            boolean bl = this.suspended;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void cancelRunningGroup(GTaskGroup group) {
        this.lock.lock();
        try {
            if (group == this.runningGroup) {
                group.setCancelled();
                if (this.runningTask != null) {
                    this.runningTask.getTaskMonitor().cancel();
                }
                if (this.suspended) {
                    this.processCancelledJobsInPriorityQ();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void cancelAll() {
        this.lock.lock();
        try {
            if (this.runningGroup != null) {
                this.runningGroup.setCancelled();
                if (this.runningTask != null) {
                    this.runningTask.getTaskMonitor().cancel();
                }
            }
            for (GTaskGroup group : this.taskGroupList) {
                group.setCancelled();
            }
            if (this.suspended) {
                this.processCancelledJobsInPriorityQ();
                this.processCancelledGroups();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private synchronized void wakeUpWaitingThread() {
        this.notify();
    }

    private synchronized void doWait() {
        try {
            this.lock.unlock();
            this.wait();
            this.lock.lock();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void runNextTaskIfNotBusyOrSuspended() {
        if (!this.suspended) {
            this.runNextTaskIfNotBusy();
        }
    }

    private void runNextTaskIfNotBusy() {
        if (this.runningTask != null) {
            return;
        }
        if (this.processNextTaskInPriorityQ()) {
            return;
        }
        this.processNextTaskGroup();
        this.processNextTaskInPriorityQ();
    }

    private void processNextTaskGroup() {
        if (this.runningGroup != null) {
            this.notifyGroupCompleted(this.runningGroup);
            this.runningGroup = null;
        }
        if (this.taskGroupList.isEmpty()) {
            this.closeTransaction();
            this.notBusy.signal();
            return;
        }
        GTaskGroup nextGroup = this.taskGroupList.removeFirst();
        this.prepareGroup(nextGroup);
    }

    private void prepareGroup(GTaskGroup taskGroup) {
        List<GScheduledTask> tasks = taskGroup.getTasks();
        this.priorityQ.addAll(tasks);
        if (taskGroup.wantsNewTransaction()) {
            this.closeTransaction();
        }
        this.openTransaction(taskGroup.getDescription());
        this.runningGroup = taskGroup;
        this.notifyGroupStarted(taskGroup);
    }

    private void openTransaction(String description) {
        if (this.currentGroupTransactionID == null) {
            this.currentGroupTransactionID = this.domainObject.startTransaction(description);
        }
    }

    private void closeTransaction() {
        if (this.currentGroupTransactionID != null) {
            this.domainObject.endTransaction(this.currentGroupTransactionID, true);
            this.currentGroupTransactionID = null;
        }
    }

    private boolean processNextTaskInPriorityQ() {
        if (this.priorityQ.isEmpty()) {
            return false;
        }
        this.runningTask = this.priorityQ.first();
        this.priorityQ.remove(this.runningTask);
        this.isBusy.signal();
        this.threadPool.submit((Runnable)new GTaskRunnable(this.runningTask));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskCompleted(GScheduledTask task, Exception e) {
        this.lock.lock();
        try {
            GTaskResult result = new GTaskResult(this.runningGroup, task, e, this.currentGroupTransactionID);
            task.getGroup().taskCompleted();
            this.notifyTaskCompleted(task, result);
            this.results.add(result);
            if (this.results.size() > 100) {
                this.results.remove();
            }
            this.runningTask = null;
            if (this.delayedTaskStack.isEmpty()) {
                this.runNextTaskIfNotBusyOrSuspended();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void notifyTaskStarted(GScheduledTask task) {
        if (this.taskListener == null) {
            return;
        }
        try {
            this.taskListener.taskStarted(task);
        }
        catch (Throwable unexpected) {
            Msg.error((Object)this, (Object)"Unexpected exception notifying listener of task started", (Throwable)unexpected);
        }
    }

    private void notifyTaskCompleted(GScheduledTask task, GTaskResult result) {
        if (this.taskListener == null) {
            return;
        }
        try {
            this.taskListener.taskCompleted(task, result);
        }
        catch (Throwable unexpected) {
            Msg.error((Object)this, (Object)"Unexpected exception notifying listener of task completed", (Throwable)unexpected);
        }
    }

    private void notifyTaskGroupScheduled(GTaskGroup group) {
        if (this.taskListener == null) {
            return;
        }
        try {
            this.taskListener.taskGroupScheduled(group);
        }
        catch (Throwable unexpected) {
            Msg.error((Object)this, (Object)"Unexpected exception notifying listener of group scheduled", (Throwable)unexpected);
        }
    }

    private void notifyTaskScheduled(GScheduledTask scheduledTask) {
        if (this.taskListener == null) {
            return;
        }
        try {
            this.taskListener.taskScheduled(scheduledTask);
        }
        catch (Throwable unexpected) {
            Msg.error((Object)this, (Object)"Unexpected exception notifying listener of task scheduled", (Throwable)unexpected);
        }
    }

    private void notifyGroupStarted(GTaskGroup taskGroup) {
        if (this.taskListener == null) {
            return;
        }
        try {
            this.taskListener.taskGroupStarted(taskGroup);
        }
        catch (Throwable unexpected) {
            Msg.error((Object)this, (Object)"Unexpected exception notifying listener of group started", (Throwable)unexpected);
        }
    }

    private void notifyGroupCompleted(GTaskGroup taskGroup) {
        if (this.taskListener == null) {
            return;
        }
        try {
            this.taskListener.taskGroupCompleted(taskGroup);
        }
        catch (Throwable unexpected) {
            Msg.error((Object)this, (Object)"Unexpected exception notifying listener of group completed", (Throwable)unexpected);
        }
    }

    private void notifySuspendedStateChanged() {
        if (this.taskListener == null) {
            return;
        }
        try {
            this.taskListener.suspendedStateChanged(this.suspended);
        }
        catch (Throwable unexpected) {
            Msg.error((Object)this, (Object)"Unexpected exception notifying listener of suspended state changed", (Throwable)unexpected);
        }
    }

    private void processCancelledGroups() {
        for (GTaskGroup group : this.taskGroupList) {
            for (GScheduledTask task : group.getTasks()) {
                this.taskCompleted(task, (Exception)new CancelledException());
            }
            this.notifyGroupCompleted(group);
        }
        this.taskGroupList.clear();
    }

    private void processCancelledJobsInPriorityQ() {
        for (GScheduledTask task : this.priorityQ) {
            this.taskCompleted(task, (Exception)new CancelledException());
        }
        this.priorityQ.clear();
        if (this.runningGroup != null) {
            this.notifyGroupCompleted(this.runningGroup);
            this.runningGroup = null;
        }
    }

    private class GTaskRunnable
    implements Runnable {
        private GScheduledTask scheduledTask;

        GTaskRunnable(GScheduledTask task) {
            this.scheduledTask = task;
        }

        @Override
        public void run() {
            try {
                this.scheduledTask.setThread(Thread.currentThread());
                GTaskManager.this.notifyTaskStarted(this.scheduledTask);
                if (this.scheduledTask.getGroup().wasCancelled()) {
                    GTaskManager.this.taskCompleted(this.scheduledTask, (Exception)new CancelledException());
                    return;
                }
                this.scheduledTask.getTask().run(GTaskManager.this.domainObject, this.scheduledTask.getTaskMonitor());
                GTaskManager.this.taskCompleted(this.scheduledTask, null);
            }
            catch (Exception e) {
                GTaskManager.this.taskCompleted(this.scheduledTask, e);
            }
        }
    }
}

