/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.data;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.trace.database.data.DBTraceDataSettingsAdapter;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.map.TraceAddressSnapRangePropertyMapOperations;
import ghidra.util.LockHold;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public interface DBTraceDataSettingsOperations
extends TraceAddressSnapRangePropertyMapOperations<DBTraceDataSettingsAdapter.DBTraceSettingsEntry> {
    public static void assertKnownType(Object obj) {
        if (obj instanceof Long) {
            return;
        }
        if (obj instanceof String) {
            return;
        }
        if (obj instanceof byte[]) {
            return;
        }
        throw new IllegalArgumentException("Value is not a known settings type");
    }

    public void makeWay(DBTraceDataSettingsAdapter.DBTraceSettingsEntry var1, Lifespan var2);

    public ReadWriteLock getLock();

    default public DBTraceDataSettingsAdapter.DBTraceSettingsEntry doGetExactEntry(Lifespan lifespan, Address address, String name) {
        for (DBTraceDataSettingsAdapter.DBTraceSettingsEntry entry : this.reduce((Object)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(address, lifespan.lmin())).values()) {
            if (!lifespan.equals(entry.getLifespan()) || !name.equals(entry.name)) continue;
            return entry;
        }
        return null;
    }

    default public void doMakeWay(Lifespan span, Address address, String name) {
        for (DBTraceDataSettingsAdapter.DBTraceSettingsEntry entry : this.reduce((Object)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting((AddressRange)new AddressRangeImpl(address, address), span)).values()) {
            if (name != null && !name.equals(entry.name)) continue;
            this.makeWay(entry, span);
        }
    }

    default public DBTraceDataSettingsAdapter.DBTraceSettingsEntry doExactOrNew(Lifespan lifespan, Address address, String name) {
        DBTraceDataSettingsAdapter.DBTraceSettingsEntry exact = this.doGetExactEntry(lifespan, address, name);
        if (exact != null) {
            return exact;
        }
        this.doMakeWay(lifespan, address, name);
        DBTraceDataSettingsAdapter.DBTraceSettingsEntry entry = this.put(address, lifespan, null);
        entry.setName(name);
        return entry;
    }

    default public DBTraceDataSettingsAdapter.DBTraceSettingsEntry doGetEntry(long snap, Address address, String name) {
        for (DBTraceDataSettingsAdapter.DBTraceSettingsEntry entry : this.reduce((Object)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(address, snap)).values()) {
            if (!name.equals(entry.name)) continue;
            return entry;
        }
        return null;
    }

    default public void setLong(Lifespan lifespan, Address address, String name, long value) {
        try (LockHold hold = LockHold.lock((Lock)this.getLock().writeLock());){
            this.doExactOrNew(lifespan, address, name).setLong(value);
        }
    }

    default public Long getLong(long snap, Address address, String name) {
        try (LockHold hold = LockHold.lock((Lock)this.getLock().readLock());){
            DBTraceDataSettingsAdapter.DBTraceSettingsEntry entry = this.doGetEntry(snap, address, name);
            Long l = entry == null ? null : entry.getLong();
            return l;
        }
    }

    default public void setString(Lifespan lifespan, Address address, String name, String value) {
        try (LockHold hold = LockHold.lock((Lock)this.getLock().writeLock());){
            this.doExactOrNew(lifespan, address, name).setString(value);
        }
    }

    default public String getString(long snap, Address address, String name) {
        try (LockHold hold = LockHold.lock((Lock)this.getLock().readLock());){
            DBTraceDataSettingsAdapter.DBTraceSettingsEntry entry = this.doGetEntry(snap, address, name);
            String string = entry == null ? null : entry.getString();
            return string;
        }
    }

    default public void setValue(Lifespan lifespan, Address address, String name, Object value) {
        DBTraceDataSettingsOperations.assertKnownType(value);
        try (LockHold hold = LockHold.lock((Lock)this.getLock().writeLock());){
            this.doExactOrNew(lifespan, address, name).setValue(value);
        }
    }

    default public Object getValue(long snap, Address address, String name) {
        try (LockHold hold = LockHold.lock((Lock)this.getLock().readLock());){
            DBTraceDataSettingsAdapter.DBTraceSettingsEntry entry = this.doGetEntry(snap, address, name);
            Object object = entry == null ? null : entry.getValue();
            return object;
        }
    }

    default public void clear(Lifespan span, Address address, String name) {
        try (LockHold hold = LockHold.lock((Lock)this.getLock().writeLock());){
            this.doMakeWay(span, address, name);
        }
    }

    default public Collection<String> getSettingNames(Lifespan lifespan, Address address) {
        ArrayList<String> result = new ArrayList<String>();
        try (LockHold hold = LockHold.lock((Lock)this.getLock().readLock());){
            for (DBTraceDataSettingsAdapter.DBTraceSettingsEntry entry : this.reduce((Object)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting((AddressRange)new AddressRangeImpl(address, address), lifespan)).values()) {
                result.add(entry.name);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    default public boolean isEmpty(Lifespan lifespan, Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.getLock().readLock());){
            boolean bl = this.reduce((Object)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting((AddressRange)new AddressRangeImpl(address, address), lifespan)).isEmpty();
            return bl;
        }
    }
}

