/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.memory;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.mem.MemBufferMixin;
import ghidra.program.model.mem.Memory;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DBTraceMemBuffer
implements MemBufferMixin {
    private final DBTraceMemorySpace space;
    private final long snap;
    private final Address start;
    private final ByteOrder byteOrder;

    public DBTraceMemBuffer(DBTraceMemorySpace space, long snap, Address start, ByteOrder byteOrder) {
        this.space = space;
        this.snap = snap;
        this.start = start;
        this.byteOrder = byteOrder;
    }

    public Address getAddress() {
        return this.start;
    }

    public Memory getMemory() {
        return this.space.trace.getProgramView().getMemory();
    }

    public boolean isBigEndian() {
        return this.byteOrder == ByteOrder.BIG_ENDIAN;
    }

    public int getBytes(ByteBuffer buffer, int offset) {
        try {
            return this.space.getViewBytes(this.snap, this.start.addNoWrap((long)offset), buffer);
        }
        catch (AddressOverflowException e) {
            return 0;
        }
    }
}

