/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghpatexpress.Next2InstructionValue;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghsymbol.SpecificSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import org.jdom.Element;

public class Next2Symbol
extends SpecificSymbol {
    private AddrSpace const_space;
    private PatternExpression patexp;

    public Next2Symbol(Location location) {
        super(location);
        this.patexp = null;
    }

    @Override
    public PatternExpression getPatternExpression() {
        return this.patexp;
    }

    @Override
    public symbol_type getType() {
        return symbol_type.next2_symbol;
    }

    public Next2Symbol(Location location, String nm, AddrSpace cspc) {
        super(location, nm);
        this.const_space = cspc;
        this.patexp = new Next2InstructionValue(location);
        this.patexp.layClaim();
    }

    @Override
    public void dispose() {
        if (this.patexp != null) {
            PatternExpression.release(this.patexp);
        }
    }

    @Override
    public VarnodeTpl getVarnode() {
        ConstTpl spc = new ConstTpl(this.const_space);
        ConstTpl off = new ConstTpl(ConstTpl.const_type.j_next2);
        ConstTpl sz_zero = new ConstTpl();
        return new VarnodeTpl(this.location, spc, off, sz_zero);
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<next2_sym");
        this.saveSleighSymbolXmlHeader(s);
        s.println("/>");
    }

    @Override
    public void saveXmlHeader(PrintStream s) {
        s.append("<next2_sym_head");
        this.saveSleighSymbolXmlHeader(s);
        s.println("/>");
    }

    @Override
    public void restoreXml(Element el, SleighBase trans) {
        this.const_space = trans.getConstantSpace();
        this.patexp = new Next2InstructionValue(null);
        this.patexp.layClaim();
    }
}

