/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghsymbol.SleighSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import org.jdom.Element;

public class UserOpSymbol
extends SleighSymbol {
    private int index;

    public UserOpSymbol(Location location) {
        super(location);
    }

    public UserOpSymbol(Location location, String nm) {
        super(location, nm);
        this.index = 0;
    }

    public void setIndex(int ind) {
        this.index = ind;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public symbol_type getType() {
        return symbol_type.userop_symbol;
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<userop");
        this.saveSleighSymbolXmlHeader(s);
        s.append(" index=\"");
        s.print(this.index);
        s.print("\"");
        s.println("/>");
    }

    @Override
    public void saveXmlHeader(PrintStream s) {
        s.append("<userop_head");
        this.saveSleighSymbolXmlHeader(s);
        s.println("/>");
    }

    @Override
    public void restoreXml(Element el, SleighBase trans) {
        this.index = XmlUtils.decodeUnknownInt(el.getAttributeValue("index"));
    }
}

