/*
 * Decompiled with CFR 0.152.
 */
package utility.module;

import generic.jar.ResourceFile;
import ghidra.util.Msg;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import utilities.util.FileUtilities;

public class ModuleManifestFile {
    public static final String MODULE_MANIFEST_FILE_NAME = "Module.manifest";
    private static final String NAME_IDENTIFIER = "MODULE NAME:";
    private static final String DEPENDENCY_IDENTIFIER = "MODULE DEPENDENCY:";
    private static final String MODULE_FILE_LICENSE = "MODULE FILE LICENSE:";
    private static final String EXCLUDE_FROM_GHIDRA_JAR = "EXCLUDE FROM GHIDRA JAR";
    private static final String DATA_SEARCH_IGNORE_DIR = "DATA SEARCH IGNORE DIR:";
    private static final String MODULE_DIR_IDENTIFIER = "MODULE DIR:";
    private static final String FAT_JAR = "FAT JAR:";
    private static final String COMMENT_IDENTIFIER = "#";
    private String moduleName;
    private boolean excludeFromGhidraJar;
    private Map<String, String> fileIPMap = new HashMap<String, String>();
    private Set<String> dataSearchIgnoreDirs = new HashSet<String>();
    private Set<String> fatJars = new HashSet<String>();

    public ModuleManifestFile(File moduleRootDir) throws IOException {
        this(new ResourceFile(moduleRootDir));
    }

    public ModuleManifestFile(ResourceFile moduleRootDir) throws IOException {
        ResourceFile file = new ResourceFile(moduleRootDir, MODULE_MANIFEST_FILE_NAME);
        if (!file.exists()) {
            throw new FileNotFoundException("Missing module manifest file:" + file.getAbsolutePath());
        }
        List<String> lines = FileUtilities.getLines(file);
        int lineNumber = 1;
        for (String line : lines) {
            this.processLine(file, line, lineNumber++);
        }
    }

    public static boolean hasModuleManifest(File moduleRootDir) {
        File file = new File(moduleRootDir, MODULE_MANIFEST_FILE_NAME);
        return file.exists();
    }

    public boolean excludeFromGhidraJar() {
        return this.excludeFromGhidraJar;
    }

    public Map<String, String> getModuleFileIPs() {
        return Collections.unmodifiableMap(this.fileIPMap);
    }

    private void processLine(ResourceFile file, String configLine, int lineNumber) throws IOException {
        String trimmedLine = configLine.trim();
        if (trimmedLine.length() == 0) {
            return;
        }
        if (trimmedLine.startsWith(NAME_IDENTIFIER)) {
            this.processNameLine(trimmedLine);
        } else if (!trimmedLine.startsWith(DEPENDENCY_IDENTIFIER)) {
            if (trimmedLine.startsWith(EXCLUDE_FROM_GHIDRA_JAR)) {
                String[] tokens = trimmedLine.split(":");
                String value = tokens.length == 2 ? tokens[1].trim() : "";
                this.excludeFromGhidraJar = Boolean.valueOf(value);
            } else if (trimmedLine.startsWith(MODULE_FILE_LICENSE)) {
                this.processModuleFileLicense(trimmedLine);
            } else if (!trimmedLine.startsWith(COMMENT_IDENTIFIER)) {
                if (trimmedLine.startsWith(DATA_SEARCH_IGNORE_DIR)) {
                    this.processDataSearchIgnoreDir(trimmedLine);
                } else if (!trimmedLine.startsWith(MODULE_DIR_IDENTIFIER)) {
                    if (trimmedLine.startsWith(FAT_JAR)) {
                        this.processFatJar(trimmedLine);
                    } else {
                        String message = "Module manifest file error on line " + (lineNumber + 1) + " of file: " + file + "\n\t-> Invalid line encountered: " + trimmedLine;
                        Msg.debug(this, message);
                    }
                }
            }
        }
    }

    private void processDataSearchIgnoreDir(String trimmedLine) {
        String ignoreDirName = trimmedLine.substring(DATA_SEARCH_IGNORE_DIR.length()).trim();
        this.dataSearchIgnoreDirs.add(ignoreDirName);
    }

    private void processModuleFileLicense(String line) throws IOException {
        String fileAndIPLine = line.substring(MODULE_FILE_LICENSE.length()).trim();
        int firstSpace = fileAndIPLine.indexOf(32);
        if (firstSpace < 0) {
            this.fileIPFail(line);
        }
        String filename = fileAndIPLine.substring(0, firstSpace);
        String IP = fileAndIPLine.substring(firstSpace + 1);
        this.fileIPMap.put(filename, IP);
    }

    private void fileIPFail(String line) throws IOException {
        throw new IOException("Invalid Module.manifest entry for identifier \"MODULE FILE LICENSE:\".\nThis line requires two parts: 1) the module-relative file path and filename, and 2) the IP of that file.\n  Found: " + line);
    }

    private void processNameLine(String line) {
        this.moduleName = line.substring(NAME_IDENTIFIER.length()).trim();
    }

    private void processFatJar(String line) {
        String fatJar = line.substring(FAT_JAR.length()).trim();
        this.fatJars.add(fatJar);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public Set<String> getDataSearchIgnoreDirs() {
        return this.dataSearchIgnoreDirs;
    }

    public Set<String> getFatJars() {
        return this.fatJars;
    }
}

