/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.DynamicColumnTableModel;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableSortState;
import docking.widgets.table.TableSortStateEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TableColumnDescriptor<ROW_TYPE> {
    private List<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();

    public List<DynamicTableColumn<ROW_TYPE, ?, ?>> getAllColumns() {
        ArrayList list = new ArrayList();
        for (TableColumnInfo info : this.columns) {
            list.add(info.column);
        }
        return list;
    }

    public List<DynamicTableColumn<ROW_TYPE, ?, ?>> getDefaultVisibleColumns() {
        ArrayList list = new ArrayList();
        for (TableColumnInfo info : this.columns) {
            if (!info.isVisible) continue;
            list.add(info.column);
        }
        return list;
    }

    public TableSortState getDefaultTableSortState(DynamicColumnTableModel<ROW_TYPE> model) {
        TableSortStateEditor editor = new TableSortStateEditor();
        ArrayList<TableColumnInfo> sortedColumns = new ArrayList<TableColumnInfo>(this.columns);
        Collections.sort(sortedColumns);
        for (TableColumnInfo info : sortedColumns) {
            if (info.sortIndex == -1) continue;
            int columnIndex = model.getColumnIndex(info.column);
            editor.addSortedColumn(columnIndex);
            if (info.ascending) continue;
            editor.flipColumnSortDirection(columnIndex);
        }
        return editor.createTableSortState();
    }

    private int remove(DynamicTableColumn<ROW_TYPE, ?, ?> column) {
        for (int i = 0; i < this.columns.size(); ++i) {
            TableColumnInfo info = this.columns.get(i);
            if (info.column != column) continue;
            this.columns.remove(i);
            return i;
        }
        return -1;
    }

    public void setHidden(DynamicTableColumn<ROW_TYPE, ?, ?> column) {
        int index = this.remove(column);
        this.columns.add(index, new TableColumnInfo(column));
    }

    public void addHiddenColumn(DynamicTableColumn<ROW_TYPE, ?, ?> column) {
        this.columns.add(new TableColumnInfo(column));
    }

    public void addVisibleColumn(DynamicTableColumn<ROW_TYPE, ?, ?> column) {
        this.addVisibleColumn(column, -1, true);
    }

    public void addVisibleColumn(DynamicTableColumn<ROW_TYPE, ?, ?> column, int sortOrdinal, boolean ascending) {
        this.columns.add(new TableColumnInfo(column, true, sortOrdinal, ascending));
    }

    private class TableColumnInfo
    implements Comparable<TableColumnInfo> {
        private DynamicTableColumn<ROW_TYPE, ?, ?> column;
        private boolean isVisible = false;
        private int sortIndex = -1;
        private boolean ascending = true;

        TableColumnInfo(DynamicTableColumn<ROW_TYPE, ?, ?> column) {
            this.column = column;
        }

        TableColumnInfo(DynamicTableColumn<ROW_TYPE, ?, ?> column, boolean isVisible, int sortIndex, boolean ascending) {
            this.column = column;
            this.isVisible = isVisible;
            this.sortIndex = sortIndex;
            this.ascending = ascending;
        }

        @Override
        public int compareTo(TableColumnInfo o) {
            return this.sortIndex - o.sortIndex;
        }
    }
}

