/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.program;

import docking.action.builder.ActionBuilder;
import docking.widgets.EventTrigger;
import ghidra.app.plugin.core.colorizer.ColorizingService;
import ghidra.app.util.AddEditDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.graph.CodeFlowGraphType;
import ghidra.graph.ProgramGraphDisplayOptions;
import ghidra.graph.ProgramGraphType;
import ghidra.graph.program.BlockModelGraphDisplayListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.SubroutineBlockModel;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayListener;
import ghidra.service.graph.GraphDisplayOptions;
import ghidra.service.graph.GraphDisplayProvider;
import ghidra.service.graph.GraphType;
import ghidra.service.graph.VertexGraphActionContext;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.GraphException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class BlockGraphTask
extends Task {
    private static final String CODE_ATTRIBUTE = "Code";
    private static final String SYMBOLS_ATTRIBUTE = "Symbols";
    protected static final String PROGRESS_DIALOG_TITLE = "Graphing Program";
    protected static final String INIT_PROGRESS_MSG = "Graphing Program...";
    private boolean graphEntryPointNexus = false;
    private boolean showCode = false;
    private int codeLimitPerBlock = 10;
    private ColorizingService colorizingService;
    private static final String ENTRY_NEXUS_NAME = "Entry Points";
    private static final int MAX_SYMBOLS = 10;
    private CodeBlockModel blockModel;
    private AddressSetView selection;
    private ProgramLocation location;
    private GraphDisplayProvider graphProvider;
    private boolean reuseGraph;
    private boolean appendGraph;
    private PluginTool tool;
    private Program program;
    private AddressSetView graphScope;
    private String graphTitle;
    private ProgramGraphType graphType;

    public BlockGraphTask(ProgramGraphType graphType, boolean graphEntryPointNexus, boolean reuseGraph, boolean appendGraph, PluginTool tool, ProgramSelection selection, ProgramLocation location, CodeBlockModel blockModel, GraphDisplayProvider graphProvider) {
        super("Graph Program", true, false, true);
        this.graphType = graphType;
        this.graphEntryPointNexus = graphEntryPointNexus;
        this.showCode = graphType instanceof CodeFlowGraphType;
        this.reuseGraph = reuseGraph;
        this.appendGraph = appendGraph;
        this.tool = tool;
        this.blockModel = blockModel;
        this.graphProvider = graphProvider;
        this.colorizingService = (ColorizingService)tool.getService(ColorizingService.class);
        this.selection = selection;
        this.location = location;
        this.program = blockModel.getProgram();
        this.graphTitle = graphType.getName() + ": ";
    }

    public void run(TaskMonitor monitor) throws CancelledException {
        block6: {
            this.graphScope = this.getGraphScopeAndGenerateGraphTitle();
            AttributedGraph graph = this.createGraph(this.graphTitle);
            monitor.setMessage("Generating Graph...");
            try {
                Set<AttributedVertex> selectedVertices;
                GraphDisplay display = this.graphProvider.getGraphDisplay(this.reuseGraph, monitor);
                ProgramGraphDisplayOptions graphOptions = new ProgramGraphDisplayOptions(this.graphType, this.tool);
                if (this.showCode) {
                    graphOptions.setArrowLength(30);
                }
                BlockModelGraphDisplayListener listener = new BlockModelGraphDisplayListener(this.tool, this.blockModel, display);
                this.addActions(display, v -> listener.getAddress((AttributedVertex)v));
                display.setGraphDisplayListener((GraphDisplayListener)listener);
                if (this.showCode) {
                    graphOptions.setVertexLabelOverrideAttributeKey(CODE_ATTRIBUTE);
                }
                display.setGraph(graph, (GraphDisplayOptions)graphOptions, this.graphTitle, this.appendGraph, monitor);
                if (this.location != null) {
                    AttributedVertex vertex = listener.getVertex(this.location.getAddress());
                    display.setFocusedVertex(vertex, EventTrigger.INTERNAL_ONLY);
                }
                if (this.selection != null && !this.selection.isEmpty() && (selectedVertices = listener.getVertices(this.selection)) != null) {
                    display.selectVertices(selectedVertices, EventTrigger.INTERNAL_ONLY);
                }
            }
            catch (GraphException e) {
                if (monitor.isCancelled()) break block6;
                Msg.showError((Object)((Object)this), null, (String)"Graphing Error", (Object)e.getMessage());
            }
        }
    }

    private void addActions(GraphDisplay display, Function<AttributedVertex, Address> addressFunction) {
        display.addAction(((ActionBuilder)new ActionBuilder("Rename Symbol", "Block Graph").popupMenuPath(new String[]{"Rename Symbol"})).withContext(VertexGraphActionContext.class).helpLocation(new HelpLocation("ProgramGraphPlugin", "Rename_Symbol")).enabledWhen(c -> addressFunction.apply(c.getClickedVertex()) != null).onAction(c -> this.updateVertexName(addressFunction, (VertexGraphActionContext)c)).build());
    }

    private void updateVertexName(Function<AttributedVertex, Address> addressFunction, VertexGraphActionContext context) {
        AttributedVertex vertex = context.getClickedVertex();
        Address address = addressFunction.apply(vertex);
        Symbol symbol = this.program.getSymbolTable().getPrimarySymbol(address);
        if (symbol == null) {
            AddEditDialog dialog = new AddEditDialog("Create Label", this.tool);
            dialog.addLabel(address, this.program, context.getComponentProvider());
        } else {
            AddEditDialog dialog = new AddEditDialog("Edit Label", this.tool);
            dialog.editLabel(symbol, this.program, context.getComponentProvider());
        }
    }

    public void setCodeLimitPerBlock(int maxLines) {
        this.codeLimitPerBlock = maxLines;
    }

    protected AttributedGraph createGraph(String name) throws CancelledException {
        int blockCount = 0;
        AttributedGraph graph = new AttributedGraph(name, (GraphType)this.graphType);
        CodeBlockIterator it = this.getBlockIterator();
        ArrayList<AttributedVertex> entryPoints = new ArrayList<AttributedVertex>();
        while (it.hasNext()) {
            CodeBlock curBB = it.next();
            Address start = this.graphBlock(graph, curBB, entryPoints);
            if (start == null || ++blockCount % 50 != 0) continue;
            this.taskMonitor.setMessage("Process Block: " + start.toString());
        }
        if (this.graphEntryPointNexus && entryPoints.size() > 1) {
            this.addEntryEdges(graph, entryPoints);
        }
        return graph;
    }

    private CodeBlockIterator getBlockIterator() throws CancelledException {
        return this.blockModel.getCodeBlocksContaining(this.graphScope, this.taskMonitor);
    }

    private AddressSetView getGraphScopeAndGenerateGraphTitle() {
        if (this.selection != null && !this.selection.isEmpty()) {
            this.graphTitle = this.graphTitle + this.selection.getMinAddress().toString();
            return this.selection;
        }
        ghidra.program.model.listing.Function function = this.getContainingFunction(this.location);
        if (function != null) {
            this.graphTitle = this.graphTitle + function.getName();
            if (this.isCallGraph()) {
                return this.getScopeForCallGraph(function);
            }
            return function.getBody();
        }
        this.graphTitle = this.graphTitle + "(Entire Program)";
        return this.blockModel.getProgram().getMemory();
    }

    private boolean isCallGraph() {
        return this.blockModel instanceof SubroutineBlockModel;
    }

    private AddressSetView getScopeForCallGraph(ghidra.program.model.listing.Function function) {
        AddressSet set = new AddressSet();
        set.add(function.getBody());
        try {
            for (CodeBlock block : this.blockModel.getCodeBlocksContaining(function.getEntryPoint(), this.taskMonitor)) {
                CodeBlockReference next;
                CodeBlockReferenceIterator it = this.blockModel.getDestinations(block, this.taskMonitor);
                while (it.hasNext()) {
                    next = it.next();
                    set.add((AddressSetView)next.getDestinationBlock());
                }
                it = this.blockModel.getSources(block, this.taskMonitor);
                while (it.hasNext()) {
                    next = it.next();
                    set.add((AddressSetView)next.getSourceBlock());
                }
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return set;
    }

    private ghidra.program.model.listing.Function getContainingFunction(ProgramLocation cursorLocation) {
        if (cursorLocation == null) {
            return null;
        }
        Address address = cursorLocation.getAddress();
        if (address == null) {
            return null;
        }
        return this.blockModel.getProgram().getFunctionManager().getFunctionContaining(address);
    }

    private Address graphBlock(AttributedGraph graph, CodeBlock curBB, List<AttributedVertex> entries) throws CancelledException {
        Address[] startAddrs = curBB.getStartAddresses();
        if (startAddrs == null || startAddrs.length == 0) {
            Msg.error((Object)((Object)this), (Object)("Block not graphed, missing start address: " + curBB.getMinAddress()));
            return null;
        }
        AttributedVertex vertex = this.graphBasicBlock(graph, curBB);
        if (this.graphEntryPointNexus && this.hasExternalEntryPoint(startAddrs)) {
            entries.add(vertex);
        }
        return startAddrs[0];
    }

    private boolean hasExternalEntryPoint(Address[] startAddrs) {
        SymbolTable symbolTable = this.program.getSymbolTable();
        for (Address address : startAddrs) {
            if (!symbolTable.isExternalEntryPoint(address)) continue;
            return true;
        }
        return false;
    }

    private void addEntryEdges(AttributedGraph graph, List<AttributedVertex> entries) {
        AttributedVertex entryNexusVertex = this.getEntryNexusVertex(graph);
        for (AttributedVertex vertex : entries) {
            AttributedEdge edge = graph.addEdge(entryNexusVertex, vertex);
            edge.setAttribute("EdgeType", ProgramGraphType.ENTRY_NEXUS);
        }
    }

    protected AttributedVertex graphBasicBlock(AttributedGraph graph, CodeBlock curBB) throws CancelledException {
        AttributedVertex fromVertex = this.getBasicBlockVertex(graph, curBB);
        CodeBlockReferenceIterator refIter = curBB.getDestinations(this.taskMonitor);
        while (refIter.hasNext()) {
            AttributedVertex toVertex;
            CodeBlockReference cbRef = refIter.next();
            CodeBlock db = cbRef.getDestinationBlock();
            if (db == null || this.graphScope != null && !this.graphScope.isEmpty() && !this.graphScope.intersects((AddressSetView)db) || (toVertex = this.getBasicBlockVertex(graph, db)) == null) continue;
            AttributedEdge newEdge = graph.addEdge(fromVertex, toVertex);
            this.setEdgeAttributes(newEdge, cbRef);
            this.setEdgeColor(newEdge, fromVertex, toVertex);
        }
        return fromVertex;
    }

    private void setEdgeColor(AttributedEdge edge, AttributedVertex fromVertex, AttributedVertex toVertex) {
        String fromColor = fromVertex.getAttribute("Color");
        String toColor = toVertex.getAttribute("Color");
        if (fromColor != null || toColor != null) {
            if (fromColor != null) {
                edge.setAttribute("Color", fromColor);
            } else if (toColor != null) {
                edge.setAttribute("Color", toColor);
            }
        }
    }

    private String getVertexId(CodeBlock bb) {
        Address addr = bb.getFirstStartAddress();
        if (addr.isExternalAddress()) {
            Symbol s = bb.getModel().getProgram().getSymbolTable().getPrimarySymbol(addr);
            return s.getName(true);
        }
        return addr.toString();
    }

    protected AttributedVertex getBasicBlockVertex(AttributedGraph graph, CodeBlock bb) throws CancelledException {
        String vertexId = this.getVertexId(bb);
        AttributedVertex vertex = graph.getVertex(vertexId);
        if (vertex != null) {
            return vertex;
        }
        String vertexName = bb.getName();
        vertex = graph.addVertex(vertexId, vertexName);
        this.setVertexAttributes(vertex, bb, vertexName.equals(vertexId) ? false : this.isEntryNode(bb));
        if (this.showCode) {
            this.addSymbolAttribute(vertex, bb);
            this.addCodeAttribute(vertex, bb);
        }
        return vertex;
    }

    private void addCodeAttribute(AttributedVertex vertex, CodeBlock bb) {
        if (!bb.getMinAddress().isMemoryAddress()) {
            vertex.setAttribute(CODE_ATTRIBUTE, vertex.getAttribute(SYMBOLS_ATTRIBUTE));
        }
        Listing listing = this.program.getListing();
        CodeUnitIterator cuIter = listing.getCodeUnits((AddressSetView)bb, true);
        int cnt = 0;
        int maxMnemonicFieldLen = 0;
        StringBuffer buf = new StringBuffer();
        while (cuIter.hasNext()) {
            String line;
            int ix;
            CodeUnit cu = cuIter.next();
            if (cnt != 0) {
                buf.append('\n');
            }
            if ((ix = (line = cu.toString()).indexOf(32)) > maxMnemonicFieldLen) {
                maxMnemonicFieldLen = ix;
            }
            buf.append(line);
            if (++cnt != this.codeLimitPerBlock) continue;
            buf.append("\n...");
            break;
        }
        vertex.setAttribute(CODE_ATTRIBUTE, this.adjustCode(buf, maxMnemonicFieldLen + 1));
    }

    private void addSymbolAttribute(AttributedVertex vertex, CodeBlock bb) {
        SymbolIterator it = this.program.getSymbolTable().getSymbolsAsIterator(bb.getMinAddress());
        int count = 0;
        if (it.hasNext()) {
            StringBuffer buf = new StringBuffer();
            for (Symbol symbol : it) {
                if (count != 0) {
                    buf.append('\n');
                }
                if (count++ > 10) {
                    buf.append("...");
                    break;
                }
                buf.append(symbol.getName());
            }
            vertex.setAttribute(SYMBOLS_ATTRIBUTE, buf.toString());
        }
    }

    private String adjustCode(StringBuffer buf, int mnemonicFieldLen) {
        if (mnemonicFieldLen <= 1) {
            return buf.toString();
        }
        int ix = 0;
        char[] pad = new char[mnemonicFieldLen];
        Arrays.fill(pad, ' ');
        while (ix < buf.length()) {
            int padSize;
            int padIx;
            int eolIx = buf.indexOf("\n", ix);
            if (eolIx < 0) {
                eolIx = buf.length();
            }
            if ((padIx = buf.indexOf(" ", ix)) > 0 && padIx < eolIx && (padSize = mnemonicFieldLen - padIx + ix) > 0) {
                buf.insert(padIx, pad, 0, padSize);
                eolIx += padSize;
            }
            ix = eolIx + 1;
        }
        return buf.toString();
    }

    protected boolean isEntryNode(CodeBlock block) throws CancelledException {
        CodeBlockReferenceIterator iter = block.getSources(this.taskMonitor);
        boolean isSource = true;
        while (iter.hasNext()) {
            isSource = false;
            if (!iter.next().getFlowType().isCall()) continue;
            return true;
        }
        return isSource;
    }

    protected void setEdgeAttributes(AttributedEdge edge, CodeBlockReference ref) {
        edge.setEdgeType(ProgramGraphType.getEdgeType((RefType)ref.getFlowType()));
    }

    protected void setVertexAttributes(AttributedVertex vertex, CodeBlock bb, boolean isEntry) {
        String vertexType = ProgramGraphType.BODY;
        Address firstStartAddress = bb.getFirstStartAddress();
        if (firstStartAddress.isExternalAddress()) {
            vertexType = ProgramGraphType.EXTERNAL;
        } else if (isEntry) {
            vertexType = ProgramGraphType.ENTRY;
        } else {
            FlowType flowType = bb.getFlowType();
            if (flowType.isTerminal()) {
                vertexType = ProgramGraphType.EXIT;
            } else if (flowType.isComputed()) {
                vertexType = ProgramGraphType.SWITCH;
            } else if (flowType == RefType.INDIRECTION) {
                vertexType = ProgramGraphType.DATA;
            } else if (flowType == RefType.INVALID) {
                vertexType = ProgramGraphType.BAD;
            }
        }
        vertex.setVertexType(vertexType);
    }

    private AttributedVertex getEntryNexusVertex(AttributedGraph graph) {
        AttributedVertex vertex = graph.getVertex(ENTRY_NEXUS_NAME);
        if (vertex == null) {
            vertex = graph.addVertex(ENTRY_NEXUS_NAME, ENTRY_NEXUS_NAME);
            vertex.setAttribute("VertexType", ProgramGraphType.ENTRY_NEXUS);
        }
        return vertex;
    }
}

