/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;

public class RemoveFunctionTagCmd
implements Command {
    private Address entryPoint;
    private String tagName;

    public RemoveFunctionTagCmd(String tagName, Address entryPoint) {
        this.tagName = tagName;
        this.entryPoint = entryPoint;
    }

    public boolean applyTo(DomainObject obj) {
        ProgramDB program = (ProgramDB)obj;
        FunctionManagerDB functionManager = program.getFunctionManager();
        Function function = functionManager.getFunctionAt(this.entryPoint);
        function.removeTag(this.tagName);
        return true;
    }

    public String getName() {
        return "Remove Tag From Function";
    }

    public String getStatusMsg() {
        return null;
    }
}

