/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.actions.KeyBindingUtils;
import docking.dnd.DragGestureAdapter;
import docking.dnd.DragSrcAdapter;
import docking.dnd.Draggable;
import docking.dnd.DropTgtAdapter;
import docking.dnd.Droppable;
import docking.widgets.DropDownSelectionTextField;
import docking.widgets.OptionDialog;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import docking.widgets.table.FocusableEditor;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableColumnModel;
import docking.widgets.textfield.GValidatedTextField;
import generic.theme.GColor;
import ghidra.app.plugin.core.compositeeditor.BitFieldEditorDialog;
import ghidra.app.plugin.core.compositeeditor.ComponentCellEditor;
import ghidra.app.plugin.core.compositeeditor.ComponentCellEditorListener;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorModel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorModelListener;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.DataTypeCellRenderer;
import ghidra.app.plugin.core.compositeeditor.DndTableCellRenderer;
import ghidra.app.plugin.core.compositeeditor.SearchControlPanel;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.datatype.DataTypeSelectionEditor;
import ghidra.app.util.datatype.NavigationDirection;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerDomainObject;
import ghidra.program.model.data.DataTypeTransferable;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.DataTypeArchive;
import ghidra.program.model.listing.Program;
import ghidra.util.ColorUtils;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.data.DataTypeParser;
import ghidra.util.exception.UsrException;
import ghidra.util.layout.VerticalLayout;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public abstract class CompositeEditorPanel
extends JPanel
implements CompositeEditorModelListener,
ComponentCellEditorListener,
Draggable,
Droppable {
    protected static final Border BEVELED_BORDER = BorderFactory.createLoweredBevelBorder();
    protected static final HelpService helpManager = Help.getHelpService();
    protected CompositeEditorProvider provider;
    protected CompositeEditorModel model;
    protected GTable table;
    private JLabel statusLabel;
    private boolean editorAdjusting = false;
    protected DndTableCellRenderer dndTableCellRenderer;
    protected DndTableCellRenderer dndDtiCellRenderer;
    private DragSource dragSource;
    private DragGestureAdapter dragGestureAdapter;
    private DragSrcAdapter dragSourceAdapter;
    private int dragAction = 2;
    private DropTarget dropTarget;
    private DropTgtAdapter dropTargetAdapter;
    private DataFlavor[] acceptableFlavors;
    protected int lastDndAction = 0;

    public CompositeEditorPanel(CompositeEditorModel model, CompositeEditorProvider provider) {
        super(new BorderLayout());
        JPanel infoPanel;
        JPanel lowerPanel = new JPanel((LayoutManager)new VerticalLayout(5));
        this.provider = provider;
        this.model = model;
        this.createTable();
        JPanel bitViewerPanel = this.createBitViewerPanel();
        if (bitViewerPanel != null) {
            lowerPanel.add(bitViewerPanel);
        }
        if ((infoPanel = this.createInfoPanel()) != null) {
            this.adjustCompositeInfo();
            lowerPanel.add(infoPanel);
        }
        lowerPanel.add(this.createStatusPanel());
        this.add((Component)lowerPanel, "South");
        model.addCompositeEditorModelListener(this);
        this.setUpDragDrop();
    }

    protected Composite getOriginalComposite() {
        return this.model.getOriginalComposite();
    }

    protected abstract void adjustCompositeInfo();

    public JTable getTable() {
        return this.table;
    }

    protected CompositeEditorModel getModel() {
        return this.model;
    }

    public void addEditorModelListener(CompositeEditorModelListener listener) {
        this.model.addCompositeEditorModelListener(listener);
    }

    public void removeEditorModelListener(CompositeEditorModelListener listener) {
        this.model.removeCompositeEditorModelListener(listener);
    }

    private void setupTableCellRenderer() {
        GTableCellRenderer cellRenderer = new GTableCellRenderer();
        DataTypeCellRenderer dtiCellRenderer = new DataTypeCellRenderer(this.model.getOriginalDataTypeManager());
        this.table.setDefaultRenderer(String.class, (TableCellRenderer)cellRenderer);
        this.table.setDefaultRenderer(DataTypeInstance.class, (TableCellRenderer)((Object)dtiCellRenderer));
    }

    private boolean launchBitFieldEditor(int modelRow, int modelColumn) {
        DataTypeComponent dtComponent;
        if (this.model.viewComposite instanceof Structure && !this.model.viewComposite.isPackingEnabled() && this.model.getDataTypeColumn() == modelColumn && modelRow < this.model.getNumComponents() && (dtComponent = this.model.getComponent(modelRow)).isBitFieldComponent()) {
            this.table.getCellEditor().cancelCellEditing();
            BitFieldEditorDialog dlg = new BitFieldEditorDialog(this.model.viewComposite, this.provider.dtmService, modelRow, this.model.showHexNumbers, ordinal -> this.model.notifyCompositeChanged());
            JComponent c = this.provider.getComponent();
            DockingWindowManager.showDialog((Component)c, (DialogComponentProvider)dlg);
            return true;
        }
        return false;
    }

    private void setupTableCellEditor() {
        this.table.addPropertyChangeListener("tableCellEditor", evt -> {
            TableCellEditor fieldEditor = (TableCellEditor)evt.getNewValue();
            if (fieldEditor == null) {
                Swing.runLater(() -> this.model.endEditingField());
            } else {
                Swing.runLater(() -> {
                    int editingColumn;
                    int modelColumn;
                    int editingRow = this.table.getEditingRow();
                    if (editingRow < 0) {
                        return;
                    }
                    int modelRow = this.table.convertRowIndexToModel(editingRow);
                    if (!this.launchBitFieldEditor(modelRow, modelColumn = this.table.convertColumnIndexToModel(editingColumn = this.table.getEditingColumn()))) {
                        this.model.beginEditingField(modelRow, modelColumn);
                    }
                });
            }
        });
        ComponentStringCellEditor cellEditor = new ComponentStringCellEditor();
        ComponentOffsetCellEditor offsetCellEditor = new ComponentOffsetCellEditor();
        ComponentDataTypeCellEditor dataTypeCellEditor = new ComponentDataTypeCellEditor();
        ComponentNameCellEditor nameCellEditor = new ComponentNameCellEditor();
        cellEditor.setComponentCellEditorListener(this);
        offsetCellEditor.setComponentCellEditorListener(this);
        nameCellEditor.setComponentCellEditorListener(this);
        this.table.setDefaultEditor(String.class, (TableCellEditor)((Object)cellEditor));
        TableColumnModel tcm = this.table.getColumnModel();
        int numCols = tcm.getColumnCount();
        for (int i = 0; i < numCols; ++i) {
            int column = this.table.convertColumnIndexToModel(i);
            if (column == this.model.getNameColumn()) {
                tcm.getColumn(column).setCellEditor((TableCellEditor)((Object)nameCellEditor));
                continue;
            }
            if (column == this.model.getDataTypeColumn()) {
                tcm.getColumn(column).setCellEditor(dataTypeCellEditor);
                continue;
            }
            if (column == this.model.getOffsetColumn()) {
                tcm.getColumn(column).setCellEditor((TableCellEditor)((Object)offsetCellEditor));
                continue;
            }
            tcm.getColumn(column).setCellEditor((TableCellEditor)((Object)cellEditor));
        }
    }

    protected void cancelCellEditing() {
        TableCellEditor cellEditor = this.table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.cancelCellEditing();
        }
    }

    protected void stopCellEditing() {
        TableCellEditor cellEditor = this.table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    protected void startCellEditing(int row, int viewColumn) {
        if (row >= 0 && viewColumn >= 0) {
            this.table.editCellAt(row, viewColumn, (EventObject)new KeyEvent((Component)this.table, 401, System.currentTimeMillis(), 0, 113, '\uffff'));
        }
    }

    @Override
    public void moveCellEditor(int direction, String value) {
        this.stopCellEditing();
        Swing.runLater(() -> this.doMoveCellEditor(direction, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doMoveCellEditor(int direction, String value) {
        if (this.editorAdjusting) {
            return;
        }
        try {
            this.editorAdjusting = true;
            if (this.table.isEditing()) {
                return;
            }
            int currentRow = this.model.getRow();
            switch (direction) {
                case 1: {
                    this.editNextField(currentRow);
                    return;
                }
                case 2: {
                    this.editPreviousField(currentRow);
                    return;
                }
                case 3: {
                    this.editAboveField();
                    return;
                }
                case 4: {
                    this.editBelowField();
                    return;
                }
            }
            return;
        }
        finally {
            this.editorAdjusting = false;
        }
    }

    private boolean beginEditField(int row, int modelColumn) {
        int viewColumn = this.table.convertColumnIndexToView(modelColumn);
        this.scrollToCell(row, viewColumn);
        this.table.setColumnSelectionInterval(viewColumn, viewColumn);
        this.startCellEditing(row, viewColumn);
        return this.table.isEditing();
    }

    protected boolean locateNextEditField(int currentRow) {
        int row = currentRow;
        int modelColumn = this.model.getColumn();
        boolean foundEditable = false;
        int index = row;
        int fieldNum = this.table.convertColumnIndexToView(modelColumn);
        int numFields = this.table.getColumnCount();
        int numComps = this.model.getRowCount();
        while (index < numComps) {
            if (++fieldNum < numFields) {
                if (this.table.isCellEditable(index, fieldNum)) {
                    foundEditable = true;
                }
            } else {
                if (++index >= numComps && index != numComps) break;
                fieldNum = 0;
                if (this.table.isCellEditable(index, fieldNum)) {
                    foundEditable = true;
                }
            }
            if (!foundEditable) continue;
        }
        if (foundEditable) {
            row = index;
            modelColumn = this.table.convertColumnIndexToModel(fieldNum);
            this.table.setRowSelectionInterval(row, row);
            this.model.setRow(row);
            this.model.setColumn(modelColumn);
        }
        return foundEditable;
    }

    protected boolean locatePreviousEditField(int currentRow) {
        int row = currentRow;
        int modelColumn = this.model.getColumn();
        boolean foundEditable = false;
        int index = row;
        int fieldNum = this.table.convertColumnIndexToView(modelColumn);
        do {
            if (--fieldNum >= 0) {
                if (!this.model.isCellEditable(index, this.table.convertColumnIndexToModel(fieldNum))) continue;
                foundEditable = true;
                continue;
            }
            if (--index < 0) break;
            fieldNum = this.model.getColumnCount() - 1;
            if (!this.model.isCellEditable(index, this.table.convertColumnIndexToModel(fieldNum))) continue;
            foundEditable = true;
        } while (!foundEditable);
        if (foundEditable) {
            row = index;
            modelColumn = this.table.convertColumnIndexToModel(fieldNum);
            this.table.setRowSelectionInterval(row, row);
            this.model.setRow(row);
            this.model.setColumn(modelColumn);
        }
        return foundEditable;
    }

    protected boolean editAboveField() {
        int row = this.model.getRow();
        int modelColumn = this.model.getColumn();
        int index = row;
        if (--index >= 0) {
            row = index;
            this.table.setRowSelectionInterval(row, row);
            if (this.model.isCellEditable(index, modelColumn)) {
                return this.beginEditField(this.model.getRow(), this.model.getColumn());
            }
        }
        return false;
    }

    protected boolean editBelowField() {
        int row = this.model.getRow();
        int modelColumn = this.model.getColumn();
        int index = row;
        int numComps = this.model.getRowCount();
        if (++index < numComps) {
            row = index;
            this.table.setRowSelectionInterval(row, row);
            if (this.model.isCellEditable(index, modelColumn)) {
                return this.beginEditField(this.model.getRow(), this.model.getColumn());
            }
        }
        return false;
    }

    protected boolean editNextField(int currentRow) {
        if (this.locateNextEditField(currentRow)) {
            return this.beginEditField(this.model.getRow(), this.model.getColumn());
        }
        return false;
    }

    protected boolean editPreviousField(int currentRow) {
        if (this.locatePreviousEditField(currentRow)) {
            return this.beginEditField(this.model.getRow(), this.model.getColumn());
        }
        return false;
    }

    private void scrollToCell(int rowIndex, int columnIndex) {
        Rectangle cellRect;
        if (this.table.getAutoscrolls() && (cellRect = this.table.getCellRect(rowIndex, columnIndex, false)) != null) {
            this.table.scrollRectToVisible(cellRect);
        }
    }

    public void domainObjectRestored(DataTypeManagerDomainObject domainObject) {
        Composite originalDt;
        Composite composite;
        String origDtPath;
        DataTypeManager originalDTM = this.model.getOriginalDataTypeManager();
        if (originalDTM == null) {
            return;
        }
        boolean reload = true;
        String objectType = "domain object";
        if (domainObject instanceof Program) {
            objectType = "program";
        } else if (domainObject instanceof DataTypeArchive) {
            objectType = "data type archive";
        }
        DataType dt = originalDTM.getDataType(this.model.getCompositeID());
        if (dt instanceof Composite && !(origDtPath = (composite = (Composite)dt).getPathName()).equals(this.model.getOriginalDataTypePath().getPath())) {
            this.model.fixupOriginalPath(composite);
        }
        if ((originalDt = this.model.getOriginalComposite()) == null) {
            this.provider.show();
            String info = "The " + objectType + " \"" + domainObject.getName() + "\" has been restored.\n\"" + this.model.getCompositeName() + "\" may no longer exist outside the editor.";
            Msg.showWarn((Object)this, (Component)this, (String)"Program Restored", (Object)info);
            return;
        }
        if (originalDt.isDeleted()) {
            this.cancelCellEditing();
            this.provider.dispose();
            return;
        }
        if (this.model.hasChanges()) {
            this.provider.show();
            String question = "The " + objectType + " \"" + domainObject.getName() + "\" has been restored.\n\"" + this.model.getCompositeName() + "\" may have changed outside the editor.\nDiscard edits & reload the " + this.model.getTypeName() + "?";
            String title = "Reload " + this.model.getTypeName() + " Editor?";
            int response = OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)this, (String)title, (String)question);
            if (response != 1) {
                reload = false;
            }
        }
        if (reload) {
            this.cancelCellEditing();
            this.model.load(originalDt);
            this.model.updateAndCheckChangeState();
        }
    }

    public void dispose() {
        if (this.isVisible()) {
            this.setVisible(false);
        }
        this.model.removeCompositeEditorModelListener(this);
        this.table.dispose();
    }

    private void createTable() {
        this.table = new CompositeEditorTable(this.model);
        TableColumnModel columnModel = this.table.getColumnModel();
        if (columnModel instanceof GTableColumnModel) {
            GTableColumnModel gColumnModel = (GTableColumnModel)columnModel;
            List<TableColumn> hiddenColumns = this.model.getHiddenColumns();
            for (TableColumn column : hiddenColumns) {
                gColumnModel.addHiddenColumn(column);
            }
        }
        this.table.setAutoEditEnabled(false);
        this.table.addMouseListener((MouseListener)new CompositeTableMouseListener());
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.model.setSelection(this.table.getSelectedRows());
            if (this.table.getAutoscrolls()) {
                this.table.scrollToSelectedRow();
            }
        });
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            TableColumnModel cm = this.table.getColumnModel();
            int[] selected = cm.getSelectedColumns();
            if (selected.length == 1) {
                int viewIndex = selected[0];
                int modelIndex = this.table.convertColumnIndexToModel(viewIndex);
                this.model.setColumn(modelIndex);
            } else {
                this.model.setColumn(-1);
            }
        });
        JPanel tablePanel = new JPanel(new BorderLayout());
        JScrollPane sp = new JScrollPane((Component)this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(this.model.getWidth(), 250));
        this.table.setSelectionMode(2);
        tablePanel.add((Component)sp, "Center");
        SearchControlPanel searchPanel = new SearchControlPanel(this);
        if (helpManager != null) {
            helpManager.registerHelp((Object)searchPanel, new HelpLocation("DataTypeEditors", "Searching_In_Editor"));
        }
        tablePanel.add((Component)searchPanel, "South");
        this.add((Component)tablePanel, "Center");
        JTableHeader header = this.table.getTableHeader();
        header.setUpdateTableInRealTime(true);
        this.table.setAutoResizeMode(3);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            TableColumn tc = this.table.getColumn((Object)this.model.getColumnName(i));
            tc.setPreferredWidth(this.model.getFieldWidth(i));
        }
        this.setupTableCellRenderer();
        this.setupTableCellEditor();
        this.selectionChanged();
        Color gridColor = this.table.getGridColor();
        Color tableBackground = this.table.getBackground();
        if (tableBackground.equals(gridColor)) {
            this.table.setGridColor((Color)new GColor("color.bg.table.grid"));
        }
    }

    protected JPanel createBitViewerPanel() {
        return null;
    }

    protected JPanel createInfoPanel() {
        return null;
    }

    private JPanel createStatusPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.statusLabel = new GDLabel(" ");
        this.statusLabel.setHorizontalAlignment(0);
        this.statusLabel.setForeground((Color)new GColor("color.fg.dialog.status.normal"));
        this.statusLabel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CompositeEditorPanel.this.updateStatusToolTip();
            }
        });
        panel.add((Component)this.statusLabel, "Center");
        this.statusLabel.setName("Editor Status");
        return panel;
    }

    public void setStatus(String status) {
        if (this.statusLabel != null) {
            this.statusLabel.setText(status);
            this.updateStatusToolTip();
        } else {
            this.provider.setStatusMessage(status);
        }
    }

    private void updateStatusToolTip() {
        String text = this.statusLabel.getText();
        FontMetrics fm = this.statusLabel.getFontMetrics(this.statusLabel.getFont());
        int messageWidth = 0;
        if (fm != null && text != null) {
            messageWidth = fm.stringWidth(text);
        }
        if (messageWidth > this.statusLabel.getWidth()) {
            this.statusLabel.setToolTipText(text);
        } else {
            this.statusLabel.setToolTipText("Editor messages appear here.");
        }
    }

    protected JPanel createNamedTextPanel(JTextField textField, String name) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        GLabel label = new GLabel(name + ":", 4);
        label.setPreferredSize(new Dimension(label.getPreferredSize()));
        panel.add((Component)label);
        panel.add(Box.createHorizontalStrut(2));
        panel.add(textField);
        if (helpManager != null) {
            helpManager.registerHelp((Object)textField, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_" + name));
        }
        return panel;
    }

    protected JPanel createHorizontalPanel(JComponent[] comps) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        for (int i = 0; i < comps.length; ++i) {
            if (i > 0) {
                panel.add(Box.createHorizontalStrut(10));
            }
            panel.add(comps[i]);
        }
        return panel;
    }

    protected JPanel createVerticalPanel(JComponent[] comps) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        for (int i = 0; i < comps.length; ++i) {
            if (i > 0) {
                panel.add(Box.createVerticalStrut(5));
            }
            panel.add(comps[i]);
        }
        return panel;
    }

    private void setUpDragDrop() {
        TableCellRenderer defRenderer = this.table.getDefaultRenderer(String.class);
        this.dndTableCellRenderer = new DndTableCellRenderer(defRenderer, (JTable)this.table);
        this.dndTableCellRenderer.setBorderColor(ColorUtils.deriveBackground((Color)this.table.getSelectionBackground(), (float)0.41666666f));
        this.table.setDefaultRenderer(String.class, (TableCellRenderer)this.dndTableCellRenderer);
        TableCellRenderer dtiRenderer = this.table.getDefaultRenderer(DataTypeInstance.class);
        this.dndDtiCellRenderer = new DndTableCellRenderer(dtiRenderer, (JTable)this.table);
        this.dndDtiCellRenderer.setBorderColor(ColorUtils.deriveBackground((Color)this.table.getSelectionBackground(), (float)0.41666666f));
        this.table.setDefaultRenderer(DataTypeInstance.class, (TableCellRenderer)this.dndDtiCellRenderer);
        this.acceptableFlavors = new DataFlavor[]{DataTypeTransferable.localDataTypeFlavor, DataTypeTransferable.localBuiltinDataTypeFlavor};
        this.dropTargetAdapter = new DropTgtAdapter((Droppable)this, 3, this.acceptableFlavors);
        this.dropTarget = new DropTarget((Component)this.table, 3, (DropTargetListener)this.dropTargetAdapter, true);
        this.dropTarget.setActive(true);
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragGestureAdapter = new DragGestureAdapter((Draggable)this);
        this.dragSourceAdapter = new DragSrcAdapter((Draggable)this);
        this.dragSource.createDefaultDragGestureRecognizer((Component)this.table, this.dragAction, (DragGestureListener)this.dragGestureAdapter);
    }

    public boolean isStartDragOk(DragGestureEvent e) {
        return false;
    }

    public DragSourceListener getDragSourceListener() {
        return this.dragSourceAdapter;
    }

    public void move() {
    }

    public void dragCanceled(DragSourceDropEvent event) {
    }

    public int getDragAction() {
        return this.dragAction;
    }

    public Transferable getTransferable(Point p) {
        int numRows;
        int index = this.table.rowAtPoint(p);
        if (index >= (numRows = this.model.getRowCount())) {
            index = numRows;
        }
        DefaultDataType dt = DefaultDataType.dataType;
        if (index >= 0) {
            dt = this.model.getComponent(index).getDataType();
        }
        return new DataTypeTransferable((DataType)dt);
    }

    public boolean isDropOk(DropTargetDragEvent e) {
        return true;
    }

    public void add(Object obj, DropTargetDropEvent e, DataFlavor f) {
        if (!(obj instanceof DataType)) {
            this.model.setStatus("Only data types can be dropped here.", true);
            return;
        }
        this.model.clearStatus();
        DataType draggedDataType = (DataType)obj;
        Point p = e.getLocation();
        if (e.getDropAction() == 1) {
            this.insertAtPoint(p, draggedDataType);
        } else {
            this.addAtPoint(p, draggedDataType);
        }
    }

    public void insertAtPoint(Point p, DataType dt) {
        this.endFieldEditing();
        int currentIndex = this.table.rowAtPoint(p);
        try {
            this.model.insert(currentIndex, dt);
        }
        catch (UsrException e) {
            this.model.setStatus(e.getMessage(), true);
        }
    }

    public void addAtPoint(Point p, DataType dt) {
        this.endFieldEditing();
        int currentIndex = this.table.rowAtPoint(p);
        try {
            this.model.add(currentIndex, dt);
        }
        catch (UsrException e) {
            this.model.setStatus(e.getMessage(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragUnderFeedback(boolean ok, DropTargetDragEvent e) {
        GTable gTable = this.table;
        synchronized (gTable) {
            int dropAction = e.getDropAction();
            boolean actionChanged = false;
            if (dropAction != this.lastDndAction) {
                actionChanged = true;
                this.lastDndAction = dropAction;
            }
            if (this.table.isEditing()) {
                this.table.editingCanceled(null);
            }
            this.dndTableCellRenderer.selectRange(true);
            this.dndDtiCellRenderer.selectRange(true);
            Point p = e.getLocation();
            int row = this.table.rowAtPoint(p);
            boolean setRow = this.dndTableCellRenderer.setRowForFeedback(row);
            boolean setDtiRow = this.dndDtiCellRenderer.setRowForFeedback(row);
            if (actionChanged || setRow || setDtiRow) {
                this.table.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoDragUnderFeedback() {
        GTable gTable = this.table;
        synchronized (gTable) {
            this.dndTableCellRenderer.setRowForFeedback(-1);
            this.dndDtiCellRenderer.setRowForFeedback(-1);
            this.table.repaint();
        }
    }

    @Override
    public void compositeEditStateChanged(int type) {
        switch (type) {
            case 3: {
                this.cancelCellEditing();
                break;
            }
            case 4: {
                this.cancelCellEditing();
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 5: {
                if (this.table.isEditing()) {
                    return;
                }
                this.beginEditField(this.model.getRow(), this.model.getColumn());
                break;
            }
            case 6: {
                break;
            }
            default: {
                this.model.setStatus("Unrecognized edit state: " + type, true);
            }
        }
    }

    @Override
    public void endFieldEditing() {
        this.stopCellEditing();
        if (this.table.isEditing()) {
            this.cancelCellEditing();
        }
    }

    @Override
    public void statusChanged(String message, boolean beep) {
        if (message == null || message.length() == 0) {
            message = " ";
        }
        this.setStatus(message);
        if (beep) {
            this.getToolkit().beep();
        }
    }

    void search(String searchText, boolean forward) {
        Integer row;
        searchText = searchText.toLowerCase();
        Integer n = row = forward ? this.findForward(searchText) : this.findBackward(searchText);
        if (row != null) {
            this.table.getSelectionModel().setSelectionInterval(row, row);
            Rectangle cellRect = this.table.getCellRect(row.intValue(), 0, true);
            this.table.scrollRectToVisible(cellRect);
        }
    }

    private Integer findForward(String searchText) {
        int col;
        int row;
        int colCount = this.model.getColumnCount();
        int currentRow = Math.max(0, this.model.getRow());
        int rowCount = this.model.getRowCount();
        for (row = currentRow + 1; row < rowCount; ++row) {
            for (col = 0; col < colCount; ++col) {
                if (!this.matchesSearch(searchText, row, col)) continue;
                return row;
            }
        }
        for (row = 0; row < currentRow; ++row) {
            for (col = 0; col < colCount; ++col) {
                if (!this.matchesSearch(searchText, row, col)) continue;
                this.getToolkit().beep();
                return row;
            }
        }
        this.getToolkit().beep();
        return null;
    }

    private Integer findBackward(String searchText) {
        int col;
        int row;
        int colCount = this.model.getColumnCount();
        int currentRow = Math.max(0, this.model.getRow());
        for (row = currentRow - 1; row >= 0; --row) {
            for (col = colCount - 1; col >= 0; --col) {
                if (!this.matchesSearch(searchText, row, col)) continue;
                return row;
            }
        }
        for (row = this.model.getRowCount() - 1; row >= currentRow; --row) {
            for (col = colCount - 1; col >= 0; --col) {
                if (!this.matchesSearch(searchText, row, col)) continue;
                this.getToolkit().beep();
                return row;
            }
        }
        this.getToolkit().beep();
        return null;
    }

    private boolean matchesSearch(String searchText, int row, int col) {
        Object valueAt = this.model.getValueAt(row, col);
        if (valueAt == null) {
            return false;
        }
        String value = this.getString(valueAt);
        return value.toLowerCase().contains(searchText);
    }

    private String getString(Object object) {
        if (object instanceof DataTypeInstance) {
            return ((DataTypeInstance)object).getDataType().getName();
        }
        return object.toString();
    }

    @Override
    public void selectionChanged() {
        int[] mRows;
        int[] tRows = this.table.getSelectedRows();
        if (Arrays.equals(tRows, mRows = this.model.getSelectedRows())) {
            return;
        }
        FieldSelection fs = this.model.getSelection();
        ListSelectionModel lsm = this.table.getSelectionModel();
        ListSelectionModel clsm = this.table.getColumnModel().getSelectionModel();
        lsm.clearSelection();
        int num = fs.getNumRanges();
        for (int i = 0; i < num; ++i) {
            FieldRange range = fs.getFieldRange(i);
            BigInteger startIndex = range.getStart().getIndex();
            BigInteger endIndex = range.getEnd().getIndex();
            lsm.addSelectionInterval(startIndex.intValue(), endIndex.intValue() - 1);
        }
        int modelColumn = this.model.getColumn();
        int viewColumn = this.table.convertColumnIndexToView(modelColumn);
        clsm.setSelectionInterval(viewColumn, viewColumn);
    }

    private class ComponentStringCellEditor
    extends ComponentCellEditor {
        public ComponentStringCellEditor(JTextField textField) {
            super(textField);
            this.getComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    CompositeEditorPanel.this.endFieldEditing();
                }
            });
        }

        public ComponentStringCellEditor() {
            this(new JTextField());
        }

        public Component getTableCellEditorComponent(JTable table1, Object value, boolean isSelected, int row, int column) {
            CompositeEditorPanel.this.model.clearStatus();
            return super.getTableCellEditorComponent(table1, value, isSelected, row, column);
        }
    }

    private class ComponentOffsetCellEditor
    extends ComponentStringCellEditor {
        JTextField offsetField;

        public ComponentOffsetCellEditor() {
            super((JTextField)new GValidatedTextField.LongField(8));
            this.offsetField = (JTextField)this.editorComponent;
        }

        public boolean stopCellEditing() {
            try {
                CompositeEditorPanel.this.model.validateComponentOffset(CompositeEditorPanel.this.table.getEditingRow(), this.offsetField.getText());
                this.fireEditingStopped();
                return true;
            }
            catch (UsrException ue) {
                CompositeEditorPanel.this.model.setStatus(ue.getMessage(), true);
                return false;
            }
        }
    }

    private class ComponentDataTypeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    FocusableEditor {
        private DataTypeSelectionEditor editor;
        private DropDownSelectionTextField<DataType> textField;
        private DataType dt;
        private int maxLength;
        private boolean bitfieldAllowed;
        private JPanel editorPanel;

        private ComponentDataTypeCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table1, Object value, boolean isSelected, int row, int column) {
            CompositeEditorPanel.this.model.clearStatus();
            this.maxLength = CompositeEditorPanel.this.model.getMaxAddLength(row);
            this.bitfieldAllowed = CompositeEditorPanel.this.model.isBitFieldAllowed();
            this.init();
            DataTypeInstance dti = (DataTypeInstance)value;
            this.dt = dti != null ? dti.getDataType() : null;
            this.editor.setCellEditorValue(this.dt);
            return this.editorPanel;
        }

        private void init() {
            Plugin plugin = CompositeEditorPanel.this.provider.getPlugin();
            PluginTool tool = plugin.getTool();
            this.editor = new DataTypeSelectionEditor((ServiceProvider)tool, this.bitfieldAllowed ? DataTypeParser.AllowedDataTypes.SIZABLE_DYNAMIC_AND_BITFIELD : DataTypeParser.AllowedDataTypes.SIZABLE_DYNAMIC);
            this.editor.setTabCommitsEdit(true);
            DataTypeManager originalDataTypeManager = CompositeEditorPanel.this.model.getOriginalDataTypeManager();
            this.editor.setPreferredDataTypeManager(originalDataTypeManager);
            this.editor.setConsumeEnterKeyPress(false);
            this.textField = this.editor.getDropDownTextField();
            this.textField.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            this.editor.addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingCanceled(ChangeEvent e) {
                    ComponentDataTypeCellEditor.this.cancelCellEditing();
                }

                @Override
                public void editingStopped(ChangeEvent e) {
                    ComponentDataTypeCellEditor.this.stopCellEditing();
                }
            });
            JButton dataTypeChooserButton = new JButton("..."){

                @Override
                public Dimension getPreferredSize() {
                    Dimension preferredSize = super.getPreferredSize();
                    preferredSize.width = 15;
                    return preferredSize;
                }
            };
            dataTypeChooserButton.addActionListener(e -> Swing.runLater(() -> this.stopEdit(tool)));
            this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ComponentDataTypeCellEditor.this.textField.selectAll();
                    ComponentDataTypeCellEditor.this.textField.removeFocusListener((FocusListener)this);
                }
            });
            this.editorPanel = new JPanel();
            this.editorPanel.setLayout(new BorderLayout());
            this.editorPanel.add((Component)this.textField, "Center");
            this.editorPanel.add((Component)dataTypeChooserButton, "East");
        }

        private void stopEdit(PluginTool tool) {
            DataTypeManagerService service = (DataTypeManagerService)tool.getService(DataTypeManagerService.class);
            DataType dataType = service.getDataType((String)null);
            if (dataType != null) {
                this.editor.setCellEditorValue(dataType);
                this.editor.stopCellEditing();
            } else {
                this.editor.cancelCellEditing();
            }
        }

        public void focusEditor() {
            this.textField.requestFocusInWindow();
        }

        @Override
        public Object getCellEditorValue() {
            return this.dt;
        }

        @Override
        public boolean stopCellEditing() {
            int editingColumn = CompositeEditorPanel.this.table.getEditingColumn();
            CompositeEditorPanel.this.model.setStatus("");
            if (!this.isEmptyEditorCell() && !this.validateUserChoice()) {
                return false;
            }
            ListSelectionModel columnSelectionModel = CompositeEditorPanel.this.table.getColumnModel().getSelectionModel();
            columnSelectionModel.setValueIsAdjusting(true);
            DataType dataType = (DataType)this.editor.getCellEditorValue();
            if (dataType != null) {
                if (dataType.equals(this.dt)) {
                    this.fireEditingCanceled();
                } else {
                    this.dt = CompositeEditorPanel.this.model.resolve(dataType);
                    this.fireEditingStopped();
                }
            } else {
                this.fireEditingCanceled();
            }
            columnSelectionModel.setSelectionInterval(editingColumn, editingColumn);
            columnSelectionModel.setValueIsAdjusting(false);
            int editingRow = CompositeEditorPanel.this.model.getRow();
            NavigationDirection navigationDirection = this.editor.getNavigationDirection();
            if (navigationDirection == NavigationDirection.BACKWARD) {
                CompositeEditorPanel.this.editPreviousField(editingRow);
            } else if (navigationDirection == NavigationDirection.FORWARD) {
                CompositeEditorPanel.this.editNextField(editingRow);
            }
            return true;
        }

        private boolean isEmptyEditorCell() {
            String cellEditorValueAsText = this.editor.getCellEditorValueAsText();
            String cellText = cellEditorValueAsText.trim();
            return cellText.isEmpty();
        }

        private boolean validateUserChoice() {
            try {
                if (!this.editor.validateUserSelection()) {
                    CompositeEditorPanel.this.model.setStatus("Unrecognized data type of \"" + this.editor.getCellEditorValueAsText() + "\" entered.");
                    return false;
                }
                DataType dataType = (DataType)this.editor.getCellEditorValue();
                int dtLen = dataType.getLength();
                if (this.maxLength >= 0 && dtLen > this.maxLength) {
                    CompositeEditorPanel.this.model.setStatus(dataType.getDisplayName() + " doesn't fit within " + this.maxLength + " bytes, need " + dtLen + " bytes");
                    return false;
                }
            }
            catch (InvalidDataTypeException idte) {
                CompositeEditorPanel.this.model.setStatus(idte.getMessage());
                return false;
            }
            return true;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= 2;
            }
            return true;
        }
    }

    private class ComponentNameCellEditor
    extends ComponentStringCellEditor {
        private static final long serialVersionUID = 1L;

        public ComponentNameCellEditor() {
            super(new JTextField());
        }

        public boolean stopCellEditing() {
            try {
                CompositeEditorPanel.this.model.validateComponentName(CompositeEditorPanel.this.table.getEditingRow(), ((JTextComponent)this.getComponent()).getText());
                this.fireEditingStopped();
                return true;
            }
            catch (UsrException ue) {
                CompositeEditorPanel.this.model.setStatus(ue.getMessage(), true);
                return false;
            }
        }
    }

    private class CompositeEditorTable
    extends GTable {
        public CompositeEditorTable(TableModel model) {
            super(model);
        }

        protected void installEditKeyBinding() {
            KeyStroke keyStroke = KeyStroke.getKeyStroke("pressed F2");
            KeyBindingUtils.clearKeyBinding((JComponent)((Object)this), (KeyStroke)keyStroke);
        }
    }

    private class CompositeTableMouseListener
    extends MouseAdapter {
        private CompositeTableMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkMouseEvent(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.checkMouseEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkMouseEvent(e);
        }

        private void checkMouseEvent(MouseEvent e) {
            DataType dt;
            boolean isStringColumn;
            boolean isPopup = e.isPopupTrigger();
            Point point = e.getPoint();
            int row = CompositeEditorPanel.this.table.rowAtPoint(point);
            int column = CompositeEditorPanel.this.table.columnAtPoint(point);
            int modelColumn = CompositeEditorPanel.this.table.convertColumnIndexToModel(column);
            int clickCount = e.getClickCount();
            if (!CompositeEditorPanel.this.table.isEditing() && e.getID() == 501) {
                CompositeEditorPanel.this.model.clearStatus();
            }
            if (isPopup) {
                if (!CompositeEditorPanel.this.table.isRowSelected(row)) {
                    CompositeEditorPanel.this.table.setRowSelectionInterval(row, row);
                }
                return;
            }
            if (clickCount < 2 || e.getButton() != 1) {
                return;
            }
            if (CompositeEditorPanel.this.model.isCellEditable(row, modelColumn)) {
                return;
            }
            String columnName = CompositeEditorPanel.this.model.getColumnName(modelColumn);
            String status = columnName + " field is not editable";
            boolean isValidRow = row >= 0 && row < CompositeEditorPanel.this.model.getNumComponents();
            boolean bl = isStringColumn = modelColumn == CompositeEditorPanel.this.model.getNameColumn() || modelColumn == CompositeEditorPanel.this.model.getCommentColumn();
            if (isValidRow && isStringColumn && (dt = CompositeEditorPanel.this.model.getComponent(row).getDataType()) == DataType.DEFAULT) {
                status = columnName + " field is not editable for Undefined byte.";
            }
            CompositeEditorPanel.this.model.setStatus(status);
            e.consume();
        }
    }
}

