/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.MultiFunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.MultiFunctionComparisonProvider;
import ghidra.program.model.listing.Function;
import ghidra.util.HelpLocation;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JComboBox;

public class RemoveFunctionsAction
extends DockingAction {
    private static final String REMOVE_FUNCTION_GROUP = "A9_RemoveFunctions";
    private static final Icon REMOVE_FUNCTION_ICON = new GIcon("icon.plugin.functioncompare.function.remove");

    public RemoveFunctionsAction(MultiFunctionComparisonProvider provider) {
        super("Remove Functions", provider.getOwner());
        this.setKeyBindingData(new KeyBindingData('R', 192));
        this.setDescription("Removes function in the focused comparison panel");
        this.setPopupMenuData(new MenuData(new String[]{"Remove Function"}, REMOVE_FUNCTION_ICON, REMOVE_FUNCTION_GROUP));
        ToolBarData newToolBarData = new ToolBarData(REMOVE_FUNCTION_ICON, REMOVE_FUNCTION_GROUP);
        this.setToolBarData(newToolBarData);
        HelpLocation helpLocation = new HelpLocation("FunctionComparison", "Remove_From_Comparison");
        this.setHelpLocation(helpLocation);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context.getComponentProvider() instanceof MultiFunctionComparisonProvider)) {
            return false;
        }
        MultiFunctionComparisonProvider provider = (MultiFunctionComparisonProvider)context.getComponentProvider();
        FunctionComparisonPanel comp = provider.getComponent();
        if (!(comp instanceof MultiFunctionComparisonPanel)) {
            return false;
        }
        MultiFunctionComparisonPanel panel = (MultiFunctionComparisonPanel)comp;
        JComboBox<Function> focusedComponent = panel.getFocusedComponent();
        return focusedComponent.getSelectedIndex() != -1;
    }

    public void actionPerformed(ActionContext context) {
        MultiFunctionComparisonProvider provider = (MultiFunctionComparisonProvider)context.getComponentProvider();
        JComboBox<Function> focusedComponent = ((MultiFunctionComparisonPanel)provider.getComponent()).getFocusedComponent();
        Function selectedFunction = (Function)focusedComponent.getSelectedItem();
        provider.removeFunctions(new HashSet<Function>(Arrays.asList(selectedFunction)));
        provider.contextChanged();
    }
}

