/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import docking.ActionContext;
import docking.action.DockingAction;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.progmgr.ProgramManagerPlugin;
import ghidra.program.model.listing.Program;

public abstract class AbstractProgramNameSwitchingAction
extends DockingAction {
    protected ProgramManagerPlugin plugin;
    protected Program lastContextProgram;

    public AbstractProgramNameSwitchingAction(ProgramManagerPlugin plugin, String name) {
        super(name, plugin.getName());
        this.plugin = plugin;
        this.addToWindowWhen(ProgramActionContext.class);
    }

    public boolean isValidContext(ActionContext context) {
        Program program = this.getProgram(context);
        if (program != this.lastContextProgram) {
            this.lastContextProgram = program;
            this.programChanged(program);
        }
        return true;
    }

    public final boolean isEnabledForContext(ActionContext context) {
        return this.isEnabledForContext(this.getProgram(context));
    }

    protected boolean isEnabledForContext(Program program) {
        return program != null;
    }

    public void actionPerformed(ActionContext context) {
        Program program = this.getProgram(context);
        if (program != null) {
            this.actionPerformed(program);
        }
    }

    protected abstract void actionPerformed(Program var1);

    protected abstract void programChanged(Program var1);

    protected Program getProgram(ActionContext context) {
        Program program;
        if (context instanceof ProgramActionContext && this.plugin.isManaged(program = ((ProgramActionContext)context).getProgram())) {
            return program;
        }
        return this.plugin.getCurrentProgram();
    }
}

