/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldCacheSlideInfo2
extends DyldCacheSlideInfoCommon {
    private static final int DYLD_CACHE_SLIDE_PAGE_ATTR_NO_REBASE = 16384;
    private static final int DYLD_CACHE_SLIDE_PAGE_ATTR_EXTRA = 32768;
    private int page_size;
    private int page_starts_offset;
    private int page_starts_count;
    private int page_extras_offset;
    private int page_extras_count;
    private long delta_mask;
    private long value_add;
    private short[] page_starts_entries;
    private short[] page_extras_entries;

    public long getPageSize() {
        return Integer.toUnsignedLong(this.page_size);
    }

    public long getPageStartsOffset() {
        return Integer.toUnsignedLong(this.page_starts_offset);
    }

    public long getPageStartsCount() {
        return Integer.toUnsignedLong(this.page_starts_count);
    }

    public long getPageExtrasOffset() {
        return Integer.toUnsignedLong(this.page_extras_offset);
    }

    public long getPageExtrasCount() {
        return Integer.toUnsignedLong(this.page_extras_count);
    }

    public long getDeltaMask() {
        return this.delta_mask;
    }

    public long getValueAdd() {
        return this.value_add;
    }

    public short[] getPageStarts() {
        return this.page_starts_entries;
    }

    public short[] getPageExtras() {
        return this.page_extras_entries;
    }

    public DyldCacheSlideInfo2(BinaryReader reader) throws IOException {
        super(reader);
        this.page_size = reader.readNextInt();
        this.page_starts_offset = reader.readNextInt();
        this.page_starts_count = reader.readNextInt();
        this.page_extras_offset = reader.readNextInt();
        this.page_extras_count = reader.readNextInt();
        this.delta_mask = reader.readNextLong();
        this.value_add = reader.readNextLong();
        this.page_starts_entries = reader.readNextShortArray(this.page_starts_count);
        this.page_extras_entries = reader.readNextShortArray(this.page_extras_count);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_slide_info2", 0);
        struct.add(DWORD, "version", "");
        struct.add(DWORD, "page_size", "");
        struct.add(DWORD, "page_starts_offset", "");
        struct.add(DWORD, "page_starts_count", "");
        struct.add(DWORD, "page_extras_offset", "");
        struct.add(DWORD, "page_extras_count", "");
        struct.add(QWORD, "delta_mask", "");
        struct.add(QWORD, "value_add", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public void fixPageChains(Program program, DyldCacheHeader dyldCacheHeader, boolean addRelocations, MessageLog log, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        long fixedAddressCount = 0L;
        List<DyldCacheMappingInfo> mappingInfos = dyldCacheHeader.getMappingInfos();
        DyldCacheMappingInfo dyldCacheMappingInfo = mappingInfos.get(1);
        long dataPageStart = dyldCacheMappingInfo.getAddress();
        long pageSize = this.getPageSize();
        long pageStartsCount = this.getPageStartsCount();
        long deltaMask = this.getDeltaMask();
        long deltaShift = Long.numberOfTrailingZeros(deltaMask);
        long valueAdd = this.getValueAdd();
        short[] pageEntries = this.getPageStarts();
        short[] extraEntries = this.getPageExtras();
        monitor.setMessage("Fixing V2 chained data page pointers...");
        monitor.setMaximum(pageStartsCount);
        int index = 0;
        while ((long)index < pageStartsCount) {
            monitor.checkCancelled();
            long page = dataPageStart + pageSize * (long)index;
            monitor.setProgress((long)index);
            int pageEntry = pageEntries[index] & 0xFFFF;
            if (pageEntry != 16384) {
                List<Object> unchainedLocList;
                if ((pageEntry & 0x8000) != 0) {
                    int extraIndex = pageEntry & 0x3FFF;
                    unchainedLocList = new ArrayList(1024);
                    do {
                        pageEntry = extraEntries[extraIndex] & 0xFFFF;
                        long pageOffset = (pageEntry & 0x3FFF) * 4;
                        List<Address> subLocList = this.processPointerChain2(program, page, pageOffset, deltaMask, deltaShift, valueAdd, addRelocations, monitor);
                        unchainedLocList.addAll(subLocList);
                        ++extraIndex;
                    } while ((pageEntry & 0x8000) == 0);
                } else {
                    long pageOffset = pageEntry * 4;
                    unchainedLocList = this.processPointerChain2(program, page, pageOffset, deltaMask, deltaShift, valueAdd, addRelocations, monitor);
                }
                fixedAddressCount += (long)unchainedLocList.size();
                this.createChainPointers(program, unchainedLocList, monitor);
            }
            ++index;
        }
        log.appendMsg("Fixed " + fixedAddressCount + " chained pointers.");
    }

    private List<Address> processPointerChain2(Program program, long page, long nextOff, long deltaMask, long deltaShift, long valueAdd, boolean addRelocations, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        Address chainStart = program.getLanguage().getDefaultSpace().getAddress(page);
        Memory memory = program.getMemory();
        ArrayList<Address> unchainedLocList = new ArrayList<Address>(1024);
        long valueMask = -1L >>> (int)(64L - deltaShift);
        long delta = -1L;
        while (delta != 0L) {
            monitor.checkCancelled();
            Address chainLoc = chainStart.add(nextOff);
            long chainValue = memory.getLong(chainLoc);
            delta = (chainValue & deltaMask) >> (int)deltaShift;
            if ((chainValue &= valueMask) != 0L) {
                chainValue += valueAdd;
            }
            if (addRelocations) {
                this.addRelocationTableEntry(program, chainLoc, 2, chainValue, 8, null);
            }
            memory.setLong(chainLoc, chainValue);
            unchainedLocList.add(chainLoc);
            nextOff += delta * 4L;
        }
        return unchainedLocList;
    }
}

