/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramWrapperLoader;
import ghidra.app.util.opinion.DefExportLine;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public class DefLoader
extends AbstractProgramWrapperLoader {
    public static final String DEF_NAME = "Module Definition (DEF)";
    public static final String NO_MAGIC = "0";

    private List<DefExportLine> parseExports(ByteProvider provider) throws IOException {
        ArrayList<DefExportLine> list = new ArrayList<DefExportLine>();
        try (InputStream inputStream = provider.getInputStream(0L);){
            boolean hasExports = false;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(";") || line.isEmpty() || line.startsWith("LIBRARY")) continue;
                if (line.startsWith("EXPORTS")) {
                    hasExports = true;
                    continue;
                }
                if (!hasExports) continue;
                DefExportLine exp = new DefExportLine(line);
                list.add(exp);
            }
        }
        return list;
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        String name = provider.getName();
        if (name != null && name.toLowerCase().endsWith(".def") && !this.parseExports(provider).isEmpty()) {
            List<QueryResult> results = QueryOpinionService.query(this.getName(), NO_MAGIC, null);
            for (QueryResult result : results) {
                loadSpecs.add(new LoadSpec((Loader)this, 0L, result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, 0L, true));
            }
        }
        return loadSpecs;
    }

    @Override
    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program prog, TaskMonitor monitor, MessageLog log) throws IOException {
        if (!prog.getExecutableFormat().equals("Portable Executable (PE)")) {
            throw new IOException("Program must be a Portable Executable (PE)");
        }
        SymbolTable symtab = prog.getSymbolTable();
        Consumer<String> errorConsumer = err -> log.error("DefLoader", err);
        for (DefExportLine def : this.parseExports(provider)) {
            Symbol symbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)prog, (String)("Ordinal_" + def.getOrdinal()), errorConsumer);
            if (symbol == null) continue;
            try {
                Symbol label = symtab.createLabel(symbol.getAddress(), def.getName(), SourceType.IMPORTED);
                label.setPrimary();
            }
            catch (InvalidInputException e) {
                log.appendMsg(e.getMessage());
            }
        }
    }

    @Override
    public String getName() {
        return DEF_NAME;
    }
}

