/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.task;

import docking.widgets.OptionDialog;
import ghidra.app.util.dialog.CheckoutDialog;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.protocol.ghidra.GhidraURLConnection;
import ghidra.framework.protocol.ghidra.GhidraURLWrappedContent;
import ghidra.framework.remote.User;
import ghidra.framework.store.ExclusiveCheckoutException;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.VersionExceptionHandler;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OpenProgramTask
extends Task {
    private final List<OpenProgramRequest> openProgramRequests = new ArrayList<OpenProgramRequest>();
    private List<OpenProgramRequest> openedProgramList = new ArrayList<OpenProgramRequest>();
    private final Object consumer;
    private boolean silent;
    private boolean noCheckout;
    private String openPromptText = "Open";

    public OpenProgramTask(Object consumer) {
        super("Open Program(s)", true, false, true);
        this.consumer = consumer;
    }

    public OpenProgramTask(DomainFile domainFile, int version, boolean forceReadOnly, Object consumer) {
        super("Open Program(s)", true, false, true);
        this.consumer = consumer;
        this.openProgramRequests.add(new OpenProgramRequest(domainFile, version, forceReadOnly));
    }

    public OpenProgramTask(DomainFile domainFile, int version, Object consumer) {
        this(domainFile, version, false, consumer);
    }

    public OpenProgramTask(DomainFile domainFile, boolean forceReadOnly, Object consumer) {
        this(domainFile, -1, forceReadOnly, consumer);
    }

    public OpenProgramTask(DomainFile domainFile, Object consumer) {
        this(domainFile, -1, false, consumer);
    }

    public OpenProgramTask(URL ghidraURL, Object consumer) {
        super("Open Program(s)", true, false, true);
        this.consumer = consumer;
        this.openProgramRequests.add(new OpenProgramRequest(ghidraURL));
    }

    public void setOpenPromptText(String text) {
        this.openPromptText = text;
    }

    public void addProgramToOpen(DomainFile domainFile, int version) {
        this.addProgramToOpen(domainFile, version, false);
    }

    public void addProgramToOpen(DomainFile domainFile, int version, boolean forceReadOnly) {
        this.setHasProgress(true);
        this.openProgramRequests.add(new OpenProgramRequest(domainFile, version, forceReadOnly));
    }

    public void addProgramToOpen(URL ghidraURL) {
        this.setHasProgress(true);
        this.openProgramRequests.add(new OpenProgramRequest(ghidraURL));
    }

    public boolean hasOpenProgramRequests() {
        return !this.openProgramRequests.isEmpty();
    }

    public void setSilent() {
        this.silent = true;
    }

    public void setNoCheckout() {
        this.noCheckout = true;
    }

    public List<OpenProgramRequest> getOpenPrograms() {
        return Collections.unmodifiableList(this.openedProgramList);
    }

    public OpenProgramRequest getOpenProgram() {
        if (this.openedProgramList.isEmpty()) {
            return null;
        }
        return this.openedProgramList.get(0);
    }

    public void run(TaskMonitor monitor) {
        this.taskMonitor.initialize((long)this.openProgramRequests.size());
        for (OpenProgramRequest domainFileInfo : this.openProgramRequests) {
            if (this.taskMonitor.isCancelled()) {
                return;
            }
            domainFileInfo.open();
            this.taskMonitor.incrementProgress(1L);
        }
    }

    private Object openReadOnlyFile(DomainFile domainFile, URL url, int version) {
        this.taskMonitor.setMessage("Opening " + domainFile.getName());
        return this.openReadOnly(domainFile, url, version);
    }

    private Object openVersionedFile(DomainFile domainFile, URL url, int version) {
        this.taskMonitor.setMessage("Getting Version " + version + " for " + domainFile.getName());
        return this.openReadOnly(domainFile, url, version);
    }

    private Object openReadOnly(DomainFile domainFile, URL url, int version) {
        String contentType = domainFile.getContentType();
        String path = url != null ? url.toString() : domainFile.getPathname();
        DomainObject obj = null;
        try {
            obj = domainFile.getReadOnlyDomainObject(this.consumer, version, this.taskMonitor);
        }
        catch (CancelledException cancelledException) {
        }
        catch (IOException e) {
            if (url == null && domainFile.isInWritableProject()) {
                ClientUtil.handleException((RepositoryAdapter)AppInfo.getActiveProject().getRepository(), (Exception)e, (String)("Get " + contentType), null);
            } else if (version != -1) {
                Msg.showError((Object)((Object)this), null, (String)"Error Getting Versioned Program", (Object)("Could not get version " + version + " for " + path), (Throwable)e);
            } else {
                Msg.showError((Object)((Object)this), null, (String)"Error Getting Program", (Object)("Open program failed for " + path), (Throwable)e);
            }
        }
        catch (VersionException e) {
            VersionExceptionHandler.showVersionError(null, (String)domainFile.getName(), (String)contentType, (String)"Open", (VersionException)e);
        }
        return obj;
    }

    private Program openUnversionedFile(DomainFile domainFile) {
        String filename = domainFile.getName();
        this.taskMonitor.setMessage("Opening " + filename);
        this.performOptionalCheckout(domainFile);
        try {
            return this.openFileMaybeUgrade(domainFile);
        }
        catch (VersionException e) {
            String contentType = domainFile.getContentType();
            VersionExceptionHandler.showVersionError(null, (String)filename, (String)contentType, (String)"Open", (VersionException)e);
        }
        catch (CancelledException e) {
        }
        catch (LanguageNotFoundException e) {
            Msg.showError((Object)((Object)this), null, (String)("Error Opening " + filename), (Object)(e.getMessage() + "\nPlease contact the Ghidra team for assistance."));
        }
        catch (Exception e) {
            if (domainFile.isInWritableProject() && e instanceof IOException) {
                RepositoryAdapter repo = domainFile.getParent().getProjectData().getRepository();
                ClientUtil.handleException((RepositoryAdapter)repo, (Exception)e, (String)"Open File", null);
            }
            Msg.showError((Object)((Object)this), null, (String)("Error Opening " + filename), (Object)("Getting domain object failed.\n" + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    private Program openFileMaybeUgrade(DomainFile domainFile) throws IOException, CancelledException, VersionException {
        Program program;
        block3: {
            boolean recoverFile = false;
            if (!this.silent && domainFile.isInWritableProject() && domainFile.canRecover()) {
                recoverFile = this.askRecoverFile(domainFile.getName());
            }
            program = null;
            try {
                program = (Program)domainFile.getDomainObject(this.consumer, false, recoverFile, this.taskMonitor);
            }
            catch (VersionException e) {
                if (!VersionExceptionHandler.isUpgradeOK(null, (DomainFile)domainFile, (String)this.openPromptText, (VersionException)e)) break block3;
                program = (Program)domainFile.getDomainObject(this.consumer, true, recoverFile, this.taskMonitor);
            }
        }
        return program;
    }

    private boolean askRecoverFile(String filename) {
        int option = OptionDialog.showYesNoDialog(null, (String)"Crash Recovery Data Found", (String)("<html>" + HTMLUtilities.escapeHTML((String)filename) + " has crash data.<br>Would you like to recover unsaved changes?"));
        return option == 1;
    }

    private void performOptionalCheckout(DomainFile domainFile) {
        if (this.silent || this.noCheckout || !domainFile.canCheckout()) {
            return;
        }
        User user = domainFile.getParent().getProjectData().getUser();
        CheckoutDialog dialog = new CheckoutDialog(domainFile, user);
        if (dialog.showDialog() == 0) {
            try {
                this.taskMonitor.setMessage("Checking Out " + domainFile.getName());
                if (domainFile.checkout(dialog.exclusiveCheckout(), this.taskMonitor)) {
                    return;
                }
                Msg.showError((Object)((Object)this), null, (String)"Checkout Failed", (Object)("Exclusive checkout failed for: " + domainFile.getName() + "\nOne or more users have file checked out!"));
            }
            catch (CancelledException cancelledException) {
            }
            catch (ExclusiveCheckoutException e) {
                Msg.showError((Object)((Object)this), null, (String)"Checkout Failed", (Object)e.getMessage());
            }
            catch (IOException e) {
                Msg.showError((Object)((Object)this), null, (String)"Error on Check Out", (Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public class OpenProgramRequest {
        private final URL ghidraURL;
        private final DomainFile domainFile;
        private URL linkURL;
        private final int version;
        private final boolean forceReadOnly;
        private Program program;

        public OpenProgramRequest(URL ghidraURL) {
            if (!"ghidra".equals(ghidraURL.getProtocol())) {
                throw new IllegalArgumentException("unsupported protocol: " + ghidraURL.getProtocol());
            }
            this.ghidraURL = ghidraURL;
            this.domainFile = null;
            this.version = -1;
            this.forceReadOnly = true;
        }

        public OpenProgramRequest(DomainFile domainFile, int version, boolean forceReadOnly) {
            this.domainFile = domainFile;
            this.ghidraURL = null;
            this.version = domainFile.isReadOnly() && domainFile.isVersioned() ? domainFile.getVersion() : version;
            this.forceReadOnly = forceReadOnly;
        }

        public DomainFile getDomainFile() {
            return this.domainFile;
        }

        public URL getGhidraURL() {
            return this.ghidraURL;
        }

        public URL getLinkURL() {
            return this.linkURL;
        }

        public Program getProgram() {
            return this.program;
        }

        public void release() {
            if (this.program != null) {
                this.program.release(OpenProgramTask.this.consumer);
            }
        }

        private Program openProgram(DomainFile df, URL url) {
            if (this.version != -1) {
                return (Program)OpenProgramTask.this.openVersionedFile(df, url, this.version);
            }
            if (this.forceReadOnly) {
                return (Program)OpenProgramTask.this.openReadOnlyFile(df, url, this.version);
            }
            return OpenProgramTask.this.openUnversionedFile(df);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void open() {
            block22: {
                Object content;
                GhidraURLWrappedContent wrappedContent;
                block21: {
                    block20: {
                        block19: {
                            DomainFile df = this.domainFile;
                            URL url = this.ghidraURL;
                            wrappedContent = null;
                            content = null;
                            try {
                                if (df == null && url != null) {
                                    GhidraURLConnection c = (GhidraURLConnection)url.openConnection();
                                    Object obj = c.getContent();
                                    if (c.getStatusCode() == GhidraURLConnection.StatusCode.UNAUTHORIZED) {
                                        return;
                                    }
                                    if (!(obj instanceof GhidraURLWrappedContent)) {
                                        this.messageBadProgramURL(url);
                                        if (content == null) return;
                                        break block19;
                                    }
                                    wrappedContent = (GhidraURLWrappedContent)obj;
                                    content = wrappedContent.getContent((Object)this);
                                    if (!(content instanceof DomainFile)) {
                                        this.messageBadProgramURL(url);
                                        if (content == null) return;
                                        break block20;
                                    }
                                    df = (DomainFile)content;
                                    if ("ProgramLink".equals(df.getContentType())) {
                                        Msg.showError((Object)this, null, (String)"Program Multi-Link Error", (Object)("Multi-link Program access not supported: " + url));
                                        if (content == null) return;
                                        break block21;
                                    }
                                }
                                if (!Program.class.isAssignableFrom(df.getDomainObjectClass())) {
                                    Msg.showError((Object)this, null, (String)"Error Opening Program", (Object)("File does not correspond to a Ghidra Program: " + df.getPathname()));
                                    return;
                                }
                                this.program = this.openProgram(df, url);
                                break block22;
                            }
                            catch (MalformedURLException e) {
                                Msg.showError((Object)this, null, (String)"Invalid Ghidra URL", (Object)("Improperly formed Ghidra URL: " + url));
                                break block22;
                            }
                            catch (IOException e) {
                                Msg.showError((Object)this, null, (String)"Program Open Failed", (Object)("Failed to open Ghidra URL: " + e.getMessage()));
                                break block22;
                            }
                        }
                        wrappedContent.release(content, (Object)this);
                        return;
                    }
                    wrappedContent.release(content, (Object)this);
                    return;
                }
                wrappedContent.release(content, (Object)this);
                return;
                finally {
                    if (content != null) {
                        wrappedContent.release(content, (Object)this);
                    }
                }
            }
            if (this.program == null) return;
            OpenProgramTask.this.openedProgramList.add(this);
        }

        private void messageBadProgramURL(URL url) {
            Msg.error((Object)"Invalid Ghidra URL", (Object)("Ghidra URL does not reference a Ghidra Program: " + url));
        }
    }
}

