/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.tasks;

import docking.widgets.OptionDialog;
import ghidra.formats.gfilesystem.AbstractFileExtractorTask;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.util.DateUtils;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import utilities.util.FileUtilities;

public class GFileSystemExtractAllTask
extends AbstractFileExtractorTask {
    private FSRL srcFSRL;
    private Component parentComponent;
    private boolean skipAllErrors;
    private Map<FSRL, String> errorredFiles = new LinkedHashMap<FSRL, String>();

    public GFileSystemExtractAllTask(FSRL srcFSRL, File outputDirectory, Component parentComponent) {
        super("Extracting directory...", true, false, true, outputDirectory);
        this.srcFSRL = srcFSRL;
        this.parentComponent = parentComponent;
    }

    public void run(TaskMonitor monitor) {
        long start_ts = System.currentTimeMillis();
        monitor.setMessage("Extracting all...");
        try (RefdFile refdFile = FileSystemService.getInstance().getRefdFile(this.srcFSRL, monitor);){
            GFileSystem fs = refdFile.fsRef.getFilesystem();
            GFile file = refdFile.file;
            if (!file.isDirectory()) {
                Msg.warn((Object)((Object)this), (Object)("Extract All source not a directory!  " + file.getFSRL()));
                return;
            }
            if (this.verifyRootOutputDir(file.getName())) {
                this.startExtract(fs, file, monitor);
            }
        }
        catch (CancelledException ce) {
            Msg.warn((Object)((Object)this), (Object)"Extract all task canceled");
        }
        catch (IOException | UnsupportedOperationException e) {
            Msg.showError((Object)((Object)this), (Component)this.parentComponent, (String)"Error extracting file", (Object)e.getMessage());
        }
        Msg.info((Object)((Object)this), (Object)("Exported " + this.getTotalFilesExportedCount() + " files, " + this.getTotalDirsExportedCount() + " directories, " + this.getTotalBytesExportedCount() + " bytes"));
        long elapsed = System.currentTimeMillis() - start_ts;
        int option = OptionDialog.showOptionDialog((Component)this.parentComponent, (String)"Export Summary", (String)("<html><div style='margin-bottom: 20pt; text-align: center; font-weight: bold'>Export files summary:</div><div style='margin-bottom: 20pt'>Source location:</div><div style='margin-bottom: 20pt; margin-left: 50pt'>" + HTMLUtilities.friendlyEncodeHTML((String)this.srcFSRL.toPrettyString()) + "</div><div style='margin-bottom: 20pt;'>Destination:</div><div style='margin-bottom: 20pt; margin-left: 50pt'>" + HTMLUtilities.friendlyEncodeHTML((String)this.rootOutputDirectory.getPath()) + "</div><div style='margin-bottom: 20pt;'>Elapsed time: " + DateUtils.formatDuration((long)elapsed) + "</div><table style='margin-bottom: 20pt;' width='100%'><tr><td></td><td>Files</td><td>Directories</td><td>Bytes</td></tr><tr><td>Successful</td><td>" + this.getTotalFilesExportedCount() + "</td><td>" + this.getTotalDirsExportedCount() + "</td><td>" + FileUtilities.formatLength((long)this.getTotalBytesExportedCount()) + "</td></tr><tr><td>Failed</td><td>" + this.errorredFiles.size() + "</td><td></td><td></td></tr></table></div></html>"), (String)"OK", (String)"Show exported files");
        if (option == 2) {
            try {
                FileUtilities.openNative((File)this.rootOutputDirectory);
            }
            catch (IOException e) {
                Msg.showError((Object)((Object)this), (Component)this.parentComponent, (String)"Problem Starting Explorer", (Object)("Problem starting file explorer: " + e.getMessage()));
            }
        }
    }

    private boolean verifyRootOutputDir(String destDirName) {
        int answer;
        File newRootOutputDir;
        boolean isSameName = destDirName.equals(this.rootOutputDirectory.getName());
        File file = newRootOutputDir = isSameName ? this.rootOutputDirectory : new File(this.rootOutputDirectory, destDirName);
        if (newRootOutputDir.isFile()) {
            Msg.showError((Object)((Object)this), (Component)this.parentComponent, (String)"Export Destination Error", (Object)("Unable to export to " + newRootOutputDir + " as it is a file"));
            return false;
        }
        if (newRootOutputDir.exists() && newRootOutputDir.list().length > 0 && (answer = OptionDialog.showYesNoDialog((Component)this.parentComponent, (String)"Verify Export Destination", (String)(newRootOutputDir.getAbsolutePath() + "\nThe directory is not empty.\nDo you want to overwrite the contents?"))) == 2) {
            return false;
        }
        this.rootOutputDirectory = newRootOutputDir;
        return true;
    }

    @Override
    protected boolean handleUnexpectedException(GFile file, Exception e) {
        this.errorredFiles.put(file.getFSRL(), e.getMessage());
        if (this.skipAllErrors) {
            return true;
        }
        int option = OptionDialog.showOptionDialog((Component)this.parentComponent, (String)"Error Extracting File", (String)("There was a problem copying file " + file.getPath() + "\n\n" + e.getMessage() + "\n\nSkip this file and continue or cancel entire operation?"), (String)"Skip && Continue", (String)"Skip All");
        if (option == 2) {
            this.skipAllErrors = true;
        }
        return this.skipAllErrors || option == 1;
    }
}

