/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.appclient.server.core.ClientJarMaker;
import org.glassfish.appclient.server.core.ClientJarMakerUtils;

class ApplicationClientJarMaker
implements ClientJarMaker {
    protected Properties props;

    public ApplicationClientJarMaker(Properties props) {
        this.props = props;
    }

    public void create(RootDeploymentDescriptor descriptor, ReadableArchive source, WritableArchive target, ZipItem[] stubs, Properties props) throws IOException {
        this.create(descriptor, source, null, target, stubs, props);
    }

    public void create(RootDeploymentDescriptor descriptor, ReadableArchive source, ReadableArchive source2, WritableArchive target, ZipItem[] stubs, Properties props) throws IOException {
        ClientJarMakerUtils.populateStubs(target, stubs);
        if (!descriptor.isApplication()) {
            ClientJarMakerUtils.populateModuleJar(source, source2, target);
            return;
        }
        ArrayList<String> libraries = new ArrayList<String>();
        URI appURI = new File(source.getURI().getSchemeSpecificPart()).toURI();
        Application app = (Application)Application.class.cast(descriptor);
        for (ModuleDescriptor<BundleDescriptor> md : app.getModules()) {
            if (!md.getModuleType().equals(XModuleType.WAR) && !md.getModuleType().equals(XModuleType.RAR)) {
                ReadableArchive subSource = source.getSubArchive(md.getArchiveUri());
                ReadableArchive subSource2 = null;
                if (source2 != null) {
                    subSource2 = source2.getSubArchive(md.getArchiveUri());
                }
                WritableArchive subTarget = target.createSubArchive(md.getArchiveUri());
                String archiveUri = md.getArchiveUri().replace('\\', '/');
                URI parentURI = null;
                try {
                    parentURI = ClientJarMakerUtils.getParent(archiveUri);
                }
                catch (URISyntaxException ex) {
                    IOException ioe = new IOException();
                    ioe.initCause(ex);
                    throw ioe;
                }
                ClientJarMakerUtils.populateModuleJar(subSource, subSource2, subTarget, libraries, appURI, parentURI);
                target.closeEntry(subTarget);
                subSource.close();
                if (source2 != null) {
                    subSource2.close();
                }
            }
            if (md.getAlternateDescriptor() == null) continue;
            String ddPath = md.getAlternateDescriptor();
            String runtimeDDPath = "sun-" + ddPath;
            if (source2 != null) {
                ClientJarMakerUtils.copy(source2, target, ddPath);
                ClientJarMakerUtils.copy(source2, target, runtimeDDPath);
                continue;
            }
            ClientJarMakerUtils.copy(source, target, ddPath);
            ClientJarMakerUtils.copy(source, target, runtimeDDPath);
        }
        List<String> additionalLibraries = ClientJarMakerUtils.getLibraryEntries(app, source);
        libraries.addAll(additionalLibraries);
        ClientJarMakerUtils.addClassPathElementsFromManifestClassPaths(new File(appURI), libraries);
        ClientJarMakerUtils.copyLibraries(source, target, libraries);
        ClientJarMakerUtils.copyDeploymentDescriptors(new ApplicationArchivist(), source, source2, target);
    }
}

