/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws.servedcontent;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.appclient.server.core.jws.Util;

public class ACCConfigContent {
    private final SunACCPairedFiles sunACC;
    private final PairedFiles appClientLogin;
    private File messageSecurityConfigFile;
    private static final Pattern SECURITY_CONFIG_VALUE_PATTERN = Pattern.compile("<property name=\"security.config\"\\s*value=\"([^\"]*)\"\\s*/\\s*>");
    private static final String SECURITY_CONFIG_REPLACEMENT = "<property name=\"security.config\" value=\"\\${security.config.path}\"/>";

    public ACCConfigContent(File domainConfig, File installLibAppclient) throws FileNotFoundException, IOException {
        this.sunACC = SunACCPairedFiles.newSunACCPairedFiles(new File(domainConfig, "sun-acc.xml"), new File(domainConfig, "sun-acc.jws.xml"));
        this.appClientLogin = PairedFiles.newPairedFiles(new File(installLibAppclient, "appclientlogin.conf"), new File(installLibAppclient, "appclientlogin.jws.conf"));
    }

    public String sunACC() throws FileNotFoundException, IOException {
        return this.sunACC.content();
    }

    public String appClientLogin() throws FileNotFoundException, IOException {
        return this.appClientLogin.content();
    }

    public String securityConfig() throws FileNotFoundException, IOException {
        return this.sunACC.securityConfigContent();
    }

    private static class PairedFiles {
        private final File normalFile;
        private final File jwsFile;
        private String currentContent;
        private long lastModified = 0L;

        private static PairedFiles newPairedFiles(File normalFile, File jwsFile) throws FileNotFoundException, IOException {
            PairedFiles result = new PairedFiles(normalFile, jwsFile);
            result.setCurrentContent();
            return result;
        }

        private PairedFiles(File normalFile, File jwsFile) throws FileNotFoundException, IOException {
            this.normalFile = normalFile;
            this.jwsFile = jwsFile;
        }

        protected long lastModified() {
            return this.lastModified;
        }

        protected void setCurrentContent() throws FileNotFoundException, IOException {
            this.setCurrentContent(this.loadContent(this.fileToCheck()));
        }

        protected void setCurrentContent(String content) {
            this.currentContent = content;
            this.lastModified = this.fileToCheck().lastModified();
        }

        protected boolean isContentCurrent() {
            return this.lastModified >= this.fileToCheck().lastModified();
        }

        protected File fileToCheck() {
            return this.jwsFile.exists() ? this.jwsFile : this.normalFile;
        }

        protected String loadContent(File f) throws FileNotFoundException, IOException {
            int charsRead;
            FileReader fr = new FileReader(f);
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[1024];
            while ((charsRead = fr.read(buffer)) != -1) {
                sb.append(buffer, 0, charsRead);
            }
            fr.close();
            return Util.replaceTokens(sb.toString(), System.getProperties());
        }

        String content() throws FileNotFoundException, IOException {
            if (!this.isContentCurrent()) {
                this.loadContent(this.fileToCheck());
            }
            return this.currentContent;
        }
    }

    private static class SunACCPairedFiles
    extends PairedFiles {
        private String configFilePath = null;
        private File securityConfigFile;
        private String securityConfigContent = null;

        private static SunACCPairedFiles newSunACCPairedFiles(File normalFile, File jwsFile) throws FileNotFoundException, IOException {
            SunACCPairedFiles result = new SunACCPairedFiles(normalFile, jwsFile);
            result.setCurrentContent();
            return result;
        }

        public SunACCPairedFiles(File normalFile, File jwsFile) throws FileNotFoundException, IOException {
            super(normalFile, jwsFile);
        }

        protected boolean isContentCurrent() {
            return super.isContentCurrent() && this.securityConfigFile.lastModified() <= this.lastModified();
        }

        protected String loadContent(File f) throws FileNotFoundException, IOException {
            String origContent = super.loadContent(f);
            Matcher m = SECURITY_CONFIG_VALUE_PATTERN.matcher(origContent);
            StringBuffer sb = new StringBuffer();
            String origConfigFilePath = this.configFilePath;
            while (m.find()) {
                this.configFilePath = m.group(1);
                m.appendReplacement(sb, ACCConfigContent.SECURITY_CONFIG_REPLACEMENT);
            }
            m.appendTail(sb);
            if (!this.configFilePath.equals(origConfigFilePath)) {
                this.securityConfigFile = new File(this.configFilePath);
                this.securityConfigContent = super.loadContent(this.securityConfigFile);
            }
            return sb.toString();
        }

        String securityConfigContent() throws FileNotFoundException, IOException {
            if (!this.isContentCurrent()) {
                this.setCurrentContent(this.loadContent(this.fileToCheck()));
            }
            return this.securityConfigContent;
        }
    }
}

