/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMain;
import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.ASMainOSGi;
import com.sun.enterprise.glassfish.bootstrap.ClassPathBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ASMainEquinox
extends ASMainOSGi {
    private static File pluginsDir = null;

    protected String getPreferedCacheDir() {
        return "osgi-cache/equinox/";
    }

    public String getName() {
        return ASMain.Platform.Equinox.toString();
    }

    protected void setFwDir() {
        String fwPath = System.getenv("EQUINOX_HOME");
        if (fwPath == null) {
            fwPath = new File(this.glassfishDir, "osgi/equinox").getAbsolutePath();
        }
        this.fwDir = new File(fwPath);
        if (!this.fwDir.exists()) {
            this.fwDir = new File(this.glassfishDir, "osgi/eclipse");
        }
        if (this.fwDir.exists() && !(pluginsDir = new File(this.fwDir, "plugins")).exists()) {
            pluginsDir = null;
        }
        if (!this.fwDir.exists()) {
            throw new RuntimeException("Can't locate Equinox at " + fwPath);
        }
    }

    protected void addFrameworkJars(ClassPathBuilder cpb) throws IOException {
        if (pluginsDir != null) {
            cpb.addGlob(pluginsDir, "org.eclipse.osgi_*.jar");
        } else {
            cpb.addJarFolder(this.fwDir, new String[0]);
        }
    }

    private File getSettingsFile() {
        File settings = new File(this.fwDir, "configuration");
        return new File(settings, "config.ini");
    }

    protected void setUpCache(File sourceDir, File cacheDir) throws IOException {
        System.setProperty("osgi.configuration.area", cacheDir.getCanonicalPath());
        File settings = this.getSettingsFile();
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            throw new RuntimeException("Not able to create " + cacheDir.getAbsolutePath());
        }
        ASMainHelper.copyFile(settings, new File(cacheDir, "config.ini"));
    }

    protected void launchOSGiFW() throws Exception {
        Class<?> mc = this.launcherCL.loadClass(this.getFWMainClassName());
        final String[] args = new String[]{};
        final Method m = mc.getMethod("main", args.getClass());
        Thread launcherThread = new Thread(new Runnable(){

            public void run() {
                try {
                    m.invoke(null, new Object[]{args});
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }, "OSGi Framework Launcher");
        launcherThread.setDaemon(false);
        launcherThread.start();
    }

    private String getFWMainClassName() {
        return "org.eclipse.core.runtime.adaptor.EclipseStarter";
    }
}

