/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.util.ArrayList;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.interceptor.proxy.InterceptorProxyCreatorImpl;
import org.jboss.interceptor.util.InterceptionUtils;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.DeploymentException;
import org.jboss.weld.ForbiddenStateException;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AnnotatedItemProvidingDecoratorWrapper;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.interceptor.CdiInterceptorHandlerFactory;
import org.jboss.weld.bean.interceptor.ClassInterceptionHandlerFactory;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.InjectionContextImpl;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Names;
import org.jboss.weld.util.Reflections;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.ext.XLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedBean<T>
extends AbstractClassBean<T> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private static final XLogger xLog = LoggerFactory.loggerFactory().getXLogger(Category.BEAN);
    private ConstructorInjectionPoint<T> constructor;
    private Set<WeldInjectionPoint<?, ?>> ejbInjectionPoints;
    private Set<WeldInjectionPoint<?, ?>> persistenceContextInjectionPoints;
    private Set<WeldInjectionPoint<?, ?>> persistenceUnitInjectionPoints;
    private Set<WeldInjectionPoint<?, ?>> resourceInjectionPoints;
    private ManagedBean<?> specializedBean;
    private boolean passivationCapable;

    public static <T> ManagedBean<T> of(WeldClass<T> clazz, BeanManagerImpl manager) {
        return new ManagedBean<T>(clazz, ManagedBean.createId(ManagedBean.class.getSimpleName(), clazz), manager);
    }

    protected static String createId(String beanType, WeldClass<?> clazz) {
        return beanType + "-" + clazz.getBaseType();
    }

    protected ManagedBean(WeldClass<T> type, String idSuffix, BeanManagerImpl manager) {
        super(type, idSuffix, manager);
        this.initType();
        this.initTypes();
        this.initBindings();
        this.initConstructor();
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        T instance = this.getInjectionTarget().produce(creationalContext);
        this.getInjectionTarget().inject(instance, creationalContext);
        if (this.isInterceptionCandidate() && (this.hasCdiBoundInterceptors() || this.hasDirectlyDefinedInterceptors())) {
            InterceptionUtils.executePostConstruct(instance);
        } else {
            this.getInjectionTarget().postConstruct(instance);
        }
        return instance;
    }

    protected InjectionPoint attachCorrectInjectionPoint() {
        Decorator<?> decorator = this.getDecorators().get(this.getDecorators().size() - 1);
        InjectionPoint outerDelegateInjectionPoint = Beans.getDelegateInjectionPoint(decorator);
        if (outerDelegateInjectionPoint == null) {
            throw new ForbiddenStateException(BeanMessage.DELEGATE_INJECTION_POINT_NOT_FOUND, decorator);
        }
        return this.getManager().replaceOrPushCurrentInjectionPoint(outerDelegateInjectionPoint);
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        try {
            if (!this.isInterceptionCandidate() || !this.hasCdiBoundInterceptors() && !this.hasDirectlyDefinedInterceptors()) {
                this.getInjectionTarget().preDestroy(instance);
            } else {
                InterceptionUtils.executePredestroy(instance);
            }
            creationalContext.release();
        }
        catch (Exception e) {
            log.error(BeanMessage.ERROR_DESTROYING, this, instance);
            xLog.throwing(XLogger.Level.DEBUG, e);
        }
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            this.checkConstructor();
            super.initialize(environment);
            this.initPostConstruct();
            this.initPreDestroy();
            this.initEEInjectionPoints();
            this.initPassivationCapable();
            if (this.isInterceptionCandidate()) {
                this.initDirectlyDefinedInterceptors();
            }
            this.setInjectionTarget(new InjectionTarget<T>(){

                @Override
                public void inject(final T instance, final CreationalContext<T> ctx) {
                    new InjectionContextImpl<T>(ManagedBean.this.getManager(), this, instance){

                        @Override
                        public void proceed() {
                            Beans.injectEEFields(instance, ManagedBean.this.getManager(), ManagedBean.this.ejbInjectionPoints, ManagedBean.this.persistenceContextInjectionPoints, ManagedBean.this.persistenceUnitInjectionPoints, ManagedBean.this.resourceInjectionPoints);
                            Beans.injectFieldsAndInitializers(instance, ctx, ManagedBean.this.getManager(), ManagedBean.this.getInjectableFields(), ManagedBean.this.getInitializerMethods());
                        }
                    }.run();
                }

                @Override
                public void postConstruct(T instance) {
                    ManagedBean.this.defaultPostConstruct(instance);
                }

                @Override
                public void preDestroy(T instance) {
                    ManagedBean.this.defaultPreDestroy(instance);
                }

                @Override
                public void dispose(T instance) {
                }

                @Override
                public Set<InjectionPoint> getInjectionPoints() {
                    return ManagedBean.this.getAnnotatedInjectionPoints();
                }

                @Override
                public T produce(CreationalContext<T> ctx) {
                    Object instance = ManagedBean.this.constructor.newInstance(ManagedBean.this.manager, ctx);
                    if (!ManagedBean.this.hasDecorators()) {
                        ctx.push(instance);
                    }
                    InjectionPoint originalInjectionPoint = null;
                    if (ManagedBean.this.hasDecorators()) {
                        originalInjectionPoint = ManagedBean.this.attachCorrectInjectionPoint();
                    }
                    if (ManagedBean.this.hasDecorators()) {
                        instance = ManagedBean.this.applyDecorators(instance, ctx, originalInjectionPoint);
                    }
                    if (ManagedBean.this.isInterceptionCandidate() && (ManagedBean.this.hasCdiBoundInterceptors() || ManagedBean.this.hasDirectlyDefinedInterceptors())) {
                        instance = ManagedBean.this.applyInterceptors(instance, ctx);
                    }
                    return instance;
                }
            });
        }
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        super.initializeAfterBeanDiscovery();
        if (this.passivationCapable && this.hasDecorators()) {
            for (Decorator<?> decorator : this.getDecorators()) {
                if (PassivationCapable.class.isAssignableFrom(decorator.getClass()) && Reflections.isSerializable(decorator.getBeanClass())) continue;
                this.passivationCapable = false;
                break;
            }
        }
        if (this.passivationCapable && this.hasCdiBoundInterceptors()) {
            for (SerializableContextual serializableContextual : this.getManager().getCdiInterceptorsRegistry().getInterceptionModel(this.getType()).getAllInterceptors()) {
                if (PassivationCapable.class.isAssignableFrom(((Interceptor)serializableContextual.get()).getClass()) && Reflections.isSerializable(((Interceptor)serializableContextual.get()).getBeanClass())) continue;
                this.passivationCapable = false;
                break;
            }
        }
        if (this.passivationCapable && this.hasDirectlyDefinedInterceptors()) {
            for (Class clazz : this.getManager().getClassDeclaredInterceptorsRegistry().getInterceptionModel(this.getType()).getAllInterceptors()) {
                if (Reflections.isSerializable(clazz)) continue;
                this.passivationCapable = false;
                break;
            }
        }
    }

    private void initPassivationCapable() {
        this.passivationCapable = Reflections.isSerializable(this.getAnnotatedItem().getJavaClass());
    }

    @Override
    public boolean isPassivationCapable() {
        return this.passivationCapable;
    }

    private void initEEInjectionPoints() {
        this.ejbInjectionPoints = Beans.getEjbInjectionPoints(this, this.getAnnotatedItem(), this.getManager());
        this.persistenceContextInjectionPoints = Beans.getPersistenceContextInjectionPoints(this, this.getAnnotatedItem(), this.getManager());
        this.persistenceUnitInjectionPoints = Beans.getPersistenceUnitInjectionPoints(this, this.getAnnotatedItem(), this.getManager());
        this.resourceInjectionPoints = Beans.getResourceInjectionPoints(this, this.getAnnotatedItem(), this.manager);
    }

    @Override
    public void checkType() {
        if (this.getAnnotatedItem().isAnonymousClass() || this.getAnnotatedItem().isMemberClass() && !this.getAnnotatedItem().isStatic()) {
            throw new DefinitionException(BeanMessage.SIMPLE_BEAN_AS_NON_STATIC_INNER_CLASS_NOT_ALLOWED, this.type);
        }
        if (!this.isDependent() && this.getAnnotatedItem().isParameterizedType()) {
            throw new DefinitionException(BeanMessage.BEAN_MUST_BE_DEPENDENT, this.type);
        }
        boolean passivating = this.manager.getServices().get(MetaAnnotationStore.class).getScopeModel(this.scopeType).isPassivating();
        if (passivating && !this.isPassivationCapable()) {
            throw new DefinitionException(BeanMessage.PASSIVATING_BEAN_NEEDS_SERIALIZABLE_IMPL, this);
        }
        if (this.hasDecorators()) {
            if (this.getAnnotatedItem().isFinal()) {
                throw new DefinitionException(BeanMessage.FINAL_BEAN_CLASS_WITH_DECORATORS_NOT_ALLOWED, this);
            }
            for (Decorator<?> decorator : this.getDecorators()) {
                WeldClass<?> decoratorClass;
                if (decorator instanceof DecoratorImpl) {
                    DecoratorImpl decoratorBean = (DecoratorImpl)decorator;
                    decoratorClass = decoratorBean.getAnnotatedItem();
                } else if (decorator instanceof AnnotatedItemProvidingDecoratorWrapper) {
                    decoratorClass = ((AnnotatedItemProvidingDecoratorWrapper)decorator).getAnnotatedItem();
                } else {
                    throw new ForbiddenStateException(BeanMessage.NON_CONTAINER_DECORATOR, decorator);
                }
                for (WeldMethod<?, ?> decoratorMethod : decoratorClass.getWeldMethods()) {
                    WeldMethod method = this.getAnnotatedItem().getWeldMethod(decoratorMethod.getSignature());
                    if (method == null || method.isStatic() || method.isPrivate() || !method.isFinal()) continue;
                    throw new DefinitionException(BeanMessage.FINAL_DECORATED_BEAN_METHOD_NOT_ALLOWED, method, decoratorMethod);
                }
            }
        }
    }

    @Override
    protected void checkBeanImplementation() {
        super.checkBeanImplementation();
        if (this.isNormalScoped()) {
            for (WeldField<?, ?> field : this.getAnnotatedItem().getWeldFields()) {
                if (!field.isPublic() || field.isStatic()) continue;
                throw new DefinitionException(BeanMessage.PUBLIC_FIELD_ON_NORMAL_SCOPED_BEAN_NOT_ALLOWED, this.getAnnotatedItem());
            }
        }
    }

    protected void checkConstructor() {
        if (!this.constructor.getAnnotatedWBParameters(Disposes.class).isEmpty()) {
            throw new DefinitionException(BeanMessage.PARAMETER_ANNOTATION_NOT_ALLOWED_ON_CONSTRUCTOR, "@Disposes", this.constructor);
        }
        if (!this.constructor.getAnnotatedWBParameters(Observes.class).isEmpty()) {
            throw new DefinitionException(BeanMessage.PARAMETER_ANNOTATION_NOT_ALLOWED_ON_CONSTRUCTOR, "@Observes", this.constructor);
        }
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        super.preSpecialize(environment);
        if (environment.getEjbDescriptors().contains(this.getAnnotatedItem().getWeldSuperclass().getJavaClass())) {
            throw new DefinitionException(BeanMessage.SPECIALIZING_BEAN_MUST_EXTEND_A_BEAN, this);
        }
    }

    @Override
    protected void specialize(BeanDeployerEnvironment environment) {
        if (environment.getClassBean(this.getAnnotatedItem().getWeldSuperclass()) == null) {
            throw new DefinitionException(BeanMessage.SPECIALIZING_BEAN_MUST_EXTEND_A_BEAN, this);
        }
        AbstractClassBean<?> specializedBean = environment.getClassBean(this.getAnnotatedItem().getWeldSuperclass());
        if (!(specializedBean instanceof ManagedBean)) {
            throw new DefinitionException(BeanMessage.SPECIALIZING_BEAN_MUST_EXTEND_A_BEAN, this);
        }
        this.specializedBean = (ManagedBean)specializedBean;
    }

    protected void initConstructor() {
        this.constructor = Beans.getBeanConstructor(this, this.getAnnotatedItem());
        this.addInjectionPoints(Beans.getParameterInjectionPoints(this, this.constructor));
    }

    public WeldConstructor<T> getConstructor() {
        return this.constructor;
    }

    @Override
    public String getDescription() {
        return this.getDescription("simple bean");
    }

    protected String getDescription(String beanType) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Names.scopeTypeToString(this.getScope()));
        if (this.getName() == null) {
            buffer.append("unnamed ").append(beanType);
        } else {
            buffer.append(beanType).append(" '" + this.getName() + "'");
        }
        buffer.append(" ").append(this.getType().getName()).append(", ");
        buffer.append(" API types = ").append(Names.typesToString(this.getTypes())).append(", binding types = " + Names.annotationsToString(this.getQualifiers()));
        return buffer.toString();
    }

    @Override
    public ManagedBean<?> getSpecializedBean() {
        return this.specializedBean;
    }

    @Override
    protected boolean isInterceptionCandidate() {
        return !Beans.isInterceptor(this.getAnnotatedItem()) && !Beans.isDecorator(this.getAnnotatedItem());
    }

    protected T applyInterceptors(T instance, CreationalContext<T> creationalContext) {
        try {
            ArrayList interceptionRegistries = new ArrayList();
            ArrayList interceptionHandlerFactories = new ArrayList();
            if (this.hasDirectlyDefinedInterceptors()) {
                interceptionRegistries.add(this.manager.getClassDeclaredInterceptorsRegistry());
                interceptionHandlerFactories.add(new ClassInterceptionHandlerFactory(creationalContext, this.getManager()));
            }
            if (this.hasCdiBoundInterceptors()) {
                interceptionRegistries.add(this.manager.getCdiInterceptorsRegistry());
                interceptionHandlerFactories.add(new CdiInterceptorHandlerFactory(creationalContext, this.manager));
            }
            if (interceptionRegistries.size() > 0) {
                instance = new InterceptorProxyCreatorImpl(interceptionRegistries, interceptionHandlerFactories).createProxyFromInstance(instance, this.getType());
            }
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
        return instance;
    }
}

