/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.transport.httptunnel.servlet;

import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelDefaults;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelPacket;
import com.sun.messaging.jmq.transport.httptunnel.Link;
import com.sun.messaging.jmq.transport.httptunnel.servlet.ServerLinkTable;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

public class ServerLink
extends Link
implements HttpTunnelDefaults {
    private static boolean DEBUG = Boolean.getBoolean("httptunnel.debug");
    private Socket serverConn = null;
    private ServerLinkTable parent = null;
    private String serverName = null;
    private boolean listenState = false;
    private boolean serverReady = false;

    public ServerLink(Socket socket, ServerLinkTable serverLinkTable) throws IOException {
        try {
            socket.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            serverLinkTable.servletContext.log("WARNING: HttpTunnelTcpLink()[" + socket.toString() + "]setTcpNoDelay: " + socketException.toString(), (Throwable)socketException);
        }
        this.serverConn = socket;
        this.parent = serverLinkTable;
        this.is = socket.getInputStream();
        this.os = socket.getOutputStream();
        this.setName("HttpTunnelTcpLink[" + socket + "]");
        this.start();
    }

    protected void createLink() {
    }

    protected void handleLinkDown() {
        try {
            this.serverConn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parent.serverDown(this);
    }

    protected void linkDown() {
        super.linkDown();
    }

    protected boolean isDone() {
        return this.done;
    }

    protected String getServerName() {
        return this.serverName;
    }

    protected boolean getListenState() {
        return this.listenState;
    }

    protected void receivePacket(HttpTunnelPacket httpTunnelPacket) {
        if (this.serverReady) {
            if (httpTunnelPacket.getPacketType() == 11) {
                this.receiveListenStatePacket(httpTunnelPacket);
                return;
            }
            if (DEBUG) {
                this.log("Received Packet : " + httpTunnelPacket);
            }
            this.parent.receivePacket(httpTunnelPacket, this);
            return;
        }
        if (httpTunnelPacket.getPacketType() != 8) {
            this.parent.servletContext.log("HttpTunnelServlet: ServerLink[" + this.serverName + "] received " + "unexpected packet type " + httpTunnelPacket.getPacketType());
            this.shutdown();
            this.linkDown();
            return;
        }
        byte[] byArray = httpTunnelPacket.getPacketBody();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            this.serverName = dataInputStream.readUTF();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                int n2 = dataInputStream.readInt();
                int n3 = dataInputStream.readInt();
                this.parent.updateConnection(n2, n3, this);
            }
            this.parent.servletContext.log("HttpTunnelServlet: ServerLink[" + this.serverName + "]" + " link initialized");
            this.parent.updateServerName(this);
            this.serverReady = true;
        }
        catch (Exception exception) {
            this.parent.servletContext.log("HttpTunnelServlet: ServerLink[" + this.serverName + "]" + " init link failed: " + exception.getMessage(), (Throwable)exception);
            this.shutdown();
            this.linkDown();
        }
    }

    private void receiveListenStatePacket(HttpTunnelPacket httpTunnelPacket) {
        byte[] byArray = httpTunnelPacket.getPacketBody();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        String string = null;
        try {
            string = dataInputStream.readUTF();
            this.listenState = dataInputStream.readBoolean();
        }
        catch (Exception exception) {
            this.parent.servletContext.log("HttpTunnelServlet: ServerLink[" + string + "]" + " receiveListenStatePacket failed: " + exception.getMessage(), (Throwable)exception);
            this.shutdown();
            this.linkDown();
        }
    }
}

