/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.nodes;

import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.IndexElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.nodes.ColumnElementNode;
import org.netbeans.modules.dbschema.nodes.ColumnPairElementNode;
import org.netbeans.modules.dbschema.nodes.DBElementNodeFactory;
import org.netbeans.modules.dbschema.nodes.ForeignKeyElementNode;
import org.netbeans.modules.dbschema.nodes.IconStrings;
import org.netbeans.modules.dbschema.nodes.IndexElementNode;
import org.netbeans.modules.dbschema.nodes.SchemaChildren;
import org.netbeans.modules.dbschema.nodes.SchemaElementNode;
import org.netbeans.modules.dbschema.nodes.TableChildren;
import org.netbeans.modules.dbschema.nodes.TableElementFilter;
import org.netbeans.modules.dbschema.nodes.TableElementNode;
import org.openide.actions.ToolsAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class DefaultDBFactory
implements DBElementNodeFactory,
IconStrings {
    public static final String WAIT = "org/openide/src/resources/wait";
    public static final String ERROR = "org/openide/src/resources/error";
    public static final DefaultDBFactory READ_WRITE = new DefaultDBFactory(true);
    public static final DefaultDBFactory READ_ONLY = new DefaultDBFactory(false);
    private boolean _writeable;
    private static final SystemAction[] CATEGORY_ACTIONS = new SystemAction[]{SystemAction.get((Class)ToolsAction.class)};
    static final String[] NAMES = new String[]{NbBundle.getMessage((Class)DefaultDBFactory.class, (String)"Columns"), NbBundle.getMessage((Class)DefaultDBFactory.class, (String)"Indexes"), NbBundle.getMessage((Class)DefaultDBFactory.class, (String)"FKs"), NbBundle.getMessage((Class)DefaultDBFactory.class, (String)"Tables")};
    static final int[][] FILTERS = new int[][]{{4}, {8}, {16}, {1}};
    static final String[] CATEGORY_ICONS = new String[]{"org/netbeans/modules/dbschema/resources/columns", "org/netbeans/modules/dbschema/resources/indexes", "org/netbeans/modules/dbschema/resources/foreignKeys", "org/netbeans/modules/dbschema/resources/table"};

    public DefaultDBFactory(boolean writeable) {
        this._writeable = writeable;
    }

    public boolean isWriteable() {
        return this._writeable;
    }

    public Node createSchemaNode(SchemaElement element) {
        return new SchemaElementNode(element, this.createSchemaChildren(element), this.isWriteable());
    }

    protected Children createSchemaChildren(SchemaElement element) {
        return this.createSchemaChildren(element, this.isWriteable() ? READ_WRITE : READ_ONLY);
    }

    protected final Children createSchemaChildren(SchemaElement element, DBElementNodeFactory factory) {
        SchemaChildren children = new SchemaChildren(factory, element);
        boolean writeable = this.isWriteable();
        return children;
    }

    public Node createColumnNode(ColumnElement element) {
        return new ColumnElementNode(element, this.isWriteable());
    }

    public Node createColumnPairNode(ColumnPairElement element) {
        return new ColumnPairElementNode(element, this.isWriteable());
    }

    public Node createIndexNode(IndexElement element) {
        return new IndexElementNode(element, (TableChildren)this.createIndexChildren(element), this.isWriteable());
    }

    protected Children createIndexChildren(IndexElement element) {
        return this.createIndexChildren(element, this.isWriteable() ? READ_WRITE : READ_ONLY);
    }

    protected final Children createIndexChildren(IndexElement element, DBElementNodeFactory factory) {
        TableChildren children = new TableChildren(factory, element);
        boolean writeable = this.isWriteable();
        return children;
    }

    public Node createForeignKeyNode(ForeignKeyElement element) {
        return new ForeignKeyElementNode(element, (TableChildren)this.createForeignKeyChildren(element), this.isWriteable());
    }

    protected Children createForeignKeyChildren(ForeignKeyElement element) {
        return this.createForeignKeyChildren(element, this.isWriteable() ? READ_WRITE : READ_ONLY);
    }

    protected final Children createForeignKeyChildren(ForeignKeyElement element, DBElementNodeFactory factory) {
        TableChildren children = new TableChildren(factory, element);
        boolean writeable = this.isWriteable();
        return children;
    }

    public Node createTableNode(TableElement element) {
        return new TableElementNode(element, this.createTableChildren(element), this.isWriteable());
    }

    protected Children createTableChildren(TableElement element) {
        return this.createTableChildren(element, this.isWriteable() ? READ_WRITE : READ_ONLY);
    }

    protected final Children createTableChildren(TableElement element, DBElementNodeFactory factory) {
        TableChildren children = new TableChildren(factory, element);
        TableElementFilter filter = new TableElementFilter();
        boolean writeable = this.isWriteable();
        filter.setOrder(new int[]{1, 2});
        children.setFilter(filter);
        String db = element.getDeclaringSchema().getDatabaseProductName();
        boolean viewSupport = false;
        if (db != null) {
            boolean bl = viewSupport = (db = db.toLowerCase()).indexOf("oracle") != -1 || db.indexOf("microsoft sql server") != -1;
        }
        if (element.isTableOrView() || viewSupport) {
            children.add(new Node[]{new ElementCategoryNode(0, factory, element, writeable), new ElementCategoryNode(1, factory, element, writeable), new ElementCategoryNode(2, factory, element, writeable)});
        } else {
            children.add(new Node[]{new ElementCategoryNode(0, factory, element, writeable)});
        }
        return children;
    }

    public Node createWaitNode() {
        AbstractNode n = new AbstractNode(Children.LEAF);
        n.setName(NbBundle.getMessage((Class)DefaultDBFactory.class, (String)"Wait"));
        n.setIconBase(WAIT);
        return n;
    }

    public Node createErrorNode() {
        AbstractNode n = new AbstractNode(Children.LEAF);
        n.setName(NbBundle.getMessage((Class)DefaultDBFactory.class, (String)"Error"));
        n.setIconBase(ERROR);
        return n;
    }

    static class ElementCategoryNode
    extends AbstractNode {
        DBElement element;
        int newTypeIndex;

        ElementCategoryNode(int index, DBElementNodeFactory factory, TableElement element, boolean writeable) {
            this(index, new TableChildren(factory, element));
            this.element = element;
            this.newTypeIndex = writeable ? index : -1;
            switch (index) {
                case 0: {
                    this.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$dbschema$nodes$DefaultDBFactory == null ? (class$org$netbeans$modules$dbschema$nodes$DefaultDBFactory = DefaultDBFactory.class$("org.netbeans.modules.dbschema.nodes.DefaultDBFactory")) : class$org$netbeans$modules$dbschema$nodes$DefaultDBFactory), (String)"Columns"));
                    break;
                }
                case 1: {
                    this.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$dbschema$nodes$DefaultDBFactory == null ? (class$org$netbeans$modules$dbschema$nodes$DefaultDBFactory = DefaultDBFactory.class$("org.netbeans.modules.dbschema.nodes.DefaultDBFactory")) : class$org$netbeans$modules$dbschema$nodes$DefaultDBFactory), (String)"Indexes"));
                    break;
                }
                case 2: {
                    this.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$dbschema$nodes$DefaultDBFactory == null ? (class$org$netbeans$modules$dbschema$nodes$DefaultDBFactory = DefaultDBFactory.class$("org.netbeans.modules.dbschema.nodes.DefaultDBFactory")) : class$org$netbeans$modules$dbschema$nodes$DefaultDBFactory), (String)"FKs"));
                }
            }
        }

        ElementCategoryNode(int index, DBElementNodeFactory factory, SchemaElement element, boolean writeable) {
            this(index, new SchemaChildren(factory, element));
            this.element = element;
            this.newTypeIndex = writeable ? index : -1;
            this.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$dbschema$nodes$DefaultDBFactory == null ? (class$org$netbeans$modules$dbschema$nodes$DefaultDBFactory = DefaultDBFactory.class$("org.netbeans.modules.dbschema.nodes.DefaultDBFactory")) : class$org$netbeans$modules$dbschema$nodes$DefaultDBFactory), (String)"Tables"));
        }

        private ElementCategoryNode(int index, TableChildren children) {
            super((Children)children);
            this.setDisplayName(NAMES[index]);
            this.systemActions = CATEGORY_ACTIONS;
            TableElementFilter filter = new TableElementFilter();
            filter.setOrder(FILTERS[index]);
            children.setFilter(filter);
            this.setIconBase(CATEGORY_ICONS[index]);
        }

        private ElementCategoryNode(int index, SchemaChildren children) {
            super((Children)children);
            this.setDisplayName(NAMES[index]);
            this.systemActions = CATEGORY_ACTIONS;
            this.setIconBase(CATEGORY_ICONS[index]);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dbschema_ctxhelp_wizard");
        }
    }
}

