/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorLogPool;
import com.sun.jts.CosTransactions.CoordinatorLogSection;
import com.sun.jts.CosTransactions.CoordinatorLogStateHolder;
import com.sun.jts.CosTransactions.Log;
import com.sun.jts.CosTransactions.LogLSN;
import com.sun.jts.CosTransactions.LogUpcallTarget;
import com.sun.jts.CosTransactions.RWLock;
import com.sun.jts.CosTransactions.SectionPool;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

class CoordinatorLog
implements LogUpcallTarget {
    private static final int LOG_DEF_KEY_TRIGGER = 100;
    private static final int LOG_THRESHOLD = 10000;
    private static final int STRING_TO_REF_RETRIES = 20;
    private static final String defaultstring = "DEFAULT_LOG";
    private static int keypointTrigger = 100;
    private static Hashtable logStateHoldertable = new Hashtable();
    private Hashtable sectionMapping = null;
    private boolean rewriteRequired = false;
    private boolean writeDone = false;
    private String logPath = null;
    static Logger _logger = LogDomains.getLogger(CoordinatorLog.class, (String)"javax.enterprise.system.core.transaction");
    Long localTID = null;
    CoordinatorLogStateHolder logStateHolder = null;
    private static CoordinatorLogStateHolder defaultLogStateHolder = CoordinatorLog.getStateHolder("DEFAULT_LOG");
    private ByteArrayOutputStream byteOutput = new ByteArrayOutputStream(2000);
    private DataOutputStream dataOutput = new DataOutputStream(this.byteOutput);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CoordinatorLogStateHolder getStateHolder(String str) {
        Hashtable hashtable = logStateHoldertable;
        synchronized (hashtable) {
            CoordinatorLogStateHolder logStateHolder = (CoordinatorLogStateHolder)logStateHoldertable.get(str);
            if (logStateHolder == null) {
                logStateHolder = new CoordinatorLogStateHolder();
                logStateHolder.logFile = null;
                logStateHolder.log = null;
                logStateHolder.activeLogs = new Hashtable();
                logStateHolder.keypointLogs = new Hashtable();
                logStateHolder.tranCount = 0;
                logStateHolder.keypointInProgress = false;
                logStateHolder.keypointLock = new RWLock();
                logStateHolder.keypointStateLock = new java.lang.Object();
                logStateHoldertable.put(str, logStateHolder);
            }
            return logStateHolder;
        }
    }

    CoordinatorLog() {
        this.sectionMapping = new Hashtable();
        this.logStateHolder = defaultLogStateHolder;
    }

    CoordinatorLog(String logPath) {
        this.sectionMapping = new Hashtable();
        this.logStateHolder = CoordinatorLog.getStateHolder(logPath);
        this.logPath = logPath;
    }

    public synchronized void doFinalize() {
        if (this.sectionMapping != null) {
            Enumeration sections = this.sectionMapping.elements();
            int sz = this.sectionMapping.size();
            while (sz-- > 0) {
                CoordinatorLogSection section = (CoordinatorLogSection)sections.nextElement();
                section.reUse();
            }
            this.sectionMapping.clear();
            this.sectionMapping = null;
        }
    }

    private synchronized void reUse() {
        if (this.sectionMapping != null) {
            Enumeration sections = this.sectionMapping.elements();
            int sz = this.sectionMapping.size();
            while (sz-- > 0) {
                CoordinatorLogSection section = (CoordinatorLogSection)sections.nextElement();
                section.reUse();
            }
            this.sectionMapping.clear();
        }
        this.rewriteRequired = false;
        this.writeDone = false;
        this.localTID = null;
        this.byteOutput.reset();
        CoordinatorLogPool.putCoordinatorLog(this);
    }

    private synchronized void reUse(String logPath) {
        if (this.sectionMapping != null) {
            Enumeration sections = this.sectionMapping.elements();
            int sz = this.sectionMapping.size();
            while (sz-- > 0) {
                CoordinatorLogSection section = (CoordinatorLogSection)sections.nextElement();
                section.reUse();
            }
            this.sectionMapping.clear();
        }
        this.rewriteRequired = false;
        this.writeDone = false;
        this.localTID = null;
        this.byteOutput.reset();
        CoordinatorLogPool.putCoordinatorLog(this, logPath);
    }

    CoordinatorLog(Long localTID) {
        this.localTID = localTID;
        if (localTID != 0L) {
            CoordinatorLog.addLog(localTID, this);
        }
    }

    synchronized java.lang.Object createSection(String sectionName) {
        CoordinatorLogSection result = null;
        result = (CoordinatorLogSection)this.sectionMapping.get(sectionName);
        if (result == null) {
            int nameLength = sectionName.length();
            result = SectionPool.getCoordinatorLogSection(sectionName);
            if (result != null) {
                this.sectionMapping.put(sectionName, result);
            }
        }
        return result;
    }

    synchronized boolean addObject(java.lang.Object sectionObj, Object obj) {
        boolean result = true;
        if (sectionObj != null) {
            CoordinatorLogSection section = (CoordinatorLogSection)sectionObj;
            section.unwrittenEmpty = false;
            if (section.unwrittenObjects == null) {
                section.unwrittenObjects = new Vector(10, 10);
            }
            String objRefStr = null;
            try {
                objRefStr = Configuration.getORB().object_to_string(obj);
                section.unwrittenObjects.addElement(objRefStr);
            }
            catch (Throwable exc) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    synchronized boolean addData(java.lang.Object sectionObj, byte[] data) {
        boolean result = true;
        if (sectionObj != null) {
            CoordinatorLogSection section = (CoordinatorLogSection)sectionObj;
            section.unwrittenEmpty = false;
            if (section.unwrittenData == null) {
                section.unwrittenData = new Vector(4, 4);
            }
            byte[] dataCopy = new byte[data.length];
            System.arraycopy(data, 0, dataCopy, 0, data.length);
            section.unwrittenData.addElement(dataCopy);
        } else {
            result = false;
        }
        return result;
    }

    boolean write(boolean force) {
        boolean result = true;
        try {
            result = this.formatLogRecords(force);
        }
        catch (IOException exc) {
            result = false;
        }
        return result;
    }

    private synchronized boolean requireRewrite() {
        boolean result = true;
        if (this.writeDone) {
            this.rewriteRequired = true;
        }
        return result;
    }

    private boolean rewrite() {
        boolean result = true;
        if (this.rewriteRequired) {
            try {
                result = this.formatLogRecords(false);
            }
            catch (IOException exc) {
                result = false;
            }
        }
        return result;
    }

    private boolean reconstruct(DataInputStream dataInput) throws IOException {
        boolean result = true;
        int numSections = dataInput.readUnsignedShort();
        while (--numSections >= 0) {
            int i;
            int length = dataInput.readUnsignedShort();
            if (length <= 0) continue;
            int numObjects = dataInput.readUnsignedShort();
            int numData = dataInput.readUnsignedShort();
            byte[] stringData = new byte[length];
            dataInput.read(stringData);
            String sectionName = new String(stringData);
            CoordinatorLogSection section = (CoordinatorLogSection)this.createSection(sectionName);
            if (numObjects > 0 && section.writtenObjects == null) {
                section.writtenObjects = new Vector(numObjects, 10);
            }
            for (i = 0; i < numObjects; ++i) {
                length = dataInput.readUnsignedShort();
                stringData = new byte[length];
                dataInput.read(stringData);
                String objRefStr = new String(stringData);
                section.writtenObjects.addElement(objRefStr);
            }
            if (numData > 0 && section.writtenData == null) {
                section.writtenData = new Vector(numData, 4);
            }
            for (i = 0; i < numData; ++i) {
                length = dataInput.readUnsignedShort();
                byte[] dataItem = new byte[length];
                dataInput.read(dataItem);
                section.writtenData.addElement(dataItem);
            }
        }
        return result;
    }

    java.lang.Object[] getObjects(java.lang.Object sectionObj) {
        java.lang.Object[] result = null;
        if (sectionObj != null) {
            Object obj;
            int i;
            CoordinatorLogSection section = (CoordinatorLogSection)sectionObj;
            int unwrittenSize = 0;
            if (section.unwrittenObjects != null) {
                unwrittenSize = section.unwrittenObjects.size();
            }
            int writtenSize = 0;
            if (section.writtenObjects != null) {
                writtenSize = section.writtenObjects.size();
            }
            result = new java.lang.Object[unwrittenSize + writtenSize];
            int currObject = 0;
            ORB orb = Configuration.getORB();
            for (i = 0; i < writtenSize; ++i) {
                obj = null;
                String refStr = (String)section.writtenObjects.elementAt(i);
                int retries = 20;
                boolean discard = false;
                while (obj == null && retries-- > 0 && !discard) {
                    try {
                        obj = orb.string_to_object(refStr);
                    }
                    catch (MARSHAL exc) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException ex2) {
                            _logger.log(Level.WARNING, "jts.wait_for_resync_complete_interrupted");
                            String msg = LogFormatter.getLocalizedMessage(_logger, "jts.wait_for_resync_complete_interrupted");
                            throw new INTERNAL(msg);
                        }
                    }
                    catch (Throwable exc) {
                        discard = true;
                    }
                }
                if (discard) continue;
                if (obj != null) {
                    result[currObject++] = obj;
                    continue;
                }
                _logger.log(Level.SEVERE, "jts.unable_to_convert_object_reference_to_string_in_recovery");
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.unable_to_convert_object_reference_to_string_in_recovery");
                throw new INTERNAL(msg);
            }
            for (i = 0; i < unwrittenSize; ++i) {
                try {
                    obj = orb.string_to_object((String)section.unwrittenObjects.elementAt(i));
                    result[currObject++] = obj;
                    continue;
                }
                catch (Throwable exc) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    byte[][] getData(java.lang.Object sectionObj) {
        java.lang.Object result = null;
        if (sectionObj != null) {
            CoordinatorLogSection section = (CoordinatorLogSection)sectionObj;
            int unwrittenSize = 0;
            if (section.unwrittenData != null) {
                unwrittenSize = section.unwrittenData.size();
            }
            int writtenSize = 0;
            if (section.writtenData != null) {
                writtenSize = section.writtenData.size();
            }
            result = new byte[unwrittenSize + writtenSize][];
            if (unwrittenSize > 0) {
                section.unwrittenData.copyInto((java.lang.Object[])result);
            }
            for (int i = 0; i < writtenSize; ++i) {
                result[unwrittenSize++] = (byte[])section.writtenData.elementAt(i);
            }
        }
        return result;
    }

    synchronized void setLocalTID(Long localTID) {
        boolean addToMetaclass = localTID != 0L && (this.localTID == null || this.localTID == 0L);
        this.localTID = localTID;
        if (addToMetaclass) {
            CoordinatorLog.addLog(localTID, this);
        }
    }

    synchronized void setLocalTID(Long localTID, String logPath) {
        boolean addToMetaclass = localTID != 0L && (this.localTID == null || this.localTID == 0L);
        this.localTID = localTID;
        if (addToMetaclass) {
            CoordinatorLog.addLog(localTID, this, logPath);
        }
    }

    private void formatSection(CoordinatorLogSection section, boolean rewrite, DataOutputStream dataOutput) throws IOException {
        byte[] dataItem;
        String objRefStr;
        int i;
        if (section.unwrittenEmpty && (!rewrite || section.writtenEmpty)) {
            dataOutput.writeShort(0);
            return;
        }
        dataOutput.writeShort(section.sectionName.length());
        int unwrittenObjectsSize = 0;
        int writtenObjectsSize = 0;
        if (section.unwrittenObjects != null) {
            unwrittenObjectsSize = section.unwrittenObjects.size();
        }
        if (rewrite && section.writtenObjects != null) {
            writtenObjectsSize = section.writtenObjects.size();
        }
        dataOutput.writeShort(unwrittenObjectsSize + writtenObjectsSize);
        int unwrittenDataSize = 0;
        int writtenDataSize = 0;
        if (section.unwrittenData != null) {
            unwrittenDataSize = section.unwrittenData.size();
        }
        if (rewrite && section.writtenData != null) {
            writtenDataSize = section.writtenData.size();
        }
        dataOutput.writeShort(unwrittenDataSize + writtenDataSize);
        dataOutput.writeBytes(section.sectionName);
        for (i = 0; i < writtenObjectsSize; ++i) {
            objRefStr = (String)section.writtenObjects.elementAt(i);
            dataOutput.writeShort(objRefStr.length());
            dataOutput.writeBytes(objRefStr);
        }
        for (i = 0; i < unwrittenObjectsSize; ++i) {
            objRefStr = (String)section.unwrittenObjects.elementAt(i);
            dataOutput.writeShort(objRefStr.length());
            dataOutput.writeBytes(objRefStr);
            if (section.writtenObjects == null) {
                section.writtenObjects = new Vector(unwrittenObjectsSize, 10);
            }
            section.writtenObjects.addElement(objRefStr);
        }
        if (unwrittenObjectsSize > 0) {
            section.unwrittenObjects.removeAllElements();
        }
        for (i = 0; i < writtenDataSize; ++i) {
            dataItem = (byte[])section.writtenData.elementAt(i);
            dataOutput.writeShort(dataItem.length);
            dataOutput.write(dataItem);
        }
        for (i = 0; i < unwrittenDataSize; ++i) {
            dataItem = (byte[])section.unwrittenData.elementAt(i);
            dataOutput.writeShort(dataItem.length);
            dataOutput.write(dataItem);
            if (section.writtenData == null) {
                section.writtenData = new Vector(unwrittenDataSize, 4);
            }
            section.writtenData.addElement(dataItem);
        }
        if (unwrittenDataSize > 0) {
            section.unwrittenData.removeAllElements();
        }
        section.unwrittenEmpty = true;
        section.writtenEmpty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean formatLogRecords(boolean forced) throws IOException {
        if (this.logPath == null) {
            CoordinatorLog.openLog();
        } else {
            CoordinatorLog.openLog(this.logPath);
        }
        if (this.logStateHolder.logFile == null) {
            return false;
        }
        boolean result = false;
        try {
            this.logStateHolder.keypointLock.acquireReadLock();
            CoordinatorLog coordinatorLog = this;
            synchronized (coordinatorLog) {
                this.byteOutput.reset();
                this.dataOutput.writeLong(this.localTID);
                this.dataOutput.writeShort(this.sectionMapping.size());
                Enumeration sections = this.sectionMapping.elements();
                int sz = this.sectionMapping.size();
                while (sz-- > 0) {
                    this.formatSection((CoordinatorLogSection)sections.nextElement(), this.rewriteRequired, this.dataOutput);
                }
                result = this.logStateHolder.logFile.write(forced ? 1 : 0, this.byteOutput.toByteArray(), this.rewriteRequired ? 3 : 0, null);
                this.rewriteRequired = false;
                this.writeDone = true;
            }
        }
        finally {
            this.logStateHolder.keypointLock.releaseReadLock();
        }
        return result;
    }

    private static boolean openLog() {
        boolean result = false;
        CoordinatorLogStateHolder logStateHolder = defaultLogStateHolder;
        if (logStateHolder.log == null) {
            logStateHolder.log = new Log();
            if (!logStateHolder.log.initialise()) {
                logStateHolder.log = null;
                _logger.log(Level.SEVERE, "jts.cannot_initialise_log");
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.cannot_initialise_log");
                throw new INTERNAL(msg);
            }
        }
        String serverName = null;
        if (logStateHolder.log != null && logStateHolder.logFile == null && (serverName = Configuration.getServerName()) != null) {
            logStateHolder.logFile = logStateHolder.log.open(serverName, CoordinatorLogPool.getCoordinatorLog());
            if (logStateHolder.logFile == null) {
                _logger.log(Level.SEVERE, "jts.cannot_open_log_file", serverName);
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.cannot_open_log_file");
                throw new INTERNAL(msg);
            }
            Configuration.setLogFile(logStateHolder.logFile);
        }
        result = logStateHolder.log != null && logStateHolder.logFile != null;
        return result;
    }

    private static boolean openLog(String logPath) {
        boolean result = false;
        CoordinatorLogStateHolder logStateHolder = CoordinatorLog.getStateHolder(logPath);
        if (logStateHolder.log == null) {
            logStateHolder.log = new Log(logPath);
            if (!logStateHolder.log.initialise()) {
                logStateHolder.log = null;
                _logger.log(Level.SEVERE, "jts.cannot_initialise_log");
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.cannot_initialise_log");
                throw new INTERNAL(msg);
            }
        }
        String serverName = null;
        if (logStateHolder.log != null && logStateHolder.logFile == null && (serverName = Configuration.getServerName(logPath)) != null) {
            logStateHolder.logFile = logStateHolder.log.open(serverName, CoordinatorLogPool.getCoordinatorLog(logPath));
            if (logStateHolder.logFile == null) {
                _logger.log(Level.SEVERE, "jts.cannot_open_log_file", serverName);
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.cannot_open_log_file");
                throw new INTERNAL(msg);
            }
            Configuration.setLogFile(logPath, logStateHolder.logFile);
        }
        result = logStateHolder.log != null && logStateHolder.logFile != null;
        return result;
    }

    static synchronized Enumeration getLogged() {
        Vector logRecords = null;
        Enumeration coordLogs = null;
        if (CoordinatorLog.openLog()) {
            CoordinatorLogStateHolder logStateHolder = defaultLogStateHolder;
            logRecords = logStateHolder.logFile.getLogRecords();
            for (int i = 0; i < logRecords.size(); ++i) {
                byte[] buffer = (byte[])logRecords.elementAt(i);
                ByteArrayInputStream byteInput = new ByteArrayInputStream(buffer);
                DataInputStream dataInput = new DataInputStream(byteInput);
                try {
                    Long localTID = new Long(dataInput.readLong());
                    CoordinatorLog coordLog = (CoordinatorLog)logStateHolder.activeLogs.get(localTID);
                    if (coordLog == null) {
                        coordLog = CoordinatorLogPool.getCoordinatorLog();
                        coordLog.setLocalTID(localTID);
                    }
                    coordLog.reconstruct(dataInput);
                    continue;
                }
                catch (IOException exc) {
                    // empty catch block
                }
            }
            coordLogs = logStateHolder.activeLogs.elements();
        } else {
            coordLogs = new Hashtable().elements();
        }
        return coordLogs;
    }

    static synchronized Enumeration getLogged(String logPath) {
        Vector logRecords = null;
        Enumeration coordLogs = null;
        if (CoordinatorLog.openLog(logPath)) {
            CoordinatorLogStateHolder logStateHolder = CoordinatorLog.getStateHolder(logPath);
            logRecords = logStateHolder.logFile.getLogRecords();
            for (int i = 0; i < logRecords.size(); ++i) {
                byte[] buffer = (byte[])logRecords.elementAt(i);
                ByteArrayInputStream byteInput = new ByteArrayInputStream(buffer);
                DataInputStream dataInput = new DataInputStream(byteInput);
                try {
                    Long localTID = new Long(dataInput.readLong());
                    CoordinatorLog coordLog = (CoordinatorLog)logStateHolder.activeLogs.get(localTID);
                    if (coordLog == null) {
                        coordLog = CoordinatorLogPool.getCoordinatorLog(logPath);
                        coordLog.setLocalTID(localTID, logPath);
                    }
                    coordLog.reconstruct(dataInput);
                    continue;
                }
                catch (IOException exc) {
                    // empty catch block
                }
            }
            coordLogs = logStateHolder.activeLogs.elements();
        } else {
            coordLogs = new Hashtable().elements();
        }
        return coordLogs;
    }

    private static boolean addLog(Long localTID, CoordinatorLog clog) {
        CoordinatorLogStateHolder logStateHolder = defaultLogStateHolder;
        boolean result = true;
        logStateHolder.activeLogs.put(localTID, clog);
        return result;
    }

    private static boolean addLog(Long localTID, CoordinatorLog clog, String logPath) {
        CoordinatorLogStateHolder logStateHolder = CoordinatorLog.getStateHolder(logPath);
        boolean result = true;
        logStateHolder.activeLogs.put(localTID, clog);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized boolean removeLog(Long localTID) {
        boolean result = true;
        CoordinatorLogStateHolder logStateHolder = defaultLogStateHolder;
        CoordinatorLog clog = (CoordinatorLog)logStateHolder.activeLogs.remove(localTID);
        if (clog != null) {
            java.lang.Object object = logStateHolder.keypointStateLock;
            synchronized (object) {
                if (logStateHolder.keypointInProgress && logStateHolder.keypointLogs != null) {
                    logStateHolder.keypointLogs.put(localTID, null);
                }
            }
            if (clog.writeDone) {
                ++logStateHolder.tranCount;
            }
            clog.reUse();
            if (logStateHolder.tranCount >= keypointTrigger) {
                logStateHolder.tranCount = 0;
                CoordinatorLog.keypoint();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized boolean removeLog(Long localTID, String logPath) {
        boolean result = true;
        CoordinatorLogStateHolder logStateHolder = CoordinatorLog.getStateHolder(logPath);
        CoordinatorLog clog = (CoordinatorLog)logStateHolder.activeLogs.remove(localTID);
        if (clog != null) {
            java.lang.Object object = logStateHolder.keypointStateLock;
            synchronized (object) {
                if (logStateHolder.keypointInProgress && logStateHolder.keypointLogs != null) {
                    logStateHolder.keypointLogs.put(localTID, null);
                }
            }
            if (clog.writeDone) {
                ++logStateHolder.tranCount;
            }
            clog.reUse(logPath);
            if (logStateHolder.tranCount >= keypointTrigger) {
                logStateHolder.tranCount = 0;
                CoordinatorLog.keypoint(logPath);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void keypoint() {
        CoordinatorLogStateHolder logStateHolder = defaultLogStateHolder;
        byte[] keypointEndRecord = new byte[]{75, 69, 89, 69, 78, 68};
        LogLSN previousLSN = new LogLSN();
        LogLSN keypointStartLSN = new LogLSN();
        boolean keypointRequired = false;
        try {
            logStateHolder.keypointLock.acquireWriteLock();
            keypointRequired = CoordinatorLog.startKeypoint(keypointStartLSN);
        }
        finally {
            logStateHolder.keypointLock.releaseWriteLock();
        }
        if (keypointStartLSN.isNULL()) {
            return;
        }
        if (keypointRequired) {
            Enumeration keypointLocalTIDs = logStateHolder.keypointLogs.keys();
            while (keypointLocalTIDs.hasMoreElements()) {
                java.lang.Object object = logStateHolder.keypointStateLock;
                synchronized (object) {
                    CoordinatorLog currentLog = (CoordinatorLog)logStateHolder.keypointLogs.get(keypointLocalTIDs.nextElement());
                    if (currentLog != null) {
                        currentLog.rewrite();
                    }
                }
            }
        }
        logStateHolder.logFile.write(0, keypointEndRecord, 2, previousLSN);
        logStateHolder.logFile.checkpoint(keypointStartLSN);
        logStateHolder.keypointInProgress = false;
        logStateHolder.keypointLogs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void keypoint(String logPath) {
        CoordinatorLogStateHolder logStateHolder = CoordinatorLog.getStateHolder(logPath);
        byte[] keypointEndRecord = new byte[]{75, 69, 89, 69, 78, 68};
        LogLSN previousLSN = new LogLSN();
        LogLSN keypointStartLSN = new LogLSN();
        boolean keypointRequired = false;
        try {
            logStateHolder.keypointLock.acquireWriteLock();
            keypointRequired = CoordinatorLog.startKeypoint(keypointStartLSN, logPath);
        }
        finally {
            logStateHolder.keypointLock.releaseWriteLock();
        }
        if (keypointStartLSN.isNULL()) {
            return;
        }
        if (keypointRequired) {
            Enumeration keypointLocalTIDs = logStateHolder.keypointLogs.keys();
            while (keypointLocalTIDs.hasMoreElements()) {
                java.lang.Object object = logStateHolder.keypointStateLock;
                synchronized (object) {
                    CoordinatorLog currentLog = (CoordinatorLog)logStateHolder.keypointLogs.get(keypointLocalTIDs.nextElement());
                    if (currentLog != null) {
                        currentLog.rewrite();
                    }
                }
            }
        }
        logStateHolder.logFile.write(0, keypointEndRecord, 2, previousLSN);
        logStateHolder.logFile.checkpoint(keypointStartLSN);
        logStateHolder.keypointInProgress = false;
        logStateHolder.keypointLogs.clear();
    }

    public void upcall(int reason) {
        if (this.logPath == null) {
            CoordinatorLog.keypoint();
        } else {
            CoordinatorLog.keypoint(this.logPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void finalizeAll() {
        CoordinatorLogStateHolder logStateHolder = defaultLogStateHolder;
        boolean deleteFile = false;
        java.lang.Object object = logStateHolder.keypointStateLock;
        synchronized (object) {
            if (logStateHolder.activeLogs != null) {
                if (logStateHolder.activeLogs.size() == 0) {
                    deleteFile = true;
                }
                logStateHolder.activeLogs.clear();
                logStateHolder.activeLogs = null;
            }
            if (logStateHolder.logFile != null) {
                logStateHolder.logFile.close(deleteFile);
            }
            logStateHolder.logFile = null;
            if (logStateHolder.keypointLogs != null) {
                logStateHolder.keypointLogs.clear();
            }
            logStateHolder.keypointLogs = null;
        }
        logStateHolder.keypointStateLock = null;
        logStateHolder.keypointLock = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void finalizeAll(String logPath) {
        CoordinatorLogStateHolder logStateHolder = CoordinatorLog.getStateHolder(logPath);
        boolean deleteFile = false;
        java.lang.Object object = logStateHolder.keypointStateLock;
        synchronized (object) {
            if (logStateHolder.activeLogs != null) {
                if (logStateHolder.activeLogs.size() == 0) {
                    deleteFile = true;
                }
                logStateHolder.activeLogs.clear();
                logStateHolder.activeLogs = null;
            }
            if (logStateHolder.logFile != null) {
                logStateHolder.logFile.close(deleteFile);
            }
            logStateHolder.logFile = null;
            if (logStateHolder.keypointLogs != null) {
                logStateHolder.keypointLogs.clear();
            }
            logStateHolder.keypointLogs = null;
        }
        logStateHolder.keypointStateLock = null;
        logStateHolder.keypointLock = null;
    }

    static synchronized boolean startKeypoint(LogLSN keypointStartLSN) {
        CoordinatorLogStateHolder logStateHolder = defaultLogStateHolder;
        boolean keypointRequired = false;
        if (logStateHolder.keypointInProgress) {
            return false;
        }
        logStateHolder.keypointInProgress = true;
        if (!CoordinatorLog.openLog()) {
            logStateHolder.keypointInProgress = false;
            return false;
        }
        if (logStateHolder.activeLogs.size() == 0) {
            keypointRequired = false;
        } else {
            Enumeration clogs = logStateHolder.activeLogs.elements();
            while (clogs.hasMoreElements()) {
                CoordinatorLog currentLog = (CoordinatorLog)clogs.nextElement();
                Long localTID = currentLog.localTID;
                currentLog.requireRewrite();
                logStateHolder.keypointLogs.put(localTID, currentLog);
            }
            keypointRequired = logStateHolder.keypointLogs.size() > 0;
        }
        byte[] keypointStartRecord = new byte[]{75, 69, 89, 83, 84, 65, 82, 84};
        logStateHolder.logFile.write(0, keypointStartRecord, 1, keypointStartLSN);
        return keypointRequired;
    }

    static synchronized boolean startKeypoint(LogLSN keypointStartLSN, String logPath) {
        CoordinatorLogStateHolder logStateHolder = CoordinatorLog.getStateHolder(logPath);
        boolean keypointRequired = false;
        if (logStateHolder.keypointInProgress) {
            return false;
        }
        logStateHolder.keypointInProgress = true;
        if (!CoordinatorLog.openLog(logPath)) {
            logStateHolder.keypointInProgress = false;
            return false;
        }
        if (logStateHolder.activeLogs.size() == 0) {
            keypointRequired = false;
        } else {
            Enumeration clogs = logStateHolder.activeLogs.elements();
            while (clogs.hasMoreElements()) {
                CoordinatorLog currentLog = (CoordinatorLog)clogs.nextElement();
                Long localTID = currentLog.localTID;
                currentLog.requireRewrite();
                logStateHolder.keypointLogs.put(localTID, currentLog);
            }
            keypointRequired = logStateHolder.keypointLogs.size() > 0;
        }
        byte[] keypointStartRecord = new byte[]{75, 69, 89, 83, 84, 65, 82, 84};
        logStateHolder.logFile.write(0, keypointStartRecord, 1, keypointStartLSN);
        return keypointRequired;
    }

    static void dumpClass() {
        CoordinatorLogStateHolder logStateHolder = defaultLogStateHolder;
        logStateHolder.log.dump();
        logStateHolder.logFile.dump();
    }

    void dump() {
        if (this.sectionMapping != null) {
            Enumeration sections = this.sectionMapping.elements();
            while (sections.hasMoreElements()) {
                byte[] dataItem;
                Enumeration data;
                String objStr;
                Enumeration objects;
                CoordinatorLogSection section = (CoordinatorLogSection)sections.nextElement();
                if (section.writtenObjects != null) {
                    objects = section.writtenObjects.elements();
                    while (objects.hasMoreElements()) {
                        objStr = (String)objects.nextElement();
                    }
                }
                if (section.unwrittenObjects != null) {
                    objects = section.unwrittenObjects.elements();
                    while (objects.hasMoreElements()) {
                        objStr = (String)objects.nextElement();
                    }
                }
                if (section.writtenData != null) {
                    data = section.writtenData.elements();
                    while (data.hasMoreElements()) {
                        dataItem = (byte[])data.nextElement();
                    }
                }
                if (section.unwrittenData == null) continue;
                data = section.unwrittenData.elements();
                while (data.hasMoreElements()) {
                    dataItem = (byte[])data.nextElement();
                }
            }
        }
    }

    public static void setKeypointTrigger(int keypoint) {
        keypointTrigger = keypoint;
    }

    static {
        String keypointCountEnv = Configuration.getPropertyValue("com.sun.jts.keypointCount");
        keypointTrigger = 100;
        if (keypointCountEnv != null) {
            try {
                keypointTrigger = Integer.parseInt(keypointCountEnv);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

