/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.naming.cosnaming;

import com.sun.corba.ee.impl.logging.NamingSystemException;
import com.sun.corba.ee.impl.naming.cosnaming.InterOperableNamingImpl;
import com.sun.corba.ee.impl.naming.cosnaming.NamingContextDataStore;
import com.sun.corba.ee.impl.naming.cosnaming.NamingUtils;
import com.sun.corba.ee.impl.naming.namingutil.INSURLHandler;
import com.sun.corba.ee.spi.logging.LogWrapperName;
import com.sun.corba.ee.spi.orb.ORB;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Object;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.BindingTypeHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExtPOA;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class NamingContextImpl
extends NamingContextExtPOA
implements NamingContextDataStore {
    protected POA nsPOA;
    private Logger readLogger;
    private Logger updateLogger;
    private Logger lifecycleLogger;
    private NamingSystemException wrapper;
    private static NamingSystemException staticWrapper = ORB.getStaticLogWrapperTable().get_NAMING_UPDATE_Naming();
    private InterOperableNamingImpl insImpl;
    protected transient ORB orb;
    public static final boolean debug = false;

    public NamingContextImpl(ORB orb, POA poa) throws Exception {
        this.orb = orb;
        this.wrapper = orb.getLogWrapperTable().get_NAMING_UPDATE_Naming();
        this.insImpl = new InterOperableNamingImpl();
        this.nsPOA = poa;
        this.readLogger = ORB.getLogger(LogWrapperName.getLoggerName(orb, "naming.read"));
        this.updateLogger = ORB.getLogger(LogWrapperName.getLoggerName(orb, "naming.update"));
        this.lifecycleLogger = ORB.getLogger(LogWrapperName.getLoggerName(orb, "naming.lifecycle"));
    }

    @Override
    public POA getNSPOA() {
        return this.nsPOA;
    }

    public void bind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (obj == null) {
            this.updateLogger.warning("<<NAMING BIND>> unsuccessful because NULL Object cannot be Bound ");
            throw this.wrapper.objectIsNull();
        }
        NamingContextImpl impl = this;
        NamingContextImpl.doBind(impl, n, obj, false, BindingType.nobject);
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING BIND>><<SUCCESS>> Name = " + NamingUtils.getDirectoryStructuredName(n));
        }
    }

    public void bind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (nc == null) {
            this.updateLogger.warning("<<NAMING BIND>><<FAILURE>> NULL Context cannot be Bound ");
            throw new BAD_PARAM("Naming Context should not be null ");
        }
        NamingContextImpl impl = this;
        NamingContextImpl.doBind(impl, n, (Object)nc, false, BindingType.ncontext);
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING BIND>><<SUCCESS>> Name = " + NamingUtils.getDirectoryStructuredName(n));
        }
    }

    public void rebind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName {
        if (obj == null) {
            this.updateLogger.warning("<<NAMING REBIND>><<FAILURE>> NULL Object cannot be Bound ");
            throw this.wrapper.objectIsNull();
        }
        try {
            NamingContextImpl impl = this;
            NamingContextImpl.doBind(impl, n, obj, true, BindingType.nobject);
        }
        catch (AlreadyBound ex) {
            this.updateLogger.warning("<<NAMING REBIND>><<FAILURE>>" + NamingUtils.getDirectoryStructuredName(n) + " is already bound to a Naming Context");
            throw this.wrapper.namingCtxRebindAlreadyBound(ex);
        }
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING REBIND>><<SUCCESS>> Name = " + NamingUtils.getDirectoryStructuredName(n));
        }
    }

    public void rebind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName {
        if (nc == null) {
            this.updateLogger.warning("<<NAMING REBIND>><<FAILURE>> NULL Context cannot be Bound ");
            throw this.wrapper.objectIsNull();
        }
        try {
            NamingContextImpl impl = this;
            NamingContextImpl.doBind(impl, n, (Object)nc, true, BindingType.ncontext);
        }
        catch (AlreadyBound ex) {
            this.updateLogger.warning("<<NAMING REBIND>><<FAILURE>>" + NamingUtils.getDirectoryStructuredName(n) + " is already bound to a CORBA Object");
            throw this.wrapper.namingCtxRebindctxAlreadyBound(ex);
        }
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING REBIND>><<SUCCESS>> Name = " + NamingUtils.getDirectoryStructuredName(n));
        }
    }

    public Object resolve(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        NamingContextImpl impl = this;
        Object obj = NamingContextImpl.doResolve(impl, n);
        if (obj != null) {
            if (this.readLogger.isLoggable(Level.FINE)) {
                this.readLogger.fine("<<NAMING RESOLVE>><<SUCCESS>> Name: " + NamingUtils.getDirectoryStructuredName(n));
            }
        } else {
            this.readLogger.warning("<<NAMING RESOLVE>><<FAILURE>> Name: " + NamingUtils.getDirectoryStructuredName(n));
        }
        return obj;
    }

    public void unbind(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        NamingContextImpl impl = this;
        NamingContextImpl.doUnbind(impl, n);
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING UNBIND>><<SUCCESS>> Name: " + NamingUtils.getDirectoryStructuredName(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void list(int how_many, BindingListHolder bl, BindingIteratorHolder bi) {
        NamingContextImpl impl;
        NamingContextImpl namingContextImpl = impl = this;
        synchronized (namingContextImpl) {
            impl.List(how_many, bl, bi);
        }
        if (this.readLogger.isLoggable(Level.FINE) && bl.value != null) {
            this.readLogger.fine("<<NAMING LIST>><<SUCCESS>>list(" + how_many + ") -> bindings[" + bl.value.length + "] + iterator: " + bi.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized NamingContext new_context() {
        NamingContextImpl impl;
        this.lifecycleLogger.fine("Creating New Naming Context ");
        NamingContextImpl namingContextImpl = impl = this;
        synchronized (namingContextImpl) {
            NamingContext nctx = impl.NewContext();
            if (nctx != null) {
                this.lifecycleLogger.fine("<<LIFECYCLE CREATE>><<SUCCESS>>");
            } else {
                this.lifecycleLogger.severe("<<LIFECYCLE CREATE>><<FAILURE>>");
            }
            return nctx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingContext bind_new_context(NameComponent[] n) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        NamingContext nc = null;
        NamingContext rnc = null;
        try {
            nc = this.new_context();
            this.bind_context(n, nc);
            rnc = nc;
            nc = null;
        }
        finally {
            try {
                if (nc != null) {
                    nc.destroy();
                }
            }
            catch (NotEmpty e) {}
        }
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING BIND>>New Context Bound To " + NamingUtils.getDirectoryStructuredName(n));
        }
        return rnc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws NotEmpty {
        NamingContextImpl impl;
        this.lifecycleLogger.fine("Destroying Naming Context ");
        NamingContextImpl namingContextImpl = impl = this;
        synchronized (namingContextImpl) {
            if (!impl.IsEmpty()) {
                this.lifecycleLogger.warning("<<LIFECYCLE DESTROY>><<FAILURE>> NamingContext children are not destroyed still..");
                throw new NotEmpty();
            }
            impl.Destroy();
            this.lifecycleLogger.fine("<<LIFECYCLE DESTROY>><<SUCCESS>>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doBind(NamingContextDataStore impl, NameComponent[] n, Object obj, boolean rebind, BindingType bt) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (n.length < 1) {
            throw new InvalidName();
        }
        if (n.length == 1) {
            if (n[0].id.length() == 0 && n[0].kind.length() == 0) {
                throw new InvalidName();
            }
            NamingContextDataStore namingContextDataStore = impl;
            synchronized (namingContextDataStore) {
                BindingTypeHolder bth = new BindingTypeHolder();
                if (rebind) {
                    Object objRef = impl.Resolve(n[0], bth);
                    if (objRef != null) {
                        if (bth.value.value() == BindingType.nobject.value()) {
                            if (bt.value() == BindingType.ncontext.value()) {
                                throw new NotFound(NotFoundReason.not_context, n);
                            }
                        } else if (bt.value() == BindingType.nobject.value()) {
                            throw new NotFound(NotFoundReason.not_object, n);
                        }
                        impl.Unbind(n[0]);
                    }
                } else if (impl.Resolve(n[0], bth) != null) {
                    throw new AlreadyBound();
                }
                impl.Bind(n[0], obj, bt);
            }
        } else {
            NamingContext context = NamingContextImpl.resolveFirstAsContext(impl, n);
            NameComponent[] tail = new NameComponent[n.length - 1];
            System.arraycopy(n, 1, tail, 0, n.length - 1);
            switch (bt.value()) {
                case 0: {
                    if (rebind) {
                        context.rebind(tail, obj);
                        break;
                    }
                    context.bind(tail, obj);
                    break;
                }
                case 1: {
                    NamingContext objContext = (NamingContext)obj;
                    if (rebind) {
                        context.rebind_context(tail, objContext);
                        break;
                    }
                    context.bind_context(tail, objContext);
                    break;
                }
                default: {
                    throw staticWrapper.namingCtxBadBindingtype();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doResolve(NamingContextDataStore impl, NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        Object obj = null;
        BindingTypeHolder bth = new BindingTypeHolder();
        if (n.length < 1) {
            throw new InvalidName();
        }
        if (n.length == 1) {
            NamingContextDataStore namingContextDataStore = impl;
            synchronized (namingContextDataStore) {
                obj = impl.Resolve(n[0], bth);
            }
            if (obj == null) {
                throw new NotFound(NotFoundReason.missing_node, n);
            }
            return obj;
        }
        if (n[1].id.length() == 0 && n[1].kind.length() == 0) {
            throw new InvalidName();
        }
        NamingContext context = NamingContextImpl.resolveFirstAsContext(impl, n);
        NameComponent[] tail = new NameComponent[n.length - 1];
        System.arraycopy(n, 1, tail, 0, n.length - 1);
        try {
            Servant servant = impl.getNSPOA().reference_to_servant((Object)context);
            return NamingContextImpl.doResolve((NamingContextDataStore)servant, tail);
        }
        catch (Exception e) {
            return context.resolve(tail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doUnbind(NamingContextDataStore impl, NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        if (n.length < 1) {
            throw new InvalidName();
        }
        if (n.length == 1) {
            if (n[0].id.length() == 0 && n[0].kind.length() == 0) {
                throw new InvalidName();
            }
            Object objRef = null;
            NamingContextDataStore namingContextDataStore = impl;
            synchronized (namingContextDataStore) {
                objRef = impl.Unbind(n[0]);
            }
            if (objRef == null) {
                throw new NotFound(NotFoundReason.missing_node, n);
            }
            return;
        }
        NamingContext context = NamingContextImpl.resolveFirstAsContext(impl, n);
        NameComponent[] tail = new NameComponent[n.length - 1];
        System.arraycopy(n, 1, tail, 0, n.length - 1);
        context.unbind(tail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static NamingContext resolveFirstAsContext(NamingContextDataStore impl, NameComponent[] n) throws NotFound {
        Object topRef = null;
        BindingTypeHolder bth = new BindingTypeHolder();
        NamingContext context = null;
        NamingContextDataStore namingContextDataStore = impl;
        synchronized (namingContextDataStore) {
            topRef = impl.Resolve(n[0], bth);
            if (topRef == null) {
                throw new NotFound(NotFoundReason.missing_node, n);
            }
        }
        if (bth.value != BindingType.ncontext) {
            throw new NotFound(NotFoundReason.not_context, n);
        }
        try {
            context = NamingContextHelper.narrow((Object)topRef);
        }
        catch (BAD_PARAM ex) {
            throw new NotFound(NotFoundReason.not_context, n);
        }
        return context;
    }

    public String to_string(NameComponent[] n) throws InvalidName {
        if (n == null || n.length == 0) {
            throw new InvalidName();
        }
        NamingContextImpl impl = this;
        String theStringifiedName = this.insImpl.convertToString(n);
        if (theStringifiedName == null) {
            throw new InvalidName();
        }
        return theStringifiedName;
    }

    public NameComponent[] to_name(String sn) throws InvalidName {
        if (sn == null || sn.length() == 0) {
            throw new InvalidName();
        }
        NamingContextImpl impl = this;
        NameComponent[] theNameComponents = this.insImpl.convertToNameComponent(sn);
        if (theNameComponents == null || theNameComponents.length == 0) {
            throw new InvalidName();
        }
        for (int i = 0; i < theNameComponents.length; ++i) {
            if (theNameComponents[i].id != null && theNameComponents[i].id.length() != 0 || theNameComponents[i].kind != null && theNameComponents[i].kind.length() != 0) continue;
            throw new InvalidName();
        }
        return theNameComponents;
    }

    public String to_url(String addr, String sn) throws InvalidAddress, InvalidName {
        if (sn == null || sn.length() == 0) {
            throw new InvalidName();
        }
        if (addr == null) {
            throw new InvalidAddress();
        }
        NamingContextImpl impl = this;
        String urlBasedAddress = null;
        urlBasedAddress = this.insImpl.createURLBasedAddress(addr, sn);
        try {
            INSURLHandler.getINSURLHandler().parseURL(urlBasedAddress);
        }
        catch (BAD_PARAM e) {
            throw new InvalidAddress();
        }
        return urlBasedAddress;
    }

    public Object resolve_str(String sn) throws NotFound, CannotProceed, InvalidName {
        Object theObject = null;
        if (sn == null || sn.length() == 0) {
            throw new InvalidName();
        }
        NamingContextImpl impl = this;
        NameComponent[] theNameComponents = this.insImpl.convertToNameComponent(sn);
        if (theNameComponents == null || theNameComponents.length == 0) {
            throw new InvalidName();
        }
        theObject = this.resolve(theNameComponents);
        return theObject;
    }

    private static String nameToString(NameComponent[] name) {
        StringBuffer s = new StringBuffer("{");
        if (name != null) {
            for (int i = 0; i < name.length; ++i) {
                if (i > 0) {
                    s.append(",");
                }
                s.append("[").append(name[i].id).append(",").append(name[i].kind).append("]");
            }
        }
        s.append("}");
        return s.toString();
    }

    private static void dprint(String msg) {
        NamingUtils.dprint("NamingContextImpl(" + Thread.currentThread().getName() + " at " + System.currentTimeMillis() + " ems): " + msg);
    }
}

