/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.ior.iiop;

import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfile;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBVersion;
import com.sun.corba.ee.spi.orb.ORBVersionFactory;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

@ManagedData
@Description(value="The maximum GIOP version supported by this IOR")
public class GIOPVersion {
    public static final GIOPVersion V1_0 = new GIOPVersion(1, 0);
    public static final GIOPVersion V1_1 = new GIOPVersion(1, 1);
    public static final GIOPVersion V1_2 = new GIOPVersion(1, 2);
    public static final GIOPVersion V1_3 = new GIOPVersion(1, 3);
    public static final GIOPVersion V13_XX = new GIOPVersion(13, 1);
    public static final GIOPVersion DEFAULT_VERSION = V1_2;
    public static final int VERSION_1_0 = 256;
    public static final int VERSION_1_1 = 257;
    public static final int VERSION_1_2 = 258;
    public static final int VERSION_1_3 = 259;
    public static final int VERSION_13_XX = 3329;
    private byte major = 0;
    private byte minor = 0;

    public GIOPVersion() {
    }

    public GIOPVersion(byte majorB, byte minorB) {
        this.major = majorB;
        this.minor = minorB;
    }

    public GIOPVersion(int major, int minor) {
        this.major = (byte)major;
        this.minor = (byte)minor;
    }

    @ManagedAttribute
    @Description(value="The Major GIOP version (almost always 1)")
    public byte getMajor() {
        return this.major;
    }

    @ManagedAttribute
    @Description(value="The Minor GIOP version (almost always 0, 1, or 2. This ORB almost always uses 2")
    public byte getMinor() {
        return this.minor;
    }

    public boolean equals(GIOPVersion gv) {
        return gv.major == this.major && gv.minor == this.minor;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof GIOPVersion) {
            return this.equals((GIOPVersion)obj);
        }
        return false;
    }

    public int hashCode() {
        return 37 * this.major + this.minor;
    }

    public boolean lessThan(GIOPVersion gv) {
        if (this.major < gv.major) {
            return true;
        }
        return this.major == gv.major && this.minor < gv.minor;
    }

    public int intValue() {
        return this.major << 8 | this.minor;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    public static GIOPVersion getInstance(byte major, byte minor) {
        switch (major << 8 | minor) {
            case 256: {
                return V1_0;
            }
            case 257: {
                return V1_1;
            }
            case 258: {
                return V1_2;
            }
            case 259: {
                return V1_3;
            }
            case 3329: {
                return V13_XX;
            }
        }
        return new GIOPVersion(major, minor);
    }

    public static GIOPVersion parseVersion(String s) {
        int dotIdx = s.indexOf(46);
        if (dotIdx < 1 || dotIdx == s.length() - 1) {
            throw new NumberFormatException("GIOP major, minor, and decimal point required: " + s);
        }
        int major = Integer.parseInt(s.substring(0, dotIdx));
        int minor = Integer.parseInt(s.substring(dotIdx + 1, s.length()));
        return GIOPVersion.getInstance((byte)major, (byte)minor);
    }

    public static GIOPVersion chooseRequestVersion(ORB orb, IOR ior) {
        GIOPVersion orbVersion = orb.getORBData().getGIOPVersion();
        IIOPProfile prof = ior.getProfile();
        GIOPVersion profVersion = prof.getGIOPVersion();
        ORBVersion targetOrbVersion = prof.getORBVersion();
        if (!targetOrbVersion.equals(ORBVersionFactory.getFOREIGN()) && targetOrbVersion.lessThan(ORBVersionFactory.getNEWER())) {
            return V1_0;
        }
        byte prof_major = profVersion.getMajor();
        byte prof_minor = profVersion.getMinor();
        byte orb_major = orbVersion.getMajor();
        byte orb_minor = orbVersion.getMinor();
        if (orb_major < prof_major) {
            return orbVersion;
        }
        if (orb_major > prof_major) {
            return profVersion;
        }
        if (orb_minor <= prof_minor) {
            return orbVersion;
        }
        return profVersion;
    }

    public boolean supportsIORIIOPProfileComponents() {
        return this.getMinor() > 0 || this.getMajor() > 1;
    }

    public void read(InputStream istream) {
        this.major = istream.read_octet();
        this.minor = istream.read_octet();
    }

    public void write(OutputStream ostream) {
        ostream.write_octet(this.major);
        ostream.write_octet(this.minor);
    }
}

