/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.gjc.spi.ManagedConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImpl
implements XAResource {
    XAResource xar;
    ManagedConnection mc;

    public XAResourceImpl(XAResource xar, ManagedConnection mc) {
        this.xar = xar;
        this.mc = mc;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.xar.commit(xid, onePhase);
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Exception e) {
            throw new XAException(e.getMessage());
        }
        finally {
            this.mc.transactionCompleted();
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.xar.end(xid, flags);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.xar.forget(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.xar.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        return this.xar.isSameRM(xares);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        try {
            int result = this.xar.prepare(xid);
            if (result == 3) {
                this.mc.transactionCompleted();
            }
            return result;
        }
        catch (XAException xae) {
            this.mc.transactionCompleted();
            throw xae;
        }
        catch (Exception e) {
            this.mc.transactionCompleted();
            throw new XAException(e.getMessage());
        }
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.xar.recover(flag);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            this.xar.rollback(xid);
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Exception e) {
            throw new XAException(e.getMessage());
        }
        finally {
            this.mc.transactionCompleted();
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xar.setTransactionTimeout(seconds);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.mc.transactionStarted();
        this.xar.start(xid, flags);
    }
}

