/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.acl;

import com.sun.messaging.jmq.auth.api.server.model.AccessControlModel;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;

public class JMQFileAccessControlModel
implements AccessControlModel {
    public static final String VERSION = "JMQFileAccessControlModel/100";
    public static final String TYPE = "file";
    public static final String PROP_FILENAME_SUFFIX = "file.filename";
    public static final String PROP_DIRPATH_SUFFIX = "file.dirpath";
    public static final String PROP_URL_SUFFIX = "file.url";
    public static final String DEFAULT_ACL_FILENAME = "accesscontrol.properties";
    private static boolean DEBUG = false;
    private Logger logger = Globals.getLogger();
    private static final String VERSION_PROPNAME = "version";
    private static final String ALLOW_SUFFIX = ".allow";
    private static final String DENY_SUFFIX = ".deny";
    private static final String USER_SUFFIX = ".user";
    private static final String GROUP_SUFFIX = ".group";
    private static final String ALL = "*";
    private static final String WILDCARD = "*";
    private static final int ALLOW_BIT = 0;
    private static final int DENY_BIT = 1;
    private String type;
    private Properties authProps;
    private String aclfname = null;
    private Properties acs = null;
    private long acsTimestamp = 0L;
    private String aclfileSave = null;
    private Class userClass = null;
    private Class groupClass = null;

    public String getType() {
        return TYPE;
    }

    public void initialize(String string, Properties properties) throws AccessControlException {
        this.type = string;
        if (!string.equals(TYPE)) {
            Object[] objectArray = new String[]{string, TYPE, this.getClass().getName()};
            String string2 = Globals.getBrokerResources().getKString("B4072", objectArray);
            this.logger.log(32, string2);
            throw new AccessControlException(string2);
        }
        this.authProps = properties;
        String string3 = this.authProps.getProperty("imq.authentication.type");
        assert (string3 != null);
        String string4 = this.authProps.getProperty("imq.authentication." + string3 + ".user_repository");
        assert (string4 != null);
        String string5 = "imq.user_repository." + string4 + ".userPrincipalClass";
        String string6 = this.authProps.getProperty(string5);
        String string7 = "imq.user_repository." + string4 + ".groupPrincipalClass";
        String string8 = this.authProps.getProperty(string7);
        try {
            if (string6 != null) {
                this.userClass = Class.forName(string6);
            }
            if (string8 != null) {
                this.groupClass = Class.forName(string8);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(32, classNotFoundException.getMessage(), classNotFoundException);
            throw new AccessControlException("ClassNotFoundException: " + classNotFoundException.getMessage());
        }
        this.load();
    }

    public void load() throws AccessControlException {
        String string = this.authProps.getProperty("imq.accesscontrol.file.url");
        String string2 = this.authProps.getProperty("imq." + this.authProps.getProperty("imq.servicename") + "." + "accesscontrol" + "." + PROP_FILENAME_SUFFIX);
        if (string2 != null) {
            string = null;
        }
        if (string != null) {
            InputStream inputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                this.acs = new Properties();
                URL uRL = new URL(string);
                inputStream = uRL.openStream();
                bufferedInputStream = new BufferedInputStream(inputStream);
                this.acs.load(bufferedInputStream);
                bufferedInputStream.close();
                inputStream.close();
                this.checkVersion(this.acs, string);
            }
            catch (IOException iOException) {
                this.acs = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this.logger.log(32, iOException.getMessage(), iOException);
                throw new AccessControlException(Globals.getBrokerResources().getKString("B4047", string) + " - " + iOException.getMessage());
            }
            return;
        }
        String string3 = this.authProps.getProperty("imq.user_repository.file.dirpath", Globals.getInstanceEtcDir());
        this.aclfname = this.authProps.getProperty("imq.accesscontrol.file.filename", DEFAULT_ACL_FILENAME);
        if (this.aclfname == null) {
            String string4 = Globals.getBrokerResources().getKString("B4046", this.type);
            this.logger.log(32, string4);
            throw new AccessControlException(string4);
        }
        String string5 = string3 + File.separator + this.aclfname;
        File file = null;
        long l = 0L;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            file = new File(string5);
            l = file.lastModified();
            if (this.acs != null && this.aclfileSave != null && string5.equals(this.aclfileSave) && l > 0L && l == this.acsTimestamp) {
                return;
            }
            if (DEBUG) {
                this.logger.log(8, "Loading access control " + string5 + " ...");
            }
            this.acs = new Properties();
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            this.acs.load(bufferedInputStream);
            bufferedInputStream.close();
            fileInputStream.close();
            this.checkVersion(this.acs, string5);
            this.aclfileSave = string5;
            this.acsTimestamp = l;
        }
        catch (IOException iOException) {
            this.acs = null;
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            this.logger.log(32, iOException.getMessage(), iOException);
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4047", string5) + " - " + iOException.getMessage());
        }
    }

    private void checkVersion(Properties properties, String string) throws AccessControlException {
        String string2 = properties.getProperty(VERSION_PROPNAME);
        if (string2 == null || !string2.equals(VERSION)) {
            string2 = string2 == null ? "null" : string2;
            Object[] objectArray = new String[]{VERSION_PROPNAME, string2, string, VERSION, this.getClass().getName()};
            String string3 = Globals.getBrokerResources().getKString("B4073", objectArray);
            this.logger.log(32, string3);
            throw new AccessControlException(string3);
        }
    }

    public void checkConnectionPermission(Principal principal, String string, String string2, Subject subject) throws AccessControlException {
        this.checkPermission(principal, subject, "connection", string2, null, false);
    }

    public void checkDestinationPermission(Principal principal, String string, String string2, Subject subject, String string3, String string4, String string5) throws AccessControlException {
        this.checkPermission(principal, subject, string5, string4, string3, true);
    }

    private void checkPermission(Principal principal, Subject subject, String string, String string2, String string3, boolean bl) throws AccessControlException {
        Set set = null;
        Set set2 = null;
        if (this.groupClass != null) {
            set = subject.getPrincipals(this.groupClass);
        }
        if (this.userClass != null) {
            set2 = subject.getPrincipals(this.userClass);
        }
        if (set2 == null || set2.size() == 0) {
            set2 = new HashSet();
            set2.add(principal);
        }
        this.load();
        Principal principal22 = null;
        StringBuffer stringBuffer = null;
        boolean bl2 = false;
        for (Principal principal22 : set2) {
            if (principal22 == null) continue;
            this.validate(principal22.getName(), set);
            ArrayList arrayList = this.getRules(string, string2, string3, bl);
            try {
                this.computePermission(principal.getName(), principal22.getName(), set, arrayList, GROUP_SUFFIX);
                bl2 = true;
            }
            catch (AccessControlException accessControlException) {
                if (DEBUG) {
                    this.logger.log(8, principal + "[" + principal22.getName() + "]AccessControlException: " + accessControlException.getMessage());
                }
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(accessControlException.getMessage());
                stringBuffer.append(", ");
            }
        }
        if (stringBuffer != null) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4051", stringBuffer));
        }
        if (!bl2) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4048"));
        }
    }

    private void computePermission(String string, String string2, Set set, ArrayList arrayList, String string3) throws AccessControlException {
        BitSet bitSet = new BitSet(2);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string4 = (String)arrayList.get(i);
            HashMap hashMap = this.getRuleRightHand(string4 + ALLOW_SUFFIX + USER_SUFFIX);
            HashMap hashMap2 = this.getRuleRightHand(string4 + DENY_SUFFIX + USER_SUFFIX);
            BitSet bitSet2 = this.getPermission("*", hashMap, hashMap2);
            BitSet bitSet3 = this.getPermission(string2, hashMap, hashMap2);
            BitSet bitSet4 = new BitSet(2);
            BitSet bitSet5 = new BitSet(2);
            if (set != null && set.size() > 0) {
                if (set.size() >= Integer.MAX_VALUE) {
                    throw new AccessControlException(Globals.getBrokerResources().getString("B4117", "too many groups for user " + string));
                }
                hashMap = this.getRuleRightHand(string4 + ALLOW_SUFFIX + string3);
                hashMap2 = this.getRuleRightHand(string4 + DENY_SUFFIX + string3);
                bitSet5 = this.getPermission("*", hashMap, hashMap2);
                for (Principal principal : set) {
                    bitSet4.or(this.getPermission(principal.getName(), hashMap, hashMap2));
                }
            }
            if (DEBUG) {
                this.logger.log(8, "\t" + string + "[" + string2 + "] computePermission:ubs=" + bitSet3);
                this.logger.log(8, "\t" + string + "[" + string2 + "] computePermission:gbs=" + bitSet4);
                this.logger.log(8, "\t" + string + "[" + string2 + "] computePermission:ubsall=" + bitSet2);
                this.logger.log(8, "\t" + string + "[" + string2 + "] computePermission:gbsall=" + bitSet5);
            }
            this.overridePermission(bitSet4, bitSet3);
            this.overridePermission(bitSet5, bitSet2);
            this.overridePermission(bitSet5, bitSet4);
            if (DEBUG) {
                this.logger.log(8, "computed permission:" + string4 + ":bs=" + bitSet5);
            }
            this.overridePermission(bitSet, bitSet5);
            if (!DEBUG) continue;
            this.logger.log(8, "computed permission:total=" + bitSet);
        }
        if (bitSet.get(0) && !bitSet.get(1)) {
            return;
        }
        throw new AccessControlException(string.equals(string2) ? "" + string : string + " [" + string2 + "]");
    }

    private void overridePermission(BitSet bitSet, BitSet bitSet2) {
        if (bitSet2.get(0) && bitSet2.get(1)) {
            return;
        }
        if (bitSet2.get(0)) {
            bitSet.set(0);
            bitSet.clear(1);
        }
        if (bitSet2.get(1)) {
            bitSet.set(1);
            bitSet.clear(0);
        }
    }

    private BitSet getPermission(String string, HashMap hashMap, HashMap hashMap2) {
        BitSet bitSet = new BitSet(2);
        if (hashMap != null && hashMap.get(string) != null) {
            bitSet.set(0);
        }
        if (hashMap2 != null && hashMap2.get(string) != null) {
            bitSet.set(1);
        }
        if (bitSet.get(0) && bitSet.get(1)) {
            bitSet.clear(0);
            bitSet.clear(1);
        }
        return bitSet;
    }

    private ArrayList getRules(String string, String string2, String string3, boolean bl) throws AccessControlException {
        String string4 = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string5 = null;
            if (string2 == null && string3 != null) {
                string5 = string + "." + string3;
                arrayList.add(string5);
                return arrayList;
            }
            string5 = string + "." + "*";
            if (string3 != null) {
                string5 = string5 + "." + string3;
            }
            arrayList.add(string5);
            if (!string2.equals("*")) {
                string5 = string + "." + string2;
                if (string3 != null) {
                    string5 = string5 + "." + string3;
                }
                arrayList.add(string5);
            }
            if (bl && string2 != null && string3 != null) {
                Pattern pattern = Pattern.compile("(" + string + "\\." + "(.+)" + "\\." + string3 + ")" + "(\\" + ALLOW_SUFFIX + "|" + "\\" + DENY_SUFFIX + ")(\\" + USER_SUFFIX + "|" + "\\" + GROUP_SUFFIX + ")");
                Enumeration<?> enumeration = this.acs.propertyNames();
                Matcher matcher = null;
                String string6 = null;
                while (enumeration.hasMoreElements()) {
                    string4 = (String)enumeration.nextElement();
                    matcher = pattern.matcher(string4);
                    if (!matcher.matches() || !Pattern.matches(string6 = DestinationUID.createRegExString(matcher.group(2)), string2)) continue;
                    arrayList.add(matcher.group(1));
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            AccessControlException accessControlException = new AccessControlException(exception.toString() + (string4 == null ? "" : " - " + string4));
            accessControlException.initCause(exception);
            throw accessControlException;
        }
    }

    private HashMap getRuleRightHand(String string) {
        String string2;
        if (DEBUG) {
            this.logger.log(4, "check permission " + string);
        }
        if ((string2 = this.acs.getProperty(string)) == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",", false);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (stringTokenizer.hasMoreElements()) {
            hashMap.put(stringTokenizer.nextToken().trim(), "");
        }
        if (hashMap.size() == 0) {
            return null;
        }
        return hashMap;
    }

    private void validate(String string, Set set) throws AccessControlException {
        if (string == null) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4048"));
        }
        if (string.equals("*")) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4049", "*"));
        }
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Principal principal = (Principal)iterator.next();
                if (principal == null || principal.getName() == null) {
                    iterator.remove();
                    continue;
                }
                if (!principal.getName().equals("*")) continue;
                throw new AccessControlException(Globals.getBrokerResources().getKString("B4069", "*"));
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DEBUG = true;
        Properties properties = new Properties();
        properties.setProperty("imq.accesscontrol.file.filename", DEFAULT_ACL_FILENAME);
        JMQFileAccessControlModel jMQFileAccessControlModel = new JMQFileAccessControlModel();
        jMQFileAccessControlModel.initialize(TYPE, properties);
        String string = "akang";
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("student");
        hashSet.add("Accounting Managers");
        ArrayList arrayList = jMQFileAccessControlModel.getRules("topic", "abc", "produce", true);
        System.out.println(arrayList);
        jMQFileAccessControlModel.computePermission(string, string, hashSet, arrayList, GROUP_SUFFIX);
        System.out.println("--DONE--");
    }
}

