/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.ToTxnLogConverter;
import com.sun.messaging.jmq.jmsserver.data.TransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class TxnConverter {
    TransactionList transactionList;
    Store store;
    static Logger logger = Globals.getLogger();

    TxnConverter(TransactionList transactionList, Store store) {
        this.transactionList = transactionList;
        this.store = store;
    }

    String getPrefix() {
        return Thread.currentThread() + " ToTxnLogConverter.TxnConverter.";
    }

    void getSentMessages(TransactionInformation transactionInformation, TransactionWork transactionWork) throws BrokerException {
        List list = transactionInformation.getPublishedMessages();
        for (SysMessageID sysMessageID : list) {
            Object object;
            PacketReference packetReference = Destination.get(sysMessageID);
            if (packetReference == null) {
                object = this.getPrefix() + " convertLocalToTxnLogFormat: can not find packet for sent msg " + sysMessageID + " in txn " + transactionInformation;
                logger.log(16, (String)object);
                continue;
            }
            object = packetReference.getDestination().getDestinationUID();
            ConsumerUID[] consumerUIDArray = this.store.getConsumerUIDs((DestinationUID)object, sysMessageID);
            TransactionWorkMessage transactionWorkMessage = new TransactionWorkMessage();
            transactionWorkMessage.setStoredInterests(consumerUIDArray);
            transactionWorkMessage.setPacketReference(packetReference);
            transactionWorkMessage.setDestUID((DestinationUID)object);
            transactionWork.addMesage(transactionWorkMessage);
        }
    }

    void getConsumedMessages(TransactionInformation transactionInformation, TransactionWork transactionWork) throws BrokerException {
        LinkedHashMap linkedHashMap = transactionInformation.getConsumedMessages(false);
        Iterator iterator = linkedHashMap.entrySet().iterator();
        HashMap hashMap = this.transactionList.retrieveStoredConsumerUIDs(transactionInformation.tid);
        while (iterator.hasNext()) {
            Object object;
            Map.Entry entry = iterator.next();
            SysMessageID sysMessageID = (SysMessageID)entry.getKey();
            List list = (List)entry.getValue();
            PacketReference packetReference = Destination.get(sysMessageID);
            if (packetReference == null) {
                object = this.getPrefix() + " convertLocalToTxnLogFormat: can not find packet for consumed msg" + sysMessageID + " in txn " + transactionInformation;
                logger.log(16, (String)object);
                continue;
            }
            object = packetReference.getDestination().getDestinationUID();
            if (list == null) continue;
            for (int i = 0; i < list.size(); ++i) {
                Object object2;
                ConsumerUID consumerUID = (ConsumerUID)list.get(i);
                ConsumerUID consumerUID2 = (ConsumerUID)hashMap.get(consumerUID);
                if (consumerUID2 == null) {
                    if (ToTxnLogConverter.DEBUG) {
                        object2 = this.getPrefix() + " storedcid=null for " + consumerUID;
                        logger.log(4, (String)object2);
                    }
                    consumerUID2 = consumerUID;
                }
                object2 = new TransactionWorkMessageAck((DestinationUID)object, sysMessageID, consumerUID2);
                if (ToTxnLogConverter.DEBUG) {
                    String string = this.getPrefix() + " convertLocalToTxnLogFormat: converting messageAck:" + " mid=" + sysMessageID + " destID=" + object + " consumerID=" + consumerUID + " storedCid=" + consumerUID2 + " txid=" + transactionInformation.tid;
                    logger.log(4, string);
                }
                transactionWork.addMessageAcknowledgement((TransactionWorkMessageAck)object2);
            }
        }
    }

    void deleteSentMessagesFromStore(TransactionWork transactionWork) throws BrokerException {
        for (TransactionWorkMessage transactionWorkMessage : transactionWork.getSentMessages()) {
            DestinationUID destinationUID = transactionWorkMessage.getDestUID();
            SysMessageID sysMessageID = transactionWorkMessage.getMessage().getSysMessageID();
            try {
                this.store.removeMessage(destinationUID, sysMessageID, true);
            }
            catch (IOException iOException) {
                String string = "Could not remove transacted sent message during txn conversion";
                logger.logStack(32, string, iOException);
            }
        }
    }
}

