/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.PHashMap;
import com.sun.messaging.jmq.util.PHashMapLoadException;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Map;

class InterestStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    BrokerConfig config = Globals.getConfig();
    static final String INTEREST_FILE_SIZE_PROP = "imq.persist.file.interest.file.size";
    static final long DEFAULT_INTEREST_FILE_SIZE = 1024L;
    static final String BASENAME = "interest";
    private File backingFile = null;
    private PHashMap interestMap = null;
    private LoadException loadException = null;

    InterestStore(File file, boolean bl) throws BrokerException {
        Throwable throwable;
        SizeString sizeString = this.config.getSizeProperty(INTEREST_FILE_SIZE_PROP, 1024L);
        this.backingFile = new File(file, BASENAME);
        try {
            this.interestMap = new PHashMap(this.backingFile, sizeString.getBytes(), false, bl);
        }
        catch (IOException iOException) {
            throw new BrokerException(this.br.getString("B4035"), iOException);
        }
        try {
            this.interestMap.load();
        }
        catch (IOException iOException) {
            throw new BrokerException(this.br.getString("B4035"), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BrokerException(this.br.getString("B4035"), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            while (throwable != null) {
                this.logger.log(16, "B4195", throwable);
                LoadException loadException = new LoadException(throwable.getMessage(), throwable.getCause());
                loadException.setKey(((PHashMapLoadException)throwable).getKey());
                loadException.setValue(((PHashMapLoadException)throwable).getValue());
                loadException.setKeyCause(((PHashMapLoadException)throwable).getKeyCause());
                loadException.setValueCause(((PHashMapLoadException)throwable).getValueCause());
                loadException.setNextException(this.loadException);
                this.loadException = loadException;
                throwable = ((PHashMapLoadException)throwable).getNextException();
            }
        }
        throwable = this.interestMap.getWarning();
        if (throwable != null) {
            this.logger.log(16, "possible loss of consumer data", throwable);
        }
        if (bl && Store.getDEBUG()) {
            this.logger.log(1, "InterestStore initialized with clear option");
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "LOADED " + this.interestMap.size() + " INTERESTS");
        }
    }

    InterestStore(FileStore fileStore, File file, File file2, boolean bl) throws BrokerException {
        Throwable throwable;
        SizeString sizeString = this.config.getSizeProperty(INTEREST_FILE_SIZE_PROP, 1024L);
        File file3 = new File(file2, BASENAME);
        PHashMap pHashMap = null;
        this.backingFile = new File(file, BASENAME);
        try {
            pHashMap = new PHashMap(file3, false, bl);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4155", file3, this.backingFile, iOException);
            throw new BrokerException(this.br.getString("B4155", file3, this.backingFile), iOException);
        }
        try {
            pHashMap.load();
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4155", file3, this.backingFile, iOException);
            throw new BrokerException(this.br.getString("B4155", file3, this.backingFile), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(32, "B4155", file3, this.backingFile, classNotFoundException);
            throw new BrokerException(this.br.getString("B4155", file3, this.backingFile), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            while (throwable != null) {
                this.logger.log(16, "B4200", throwable);
                LoadException loadException = new LoadException(throwable.getMessage(), throwable.getCause());
                loadException.setKey(((PHashMapLoadException)throwable).getKey());
                loadException.setValue(((PHashMapLoadException)throwable).getValue());
                loadException.setKeyCause(((PHashMapLoadException)throwable).getKeyCause());
                loadException.setValueCause(((PHashMapLoadException)throwable).getValueCause());
                loadException.setNextException(this.loadException);
                this.loadException = loadException;
                throwable = ((PHashMapLoadException)throwable).getNextException();
            }
        }
        throwable = pHashMap.getWarning();
        if (throwable != null) {
            this.logger.log(16, "possible loss of consumer data in old store", throwable);
        }
        try {
            this.interestMap = new PHashMap(this.backingFile, file3.length(), false, false);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4155", file3, this.backingFile, iOException);
            throw new BrokerException(this.br.getString("B4155", file3, this.backingFile), iOException);
        }
        try {
            this.interestMap.load();
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4155", file3, this.backingFile, iOException);
            throw new BrokerException(this.br.getString("B4155", file3, this.backingFile), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(32, "B4155", file3, this.backingFile, classNotFoundException);
            throw new BrokerException(this.br.getString("B4155", file3, this.backingFile), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            this.logger.log(32, "B4155", file3, this.backingFile, pHashMapLoadException);
            throw new BrokerException(this.br.getString("B4155", file3, this.backingFile), pHashMapLoadException);
        }
        throwable = this.interestMap.getWarning();
        if (throwable != null) {
            this.logger.log(16, "possible loss of consumer data", throwable);
        }
        for (Map.Entry entry : pHashMap.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.interestMap.put(k, v);
        }
        pHashMap.close();
        if (Store.getDEBUG()) {
            this.logger.log(4, "UPGRADED " + this.interestMap.size() + " INTERESTS");
        }
        if (fileStore.upgradeNoBackup() && !file3.delete()) {
            this.logger.log(32, "B1044", file3);
        }
    }

    LoadException getLoadException() {
        return this.loadException;
    }

    private void sync() throws BrokerException {
        try {
            if (Store.getDEBUG_SYNC()) {
                String string = "InterestStore sync()";
                this.logger.log(4, string);
            }
            this.interestMap.force();
        }
        catch (IOException iOException) {
            throw new BrokerException("Failed to synchronize file: " + this.backingFile, iOException);
        }
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Consumers", String.valueOf(this.interestMap.size()));
        return hashtable;
    }

    public void printInfo(PrintStream printStream) {
        printStream.println("\nInterests");
        printStream.println("---------");
        printStream.println("backing file: " + this.backingFile);
        printStream.println("number of interests:   " + this.interestMap.size());
    }

    void storeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        ConsumerUID consumerUID = consumer.getConsumerUID();
        try {
            Object object = this.interestMap.putIfAbsent(consumerUID, consumer);
            if (object != null) {
                this.logger.log(32, "B3010", (Object)consumerUID, consumer.getDestinationUID().getLongString());
                throw new BrokerException(this.br.getString("B3010", consumerUID, consumer.getDestinationUID().getLongString()));
            }
            if (bl) {
                this.sync();
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4012", (Object)consumerUID, (Throwable)runtimeException);
            throw runtimeException;
        }
    }

    void removeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        Object object = null;
        ConsumerUID consumerUID = consumer.getConsumerUID();
        try {
            object = this.interestMap.remove(consumerUID);
            if (object == null) {
                this.logger.log(32, "B3011", (Object)consumerUID, consumer.getDestinationUID().getLongString());
                throw new BrokerException(this.br.getString("B3011", consumerUID, consumer.getDestinationUID().getLongString()));
            }
            if (bl) {
                this.sync();
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4034", consumerUID);
            throw new BrokerException(this.br.getString("B4034", consumerUID), runtimeException);
        }
    }

    Consumer[] getAllInterests() throws IOException {
        return this.interestMap.values().toArray(new Consumer[0]);
    }

    void clearAll(boolean bl) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "InterestStore.clearAll() called");
        }
        this.interestMap.clear();
        if (bl) {
            try {
                this.sync();
            }
            catch (BrokerException brokerException) {
                this.logger.log(32, "Got exception while synchronizing data to disk", brokerException);
            }
        }
    }

    void close(boolean bl) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "InterestStore: closing, " + this.interestMap.size() + " persisted interests");
        }
        this.interestMap.close();
    }
}

