/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConfigRecordDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerStateDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBTool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DestinationDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.PropertyDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.TransactionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.XidImpl;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class UpgradeStore
implements DBConstants {
    private BrokerResources br = Globals.getBrokerResources();
    private Logger logger = Globals.getLogger();
    private JDBCStore store;
    private DBManager dbMgr;
    private String brokerID;
    private long storeSessionID;
    private int oldStoreVersion;
    private String oldVersionTable;
    private String oldPropTable;
    private String oldConfigRecordTable;
    private String oldDestTable;
    private String oldMsgTable;
    private String oldStateTable;
    private String oldInterestTable;
    private String oldTxnTable;
    private String oldAckTable;
    private boolean useBlob;
    private static boolean DEBUG = false;

    UpgradeStore(JDBCStore jDBCStore, int n) throws BrokerException {
        this.store = jDBCStore;
        this.dbMgr = DBManager.getDBManager();
        this.brokerID = this.dbMgr.getBrokerID();
        this.oldStoreVersion = n;
        if (this.oldStoreVersion == 400) {
            this.useBlob = true;
            this.oldVersionTable = this.dbMgr.getTableName("MQVER40");
            this.oldPropTable = this.dbMgr.getTableName("MQPROP40");
            this.oldConfigRecordTable = this.dbMgr.getTableName("MQCREC40");
            this.oldDestTable = this.dbMgr.getTableName("MQDST40");
            this.oldMsgTable = this.dbMgr.getTableName("MQMSG40");
            this.oldStateTable = this.dbMgr.getTableName("MQCONSTATE40");
            this.oldInterestTable = this.dbMgr.getTableName("MQCON40");
            this.oldTxnTable = this.dbMgr.getTableName("MQTXN40");
        } else if (this.oldStoreVersion == 370) {
            this.useBlob = true;
            this.oldVersionTable = "IMQSV37" + this.brokerID;
            this.oldPropTable = "IMQPROPS37" + this.brokerID;
            this.oldConfigRecordTable = "IMQCCREC37" + this.brokerID;
            this.oldDestTable = "IMQDEST37" + this.brokerID;
            this.oldMsgTable = "IMQMSG37" + this.brokerID;
            this.oldStateTable = "IMQILIST37" + this.brokerID;
            this.oldInterestTable = "IMQINT37" + this.brokerID;
            this.oldTxnTable = "IMQTXN37" + this.brokerID;
            this.oldAckTable = "IMQTACK37" + this.brokerID;
        } else {
            this.useBlob = false;
            this.oldVersionTable = "IMQSV35" + this.brokerID;
            this.oldPropTable = "IMQPROPS35" + this.brokerID;
            this.oldConfigRecordTable = "IMQCCREC35" + this.brokerID;
            this.oldDestTable = "IMQDEST35" + this.brokerID;
            this.oldMsgTable = "IMQMSG35" + this.brokerID;
            this.oldStateTable = "IMQILIST35" + this.brokerID;
            this.oldInterestTable = "IMQINT35" + this.brokerID;
            this.oldTxnTable = "IMQTXN35" + this.brokerID;
            this.oldAckTable = "IMQTACK35" + this.brokerID;
        }
    }

    void upgradeStore(Connection connection) throws BrokerException {
        Object[] objectArray = new Object[]{new Integer(410)};
        this.logger.logToAll(8, "B1115", objectArray);
        if (this.store.resetMessage()) {
            this.logger.logToAll(8, "B1101");
            this.logger.logToAll(8, "B1102");
        } else if (this.store.resetInterest()) {
            this.logger.logToAll(8, "B1103");
            this.logger.logToAll(8, "B1102");
        }
        try {
            DBTool.createTables(connection);
            this.storeSessionID = this.dbMgr.getDAOFactory().getStoreSessionDAO().getStoreSession(connection, this.brokerID);
        }
        catch (Throwable throwable) {
            String string = this.dbMgr.getCreateDBURL();
            if (string == null || string.length() == 0) {
                string = this.dbMgr.getOpenDBURL();
            }
            String string2 = this.br.getKString("B3073", string);
            this.logger.logToAll(32, string2, throwable);
            throw new BrokerException(string2, throwable);
        }
        try {
            connection.setAutoCommit(false);
            this.upgradeProperties(connection);
            this.upgradeChangeRecords(connection);
            this.upgradeDestinations(connection);
            this.upgradeMessages(connection);
            this.upgradeInterests(connection);
            this.upgradeTxns(connection);
            this.upgradeTxnAcks(connection);
            this.logger.logToAll(8, "B1106");
            if (this.store.upgradeNoBackup()) {
                this.dropTable(connection, this.oldVersionTable);
            } else {
                this.logger.logToAll(8, "B1121");
            }
        }
        catch (Exception exception) {
            this.logger.logToAll(32, "B1116");
            try {
                DBTool.dropTables(connection, this.dbMgr.getTableNames(410));
            }
            catch (SQLException sQLException) {
                this.logger.logStack(32, "B4117", "Failed to clean up new tables after upgrade failed", (Throwable)sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            throw new BrokerException(this.br.getKString("B3207"), exception);
        }
    }

    private void upgradeDestinations(Connection connection) throws BrokerException {
        DestinationDAO destinationDAO = this.dbMgr.getDAOFactory().getDestinationDAO();
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this.oldStoreVersion == 400) {
            stringBuffer.append("SELECT ").append("DESTINATION").append(", ").append("CONNECTION_ID").append(", ").append("CONNECTED_TS").append(", ").append("CREATED_TS");
        } else {
            stringBuffer.append("SELECT ").append("DEST");
        }
        stringBuffer.append(" FROM ").append(this.oldDestTable);
        String string = stringBuffer.toString();
        String string2 = new StringBuffer(128).append("INSERT INTO ").append(destinationDAO.getTableName()).append(" ( ").append("ID").append(", ").append("DESTINATION").append(", ").append("IS_LOCAL").append(", ").append("CONNECTION_ID").append(", ").append("CONNECTED_TS").append(", ").append("STORE_SESSION_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates() && !this.dbMgr.isHADB();
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Destination destination = null;
        try {
            block15: {
                try {
                    preparedStatement = connection.prepareStatement(string2);
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string);
                    while (resultSet.next()) {
                        ConnectionUID connectionUID;
                        Object object = Util.readObject(resultSet, 1);
                        destination = (Destination)object;
                        String string3 = destination.getUniqueName();
                        int n = destination.getIsLocal() ? 1 : 0;
                        long l = -1L;
                        long l2 = -1L;
                        long l3 = System.currentTimeMillis();
                        if (this.oldStoreVersion == 400) {
                            l = resultSet.getLong(2);
                            l2 = resultSet.getLong(3);
                            l3 = resultSet.getLong(4);
                        } else if (n > 0 && (connectionUID = destination.getConnectionUID()) != null) {
                            l = connectionUID.longValue();
                            l2 = l3;
                        }
                        try {
                            preparedStatement.setString(1, string3);
                            Util.setObject(preparedStatement, 2, destination);
                            preparedStatement.setInt(3, n);
                            Util.setLong(preparedStatement, 4, l);
                            Util.setLong(preparedStatement, 5, l2);
                            Util.setLong(preparedStatement, 6, this.storeSessionID);
                            preparedStatement.setLong(7, l3);
                            if (bl) {
                                preparedStatement.addBatch();
                                continue;
                            }
                            preparedStatement.executeUpdate();
                        }
                        catch (IOException iOException) {
                            IOException iOException2 = DBManager.wrapIOException("[" + string2 + "]", iOException);
                            throw iOException2;
                        }
                        catch (SQLException sQLException) {
                            SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                            throw sQLException2;
                        }
                    }
                    if (bl) {
                        preparedStatement.executeBatch();
                    }
                    connection.commit();
                    if (!this.store.upgradeNoBackup()) break block15;
                    this.dropTable(connection, this.oldDestTable);
                }
                catch (Exception exception) {
                    String string4 = this.br.getKString("B4162", destination == null ? "loading" : destination.getUniqueName());
                    this.logger.logStack(32, string4, exception);
                    throw new BrokerException(string4, exception);
                }
            }
            Object var23_24 = null;
        }
        catch (Throwable throwable) {
            Object var23_25 = null;
            Util.close(resultSet, statement, null);
            Util.close(null, preparedStatement, null);
            throw throwable;
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    private void upgradeMessages(Connection connection) throws BrokerException {
        String string = null;
        int n = 0;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            block13: {
                try {
                    string = "SELECT COUNT(*) FROM " + this.oldMsgTable;
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string);
                    if (!resultSet.next()) break block13;
                    n = resultSet.getInt(1);
                }
                catch (SQLException sQLException) {
                    this.logger.log(32, "B4166", string, (Throwable)sQLException);
                    throw new BrokerException(this.br.getString("B4166", string), sQLException);
                }
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            Util.close(resultSet, statement, null);
            throw throwable;
        }
        Util.close(resultSet, statement, null);
        if (Store.getDEBUG()) {
            this.logger.log(4, "number of messages in old table = " + n);
        }
        boolean bl = this.store.upgradeNoBackup();
        if (n == 0) {
            if (bl) {
                this.dropTable(connection, this.oldMsgTable);
                this.dropTable(connection, this.oldStateTable);
            }
        } else if (this.store.resetMessage()) {
            if (bl) {
                this.dropTable(connection, this.oldMsgTable);
                this.dropTable(connection, this.oldStateTable);
            } else {
                this.clearTable(connection, this.oldMsgTable);
                this.clearTable(connection, this.oldStateTable);
            }
        } else {
            this.logger.logToAll(8, this.br.getString("B1118", String.valueOf(n)));
            this.doUpgradeMsg(connection);
            if (bl) {
                this.dropTable(connection, this.oldMsgTable);
                this.dropTable(connection, this.oldStateTable);
            }
        }
    }

    private void doUpgradeMsg(Connection connection) throws BrokerException {
        String string;
        Object object;
        Object object2;
        MessageDAO messageDAO = this.dbMgr.getDAOFactory().getMessageDAO();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this.oldStoreVersion == 400) {
            stringBuffer.append("SELECT ").append("ID").append(", ").append("MESSAGE").append(", ").append("DESTINATION_ID").append(", ").append("CREATED_TS");
        } else {
            stringBuffer.append("SELECT ").append("MID").append(", ").append("MSG").append(", ").append("DID").append(", ").append(0);
        }
        stringBuffer.append(" FROM ").append(this.oldMsgTable);
        String string2 = stringBuffer.toString();
        Statement statement = null;
        ResultSet resultSet = null;
        Packet packet = null;
        String string3 = null;
        try {
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string2);
                while (resultSet.next()) {
                    string3 = resultSet.getString(1);
                    packet = new Packet(false);
                    packet.generateTimestamp(false);
                    packet.generateSequenceNumber(false);
                    object2 = this.useBlob ? resultSet.getBlob(2).getBinaryStream() : resultSet.getBinaryStream(2);
                    packet.readPacket((InputStream)object2);
                    ((InputStream)object2).close();
                    object = packet.getSysMessageID();
                    string = resultSet.getString(3);
                    long l = resultSet.getLong(4);
                    if (l == 0L) {
                        l = ((SysMessageID)object).getTimestamp();
                    }
                    messageDAO.insert(connection, string, packet, null, null, this.storeSessionID, l, false);
                    String string4 = ((SysMessageID)object).toString();
                    hashMap.put(string3, string4);
                    hashMap2.put(string4, string);
                }
                Object var18_20 = null;
            }
            catch (Exception exception) {
                String string5 = this.br.getKString("B4163", packet == null ? string3 : packet.getSysMessageID().toString());
                this.logger.logStack(32, string5, exception);
                throw new BrokerException(string5, exception);
            }
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            Util.close(resultSet, statement, null);
            throw throwable;
        }
        Util.close(resultSet, statement, null);
        object2 = this.dbMgr.getDAOFactory().getConsumerStateDAO();
        stringBuffer = new StringBuffer(128);
        if (this.oldStoreVersion == 400) {
            stringBuffer.append("SELECT ").append("MESSAGE_ID").append(", ").append("CONSUMER_ID").append(", ").append("STATE").append(", ").append("TRANSACTION_ID").append(", ").append("CREATED_TS");
        } else {
            stringBuffer.append("SELECT ").append("MID").append(", ").append("CUID").append(", ").append("STATE");
        }
        stringBuffer.append(" FROM ").append(this.oldStateTable).append(" WHERE ").append("STATE").append(" <> ").append(2);
        object = stringBuffer.toString();
        string = new StringBuffer(128).append("INSERT INTO ").append(object2.getTableName()).append(" ( ").append("MESSAGE_ID").append(", ").append("CONSUMER_ID").append(", ").append("STATE").append(", ").append("TRANSACTION_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates() && !this.dbMgr.isHADB();
        PreparedStatement preparedStatement = null;
        long l = 0L;
        string3 = null;
        try {
            try {
                preparedStatement = connection.prepareStatement(string);
                statement = connection.createStatement();
                resultSet = statement.executeQuery((String)object);
                while (resultSet.next()) {
                    String string6;
                    string3 = resultSet.getString(1);
                    l = resultSet.getLong(2);
                    int n = resultSet.getInt(3);
                    String string7 = (String)hashMap.get(string3);
                    if (string7 == null) {
                        string6 = this.br.getKString("B3100", "Unable to update message ID format of interest " + l + " for message " + string3);
                        throw new BrokerException(string6);
                    }
                    string6 = (String)hashMap2.get(string7);
                    if (string6 == null) {
                        this.logger.log(16, "Destination not found: ignore state of interest " + l + " for message " + string3);
                        continue;
                    }
                    long l2 = -1L;
                    long l3 = System.currentTimeMillis();
                    if (this.oldStoreVersion == 400) {
                        l2 = resultSet.getLong(4);
                        if (resultSet.wasNull()) {
                            l2 = -1L;
                        }
                        l3 = resultSet.getLong(5);
                    }
                    try {
                        preparedStatement.setString(1, string7);
                        preparedStatement.setLong(2, l);
                        preparedStatement.setInt(3, n);
                        Util.setLong(preparedStatement, 4, l2);
                        preparedStatement.setLong(5, l3);
                        if (bl) {
                            preparedStatement.addBatch();
                            continue;
                        }
                        preparedStatement.executeUpdate();
                    }
                    catch (SQLException sQLException) {
                        SQLException sQLException2 = DBManager.wrapSQLException("[" + string + "]", sQLException);
                        throw sQLException2;
                    }
                }
                hashMap2.clear();
                if (bl) {
                    preparedStatement.executeBatch();
                }
                connection.commit();
            }
            catch (SQLException sQLException) {
                String string8 = this.br.getKString("B4163", string3 == null ? "loading" : string3);
                this.logger.logStack(32, string8, sQLException);
                throw new BrokerException(string8, sQLException);
            }
            Object var28_33 = null;
        }
        catch (Throwable throwable) {
            Object var28_34 = null;
            Util.close(resultSet, statement, null);
            Util.close(null, preparedStatement, null);
            throw throwable;
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    private void upgradeInterests(Connection connection) throws BrokerException {
        String string = "SELECT COUNT(*) FROM " + this.oldInterestTable;
        int n = 0;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            block12: {
                try {
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string);
                    if (!resultSet.next()) break block12;
                    n = resultSet.getInt(1);
                }
                catch (SQLException sQLException) {
                    this.logger.log(32, "B4166", (Object)string, (Throwable)sQLException);
                    throw new BrokerException(this.br.getString("B4166", string), sQLException);
                }
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            Util.close(resultSet, statement, null);
            throw throwable;
        }
        Util.close(resultSet, statement, null);
        if (Store.getDEBUG()) {
            this.logger.log(4, "number of interests in old table = " + n);
        }
        boolean bl = this.store.upgradeNoBackup();
        if (n == 0) {
            if (bl) {
                this.dropTable(connection, this.oldInterestTable);
            }
        } else if (this.store.resetInterest()) {
            if (bl) {
                this.dropTable(connection, this.oldInterestTable);
            } else {
                this.clearTable(connection, this.oldInterestTable);
            }
        } else {
            this.doUpgradeInterests(this.store, connection);
        }
    }

    private void doUpgradeInterests(JDBCStore jDBCStore, Connection connection) throws BrokerException {
        ConsumerDAO consumerDAO = this.dbMgr.getDAOFactory().getConsumerDAO();
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this.oldStoreVersion == 400) {
            stringBuffer.append("SELECT ").append("CONSUMER").append(", ").append("CREATED_TS");
        } else {
            stringBuffer.append("SELECT ").append("INTEREST");
        }
        stringBuffer.append(" FROM ").append(this.oldInterestTable);
        String string = stringBuffer.toString();
        String string2 = new StringBuffer(128).append("INSERT INTO ").append(consumerDAO.getTableName()).append(" ( ").append("ID").append(", ").append("CONSUMER").append(", ").append("DURABLE_NAME").append(", ").append("CLIENT_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates() && !this.dbMgr.isHADB();
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Consumer consumer = null;
        try {
            block14: {
                try {
                    preparedStatement = connection.prepareStatement(string2);
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string);
                    while (resultSet.next()) {
                        consumer = (Consumer)Util.readObject(resultSet, 1);
                        String string3 = null;
                        String string4 = null;
                        if (consumer instanceof Subscription) {
                            Subscription subscription = (Subscription)consumer;
                            string3 = subscription.getDurableName();
                            string4 = subscription.getClientID();
                        }
                        long l = System.currentTimeMillis();
                        if (this.oldStoreVersion == 400) {
                            l = resultSet.getLong(2);
                        }
                        try {
                            preparedStatement.setLong(1, consumer.getConsumerUID().longValue());
                            Util.setObject(preparedStatement, 2, consumer);
                            Util.setString(preparedStatement, 3, string3);
                            Util.setString(preparedStatement, 4, string4);
                            preparedStatement.setLong(5, l);
                            if (bl) {
                                preparedStatement.addBatch();
                                continue;
                            }
                            preparedStatement.executeUpdate();
                        }
                        catch (IOException iOException) {
                            IOException iOException2 = DBManager.wrapIOException("[" + string2 + "]", iOException);
                            throw iOException2;
                        }
                        catch (SQLException sQLException) {
                            SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                            throw sQLException2;
                        }
                    }
                    if (bl) {
                        preparedStatement.executeBatch();
                    }
                    connection.commit();
                    if (!jDBCStore.upgradeNoBackup()) break block14;
                    this.dropTable(connection, this.oldInterestTable);
                }
                catch (Exception exception) {
                    String string5 = this.br.getKString("B4168", consumer == null ? "loading" : consumer.toString());
                    this.logger.logStack(32, string5, exception);
                    throw new BrokerException(string5, exception);
                }
            }
            Object var19_22 = null;
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            Util.close(resultSet, statement, null);
            Util.close(null, preparedStatement, null);
            throw throwable;
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    private void upgradeTxns(Connection connection) throws BrokerException {
        TransactionDAO transactionDAO = this.dbMgr.getDAOFactory().getTransactionDAO();
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this.oldStoreVersion == 400) {
            stringBuffer.append("SELECT ").append("ID").append(", ").append("STATE").append(", ").append("TXN_STATE");
        } else {
            stringBuffer.append("SELECT ").append("TUID").append(", ").append("STATE").append(", ").append("TSTATEOBJ");
        }
        stringBuffer.append(" FROM ").append(this.oldTxnTable).append(" WHERE ").append("STATE").append(" <> ").append(-1);
        String string = stringBuffer.toString();
        String string2 = new StringBuffer(128).append("INSERT INTO ").append(transactionDAO.getTableName()).append(" ( ").append("ID").append(", ").append("TYPE").append(", ").append("STATE").append(", ").append("AUTO_ROLLBACK").append(", ").append("XID").append(", ").append("TXN_STATE").append(", ").append("TXN_HOME_BROKER").append(", ").append("TXN_BROKERS").append(", ").append("STORE_SESSION_ID").append(", ").append("EXPIRED_TS").append(", ").append("ACCESSED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates() && !this.dbMgr.isHADB();
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        TransactionUID transactionUID = null;
        try {
            try {
                preparedStatement = connection.prepareStatement(string2);
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    Object object;
                    long l = resultSet.getLong(1);
                    transactionUID = new TransactionUID(l);
                    int n = resultSet.getInt(2);
                    TransactionState transactionState = (TransactionState)Util.readObject(resultSet, 3);
                    if (DEBUG) {
                        object = "reading transaction from old format: state=" + n + " txnState = " + transactionState;
                        this.logger.log(4, (String)object);
                    }
                    transactionState.setState(n);
                    try {
                        preparedStatement.setLong(1, l);
                        preparedStatement.setInt(2, 1);
                        preparedStatement.setInt(3, n);
                        preparedStatement.setInt(4, transactionState.getType().intValue());
                        object = transactionState.getXid();
                        if (object != null) {
                            preparedStatement.setString(5, ((XidImpl)object).toString());
                        } else {
                            preparedStatement.setNull(5, 12);
                        }
                        Util.setObject(preparedStatement, 6, transactionState);
                        Util.setObject(preparedStatement, 7, null);
                        Util.setObject(preparedStatement, 8, null);
                        preparedStatement.setLong(9, this.storeSessionID);
                        preparedStatement.setLong(10, transactionState.getExpirationTime());
                        preparedStatement.setLong(11, transactionState.getLastAccessTime());
                        if (bl) {
                            preparedStatement.addBatch();
                            continue;
                        }
                        preparedStatement.executeUpdate();
                    }
                    catch (IOException iOException) {
                        IOException iOException2 = DBManager.wrapIOException("[" + string2 + "]", iOException);
                        throw iOException2;
                    }
                    catch (SQLException sQLException) {
                        SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                        throw sQLException2;
                    }
                }
                if (bl) {
                    preparedStatement.executeBatch();
                }
                connection.commit();
            }
            catch (Exception exception) {
                String string3 = this.br.getKString("B4172", transactionUID == null ? "loading" : transactionUID.toString());
                this.logger.logStack(32, string3, exception);
                throw new BrokerException(string3, exception);
            }
            Object var18_20 = null;
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            Util.close(resultSet, statement, null);
            Util.close(null, preparedStatement, null);
            throw throwable;
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    private void upgradeTxnAcks(Connection connection) throws BrokerException {
        if (this.oldStoreVersion == 400) {
            return;
        }
        ConsumerStateDAO consumerStateDAO = this.dbMgr.getDAOFactory().getConsumerStateDAO();
        String string = "SELECT atbl.TUID, TXNACK FROM " + this.oldTxnTable + " ttbl, " + this.oldAckTable + " atbl" + " WHERE ttbl." + "TUID" + " = atbl." + "TUID";
        String string2 = new StringBuffer(128).append("UPDATE ").append(consumerStateDAO.getTableName()).append(" SET ").append("TRANSACTION_ID").append(" = ? ").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates() && !this.dbMgr.isHADB();
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        TransactionUID transactionUID = null;
        try {
            block10: {
                try {
                    preparedStatement = connection.prepareStatement(string2);
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string);
                    while (resultSet.next()) {
                        long l = resultSet.getLong(1);
                        transactionUID = new TransactionUID(l);
                        TransactionAcknowledgement transactionAcknowledgement = (TransactionAcknowledgement)Util.readObject(resultSet, 2);
                        try {
                            preparedStatement.setLong(1, l);
                            preparedStatement.setString(2, transactionAcknowledgement.getSysMessageID().toString());
                            preparedStatement.setLong(3, transactionAcknowledgement.getStoredConsumerUID().longValue());
                            if (bl) {
                                preparedStatement.addBatch();
                                continue;
                            }
                            preparedStatement.executeUpdate();
                        }
                        catch (SQLException sQLException) {
                            SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                            throw sQLException2;
                        }
                    }
                    if (bl) {
                        preparedStatement.executeBatch();
                    }
                    connection.commit();
                    if (!this.store.upgradeNoBackup()) break block10;
                    this.dropTable(connection, this.oldTxnTable);
                    this.dropTable(connection, this.oldAckTable);
                }
                catch (Exception exception) {
                    String string3 = this.br.getKString("B4173", transactionUID == null ? "loading" : transactionUID.toString());
                    this.logger.logStack(32, string3, exception);
                    throw new BrokerException(string3, exception);
                }
            }
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            Util.close(resultSet, statement, null);
            Util.close(null, preparedStatement, null);
            throw throwable;
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    private void upgradeChangeRecords(Connection connection) throws BrokerException {
        ConfigRecordDAO configRecordDAO = this.dbMgr.getDAOFactory().getConfigRecordDAO();
        StringBuffer stringBuffer = new StringBuffer(128).append("SELECT ").append("RECORD").append(", ");
        if (this.oldStoreVersion == 400) {
            stringBuffer.append("CREATED_TS");
        } else {
            stringBuffer.append("RECORDTIME");
        }
        stringBuffer.append(" FROM ").append(this.oldConfigRecordTable);
        String string = stringBuffer.toString();
        String string2 = new StringBuffer(128).append("INSERT INTO ").append(configRecordDAO.getTableName()).append(" ( ").append("RECORD").append(", ").append("CREATED_TS").append(") VALUES ( ?, ? )").toString();
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Long l = null;
        try {
            block10: {
                try {
                    preparedStatement = connection.prepareStatement(string2);
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string);
                    while (resultSet.next()) {
                        byte[] byArray = Util.readBytes(resultSet, 1);
                        long l2 = resultSet.getLong(2);
                        l = new Long(l2);
                        try {
                            Util.setBytes(preparedStatement, 1, byArray);
                            preparedStatement.setLong(2, l2);
                            preparedStatement.executeUpdate();
                        }
                        catch (IOException iOException) {
                            IOException iOException2 = DBManager.wrapIOException("[" + string2 + "]", iOException);
                            throw iOException2;
                        }
                        catch (SQLException sQLException) {
                            SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                            throw sQLException2;
                        }
                    }
                    connection.commit();
                    if (!this.store.upgradeNoBackup()) break block10;
                    this.dropTable(connection, this.oldConfigRecordTable);
                }
                catch (Exception exception) {
                    String string3 = this.br.getKString("B4171", l == null ? "loading" : l.toString());
                    this.logger.logStack(32, string3, exception);
                    throw new BrokerException(string3, exception);
                }
            }
            Object var16_18 = null;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            Util.close(resultSet, statement, null);
            Util.close(null, preparedStatement, null);
            throw throwable;
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    private void upgradeProperties(Connection connection) throws BrokerException {
        PropertyDAO propertyDAO = this.dbMgr.getDAOFactory().getPropertyDAO();
        String string = "SELECT PROPNAME, PROPVALUE FROM " + this.oldPropTable;
        String string2 = new StringBuffer(128).append("INSERT INTO ").append(propertyDAO.getTableName()).append(" ( ").append("PROPNAME").append(", ").append("PROPVALUE").append(") VALUES ( ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates();
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = null;
        try {
            block10: {
                try {
                    preparedStatement = connection.prepareStatement(string2);
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string);
                    while (resultSet.next()) {
                        string3 = resultSet.getString(1);
                        Object object = Util.readObject(resultSet, 2);
                        try {
                            preparedStatement.setString(1, string3);
                            Util.setObject(preparedStatement, 2, object);
                            if (bl) {
                                preparedStatement.addBatch();
                                continue;
                            }
                            preparedStatement.executeUpdate();
                        }
                        catch (IOException iOException) {
                            IOException iOException2 = DBManager.wrapIOException("[" + string2 + "]", iOException);
                            throw iOException2;
                        }
                        catch (SQLException sQLException) {
                            SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                            throw sQLException2;
                        }
                    }
                    if (bl) {
                        preparedStatement.executeBatch();
                    }
                    connection.commit();
                    if (!this.store.upgradeNoBackup()) break block10;
                    this.dropTable(connection, this.oldPropTable);
                }
                catch (Exception exception) {
                    String string4 = this.br.getKString("B4170", string3 == null ? "loading" : string3);
                    this.logger.logStack(32, string4, exception);
                    throw new BrokerException(string4, exception);
                }
            }
            Object var14_17 = null;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            Util.close(resultSet, statement, null);
            Util.close(null, preparedStatement, null);
            throw throwable;
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dropTable(Connection connection, String string) throws BrokerException {
        String string2 = "DROP TABLE " + string;
        Statement statement = null;
        try {
            block4: {
                try {
                    statement = connection.createStatement();
                    statement.executeUpdate(string2);
                    connection.commit();
                    if (!Store.getDEBUG()) break block4;
                    Globals.getLogger().log(4, "Dropped table " + string);
                }
                catch (SQLException sQLException) {
                    Globals.getLogger().log(32, "B1117", (Object)string, (Throwable)DBManager.wrapSQLException("[" + string2 + "]", sQLException));
                    Object var7_6 = null;
                    Util.close(null, statement, null);
                    return;
                }
            }
            Object var7_5 = null;
            Util.close(null, statement, null);
            return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Util.close(null, statement, null);
            throw throwable;
        }
    }

    private void clearTable(Connection connection, String string) throws BrokerException {
        String string2 = "DELETE FROM " + string;
        Statement statement = null;
        try {
            block4: {
                try {
                    statement = connection.createStatement();
                    int n = statement.executeUpdate(string2);
                    connection.commit();
                    if (!Store.getDEBUG()) break block4;
                    Globals.getLogger().log(4, "Deleted " + n + " entries in " + string);
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                    String string3 = Globals.getBrokerResources().getString("B4174", string);
                    Globals.getLogger().log(32, string3, sQLException2);
                    throw new BrokerException(string3, sQLException2);
                }
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            Util.close(null, statement, null);
            throw throwable;
        }
        Util.close(null, statement, null);
    }

    static {
        if (Globals.getLogger().getLevel() <= 4) {
            DEBUG = true;
        }
    }
}

