/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.services;

import com.sun.enterprise.admin.servermgmt.services.AppserverServiceType;
import com.sun.enterprise.admin.servermgmt.services.Service;
import com.sun.enterprise.admin.servermgmt.services.Strings;
import com.sun.enterprise.universal.PropertiesDecoder;
import com.sun.enterprise.universal.io.SmartFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceAdapter
implements Service {
    private final String user = System.getProperty("user.name");
    private String date = new Date().toString();
    private String location;
    private String name;
    private String asadminPath;
    private String passwordFilePath;
    private String flattenedServicePropertes;
    private String appserverUser;
    private boolean trace;
    private boolean dryRun;
    private AppserverServiceType type = AppserverServiceType.Domain;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public AppserverServiceType getType() {
        return this.type;
    }

    @Override
    public void setType(AppserverServiceType type) {
        this.type = type;
    }

    @Override
    public String getDate() {
        return this.date;
    }

    @Override
    public void setDate(String date) {
        this.date = date;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public String getFQSN() {
        throw new UnsupportedOperationException("getFQSN not supported for this Platform Service");
    }

    @Override
    public void setFQSN() {
    }

    @Override
    public String getAsadminPath() {
        return this.asadminPath;
    }

    @Override
    public void setAsadminPath(String path) {
        this.asadminPath = path;
    }

    @Override
    public String getPasswordFilePath() {
        return this.passwordFilePath;
    }

    @Override
    public void setPasswordFilePath(String path) {
        this.setAsadminCredentials(path);
    }

    @Override
    public int getTimeoutSeconds() {
        throw new UnsupportedOperationException("getTimeoutSeconds() is not supported on this platform");
    }

    @Override
    public void setTimeoutSeconds(int number) {
        throw new UnsupportedOperationException("setTimeoutSeconds() is not supported on this platform");
    }

    @Override
    public String getOSUser() {
        return this.user;
    }

    @Override
    public void setOSUser() {
    }

    @Override
    public String getServiceProperties() {
        return this.flattenedServicePropertes;
    }

    @Override
    public void setServiceProperties(String cds) {
        this.flattenedServicePropertes = cds;
    }

    @Override
    public Map<String, String> tokensAndValues() {
        return PropertiesDecoder.unflatten((String)this.flattenedServicePropertes);
    }

    @Override
    public String getManifestFilePath() {
        UnsupportedOperationException ex = new UnsupportedOperationException("getManifestFilePath() is not supported in this platform.");
        ex.printStackTrace();
        throw ex;
    }

    @Override
    public String getManifestFileTemplatePath() {
        throw new UnsupportedOperationException("getManifestFileTemplatePath() is not supported in this platform.");
    }

    @Override
    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Override
    public boolean isTrace() {
        return this.trace;
    }

    @Override
    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }

    final String getAppserverUser() {
        return this.appserverUser;
    }

    private void setAsadminCredentials(String path) {
        this.appserverUser = null;
        this.passwordFilePath = null;
        if (!ServiceAdapter.ok(path)) {
            return;
        }
        File f = SmartFile.sanitize((File)new File(path));
        if (!f.isFile()) {
            throw new IllegalArgumentException(Strings.get("windows.services.passwordFileNotA", f));
        }
        if (!f.canRead()) {
            throw new IllegalArgumentException(Strings.get("windows.services.passwordFileNotReadable", f));
        }
        Properties p = this.getProperties(f);
        this.appserverUser = p.getProperty("AS_ADMIN_USER");
        if (!ServiceAdapter.ok(this.appserverUser)) {
            this.appserverUser = null;
        }
        this.passwordFilePath = f.getPath().replace('\\', '/');
    }

    private String validateProperty(File f, Properties p, String key) {
        String value = (String)p.get(key);
        if (!ServiceAdapter.ok(value)) {
            throw new IllegalArgumentException(Strings.get("missingParamsInFile", f, key));
        }
        return value;
    }

    private Properties getProperties(File f) {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(f));
            Properties p = new Properties();
            p.load(bis);
            Properties properties = p;
            return properties;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception ee) {}
            }
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

