/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.listener.PoolLifeCycleListener;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.resource.pool.ResourcePool;
import java.util.ArrayList;
import java.util.List;

public class PoolLifeCycleListenerRegistry
implements PoolLifeCycleListener {
    protected List<PoolLifeCycleListener> poolListenersList;
    private String poolName;

    public PoolLifeCycleListenerRegistry(String poolName) {
        this.poolName = poolName;
        this.poolListenersList = new ArrayList<PoolLifeCycleListener>();
    }

    public void registerPoolLifeCycleListener(PoolLifeCycleListener listener) {
        this.poolListenersList.add(listener);
        if (this.poolListenersList.size() <= 1) {
            PoolManager poolMgr = ConnectorRuntime.getRuntime().getPoolManager();
            ResourcePool pool = poolMgr.getPool(this.poolName);
            pool.setPoolLifeCycleListener(this);
        }
    }

    public void unRegisterPoolLifeCycleListener(String poolName) {
        if (this.poolName.equals(poolName) && this.poolListenersList != null && !this.poolListenersList.isEmpty()) {
            this.poolListenersList.clear();
        }
    }

    public void toString(StringBuffer stackTrace) {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.toString(stackTrace);
        }
    }

    public void connectionAcquired() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionAcquired();
        }
    }

    public void connectionRequestServed(long timeTakenInMillis) {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionRequestServed(timeTakenInMillis);
        }
    }

    public void connectionTimedOut() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionTimedOut();
        }
    }

    public void connectionNotMatched() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionNotMatched();
        }
    }

    public void connectionMatched() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionMatched();
        }
    }

    public void connectionUsed() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionUsed();
        }
    }

    public void connectionDestroyed() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionDestroyed();
        }
    }

    public void connectionReleased() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionReleased();
        }
    }

    public void connectionCreated() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionCreated();
        }
    }

    public void foundPotentialConnectionLeak() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.foundPotentialConnectionLeak();
        }
    }

    public void connectionValidationFailed(int count) {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionValidationFailed(count);
        }
    }

    public void connectionsFreed(int count) {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionsFreed(count);
        }
    }

    public void decrementConnectionUsed() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.decrementConnectionUsed();
        }
    }

    public void decrementNumConnFree() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.decrementNumConnFree();
        }
    }

    public void incrementNumConnFree(boolean beingDestroyed, int steadyPoolSize) {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.incrementNumConnFree(beingDestroyed, steadyPoolSize);
        }
    }

    public void connectionRequestQueued() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionRequestQueued();
        }
    }

    public void connectionRequestDequeued() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionRequestDequeued();
        }
    }
}

