/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.JavaClassRunner;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.api.Async;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service(name="restart-domain")
@Async
@I18n(value="restart.domain.command")
public class RestartDomainCommand
implements AdminCommand {
    @Inject
    ModulesRegistry registry;
    private Properties props;
    private Logger logger;
    private boolean verbose;
    private String classpath;
    private String classname;
    private String argsString;
    private String[] args;
    private static final String magicProperty = "-DAS_RESTART=true";
    private static final String[] normalProps = new String[]{"-DAS_RESTART=true"};
    private static final LocalStringsImpl strings = new LocalStringsImpl(RestartDomainCommand.class);
    private static final boolean debug = Boolean.parseBoolean(System.getenv("AS_DEBUG"));
    private static final String[] debuggerProps = new String[]{"-DAS_RESTART=true", "-Xdebug", "-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=1323"};

    public RestartDomainCommand() {
    }

    public RestartDomainCommand(ModulesRegistry registryIn) {
        this.registry = registryIn;
    }

    public void execute(AdminCommandContext context) {
        try {
            Collection<Module> modules;
            this.init(context);
            if (!this.verbose) {
                this.reincarnate();
            }
            if ((modules = this.registry.getModules("com.sun.enterprise.osgi-adapter")).size() == 1) {
                Module mgmtAgentModule = modules.iterator().next();
                mgmtAgentModule.stop();
            } else {
                context.getLogger().warning(modules.size() + " no of primordial modules found");
            }
        }
        catch (Exception e) {
            context.getLogger().severe("Got an exception trying to restart: " + e);
        }
        System.exit(10);
    }

    private void init(AdminCommandContext context) throws IOException {
        this.logger = context.getLogger();
        String s = System.getProperty("hk2.startup.context.args");
        StringReader reader = new StringReader(s);
        this.props = new Properties();
        this.props.load(reader);
        this.verbose = Boolean.parseBoolean(this.props.getProperty("-verbose", "false"));
        this.logger.info(strings.get("restart.domain.init"));
    }

    private void reincarnate() {
        try {
            if (this.setupReincarnationWithAsadmin() || this.setupReincarnationWithOther()) {
                this.doReincarnation();
            } else {
                this.logger.severe(strings.get("restart.domain.noStartupInfo", new Object[]{strings.get("restart.domain.asadminError"), strings.get("restart.domain.nonAsadminError")}));
            }
        }
        catch (RDCException rdce) {
        }
        catch (Exception e) {
            this.logger.severe(strings.get("restart.domain.internalError", new Object[]{e}));
        }
    }

    private void doReincarnation() throws RDCException {
        try {
            String[] props = normalProps;
            if (Boolean.parseBoolean(System.getenv("AS_SUPER_DEBUG"))) {
                props = debuggerProps;
            }
            new JavaClassRunner(this.classpath, props, this.classname, this.args);
        }
        catch (Exception e) {
            this.logger.severe(strings.get("restart.domain.jvmError", new Object[]{e}));
            throw new RDCException();
        }
    }

    private boolean setupReincarnationWithAsadmin() throws RDCException {
        this.classpath = this.props.getProperty("-asadmin-classpath");
        this.classname = this.props.getProperty("-asadmin-classname");
        this.argsString = this.props.getProperty("-asadmin-args");
        return this.verify("restart.domain.asadminError");
    }

    private boolean setupReincarnationWithOther() throws RDCException {
        this.classpath = this.props.getProperty("-startup-classpath");
        this.classname = this.props.getProperty("-startup-classname");
        this.argsString = this.props.getProperty("-startup-args");
        return this.verify("restart.domain.nonAsadminError");
    }

    private boolean verify(String errorStringKey) throws RDCException {
        if (this.classpath == null && this.classname == null && this.argsString == null) {
            return false;
        }
        if (!this.ok(this.classpath) || !this.ok(this.classname) || this.argsString == null) {
            this.logger.severe(strings.get(errorStringKey));
            throw new RDCException();
        }
        this.args = this.argsString.split(",,,");
        return true;
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private static class RDCException
    extends Exception {
        private RDCException() {
        }
    }
}

