/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OptionsMap {
    private Map<String, Value> optionsMap = new HashMap<String, Value>();

    public String getOption(String name) {
        if (!this.optionsMap.containsKey(name)) {
            return null;
        }
        return this.optionsMap.get(name).getValue();
    }

    public Map<String, String> getOptions() {
        HashMap<String, String> tempOptions = new HashMap<String, String>();
        for (String optionKey : this.optionsMap.keySet()) {
            tempOptions.put(optionKey, this.optionsMap.get(optionKey).getValue());
        }
        return tempOptions;
    }

    public Map<String, String> getCLOptions() {
        return this.getOptions(OptionValueFrom.CommandLine);
    }

    public Map<String, String> getEnvOptions() {
        return this.getOptions(OptionValueFrom.Environment);
    }

    public Map<String, String> getDefaultOptions() {
        return this.getOptions(OptionValueFrom.Default);
    }

    public Map<String, String> getOtherOptions() {
        return this.getOptions(OptionValueFrom.Other);
    }

    private Map<String, String> getOptions(OptionValueFrom ovf) {
        HashMap<String, String> tempOptions = new HashMap<String, String>();
        for (String optionKey : this.optionsMap.keySet()) {
            if (this.optionsMap.get(optionKey).getOptionValueFrom() != ovf) continue;
            tempOptions.put(optionKey, this.optionsMap.get(optionKey).getValue());
        }
        return tempOptions;
    }

    public void addOptionValue(String name, String value, OptionValueFrom ovf) {
        this.optionsMap.put(name, new Value(value, ovf));
    }

    public void addOptionValue(String name, String value) {
        this.optionsMap.put(name, new Value(value, OptionValueFrom.Other));
    }

    public void addCLValue(String name, String value) {
        this.optionsMap.put(name, new Value(value, OptionValueFrom.CommandLine));
    }

    public void addEnvValue(String name, String value) {
        this.optionsMap.put(name, new Value(value, OptionValueFrom.Environment));
    }

    public void addDefaultValue(String name, String value) {
        this.optionsMap.put(name, new Value(value, OptionValueFrom.Default));
    }

    public void addPrefValue(String name, String value) {
        this.optionsMap.put(name, new Value(value, OptionValueFrom.PrefFile));
    }

    public boolean containsName(String name) {
        return this.optionsMap.containsKey(name);
    }

    public Set<String> nameSet() {
        return this.optionsMap.keySet();
    }

    public void remove(String name) {
        this.optionsMap.remove(name);
    }

    public String toString() {
        Iterator<String> optionNames = this.optionsMap.keySet().iterator();
        StringBuffer strbuf = new StringBuffer();
        while (optionNames.hasNext()) {
            String optionKey = optionNames.next();
            strbuf.append("<" + optionKey + "," + this.optionsMap.get(optionKey).getValue() + ">");
            strbuf.append("\n");
        }
        return strbuf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionValueFrom {
        CommandLine,
        Environment,
        Default,
        PrefFile,
        Other;

    }

    private static class Value {
        private String value;
        private OptionValueFrom ovf;

        Value(String value, OptionValueFrom ovf) {
            this.value = value;
            this.ovf = ovf;
        }

        String getValue() {
            return this.value;
        }

        public OptionValueFrom getOptionValueFrom() {
            return this.ovf;
        }
    }
}

