/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.net;

import com.sun.messaging.jmq.util.Bits;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;

public class IPAddress
implements Cloneable,
Serializable {
    public static final int IPV4_SIZE = 4;
    public static final int IPV6_SIZE = 16;
    public static final int UNKNOWN = 0;
    public static final int IPV4 = 1;
    public static final int IPV6 = 2;
    public static final int IPV4MAC = 3;
    protected int type = 0;
    private static byte[] prefix = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
    private static byte[] IPv4MacPrefix = new byte[]{-1, 0, 0, 0};
    private static byte[] nullAddr = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0};
    protected byte[] ip = new byte[16];

    public IPAddress() {
        this.clear();
    }

    public void clear() {
        System.arraycopy(nullAddr, 0, this.ip, 0, nullAddr.length);
        this.type = 1;
    }

    public int getType() {
        if (this.type == 0) {
            this.type = IPAddress.isIPv4Mapped(this.ip) ? 1 : (IPAddress.isIPv4Mac(this.ip) ? 3 : 2);
        }
        return this.type;
    }

    public Object clone() {
        IPAddress iPAddress = null;
        try {
            iPAddress = (IPAddress)super.clone();
            iPAddress.ip = (byte[])this.ip.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("IPAddress: Could not clone: " + cloneNotSupportedException);
        }
        return iPAddress;
    }

    public boolean equals(Object object) {
        if (object instanceof IPAddress) {
            return IPAddress.isEqual(this.ip, ((IPAddress)object).ip);
        }
        return false;
    }

    public int hashCode() {
        if (this.ip == null) {
            return 0;
        }
        return this.ip.hashCode();
    }

    public static boolean isNull(byte[] byArray) {
        return byArray == null || IPAddress.isEqual(byArray, nullAddr);
    }

    private static boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length == byArray2.length) {
            for (int i = byArray.length - 1; i >= 0; --i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public byte[] getAddress() {
        return (byte[])this.ip.clone();
    }

    public byte[] getAddressUnsafe() {
        return this.ip;
    }

    public byte[] getIPv4Address() throws IllegalArgumentException {
        if (this.getType() != 1 && this.getType() != 3) {
            throw new IllegalArgumentException("Address is not an IPv4 or IPv4-mapped IPv6 address");
        }
        byte[] byArray = new byte[4];
        System.arraycopy(this.ip, prefix.length, byArray, 0, byArray.length);
        return byArray;
    }

    public void setMac(byte[] byArray) {
        if (this.getType() != 1 && this.getType() != 3) {
            throw new IllegalArgumentException("Address is not an IPv4 or IPv4-mapped IPv6 address");
        }
        if (byArray.length != 6) {
            throw new IllegalArgumentException("Invalid mac length: " + byArray.length);
        }
        this.ip[0] = -1;
        for (int i = 0; i < byArray.length; ++i) {
            this.ip[i + 4] = byArray[i];
        }
        this.type = 3;
    }

    public byte[] getMac() {
        if (this.getType() != 3) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[6];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.ip[i + 4];
        }
        return byArray;
    }

    public int getIPv4AddressAsInt() throws IllegalArgumentException {
        if (this.getType() != 1 && this.getType() != 3) {
            throw new IllegalArgumentException("Address is not an IPv4 or IPv4-mapped IPv6 address");
        }
        int n = this.ip[15] & 0xFF;
        n |= this.ip[14] << 8 & 0xFF00;
        n |= this.ip[13] << 16 & 0xFF0000;
        return n |= this.ip[12] << 24 & 0xFF000000;
    }

    public void setAddress(byte[] byArray) throws IllegalArgumentException {
        this.type = 0;
        if (byArray == null) {
            this.clear();
        } else if (byArray.length == 4) {
            System.arraycopy(prefix, 0, this.ip, 0, prefix.length);
            System.arraycopy(byArray, 0, this.ip, prefix.length, byArray.length);
            this.type = 1;
        } else if (byArray.length == 16) {
            System.arraycopy(byArray, 0, this.ip, 0, byArray.length);
            this.type = 2;
        } else {
            throw new IllegalArgumentException("Bad IP address length: " + byArray.length + ". Should be " + 4 + " or " + 16 + " bytes");
        }
    }

    public void writeAddress(DataOutput dataOutput) throws IOException {
        dataOutput.write(this.ip);
    }

    public void readAddress(DataInput dataInput) throws IOException {
        this.type = 0;
        dataInput.readFully(this.ip);
    }

    public static boolean isIPv4Mapped(byte[] byArray) {
        if (byArray.length == 16) {
            for (int i = 0; i < prefix.length; ++i) {
                if (byArray[i] == prefix[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isIPv4Mac(byte[] byArray) {
        if (byArray.length == 16) {
            for (int i = 0; i < IPv4MacPrefix.length; ++i) {
                if (byArray[i] == IPv4MacPrefix[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return IPAddress.rawIPToString(this.ip, true, false);
    }

    public static String rawIPToString(byte[] byArray) {
        return IPAddress.rawIPToString(byArray, true, false);
    }

    public static String rawIPToString(byte[] byArray, boolean bl) {
        return IPAddress.rawIPToString(byArray, bl, false);
    }

    public static IPAddress readFromString(String string) {
        String[] stringArray;
        Object object;
        int n = string.indexOf("(");
        String string2 = null;
        byte[] byArray = null;
        if (n != -1) {
            object = string.substring(0, n);
            string2 = string.substring(n + 1, string.length() - 1);
            stringArray = ((String)object).split("\\.");
            byArray = new byte[4];
            for (int i = 0; i < 4; ++i) {
                byArray[i] = Integer.valueOf(stringArray[i]).byteValue();
            }
        } else {
            n = string.indexOf(":");
            if (n != -1) {
                object = string.split(":");
                byArray = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    byArray[i] = Byte.parseByte(object[i]);
                }
            } else {
                object = string.split("\\.");
                byArray = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    byArray[i] = Integer.valueOf(object[i]).byteValue();
                }
            }
        }
        object = new IPAddress();
        ((IPAddress)object).setAddress(byArray);
        if (string2 != null) {
            stringArray = string2.split("\\:");
            byte[] byArray2 = new byte[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                byArray2[i] = Integer.valueOf(stringArray[i].toUpperCase(), 16).byteValue();
            }
            ((IPAddress)object).setMac(byArray2);
        }
        return object;
    }

    public static String rawIPToString(byte[] byArray, boolean bl, boolean bl2) {
        String string = ".";
        String string2 = ":";
        String string3 = "-";
        String string4 = "(";
        String string5 = ")";
        if (!bl) {
            string = "";
            string2 = "";
            string3 = "";
            string4 = "";
            string5 = "";
        }
        if (byArray == null) {
            return "0.0.0.0";
        }
        if (byArray.length == 4) {
            return (byArray[0] & 0xFF) + string + (byArray[1] & 0xFF) + string + (byArray[2] & 0xFF) + string + (byArray[3] & 0xFF);
        }
        if (IPAddress.isIPv4Mapped(byArray) || bl2 && IPAddress.isIPv4Mac(byArray)) {
            return (byArray[12] & 0xFF) + string + (byArray[13] & 0xFF) + string + (byArray[14] & 0xFF) + string + (byArray[15] & 0xFF);
        }
        if (IPAddress.isIPv4Mac(byArray)) {
            return (byArray[12] & 0xFF) + string + (byArray[13] & 0xFF) + string + (byArray[14] & 0xFF) + string + (byArray[15] & 0xFF) + string4 + Integer.toHexString(byArray[4] & 0xFF) + string2 + Integer.toHexString(byArray[5] & 0xFF) + string2 + Integer.toHexString(byArray[6] & 0xFF) + string2 + Integer.toHexString(byArray[7] & 0xFF) + string2 + Integer.toHexString(byArray[8] & 0xFF) + string2 + Integer.toHexString(byArray[9] & 0xFF) + string5;
        }
        if (byArray.length == 16) {
            return Bits.toHexString(byArray, bl);
        }
        return null;
    }

    public static byte[] getRandomMac() {
        byte[] byArray = Bits.randomBits(6);
        byArray[0] = (byte)(byArray[0] | 0xFFFFFF80);
        return byArray;
    }

    public static void main(String[] stringArray) {
        System.out.println(Bits.toHexString(IPAddress.getRandomMac(), true));
        System.out.println(Bits.toHexString(IPAddress.getRandomMac(), true));
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        IPAddress iPAddress = new IPAddress();
        iPAddress.setAddress(inetAddress.getAddress());
        System.out.println("IPv4: " + iPAddress);
        iPAddress.setMac(IPAddress.getRandomMac());
        System.out.println("IPv4Mac: " + iPAddress);
    }
}

