/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.Hashtable;

public class PurgeDurableHandler
extends AdminCmdHandler {
    private static boolean DEBUG = PurgeDurableHandler.getDEBUG();

    public PurgeDurableHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        Subscription subscription;
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "PurgeDurable: " + hashtable);
        }
        String string = (String)hashtable.get("JMQDurableName");
        String string2 = (String)hashtable.get("JMQClientID");
        int n = 200;
        String string3 = null;
        HAMonitorService hAMonitorService = Globals.getHAMonitorService();
        if (hAMonitorService != null && hAMonitorService.inTakeover()) {
            n = 500;
            string3 = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + string3);
        } else {
            try {
                subscription = Subscription.findDurableSubscription(string2, string);
                if (subscription == null) {
                    string3 = " unknown durable subscription " + string + ":" + string2;
                    n = 500;
                } else {
                    subscription.purge();
                }
            }
            catch (BrokerException brokerException) {
                brokerException.printStackTrace();
                string3 = PurgeDurableHandler.getMessageFromException(brokerException);
                n = 500;
            }
        }
        subscription = new Packet(iMQConnection.useDirectBuffers());
        subscription.setPacketType(5);
        PurgeDurableHandler.setProperties((Packet)subscription, 67, n, string3);
        this.parent.sendReply(iMQConnection, packet, (Packet)subscription);
        return true;
    }
}

