/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.PHashMap;
import com.sun.messaging.jmq.util.PHashMapLoadException;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

class DestinationList {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    protected BrokerConfig config = Globals.getConfig();
    static final String DEST_FILE_SIZE_PROP = "imq.persist.file.destination.file.size";
    static final long DEFAULT_DEST_FILE_SIZE = 1024L;
    static final String BASENAME = "destination";
    private PHashMap dstMap = null;
    private File backingFile = null;
    private FileStore parent = null;
    private LoadException loadException = null;

    DestinationList(FileStore fileStore, File file, boolean bl) throws BrokerException {
        Object object;
        this.parent = fileStore;
        SizeString sizeString = this.config.getSizeProperty(DEST_FILE_SIZE_PROP, 1024L);
        if (bl && Store.getDEBUG()) {
            this.logger.log(1, "DestinationList initialized with clear option");
        }
        this.backingFile = new File(file, BASENAME);
        try {
            this.dstMap = new PHashMap(this.backingFile, sizeString.getBytes(), false, bl);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4031", (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4031"), iOException);
        }
        try {
            this.dstMap.load();
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4031", (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4031"), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(32, "B4031", (Throwable)classNotFoundException);
            throw new BrokerException(this.br.getString("B4031"), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            while (object != null) {
                this.logger.log(16, "B4194", (Throwable)object);
                LoadException loadException = new LoadException(object.getMessage(), object.getCause());
                loadException.setKey(object.getKey());
                loadException.setValue(object.getValue());
                loadException.setKeyCause(object.getKeyCause());
                loadException.setValueCause(object.getValueCause());
                loadException.setNextException(this.loadException);
                this.loadException = loadException;
                object = object.getNextException();
            }
        }
        object = this.dstMap.getWarning();
        if (object != null) {
            this.logger.log(16, "possible loss of destination data", (Throwable)object);
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "DestinationList: loaded " + this.dstMap.size() + " destinations");
        }
    }

    LoadException getLoadException() {
        return this.loadException;
    }

    DestinationList(FileStore fileStore, File file, File file2) throws BrokerException {
        Object object;
        Object object2;
        this.parent = fileStore;
        File file3 = new File(file2, BASENAME);
        PHashMap pHashMap = null;
        this.backingFile = new File(file, BASENAME);
        try {
            pHashMap = new PHashMap(file3, false, false);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4158", (Object)file3, (Object)this.backingFile, (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4158", file3, this.backingFile), iOException);
        }
        try {
            pHashMap.load();
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4158", (Object)file3, (Object)this.backingFile, (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4158", file3, this.backingFile), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(32, "B4158", (Object)file3, (Object)this.backingFile, (Throwable)classNotFoundException);
            throw new BrokerException(this.br.getString("B4158", file3, this.backingFile), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            while (object2 != null) {
                this.logger.log(16, "B4199", (Throwable)object2);
                object = new LoadException(object2.getMessage(), object2.getCause());
                ((LoadException)object).setKey(object2.getKey());
                ((LoadException)object).setValue(object2.getValue());
                ((LoadException)object).setKeyCause(object2.getKeyCause());
                ((LoadException)object).setValueCause(object2.getValueCause());
                ((LoadException)object).setNextException(this.loadException);
                this.loadException = object;
                object2 = object2.getNextException();
            }
        }
        object2 = pHashMap.getWarning();
        if (object2 != null) {
            this.logger.log(16, "possible loss of destination data in old store", (Throwable)object2);
        }
        try {
            this.dstMap = new PHashMap(this.backingFile, file3.length(), false, false);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4158", (Object)file3, (Object)this.backingFile, (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4158", file3, this.backingFile), iOException);
        }
        try {
            this.dstMap.load();
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4158", (Object)file3, (Object)this.backingFile, (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4158", file3, this.backingFile), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(32, "B4158", (Object)file3, (Object)this.backingFile, (Throwable)classNotFoundException);
            throw new BrokerException(this.br.getString("B4158", file3, this.backingFile), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            this.logger.log(32, "B4158", (Object)file3, (Object)this.backingFile, (Throwable)pHashMapLoadException);
            throw new BrokerException(this.br.getString("B4158", file3, this.backingFile), pHashMapLoadException);
        }
        object2 = this.dstMap.getWarning();
        if (object2 != null) {
            this.logger.log(16, "possible loss of destination data", (Throwable)object2);
        }
        object = pHashMap.values().iterator();
        Destination destination = null;
        while (object.hasNext()) {
            destination = (Destination)object.next();
            this.dstMap.put((Object)destination.getDestinationUID().toString(), (Object)destination);
        }
        pHashMap.close();
        if (Store.getDEBUG()) {
            this.logger.log(4, "DestinationList: upgraded " + this.dstMap.size() + " destinations");
        }
        if (this.parent.upgradeNoBackup() && !file3.delete()) {
            this.logger.log(32, "B1044", (Object)file3);
        }
    }

    void syncDestination(Destination destination) throws BrokerException {
        String string;
        String string2 = string = destination != null ? destination.getDestinationUID().toString() : null;
        if (string != null) {
            this.checkDestination(string);
        }
        try {
            if (Store.getDEBUG_SYNC()) {
                String string3 = "DestinationList sync() " + string;
                this.logger.log(4, string3);
            }
            this.dstMap.force((Object)string);
        }
        catch (IOException iOException) {
            throw new BrokerException("Failed to synchronize file: " + this.backingFile, iOException);
        }
    }

    void storeDestination(Destination destination, boolean bl) throws IOException, BrokerException {
        String string = destination.getDestinationUID().toString();
        try {
            Object object = this.dstMap.putIfAbsent((Object)string, (Object)destination);
            if (object != null) {
                this.logger.log(32, "B3012", (Object)destination.getName());
                throw new BrokerException(this.br.getString("B3012", destination.getName()));
            }
            if (bl) {
                this.sync();
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4014", (Object)destination.getName());
            throw new BrokerException(this.br.getString("B4014", destination.getName()), runtimeException);
        }
    }

    void updateDestination(Destination destination, boolean bl) throws BrokerException {
        String string = destination.getDestinationUID().toString();
        this.checkDestination(string);
        try {
            this.dstMap.put((Object)string, (Object)destination);
            if (bl) {
                this.sync();
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4014", (Object)string);
            throw new BrokerException(this.br.getString("B4014", string), runtimeException);
        }
    }

    void removeDestination(Destination destination, boolean bl) throws BrokerException {
        String string = destination.getDestinationUID().toString();
        try {
            Object object = this.dstMap.remove((Object)string);
            if (object == null) {
                this.logger.log(32, "B3013", (Object)destination.getName());
                throw new BrokerException(this.br.getString("B3013", destination.getName()));
            }
            if (bl) {
                this.sync();
            }
            this.parent.getMsgStore().releaseMessageDir(destination.getDestinationUID(), bl);
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4144", (Object)destination.getName(), (Throwable)runtimeException);
            throw new BrokerException(this.br.getString("B4144", destination.getName()), runtimeException);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4144", (Object)string, (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4144", string), iOException);
        }
    }

    Destination getDestination(DestinationUID destinationUID) throws IOException {
        return (Destination)this.dstMap.get((Object)destinationUID.toString());
    }

    Destination[] getAllDestinations() throws IOException {
        return this.dstMap.values().toArray(new Destination[0]);
    }

    Collection getDestinations() {
        return this.dstMap.values();
    }

    void clearAll(boolean bl, boolean bl2) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "DestinationList.clearAll(" + bl2 + ") called");
        }
        if (bl2) {
            for (Destination destination : this.dstMap.values()) {
                DestinationUID destinationUID = destination.getDestinationUID();
                try {
                    this.parent.getMsgStore().releaseMessageDir(destinationUID, bl);
                }
                catch (IOException iOException) {
                    this.logger.log(32, "B4146", (Object)this.parent.getMsgStore().getDirName(destinationUID), (Object)destinationUID, (Throwable)iOException);
                }
                catch (BrokerException brokerException) {
                    this.logger.log(32, "B4146", (Object)this.parent.getMsgStore().getDirName(destinationUID), (Object)destinationUID, (Throwable)brokerException);
                }
            }
        }
        this.dstMap.clear();
        if (bl) {
            try {
                this.sync();
            }
            catch (BrokerException brokerException) {
                this.logger.log(32, "Got exception while synchronizing data to disk", (Throwable)brokerException);
            }
        }
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Destinations", String.valueOf(this.dstMap.size()));
        return hashtable;
    }

    void close(boolean bl) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "DestinationList: closing, " + this.dstMap.size() + " persisted destinations");
        }
        this.dstMap.close();
    }

    public void dumpDestination() {
        Iterator iterator = this.dstMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            System.out.println("dst " + n++ + ":" + iterator.next());
        }
    }

    void checkDestination(String string) throws BrokerException {
        if (!this.dstMap.containsKey((Object)string)) {
            this.logger.log(32, "B3013", (Object)string);
            throw new BrokerException(this.br.getString("B3013", string));
        }
    }

    private void sync() throws BrokerException {
        try {
            if (Store.getDEBUG_SYNC()) {
                String string = "DestinationList sync() all";
                this.logger.log(4, string);
            }
            this.dstMap.force();
        }
        catch (IOException iOException) {
            throw new BrokerException("Failed to synchronize file: " + this.backingFile, iOException);
        }
    }
}

