/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry;

import java.util.HashMap;

public class MonitoredObjectType {
    private static final HashMap objectMap = new HashMap();
    public static final MonitoredObjectType NONE = new MonitoredObjectType("none", true);
    public static final MonitoredObjectType ROOT = new MonitoredObjectType("root", true);
    public static final MonitoredObjectType APPLICATIONS = new MonitoredObjectType("applications", true);
    public static final MonitoredObjectType APPLICATION = new MonitoredObjectType("application");
    public static final MonitoredObjectType EJBMODULE = new MonitoredObjectType("ejb-module");
    public static final MonitoredObjectType WEBMODULE = new MonitoredObjectType("web-module");
    public static final MonitoredObjectType STANDALONE_EJBMODULE = new MonitoredObjectType("standalone-ejb-module");
    public static final MonitoredObjectType STANDALONE_WEBMODULE = new MonitoredObjectType("standalone-web-module");
    public static final MonitoredObjectType STATELESS_BEAN = new MonitoredObjectType("stateless-session-bean");
    public static final MonitoredObjectType STATEFUL_BEAN = new MonitoredObjectType("stateful-session-bean");
    public static final MonitoredObjectType ENTITY_BEAN = new MonitoredObjectType("entity-bean");
    public static final MonitoredObjectType MESSAGE_DRIVEN_BEAN = new MonitoredObjectType("message-driven-bean");
    public static final MonitoredObjectType BEAN_POOL = new MonitoredObjectType("bean-pool", true);
    public static final MonitoredObjectType BEAN_CACHE = new MonitoredObjectType("bean-cache", true);
    public static final MonitoredObjectType BEAN_METHOD = new MonitoredObjectType("bean-method");
    public static final MonitoredObjectType BEAN_METHODS = new MonitoredObjectType("bean-methods", true);
    public static final MonitoredObjectType SERVLET = new MonitoredObjectType("servlet");
    public static final MonitoredObjectType HTTP_SERVICE = new MonitoredObjectType("http-service", true);
    public static final MonitoredObjectType VIRTUAL_SERVER = new MonitoredObjectType("virtual-server");
    public static final MonitoredObjectType WEBAPP_VIRTUAL_SERVER = new MonitoredObjectType("webmodule-virtual-server");
    public static final MonitoredObjectType HTTP_LISTENER = new MonitoredObjectType("http-listener");
    public static final MonitoredObjectType JVM = new MonitoredObjectType("jvm", true);
    public static final MonitoredObjectType TRANSACTION_SERVICE = new MonitoredObjectType("transaction-service", true);
    public static final MonitoredObjectType THREAD_POOLS = new MonitoredObjectType("thread-pools", true);
    public static final MonitoredObjectType THREAD_POOL = new MonitoredObjectType("thread-pool");
    public static final MonitoredObjectType ORB = new MonitoredObjectType("orb", true);
    public static final MonitoredObjectType CONNECTION_MANAGERS = new MonitoredObjectType("connection-managers", true);
    public static final MonitoredObjectType CONNECTION_MANAGER = new MonitoredObjectType("connection-manager", true);
    public static final MonitoredObjectType RESOURCES = new MonitoredObjectType("resources", true);
    public static final MonitoredObjectType JDBC_CONN_POOL = new MonitoredObjectType("jdbc-connection-pool");
    public static final MonitoredObjectType CONNECTOR_CONN_POOL = new MonitoredObjectType("connector-connection-pool");
    public static final MonitoredObjectType WEB_COMPONENT = new MonitoredObjectType("web-component");
    public static final MonitoredObjectType JNDI = new MonitoredObjectType("jndi", true);
    public static final MonitoredObjectType CONNECTOR_SERVICE = new MonitoredObjectType("connector-service", true);
    public static final MonitoredObjectType CONNECTOR_MODULE = new MonitoredObjectType("connector-module");
    public static final MonitoredObjectType STANDALONE_CONNECTOR_MODULE = new MonitoredObjectType("standalone-connector-module");
    public static final MonitoredObjectType CONNECTOR_WORKMGMT = new MonitoredObjectType("work-management", true);
    public static final MonitoredObjectType JMS_SERVICE = new MonitoredObjectType("jms-service", true);
    public static final MonitoredObjectType CONNECTION_FACTORIES = new MonitoredObjectType("connection-factories", true);
    public static final MonitoredObjectType CONNECTION_FACTORY = new MonitoredObjectType("connection-factory");
    public static final MonitoredObjectType CONNECTION_POOLS = new MonitoredObjectType("connection-pools", true);
    public static final MonitoredObjectType CONNECTION_QUEUE = new MonitoredObjectType("connection-queue", true);
    public static final MonitoredObjectType DNS = new MonitoredObjectType("dns", true);
    public static final MonitoredObjectType KEEP_ALIVE = new MonitoredObjectType("keep-alive", true);
    public static final MonitoredObjectType PWC_THREAD_POOL = new MonitoredObjectType("pwc-thread-pool", true);
    public static final MonitoredObjectType FILE_CACHE = new MonitoredObjectType("file-cache", true);
    public static final MonitoredObjectType REQUEST = new MonitoredObjectType("request", true);
    public static final MonitoredObjectType SESSION_STORE = new MonitoredObjectType("stateful-session-store", true);
    public static final MonitoredObjectType TIMERS = new MonitoredObjectType("timers", true);
    public static final MonitoredObjectType JVM_COMPILATION = new MonitoredObjectType("compilation-system", true);
    public static final MonitoredObjectType JVM_CLASSLOADING = new MonitoredObjectType("class-loading-system", true);
    public static final MonitoredObjectType JVM_OS = new MonitoredObjectType("operating-system", true);
    public static final MonitoredObjectType JVM_RUNTIME = new MonitoredObjectType("runtime", true);
    public static final MonitoredObjectType JVM_GCS = new MonitoredObjectType("garbage-collectors", true);
    public static final MonitoredObjectType JVM_GC = new MonitoredObjectType("garbage-collector");
    public static final MonitoredObjectType JVM_MEMORY = new MonitoredObjectType("memory", true);
    public static final MonitoredObjectType JVM_THREAD = new MonitoredObjectType("thread-system", true);
    public static final MonitoredObjectType JVM_THREAD_INFO = new MonitoredObjectType("threadinfo");
    public static final MonitoredObjectType WEBSERVICE_ENDPOINT = new MonitoredObjectType("webservice-endpoint");
    private String typeName;
    private boolean isSingleton;
    public static final MonitoredObjectType[] EJB_TYPES = new MonitoredObjectType[]{EJBMODULE, STANDALONE_EJBMODULE, STATELESS_BEAN, STATEFUL_BEAN, ENTITY_BEAN, BEAN_POOL, BEAN_CACHE, BEAN_METHOD, SESSION_STORE, TIMERS};
    public static final MonitoredObjectType[] ORB_TYPES = new MonitoredObjectType[]{ORB, CONNECTION_MANAGER, CONNECTION_MANAGERS};
    public static final MonitoredObjectType[] HTTP_SERVICE_TYPES = new MonitoredObjectType[]{HTTP_SERVICE, HTTP_LISTENER, VIRTUAL_SERVER};

    private MonitoredObjectType(String type) {
        this(type, false);
    }

    private MonitoredObjectType(String type, boolean isSingleton) {
        this.typeName = type;
        this.isSingleton = isSingleton;
        objectMap.put(this.typeName, this);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public String toString() {
        return this.typeName;
    }

    public static MonitoredObjectType getMonitoredObjectType(String typeName) {
        MonitoredObjectType type = MonitoredObjectType.getMonitoredObjectTypeOrNull(typeName);
        if (type == null) {
            String msg = "admin.monitor.unknown_type_name:" + typeName;
            throw new IllegalArgumentException(msg);
        }
        return type;
    }

    static MonitoredObjectType getMonitoredObjectTypeOrNull(String typeName) {
        MonitoredObjectType type = null;
        if (objectMap != null && typeName != null) {
            type = (MonitoredObjectType)objectMap.get(typeName);
        }
        return type;
    }
}

