/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import java.util.Arrays;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.PrettyPrinter;
import org.codehaus.jackson.impl.Indenter;

public class DefaultPrettyPrinter
implements PrettyPrinter {
    protected Indenter mArrayIndenter = new FixedSpaceIndenter();
    protected Indenter mObjectIndenter = new Lf2SpacesIndenter();
    protected boolean mSpacesInObjectEntries = true;
    protected int mNesting = 0;

    public void indentArraysWith(Indenter indenter) {
        this.mArrayIndenter = indenter == null ? new NopIndenter() : indenter;
    }

    public void indentObjectsWith(Indenter indenter) {
        this.mObjectIndenter = indenter == null ? new NopIndenter() : indenter;
    }

    public void spacesInObjectEntries(boolean bl) {
        this.mSpacesInObjectEntries = bl;
    }

    public void writeRootValueSeparator(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        jsonGenerator.writeRaw(' ');
    }

    public void writeStartObject(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        jsonGenerator.writeRaw('{');
        if (!this.mObjectIndenter.isInline()) {
            ++this.mNesting;
        }
    }

    public void beforeObjectEntries(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        this.mObjectIndenter.writeIndentation(jsonGenerator, this.mNesting);
    }

    public void writeObjectFieldValueSeparator(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        if (this.mSpacesInObjectEntries) {
            jsonGenerator.writeRaw(" : ");
        } else {
            jsonGenerator.writeRaw(':');
        }
    }

    public void writeObjectEntrySeparator(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        jsonGenerator.writeRaw(',');
        this.mObjectIndenter.writeIndentation(jsonGenerator, this.mNesting);
    }

    public void writeEndObject(JsonGenerator jsonGenerator, int n) throws IOException, JsonGenerationException {
        if (!this.mObjectIndenter.isInline()) {
            --this.mNesting;
        }
        if (n > 0) {
            this.mObjectIndenter.writeIndentation(jsonGenerator, this.mNesting);
        } else {
            jsonGenerator.writeRaw(' ');
        }
        jsonGenerator.writeRaw('}');
    }

    public void writeStartArray(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        if (!this.mArrayIndenter.isInline()) {
            ++this.mNesting;
        }
        jsonGenerator.writeRaw('[');
    }

    public void beforeArrayValues(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        this.mArrayIndenter.writeIndentation(jsonGenerator, this.mNesting);
    }

    public void writeArrayValueSeparator(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        jsonGenerator.writeRaw(',');
        this.mArrayIndenter.writeIndentation(jsonGenerator, this.mNesting);
    }

    public void writeEndArray(JsonGenerator jsonGenerator, int n) throws IOException, JsonGenerationException {
        if (!this.mArrayIndenter.isInline()) {
            --this.mNesting;
        }
        if (n > 0) {
            this.mArrayIndenter.writeIndentation(jsonGenerator, this.mNesting);
        } else {
            jsonGenerator.writeRaw(' ');
        }
        jsonGenerator.writeRaw(']');
    }

    public static class FixedSpaceIndenter
    implements Indenter {
        public void writeIndentation(JsonGenerator jsonGenerator, int n) throws IOException, JsonGenerationException {
            jsonGenerator.writeRaw(' ');
        }

        public boolean isInline() {
            return true;
        }
    }

    public static class Lf2SpacesIndenter
    implements Indenter {
        static final String SYSTEM_LINE_SEPARATOR;
        static final int SPACE_COUNT = 64;
        static final char[] SPACES;

        public boolean isInline() {
            return false;
        }

        public void writeIndentation(JsonGenerator jsonGenerator, int n) throws IOException, JsonGenerationException {
            jsonGenerator.writeRaw(SYSTEM_LINE_SEPARATOR);
            n += n;
            while (n > 64) {
                jsonGenerator.writeRaw(SPACES, 0, 64);
                n -= SPACES.length;
            }
            jsonGenerator.writeRaw(SPACES, 0, n);
        }

        static {
            String string = null;
            try {
                string = System.getProperty("line.separator");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SYSTEM_LINE_SEPARATOR = string == null ? "\n" : string;
            SPACES = new char[64];
            Arrays.fill(SPACES, ' ');
        }
    }

    public static class NopIndenter
    implements Indenter {
        public void writeIndentation(JsonGenerator jsonGenerator, int n) {
        }

        public boolean isInline() {
            return true;
        }
    }
}

