/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.annotation.introspection.EjbComponentAnnotationScanner;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.CompositeArchivist;
import com.sun.enterprise.deployment.archivist.EjbArchivist;
import com.sun.enterprise.deployment.archivist.ExtensionsArchivist;
import com.sun.enterprise.deployment.io.ApplicationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.runtime.ApplicationRuntimeDDFile;
import com.sun.enterprise.deployment.util.AnnotationDetector;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.shared.ArchivistUtils;
import com.sun.hk2.component.Holder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
public class ApplicationArchivist
extends Archivist<Application>
implements CompositeArchivist {
    @Inject
    Holder<ArchivistFactory> archivistFactory;
    @Inject
    Habitat habitat;
    @Inject(optional=true)
    ExtensionsArchivist[] extensionsArchivists;
    DeploymentDescriptorFile standardDD = new ApplicationDeploymentDescriptorFile();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationArchivist.class);

    public ApplicationArchivist() {
        this.handleRuntimeInfo = true;
    }

    @Override
    public XModuleType getModuleType() {
        return XModuleType.EAR;
    }

    @Override
    protected void writeContents(ReadableArchive in, WritableArchive out) throws IOException {
        Vector<String> filesToSkip = new Vector<String>();
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
            DOLUtils.getDefaultLogger().fine("Write " + out.getURI() + " with " + this);
        }
        Enumeration alreadyWritten = out.entries();
        while (alreadyWritten.hasMoreElements()) {
            String elementName = (String)alreadyWritten.nextElement();
            filesToSkip.add(elementName);
        }
        for (ModuleDescriptor<BundleDescriptor> aModule : ((Application)this.descriptor).getModules()) {
            Archivist subArchivist = this.archivistFactory.get().getPrivateArchivistFor(aModule.getModuleType());
            subArchivist.initializeContext(this);
            subArchivist.setModuleDescriptor(aModule);
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().info("Write " + aModule.getArchiveUri() + " with " + subArchivist);
            }
            if (aModule.getAlternateDescriptor() != null) {
                OutputStream os = out.putNextEntry(aModule.getAlternateDescriptor());
                subArchivist.writeStandardDeploymentDescriptors(os);
                out.closeEntry();
                if (!this.isHandlingRuntimeInfo()) continue;
                os = out.putNextEntry("sun-" + aModule.getAlternateDescriptor());
                subArchivist.writeRuntimeDeploymentDescriptors(os);
                out.closeEntry();
                continue;
            }
            WritableArchive internalJar = out.createSubArchive(aModule.getArchiveUri());
            InputStream is = in.getEntry(aModule.getArchiveUri());
            File tmpFile = null;
            try {
                if (in instanceof WritableArchive) {
                    subArchivist.setArchiveUri(internalJar.getURI().getSchemeSpecificPart());
                } else {
                    tmpFile = ApplicationArchivist.getTempFile(this.path);
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile));
                    ArchivistUtils.copy((InputStream)is, (OutputStream)bos);
                    subArchivist.setArchiveUri(tmpFile.getAbsolutePath());
                }
                subArchivist.writeContents(internalJar);
                out.closeEntry(internalJar);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
            filesToSkip.add(aModule.getArchiveUri());
        }
        super.writeContents(in, out, filesToSkip);
    }

    @Override
    public Application getDefaultBundleDescriptor() {
        return new Application(this.habitat);
    }

    @Override
    public Application open(ReadableArchive appArchive) throws IOException, SAXParseException {
        this.setManifest(appArchive.getManifest());
        Application appDesc = (Application)this.readStandardDeploymentDescriptor(appArchive);
        return this.openWith(appDesc, appArchive);
    }

    @Override
    public Application openWith(Application application, ReadableArchive archive) throws IOException, SAXParseException {
        this.setManifest(archive.getManifest());
        this.setDescriptor(application);
        if (this.extensionsArchivists != null) {
            for (ExtensionsArchivist extension : this.extensionsArchivists) {
                Object o;
                if (!extension.supportsModuleType(this.getModuleType()) || !((o = extension.open(this, archive, this.descriptor)) instanceof RootDeploymentDescriptor)) continue;
                extension.addExtension(this.descriptor, (RootDeploymentDescriptor)o);
            }
        }
        this.handleRuntimeInfo = false;
        if (!this.readModulesDescriptors(application, archive)) {
            return null;
        }
        this.handleRuntimeInfo = true;
        this.readRuntimeDeploymentDescriptor(archive, application);
        if (this.classLoader != null && this.isHandlingRuntimeInfo()) {
            this.validate(null);
        }
        return application;
    }

    public Application createApplication(ReadableArchive archive, boolean directory) throws IOException, SAXParseException {
        if (this.hasStandardDeploymentDescriptor(archive)) {
            return (Application)this.readStandardDeploymentDescriptor(archive);
        }
        return this.getApplicationFromIntrospection(archive, directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Application getApplicationFromIntrospection(ReadableArchive archive, boolean directory) {
        File[] files;
        String appRoot = archive.getURI().getSchemeSpecificPart();
        if (appRoot.endsWith(File.separator)) {
            appRoot = appRoot.substring(0, appRoot.length() - 1);
        }
        Application app = new Application(this.habitat);
        app.setLoadedFromApplicationXml(false);
        app.setVirtual(false);
        String appName = appRoot.substring(appRoot.lastIndexOf(File.separatorChar) + 1);
        app.setName(appName);
        ArrayList<ReadableArchive> unknowns = new ArrayList<ReadableArchive>();
        for (File subModule : files = ApplicationArchivist.getEligibleEntries(new File(appRoot), directory)) {
            ReadableArchive subArchive;
            block25: {
                block28: {
                    block27: {
                        String uri;
                        block26: {
                            ModuleDescriptor<BundleDescriptor> md;
                            subArchive = null;
                            try {
                                subArchive = this.archiveFactory.openArchive(subModule);
                            }
                            catch (IOException ex) {
                                logger.log(Level.WARNING, ex.getMessage());
                            }
                            String name = subModule.getName();
                            uri = ApplicationArchivist.deriveArchiveUri(appRoot, subModule, directory);
                            if (!directory && name.endsWith(".war") || directory && (name.endsWith("_war") || name.endsWith(".war"))) {
                                md = new ModuleDescriptor<BundleDescriptor>();
                                md.setArchiveUri(uri);
                                md.setModuleType(XModuleType.WAR);
                                app.addModule(md);
                                break block25;
                            }
                            if (!directory && name.endsWith(".rar") || directory && (name.endsWith("_rar") || name.endsWith(".rar"))) {
                                md = new ModuleDescriptor();
                                md.setArchiveUri(uri);
                                md.setModuleType(XModuleType.RAR);
                                app.addModule(md);
                                break block25;
                            }
                            if ((directory || !name.endsWith(".jar")) && (!directory || !name.endsWith("_jar") && !name.endsWith(".jar"))) break block25;
                            AppClientArchivist acArchivist = new AppClientArchivist();
                            if (!acArchivist.hasStandardDeploymentDescriptor(subArchive) && !acArchivist.hasRuntimeDeploymentDescriptor(subArchive) && acArchivist.getMainClassName(subArchive.getManifest()) == null) break block26;
                            ModuleDescriptor<BundleDescriptor> md2 = new ModuleDescriptor<BundleDescriptor>();
                            md2.setArchiveUri(uri);
                            md2.setModuleType(XModuleType.CAR);
                            md2.setManifest(subArchive.getManifest());
                            app.addModule(md2);
                            if (subArchive == null) continue;
                            try {
                                subArchive.close();
                            }
                            catch (IOException ioe) {
                                logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.errorClosingSubArch", "Error closing subarchive {0}", new Object[]{subModule.getAbsolutePath()}), ioe);
                            }
                            continue;
                        }
                        EjbArchivist ejbArchivist = new EjbArchivist();
                        if (!ejbArchivist.hasStandardDeploymentDescriptor(subArchive) && !ejbArchivist.hasRuntimeDeploymentDescriptor(subArchive)) break block27;
                        ModuleDescriptor<BundleDescriptor> md = new ModuleDescriptor<BundleDescriptor>();
                        md.setArchiveUri(uri);
                        md.setModuleType(XModuleType.EJB);
                        app.addModule(md);
                        if (subArchive == null) continue;
                        try {
                            subArchive.close();
                        }
                        catch (IOException ioe) {
                            logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.errorClosingSubArch", "Error closing subarchive {0}", new Object[]{subModule.getAbsolutePath()}), ioe);
                        }
                        continue;
                    }
                    break block28;
                    {
                        catch (IOException ex) {
                            logger.log(Level.WARNING, ex.getMessage());
                        }
                    }
                }
                unknowns.add(subArchive);
            }
            if (subArchive == null) continue;
            try {
                subArchive.close();
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.errorClosingSubArch", "Error closing subarchive {0}", new Object[]{subModule.getAbsolutePath()}), ioe);
            }
            continue;
            catch (Throwable throwable) {
                if (subArchive != null) {
                    try {
                        subArchive.close();
                    }
                    catch (IOException ioe) {
                        logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.errorClosingSubArch", "Error closing subarchive {0}", new Object[]{subModule.getAbsolutePath()}), ioe);
                    }
                }
                throw throwable;
            }
        }
        if (unknowns.size() > 0) {
            AnnotationDetector detector = new AnnotationDetector(new EjbComponentAnnotationScanner());
            for (int i = 0; i < unknowns.size(); ++i) {
                File jarFile = new File(((ReadableArchive)unknowns.get(i)).getURI().getSchemeSpecificPart());
                try {
                    if (!detector.hasAnnotationInArchive((ReadableArchive)unknowns.get(i))) continue;
                    String uri = ApplicationArchivist.deriveArchiveUri(appRoot, jarFile, directory);
                    ModuleDescriptor<BundleDescriptor> md = new ModuleDescriptor<BundleDescriptor>();
                    md.setArchiveUri(uri);
                    md.setModuleType(XModuleType.EJB);
                    app.addModule(md);
                    continue;
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, ex.getMessage());
                }
            }
        }
        return app;
    }

    private static String deriveArchiveUri(String appRoot, File subModule, boolean deploydir) {
        if (deploydir) {
            return FileUtils.revertFriendlyFilename((String)subModule.getName());
        }
        String aRoot = null;
        try {
            aRoot = new File(appRoot).getCanonicalPath();
        }
        catch (IOException ex) {
            aRoot = appRoot;
        }
        String uri = subModule.getAbsolutePath().substring(aRoot.length() + 1);
        return uri.replace(File.separatorChar, '/');
    }

    private static File[] getEligibleEntries(File appRoot, boolean deploydir) {
        if (deploydir) {
            return appRoot.listFiles(new DirectoryIntrospectionFilter());
        }
        Vector<File> files = new Vector<File>();
        ApplicationArchivist.getListOfFiles(appRoot, files, new ArchiveIntrospectionFilter(appRoot.getAbsolutePath()));
        return files.toArray(new File[files.size()]);
    }

    private static void getListOfFiles(File directory, Vector<File> files, FilenameFilter filter) {
        File[] list = directory.listFiles(filter);
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].isDirectory()) {
                files.add(list[i]);
                continue;
            }
            ApplicationArchivist.getListOfFiles(list[i], files, filter);
        }
    }

    public boolean readModulesDescriptors(Application app, ReadableArchive appArchive) throws IOException, SAXParseException {
        ArrayList<ModuleDescriptor<BundleDescriptor>> nonexistentModules = new ArrayList<ModuleDescriptor<BundleDescriptor>>();
        for (ModuleDescriptor<BundleDescriptor> aModule : app.getModules()) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Opening sub-module " + aModule);
            }
            RootDeploymentDescriptor descriptor = null;
            Archivist newArchivist = this.archivistFactory.get().getPrivateArchivistFor(aModule.getModuleType());
            newArchivist.initializeContext(this);
            newArchivist.setRuntimeXMLValidation(this.getRuntimeXMLValidation());
            newArchivist.setRuntimeXMLValidationLevel(this.getRuntimeXMLValidationLevel());
            newArchivist.setAnnotationProcessingRequested(this.annotationProcessingRequested);
            ReadableArchive embeddedArchive = appArchive.getSubArchive(aModule.getArchiveUri());
            if (embeddedArchive != null) {
                embeddedArchive.setParentArchive(appArchive);
            }
            if (aModule.getAlternateDescriptor() != null) {
                InputStream is = appArchive.getEntry(aModule.getAlternateDescriptor());
                DeploymentDescriptorFile ddFile = newArchivist.getStandardDDFile();
                ddFile.setXMLValidation(newArchivist.getXMLValidation());
                ddFile.setXMLValidationLevel(newArchivist.getXMLValidationLevel());
                if (appArchive.getURI() != null) {
                    ddFile.setErrorReportingString(appArchive.getURI().getSchemeSpecificPart());
                }
                descriptor = (BundleDescriptor)ddFile.read(is);
                ((BundleDescriptor)descriptor).setApplication(app);
                is.close();
                HashMap<ExtensionsArchivist, RootDeploymentDescriptor> extensions = new HashMap<ExtensionsArchivist, RootDeploymentDescriptor>();
                if (this.extensionsArchivists != null) {
                    for (ExtensionsArchivist extension : this.extensionsArchivists) {
                        Object rdd;
                        if (!extension.supportsModuleType(aModule.getModuleType()) || !((rdd = extension.open(newArchivist, embeddedArchive, descriptor)) instanceof RootDeploymentDescriptor)) continue;
                        extensions.put(extension, (RootDeploymentDescriptor)rdd);
                    }
                }
                newArchivist.postStandardDDsRead(descriptor, embeddedArchive);
                newArchivist.readAnnotations(embeddedArchive, descriptor, extensions);
                newArchivist.postAnnotationProcess(descriptor, embeddedArchive);
                newArchivist.postOpen(descriptor, embeddedArchive);
                if (this.isHandlingRuntimeInfo()) {
                    is = appArchive.getEntry("sun-" + aModule.getAlternateDescriptor());
                    if (is != null) {
                        DeploymentDescriptorFile confDD = newArchivist.getConfigurationDDFile();
                        confDD.setXMLValidation(newArchivist.getRuntimeXMLValidation());
                        confDD.setXMLValidationLevel(newArchivist.getRuntimeXMLValidationLevel());
                        if (appArchive.getURI() != null) {
                            confDD.setErrorReportingString(appArchive.getURI().getSchemeSpecificPart());
                        }
                        confDD.read(descriptor, is);
                        is.close();
                        newArchivist.postRuntimeDDsRead(descriptor, embeddedArchive);
                    } else if (embeddedArchive != null) {
                        newArchivist.readRuntimeDeploymentDescriptor(embeddedArchive, descriptor);
                    }
                    for (Map.Entry extension : extensions.entrySet()) {
                        if (extension.getValue() == null) continue;
                        ((ExtensionsArchivist)extension.getKey()).readRuntimeDeploymentDescriptor(newArchivist, embeddedArchive, (RootDeploymentDescriptor)extension.getValue());
                    }
                }
            } else if (embeddedArchive != null) {
                descriptor = (RootDeploymentDescriptor)newArchivist.open(embeddedArchive, app);
            } else {
                DOLUtils.getDefaultLogger().info(localStrings.getLocalString("enterprise.deployment.cannotfindmodule", "Cannot find module {0} in application bundle", new Object[]{aModule.getArchiveUri()}));
                nonexistentModules.add(aModule);
                continue;
            }
            if (embeddedArchive != null) {
                embeddedArchive.close();
            }
            if (descriptor != null && descriptor instanceof BundleDescriptor) {
                descriptor.getModuleDescriptor().setArchiveUri(aModule.getArchiveUri());
                aModule.setModuleName(descriptor.getModuleDescriptor().getModuleName());
                aModule.setDescriptor((BundleDescriptor)descriptor);
                ((BundleDescriptor)descriptor).setApplication(app);
                aModule.setManifest(newArchivist.getManifest());
                if (appArchive.exists("META-INF/application.xml") || !aModule.getModuleType().equals(XModuleType.WAR)) continue;
                aModule.setContextRoot(aModule.getModuleName());
                continue;
            }
            if (embeddedArchive != null) {
                DOLUtils.getDefaultLogger().info(localStrings.getLocalString("enterprise.deployment.cannotreadDDs", "Cannot read the Deployment Descriptors for module {0}", new Object[]{aModule.getArchiveUri()}));
            }
            return false;
        }
        for (ModuleDescriptor<BundleDescriptor> nonexistentModule : nonexistentModules) {
            app.removeModule(nonexistentModule);
        }
        return true;
    }

    @Override
    public void readRuntimeDeploymentDescriptor(ReadableArchive archive, Application descriptor) throws IOException, SAXParseException {
        if (descriptor != null) {
            for (ModuleDescriptor<BundleDescriptor> md : descriptor.getModules()) {
                Archivist archivist = this.archivistFactory.get().getPrivateArchivistFor(md.getModuleType());
                archivist.initializeContext(this);
                archivist.setRuntimeXMLValidation(this.getRuntimeXMLValidation());
                archivist.setRuntimeXMLValidationLevel(this.getRuntimeXMLValidationLevel());
                InputStream is = null;
                if (md.getAlternateDescriptor() != null && (is = archive.getEntry("sun-" + md.getAlternateDescriptor())) != null) {
                    DeploymentDescriptorFile confDD = archivist.getConfigurationDDFile();
                    confDD.setXMLValidation(archivist.getRuntimeXMLValidation());
                    confDD.setXMLValidationLevel(archivist.getRuntimeXMLValidationLevel());
                    if (archive.getURI() != null) {
                        confDD.setErrorReportingString(archive.getURI().getSchemeSpecificPart());
                    }
                    confDD.read(md.getDescriptor(), is);
                    is.close();
                }
                if (is != null) continue;
                ReadableArchive subArchive = archive.getSubArchive(md.getArchiveUri());
                archivist.readRuntimeDeploymentDescriptor(subArchive, md.getDescriptor());
            }
        }
        super.readRuntimeDeploymentDescriptor(archive, descriptor);
    }

    @Override
    public void readRuntimeDDFromDeploymentPlan(ReadableArchive planArchive, Application descriptor) throws IOException, SAXParseException {
        if (planArchive == null) {
            return;
        }
        Vector dpEntries = new Vector();
        Enumeration e = planArchive.entries();
        while (e.hasMoreElements()) {
            dpEntries.add(e.nextElement());
        }
        if (descriptor instanceof Application) {
            Application application = descriptor;
            for (ModuleDescriptor<BundleDescriptor> moduleDesc : application.getModules()) {
                Archivist subArchivist = this.archivistFactory.get().getPrivateArchivistFor(moduleDesc.getModuleType());
                String archiveUri = moduleDesc.getArchiveUri();
                String runtimeDDPath = subArchivist.getRuntimeDeploymentDescriptorPath();
                if (runtimeDDPath == null) continue;
                String mangledName = archiveUri + "." + runtimeDDPath.substring(runtimeDDPath.lastIndexOf(47) + 1);
                DOLUtils.getDefaultLogger().fine("mangledName is " + mangledName);
                if (!dpEntries.contains(mangledName)) continue;
                subArchivist.readRuntimeDDFromDeploymentPlan(mangledName, planArchive, moduleDesc.getDescriptor());
            }
        }
        super.readRuntimeDDFromDeploymentPlan(planArchive, descriptor);
    }

    @Override
    public void validate(ClassLoader aClassLoader) {
        ClassLoader cl = aClassLoader;
        if (cl == null) {
            cl = this.classLoader;
        }
        if (cl == null) {
            return;
        }
        ((Application)this.descriptor).setClassLoader(cl);
        ((Application)this.descriptor).visit(new ApplicationValidator());
    }

    @Override
    public DeploymentDescriptorFile getStandardDDFile() {
        return this.standardDD;
    }

    @Override
    public DeploymentDescriptorFile getConfigurationDDFile() {
        return new ApplicationRuntimeDDFile();
    }

    @Override
    public boolean performOptionalPkgDependenciesCheck(ReadableArchive archive) throws IOException {
        if (!super.performOptionalPkgDependenciesCheck(archive)) {
            return false;
        }
        if (this.descriptor == null) {
            throw new IOException("Application object not set on archivist");
        }
        boolean returnValue = true;
        for (ModuleDescriptor<BundleDescriptor> md : ((Application)this.descriptor).getModules()) {
            Archivist subArchivist;
            ReadableArchive sub = archive.getSubArchive(md.getArchiveUri());
            if (sub == null || (subArchivist = this.archivistFactory.get().getPrivateArchivistFor(md.getModuleType())).performOptionalPkgDependenciesCheck(sub)) continue;
            returnValue = false;
        }
        return returnValue;
    }

    @Override
    public void copyInto(ReadableArchive source, WritableArchive target) throws IOException {
        try {
            Application a = (Application)this.readStandardDeploymentDescriptor(source);
            this.copyInto(a, source, target);
        }
        catch (SAXParseException spe) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.fileCopyFailure", spe);
        }
    }

    public void copyInto(Application a, ReadableArchive source, WritableArchive target) throws IOException {
        this.copyInto(a, source, target, true);
    }

    public void copyInto(Application a, ReadableArchive source, WritableArchive target, boolean overwriteManifest) throws IOException {
        Vector<String> entriesAdded = new Vector<String>();
        for (ModuleDescriptor<BundleDescriptor> aModule : a.getModules()) {
            entriesAdded.add(aModule.getArchiveUri());
            ReadableArchive subSource = source.getSubArchive(aModule.getArchiveUri());
            WritableArchive subTarget = target.createSubArchive(aModule.getArchiveUri());
            Archivist newArchivist = this.archivistFactory.get().getPrivateArchivistFor(aModule.getModuleType());
            newArchivist.copyInto(subSource, subTarget, overwriteManifest);
            target.closeEntry(subTarget);
            String subModulePath = subSource.getURI().getSchemeSpecificPart();
            if (subModulePath.startsWith(subModulePath)) {
                subModulePath = subModulePath.substring(subModulePath.length() + File.separator.length());
                Enumeration subEntries = subSource.entries();
                while (subEntries.hasMoreElements()) {
                    String anEntry = (String)subEntries.nextElement();
                    entriesAdded.add(subModulePath + "/" + anEntry);
                }
            }
            subSource.close();
        }
        super.copyInto(source, target, entriesAdded, overwriteManifest);
    }

    @Override
    protected boolean postHandles(ReadableArchive abstractArchive) throws IOException {
        if (!(abstractArchive instanceof FileArchive)) {
            return false;
        }
        File file = new File(abstractArchive.getURI());
        if (file.isDirectory()) {
            File[] files;
            for (File content : files = file.listFiles()) {
                if (!content.isDirectory() || !ApplicationArchivist.resemblesTopLevelSubmodule(content.getPath())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getArchiveExtension() {
        return ".ear";
    }

    private static boolean resemblesTopLevelSubmodule(String entryName) {
        return entryName.endsWith("_war") || entryName.endsWith("_jar") || entryName.endsWith("_rar") || entryName.endsWith(".war") || entryName.endsWith(".jar") || entryName.endsWith(".rar");
    }

    private static class ArchiveIntrospectionFilter
    implements FilenameFilter {
        private String libDir;

        ArchiveIntrospectionFilter(String root) {
            this.libDir = root + File.separator + "lib" + File.separator;
        }

        public boolean accept(File dir, String name) {
            File currentFile = new File(dir, name);
            if (currentFile.isDirectory()) {
                return true;
            }
            if (name.endsWith(".war") || name.endsWith(".rar")) {
                return true;
            }
            String path = currentFile.getAbsolutePath();
            return !path.startsWith(this.libDir) && path.endsWith(".jar");
        }
    }

    private static class DirectoryIntrospectionFilter
    implements FilenameFilter {
        DirectoryIntrospectionFilter() {
        }

        public boolean accept(File dir, String name) {
            File currentFile = new File(dir, name);
            if (!currentFile.isDirectory()) {
                return false;
            }
            return ApplicationArchivist.resemblesTopLevelSubmodule(name);
        }
    }
}

