/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.utils.Base64Coder;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.Queue;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.GameConfig;
import com.esotericsoftware.gloomhavenhelper.GameState;
import com.esotericsoftware.gloomhavenhelper.network.Message;
import com.esotericsoftware.gloomhavenhelper.network.Network;
import com.esotericsoftware.gloomhavenhelper.util.Output;
import com.esotericsoftware.gloomhavenhelper.util.Serialization;
import com.esotericsoftware.minlog.Log;

public class Game {
    protected static Json json = new Json();
    Preferences preferences;
    public Queue<Output> undos = new Queue(16);
    public int undoIndex;

    static {
        json.setUsePrototypes(false);
        json.setIgnoreUnknownFields(true);
    }

    public void initialize() {
        this.preferences = Gdx.app.getPreferences("ghh");
    }

    public void loadConfig() {
        block5: {
            String configText = this.preferences.getString("config", null);
            if (configText != null) {
                try {
                    App.config = json.fromJson(GameConfig.class, configText);
                }
                catch (Exception ex) {
                    if (Log.ERROR) {
                        Log.error("game", "Unable to read game config preferences.", ex);
                    }
                    if (!App.eclipse) break block5;
                    Gdx.app.exit();
                }
            }
        }
        if (App.config == null) {
            App.config = new GameConfig();
        }
    }

    public void close() {
    }

    public void saveConfig() {
        block2: {
            App.gameThread();
            Network.update();
            try {
                this.preferences.putString("config", json.toJson(App.config));
                this.preferences.flush();
            }
            catch (Exception ex) {
                if (!Log.ERROR) break block2;
                Log.error("game", "Unable to write game config preferences.", ex);
            }
        }
    }

    public void loadState() {
        App.gameThread();
        String stateText = this.preferences.getString("state", null);
        if (stateText != null) {
            byte[] oldBuffer = Serialization.input.getBuffer();
            Serialization.input.setBuffer(Base64Coder.decode(stateText));
            try {
                int changeNumber = Serialization.input.readInt();
                App.state = Serialization.read(Serialization.input);
                App.state.changeNumber = changeNumber;
                App.state.apply(false);
                Serialization.lastOutput.clear();
                Serialization.lastOutput.writeBytes(Serialization.input.getBuffer(), 0, (int)Serialization.input.total());
                this.storeUndo();
                return;
            }
            catch (Exception ex) {
                if (Log.ERROR) {
                    Log.error("game", "Unable to load game state from file.", ex);
                }
                App.toast("Unable to load game state!");
                this.stateLoaded(false);
                return;
            }
            finally {
                Serialization.input.setBuffer(oldBuffer);
            }
        }
        this.stateLoaded(true);
    }

    public int loadState(byte[] bytes, boolean storeUndo) {
        App.gameThread();
        App.state.ignoreChanges = true;
        App.stage.cancelTouchFocus();
        App.state.ignoreChanges = false;
        byte[] oldBuffer = Serialization.input.getBuffer();
        Serialization.input.setBuffer(bytes);
        try {
            int changeNumber = Serialization.input.readInt();
            App.state = Serialization.read(Serialization.input);
            App.state.changeNumber = changeNumber;
            App.state.apply(true);
            Serialization.lastOutput.clear();
            Serialization.lastOutput.writeBytes(bytes, 0, (int)Serialization.input.total());
            App.game.saveState(Serialization.lastOutput.getBuffer(), Serialization.lastOutput.position());
            if (storeUndo) {
                this.storeUndo();
            }
            int n = Serialization.input.position();
            return n;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to read game state.", ex);
        }
        finally {
            Serialization.input.setBuffer(oldBuffer);
        }
    }

    void storeUndo() {
        while (this.undoIndex > 0 && !this.undos.isEmpty()) {
            this.undos.removeFirst();
            --this.undoIndex;
        }
        this.undoIndex = 0;
        if (this.undos.size > 25) {
            this.undos.removeLast();
        }
        Output undo = new Output(Serialization.lastOutput.position(), -1);
        undo.writeBytes(Serialization.lastOutput.getBuffer(), 0, Serialization.lastOutput.position());
        this.undos.addFirst(undo);
    }

    protected void stateLoaded(boolean save) {
        App.gloom.playerRows.clear();
        App.gloom.monsterRows.clear();
        App.gloom.rows.clearChildren();
        App.state = new GameState();
        App.state.shuffleAttackModifiers(false);
        App.state.apply(false);
        if (!save) {
            App.state.ignoreChanges = true;
        }
        App.state.changed();
        if (!save) {
            App.state.ignoreChanges = false;
        }
    }

    public void saveState(boolean storeUndo, byte[] animate) {
        Serialization.output.clear();
        Serialization.output.writeInt(App.state.changeNumber + 1);
        Serialization.write(Serialization.output, App.state);
        int count = Serialization.output.position();
        if (count == Serialization.lastOutput.position() && this.isEqual(Serialization.lastOutput.getBuffer(), Serialization.output.getBuffer(), count)) {
            if (Log.TRACE) {
                Log.trace("game", "State has not changed.");
            }
            return;
        }
        if (App.config.server || App.config.client) {
            byte[] bytes = Network.combine(Serialization.output, animate, 0);
            Network.send(Message.gameState, bytes, 0, bytes.length);
        }
        ++App.state.changeNumber;
        this.preferences.putString("config", json.toJson(App.config));
        this.preferences.flush();
        this.saveState(Serialization.output.getBuffer(), Serialization.output.position());
        Output temp = Serialization.lastOutput;
        Serialization.lastOutput = Serialization.output;
        Serialization.output = temp;
        if (storeUndo) {
            this.storeUndo();
        }
    }

    public void saveState(byte[] bytes, int count) {
        this.preferences.putString("state", new String(Base64Coder.encode(bytes, 0, count, Base64Coder.regularMap.getEncodingMap())));
        this.preferences.flush();
    }

    protected boolean isEqual(byte[] buffer1, byte[] buffer2, int size) {
        int i = 4;
        while (i < size) {
            if (buffer1[i] != buffer2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object currentThread() {
        return null;
    }

    public void packAtlas() {
    }

    public void thread(Runnable runnable) {
    }

    public boolean canOpenURL() {
        return false;
    }

    public void openURL(String string) {
    }

    public boolean isPurchased() {
        return true;
    }

    public boolean canPurchase() {
        return false;
    }

    public void purchase() {
    }

    public void purchased() {
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                App.gloom.mainMenu.populate();
            }
        });
    }

    public void showAd() {
        if (App.eclipse) {
            System.out.println("SHOW AD");
        }
    }

    public Insets getInsets() {
        return new Insets(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static class Insets {
        public float top;
        public float bottom;
        public float left;
        public float right;

        public Insets(float top, float bottom, float left, float right) {
            this.top = top;
            this.bottom = bottom;
            this.left = left;
            this.right = right;
        }

        public String toString() {
            return "Insets [top=" + this.top + ", bottom=" + this.bottom + ", left=" + this.left + ", right=" + this.right + "]";
        }
    }
}

