/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper.util;

import java.io.IOException;
import java.io.OutputStream;

public class Output
extends OutputStream {
    protected int maxCapacity;
    protected long total;
    protected int position;
    protected int capacity;
    protected byte[] buffer;
    protected OutputStream outputStream;

    public Output() {
    }

    public Output(int bufferSize) {
        this(bufferSize, bufferSize);
    }

    public Output(int bufferSize, int maxBufferSize) {
        if (bufferSize > maxBufferSize && maxBufferSize != -1) {
            throw new IllegalArgumentException("bufferSize: " + bufferSize + " cannot be greater than maxBufferSize: " + maxBufferSize);
        }
        if (maxBufferSize < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + maxBufferSize);
        }
        this.capacity = bufferSize;
        this.maxCapacity = maxBufferSize == -1 ? 0x7FFFFFF7 : maxBufferSize;
        this.buffer = new byte[bufferSize];
    }

    public Output(byte[] buffer) {
        this(buffer, buffer.length);
    }

    public Output(byte[] buffer, int maxBufferSize) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        this.setBuffer(buffer, maxBufferSize);
    }

    public Output(OutputStream outputStream) {
        this(4096, 4096);
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream cannot be null.");
        }
        this.outputStream = outputStream;
    }

    public Output(OutputStream outputStream, int bufferSize) {
        this(bufferSize, bufferSize);
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream cannot be null.");
        }
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.position = 0;
        this.total = 0L;
    }

    public void setBuffer(byte[] buffer) {
        this.setBuffer(buffer, buffer.length);
    }

    public void setBuffer(byte[] buffer, int maxBufferSize) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        if (buffer.length > maxBufferSize && maxBufferSize != -1) {
            throw new IllegalArgumentException("buffer has length: " + buffer.length + " cannot be greater than maxBufferSize: " + maxBufferSize);
        }
        if (maxBufferSize < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + maxBufferSize);
        }
        this.buffer = buffer;
        this.maxCapacity = maxBufferSize == -1 ? 0x7FFFFFF7 : maxBufferSize;
        this.capacity = buffer.length;
        this.position = 0;
        this.total = 0L;
        this.outputStream = null;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public byte[] toBytes() {
        byte[] newBuffer = new byte[this.position];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.position);
        return newBuffer;
    }

    public int position() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public long total() {
        return this.total + (long)this.position;
    }

    public void clear() {
        this.position = 0;
        this.total = 0L;
    }

    protected boolean require(int required) {
        if (this.capacity - this.position >= required) {
            return false;
        }
        if (required > this.maxCapacity) {
            throw new RuntimeException("Buffer overflow. Max capacity: " + this.maxCapacity + ", required: " + required);
        }
        this.flush();
        while (this.capacity - this.position < required) {
            if (this.capacity == this.maxCapacity) {
                throw new RuntimeException("Buffer overflow. Available: " + (this.capacity - this.position) + ", required: " + required);
            }
            if (this.capacity == 0) {
                this.capacity = 1;
            }
            this.capacity = Math.min(this.capacity * 2, this.maxCapacity);
            if (this.capacity < 0) {
                this.capacity = this.maxCapacity;
            }
            byte[] newBuffer = new byte[this.capacity];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.position);
            this.buffer = newBuffer;
        }
        return true;
    }

    @Override
    public void flush() {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.write(this.buffer, 0, this.position);
            this.outputStream.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.total += (long)this.position;
        this.position = 0;
    }

    @Override
    public void close() {
        this.flush();
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void write(int value) {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = (byte)value;
    }

    @Override
    public void write(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) {
        this.writeBytes(bytes, offset, length);
    }

    public void writeByte(byte value) {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = value;
    }

    public void writeByte(int value) {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = (byte)value;
    }

    public void writeBytes(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeBytes(byte[] bytes, int offset, int count) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int copyCount = Math.min(this.capacity - this.position, count);
        while (true) {
            System.arraycopy(bytes, offset, this.buffer, this.position, copyCount);
            this.position += copyCount;
            if ((count -= copyCount) == 0) {
                return;
            }
            offset += copyCount;
            copyCount = Math.min(this.capacity, count);
            this.require(copyCount);
        }
    }

    public void writeInt(int value) {
        this.require(4);
        byte[] buffer = this.buffer;
        buffer[this.position++] = (byte)(value >> 24);
        buffer[this.position++] = (byte)(value >> 16);
        buffer[this.position++] = (byte)(value >> 8);
        buffer[this.position++] = (byte)value;
    }

    public int writeInt(int value, boolean optimizePositive) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        if (value >>> 7 == 0) {
            this.require(1);
            this.buffer[this.position++] = (byte)value;
            return 1;
        }
        if (value >>> 14 == 0) {
            this.require(2);
            this.buffer[this.position++] = (byte)(value & 0x7F | 0x80);
            this.buffer[this.position++] = (byte)(value >>> 7);
            return 2;
        }
        if (value >>> 21 == 0) {
            this.require(3);
            this.buffer[this.position++] = (byte)(value & 0x7F | 0x80);
            this.buffer[this.position++] = (byte)(value >>> 7 | 0x80);
            this.buffer[this.position++] = (byte)(value >>> 14);
            return 3;
        }
        if (value >>> 28 == 0) {
            this.require(4);
            this.buffer[this.position++] = (byte)(value & 0x7F | 0x80);
            this.buffer[this.position++] = (byte)(value >>> 7 | 0x80);
            this.buffer[this.position++] = (byte)(value >>> 14 | 0x80);
            this.buffer[this.position++] = (byte)(value >>> 21);
            return 4;
        }
        this.require(5);
        this.buffer[this.position++] = (byte)(value & 0x7F | 0x80);
        this.buffer[this.position++] = (byte)(value >>> 7 | 0x80);
        this.buffer[this.position++] = (byte)(value >>> 14 | 0x80);
        this.buffer[this.position++] = (byte)(value >>> 21 | 0x80);
        this.buffer[this.position++] = (byte)(value >>> 28);
        return 5;
    }

    public void writeString(String value) {
        if (value == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value.length();
        if (charCount == 0) {
            this.writeByte(129);
            return;
        }
        boolean ascii = false;
        if (charCount > 1 && charCount < 64) {
            ascii = true;
            int i = 0;
            while (i < charCount) {
                char c = value.charAt(i);
                if (c > '\u007f') {
                    ascii = false;
                    break;
                }
                ++i;
            }
        }
        if (ascii) {
            if (this.capacity - this.position < charCount) {
                this.writeAscii_slow(value, charCount);
            } else {
                this.getBytes(value, 0, charCount, this.buffer, this.position);
                this.position += charCount;
            }
            int n = this.position - 1;
            this.buffer[n] = (byte)(this.buffer[n] | 0x80);
        } else {
            this.writeUtf8Length(charCount + 1);
            int charIndex = 0;
            if (this.capacity - this.position >= charCount) {
                byte[] buffer = this.buffer;
                int position = this.position;
                while (charIndex < charCount) {
                    char c = value.charAt(charIndex);
                    if (c > '\u007f') break;
                    buffer[position++] = (byte)c;
                    ++charIndex;
                }
                this.position = position;
            }
            if (charIndex < charCount) {
                this.writeString_slow(value, charCount, charIndex);
            }
        }
    }

    private void getBytes(String value, int start, int end, byte[] bytes, int offset) {
        while (start < end) {
            bytes[offset++] = (byte)value.charAt(start++);
        }
    }

    public void writeString(CharSequence value) {
        if (value == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value.length();
        if (charCount == 0) {
            this.writeByte(129);
            return;
        }
        this.writeUtf8Length(charCount + 1);
        int charIndex = 0;
        if (this.capacity - this.position >= charCount) {
            byte[] buffer = this.buffer;
            int position = this.position;
            while (charIndex < charCount) {
                char c = value.charAt(charIndex);
                if (c > '\u007f') break;
                buffer[position++] = (byte)c;
                ++charIndex;
            }
            this.position = position;
        }
        if (charIndex < charCount) {
            this.writeString_slow(value, charCount, charIndex);
        }
    }

    public void writeAscii(String value) {
        if (value == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value.length();
        switch (charCount) {
            case 0: {
                this.writeByte(129);
                return;
            }
            case 1: {
                this.writeByte(130);
                this.writeByte(value.charAt(0));
                return;
            }
        }
        if (this.capacity - this.position < charCount) {
            this.writeAscii_slow(value, charCount);
        } else {
            this.getBytes(value, 0, charCount, this.buffer, this.position);
            this.position += charCount;
        }
        int n = this.position - 1;
        this.buffer[n] = (byte)(this.buffer[n] | 0x80);
    }

    private void writeUtf8Length(int value) {
        if (value >>> 6 == 0) {
            this.require(1);
            this.buffer[this.position++] = (byte)(value | 0x80);
        } else if (value >>> 13 == 0) {
            this.require(2);
            byte[] buffer = this.buffer;
            buffer[this.position++] = (byte)(value | 0x40 | 0x80);
            buffer[this.position++] = (byte)(value >>> 6);
        } else if (value >>> 20 == 0) {
            this.require(3);
            byte[] buffer = this.buffer;
            buffer[this.position++] = (byte)(value | 0x40 | 0x80);
            buffer[this.position++] = (byte)(value >>> 6 | 0x80);
            buffer[this.position++] = (byte)(value >>> 13);
        } else if (value >>> 27 == 0) {
            this.require(4);
            byte[] buffer = this.buffer;
            buffer[this.position++] = (byte)(value | 0x40 | 0x80);
            buffer[this.position++] = (byte)(value >>> 6 | 0x80);
            buffer[this.position++] = (byte)(value >>> 13 | 0x80);
            buffer[this.position++] = (byte)(value >>> 20);
        } else {
            this.require(5);
            byte[] buffer = this.buffer;
            buffer[this.position++] = (byte)(value | 0x40 | 0x80);
            buffer[this.position++] = (byte)(value >>> 6 | 0x80);
            buffer[this.position++] = (byte)(value >>> 13 | 0x80);
            buffer[this.position++] = (byte)(value >>> 20 | 0x80);
            buffer[this.position++] = (byte)(value >>> 27);
        }
    }

    private void writeString_slow(CharSequence value, int charCount, int charIndex) {
        while (charIndex < charCount) {
            char c;
            if (this.position == this.capacity) {
                this.require(Math.min(this.capacity, charCount - charIndex));
            }
            if ((c = value.charAt(charIndex)) <= '\u007f') {
                this.buffer[this.position++] = (byte)c;
            } else if (c > '\u07ff') {
                this.buffer[this.position++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.require(2);
                this.buffer[this.position++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buffer[this.position++] = (byte)(0x80 | c & 0x3F);
            } else {
                this.buffer[this.position++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.require(1);
                this.buffer[this.position++] = (byte)(0x80 | c & 0x3F);
            }
            ++charIndex;
        }
    }

    private void writeAscii_slow(String value, int charCount) {
        if (charCount == 0) {
            return;
        }
        if (this.capacity == 0) {
            this.require(1);
        }
        int charIndex = 0;
        byte[] buffer = this.buffer;
        int charsToWrite = Math.min(charCount, this.capacity - this.position);
        while (charIndex < charCount) {
            this.getBytes(value, charIndex, charIndex + charsToWrite, buffer, this.position);
            this.position += charsToWrite;
            charsToWrite = Math.min(charCount - (charIndex += charsToWrite), this.capacity);
            if (!this.require(charsToWrite)) continue;
            buffer = this.buffer;
        }
    }

    public void writeFloat(float value) {
        this.writeInt(Float.floatToIntBits(value));
    }

    public int writeFloat(float value, float precision, boolean optimizePositive) {
        return this.writeInt((int)(value * precision), optimizePositive);
    }

    public void writeShort(int value) {
        this.require(2);
        this.buffer[this.position++] = (byte)(value >>> 8);
        this.buffer[this.position++] = (byte)value;
    }

    public void writeLong(long value) {
        this.require(8);
        byte[] buffer = this.buffer;
        buffer[this.position++] = (byte)(value >>> 56);
        buffer[this.position++] = (byte)(value >>> 48);
        buffer[this.position++] = (byte)(value >>> 40);
        buffer[this.position++] = (byte)(value >>> 32);
        buffer[this.position++] = (byte)(value >>> 24);
        buffer[this.position++] = (byte)(value >>> 16);
        buffer[this.position++] = (byte)(value >>> 8);
        buffer[this.position++] = (byte)value;
    }

    public int writeLong(long value, boolean optimizePositive) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 63;
        }
        if (value >>> 7 == 0L) {
            this.require(1);
            this.buffer[this.position++] = (byte)value;
            return 1;
        }
        if (value >>> 14 == 0L) {
            this.require(2);
            this.buffer[this.position++] = (byte)(value & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 7);
            return 2;
        }
        if (value >>> 21 == 0L) {
            this.require(3);
            this.buffer[this.position++] = (byte)(value & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 14);
            return 3;
        }
        if (value >>> 28 == 0L) {
            this.require(4);
            this.buffer[this.position++] = (byte)(value & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 21);
            return 4;
        }
        if (value >>> 35 == 0L) {
            this.require(5);
            this.buffer[this.position++] = (byte)(value & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 28);
            return 5;
        }
        if (value >>> 42 == 0L) {
            this.require(6);
            this.buffer[this.position++] = (byte)(value & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 28 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 35);
            return 6;
        }
        if (value >>> 49 == 0L) {
            this.require(7);
            this.buffer[this.position++] = (byte)(value & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 28 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 35 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 42);
            return 7;
        }
        if (value >>> 56 == 0L) {
            this.require(8);
            this.buffer[this.position++] = (byte)(value & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 28 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 35 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 42 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 49);
            return 8;
        }
        this.require(9);
        this.buffer[this.position++] = (byte)(value & 0x7FL | 0x80L);
        this.buffer[this.position++] = (byte)(value >>> 7 | 0x80L);
        this.buffer[this.position++] = (byte)(value >>> 14 | 0x80L);
        this.buffer[this.position++] = (byte)(value >>> 21 | 0x80L);
        this.buffer[this.position++] = (byte)(value >>> 28 | 0x80L);
        this.buffer[this.position++] = (byte)(value >>> 35 | 0x80L);
        this.buffer[this.position++] = (byte)(value >>> 42 | 0x80L);
        this.buffer[this.position++] = (byte)(value >>> 49 | 0x80L);
        this.buffer[this.position++] = (byte)(value >>> 56);
        return 9;
    }

    public void writeBoolean(boolean value) {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = (byte)(value ? 1 : 0);
    }

    public void writeChar(char value) {
        this.require(2);
        this.buffer[this.position++] = (byte)(value >>> 8);
        this.buffer[this.position++] = (byte)value;
    }

    public void writeDouble(double value) {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public int writeDouble(double value, double precision, boolean optimizePositive) {
        return this.writeLong((long)(value * precision), optimizePositive);
    }

    public void writeInts(int[] object, boolean optimizePositive) {
        int i = 0;
        int n = object.length;
        while (i < n) {
            this.writeInt(object[i], optimizePositive);
            ++i;
        }
    }

    public void writeLongs(long[] object, boolean optimizePositive) {
        int i = 0;
        int n = object.length;
        while (i < n) {
            this.writeLong(object[i], optimizePositive);
            ++i;
        }
    }

    public void writeInts(int[] object) {
        int i = 0;
        int n = object.length;
        while (i < n) {
            this.writeInt(object[i]);
            ++i;
        }
    }

    public void writeLongs(long[] object) {
        int i = 0;
        int n = object.length;
        while (i < n) {
            this.writeLong(object[i]);
            ++i;
        }
    }

    public void writeFloats(float[] object) {
        int i = 0;
        int n = object.length;
        while (i < n) {
            this.writeFloat(object[i]);
            ++i;
        }
    }

    public void writeShorts(short[] object) {
        int i = 0;
        int n = object.length;
        while (i < n) {
            this.writeShort(object[i]);
            ++i;
        }
    }

    public void writeChars(char[] object) {
        int i = 0;
        int n = object.length;
        while (i < n) {
            this.writeChar(object[i]);
            ++i;
        }
    }

    public void writeDoubles(double[] object) {
        int i = 0;
        int n = object.length;
        while (i < n) {
            this.writeDouble(object[i]);
            ++i;
        }
    }

    public static int intLength(int value, boolean optimizePositive) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        if (value >>> 7 == 0) {
            return 1;
        }
        if (value >>> 14 == 0) {
            return 2;
        }
        if (value >>> 21 == 0) {
            return 3;
        }
        if (value >>> 28 == 0) {
            return 4;
        }
        return 5;
    }

    public static int longLength(long value, boolean optimizePositive) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 63;
        }
        if (value >>> 7 == 0L) {
            return 1;
        }
        if (value >>> 14 == 0L) {
            return 2;
        }
        if (value >>> 21 == 0L) {
            return 3;
        }
        if (value >>> 28 == 0L) {
            return 4;
        }
        if (value >>> 35 == 0L) {
            return 5;
        }
        if (value >>> 42 == 0L) {
            return 6;
        }
        if (value >>> 49 == 0L) {
            return 7;
        }
        if (value >>> 56 == 0L) {
            return 8;
        }
        return 9;
    }

    public static void writeInt(byte[] buffer, int position, int value) {
        buffer[position++] = (byte)(value >> 24);
        buffer[position++] = (byte)(value >> 16);
        buffer[position++] = (byte)(value >> 8);
        buffer[position] = (byte)value;
    }
}

