/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DataInput;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.SerializationException;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.ConstraintData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.EventData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonJson;
import com.esotericsoftware.spine.SkeletonLoader;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentLoader;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.PointAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import java.io.EOFException;
import java.io.IOException;

public class SkeletonBinary
extends SkeletonLoader {
    public static final int BONE_ROTATE = 0;
    public static final int BONE_TRANSLATE = 1;
    public static final int BONE_SCALE = 2;
    public static final int BONE_SHEAR = 3;
    public static final int SLOT_ATTACHMENT = 0;
    public static final int SLOT_COLOR = 1;
    public static final int SLOT_TWO_COLOR = 2;
    public static final int PATH_POSITION = 0;
    public static final int PATH_SPACING = 1;
    public static final int PATH_MIX = 2;
    public static final int CURVE_LINEAR = 0;
    public static final int CURVE_STEPPED = 1;
    public static final int CURVE_BEZIER = 2;

    public SkeletonBinary(AttachmentLoader attachmentLoader) {
        super(attachmentLoader);
    }

    public SkeletonBinary(TextureAtlas atlas) {
        super(atlas);
    }

    @Override
    public SkeletonData readSkeletonData(FileHandle file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        float scale = this.scale;
        SkeletonData skeletonData = new SkeletonData();
        skeletonData.name = file.nameWithoutExtension();
        SkeletonInput input = new SkeletonInput(file);
        try {
            try {
                int ii;
                BoneData[] constraintBones;
                Object data;
                Object data2;
                long hash = input.readLong();
                skeletonData.hash = hash == 0L ? null : Long.toString(hash);
                skeletonData.version = input.readString();
                if (skeletonData.version.isEmpty()) {
                    skeletonData.version = null;
                }
                if ("3.8.75".equals(skeletonData.version)) {
                    throw new RuntimeException("Unsupported skeleton data, please export with a newer version of Spine.");
                }
                skeletonData.x = input.readFloat();
                skeletonData.y = input.readFloat();
                skeletonData.width = input.readFloat();
                skeletonData.height = input.readFloat();
                boolean nonessential = input.readBoolean();
                if (nonessential) {
                    skeletonData.fps = input.readFloat();
                    skeletonData.imagesPath = input.readString();
                    if (skeletonData.imagesPath.isEmpty()) {
                        skeletonData.imagesPath = null;
                    }
                    skeletonData.audioPath = input.readString();
                    if (skeletonData.audioPath.isEmpty()) {
                        skeletonData.audioPath = null;
                    }
                }
                int n = input.readInt(true);
                input.strings = new String[n];
                Object[] o = input.strings;
                int i = 0;
                while (i < n) {
                    o[i] = input.readString();
                    ++i;
                }
                n = input.readInt(true);
                BoneData[] bones = skeletonData.bones.setSize(n);
                int i2 = 0;
                while (i2 < n) {
                    String name = input.readString();
                    BoneData parent = i2 == 0 ? null : bones[input.readInt(true)];
                    data2 = new BoneData(i2, name, parent);
                    ((BoneData)data2).rotation = input.readFloat();
                    ((BoneData)data2).x = input.readFloat() * scale;
                    ((BoneData)data2).y = input.readFloat() * scale;
                    ((BoneData)data2).scaleX = input.readFloat();
                    ((BoneData)data2).scaleY = input.readFloat();
                    ((BoneData)data2).shearX = input.readFloat();
                    ((BoneData)data2).shearY = input.readFloat();
                    ((BoneData)data2).length = input.readFloat() * scale;
                    ((BoneData)data2).transformMode = BoneData.TransformMode.values[input.readInt(true)];
                    ((BoneData)data2).skinRequired = input.readBoolean();
                    if (nonessential) {
                        Color.rgba8888ToColor(((BoneData)data2).color, input.readInt());
                    }
                    bones[i2] = data2;
                    ++i2;
                }
                n = input.readInt(true);
                SlotData[] slots = skeletonData.slots.setSize(n);
                int i3 = 0;
                while (i3 < n) {
                    String slotName = input.readString();
                    BoneData boneData = bones[input.readInt(true)];
                    data = new SlotData(i3, slotName, boneData);
                    Color.rgba8888ToColor(((SlotData)data).color, input.readInt());
                    int darkColor = input.readInt();
                    if (darkColor != -1) {
                        ((SlotData)data).darkColor = new Color();
                        Color.rgb888ToColor(((SlotData)data).darkColor, darkColor);
                    }
                    ((SlotData)data).attachmentName = input.readStringRef();
                    ((SlotData)data).blendMode = BlendMode.values[input.readInt(true)];
                    slots[i3] = data;
                    ++i3;
                }
                n = input.readInt(true);
                o = skeletonData.ikConstraints.setSize(n);
                i3 = 0;
                while (i3 < n) {
                    data2 = new IkConstraintData(input.readString());
                    ((IkConstraintData)data2).order = input.readInt(true);
                    ((IkConstraintData)data2).skinRequired = input.readBoolean();
                    int nn = input.readInt(true);
                    constraintBones = ((IkConstraintData)data2).bones.setSize(nn);
                    ii = 0;
                    while (ii < nn) {
                        constraintBones[ii] = bones[input.readInt(true)];
                        ++ii;
                    }
                    ((IkConstraintData)data2).target = bones[input.readInt(true)];
                    ((IkConstraintData)data2).mix = input.readFloat();
                    ((IkConstraintData)data2).softness = input.readFloat() * scale;
                    ((IkConstraintData)data2).bendDirection = input.readByte();
                    ((IkConstraintData)data2).compress = input.readBoolean();
                    ((IkConstraintData)data2).stretch = input.readBoolean();
                    ((IkConstraintData)data2).uniform = input.readBoolean();
                    o[i3] = data2;
                    ++i3;
                }
                n = input.readInt(true);
                o = skeletonData.transformConstraints.setSize(n);
                i3 = 0;
                while (i3 < n) {
                    data2 = new TransformConstraintData(input.readString());
                    ((TransformConstraintData)data2).order = input.readInt(true);
                    ((TransformConstraintData)data2).skinRequired = input.readBoolean();
                    int nn = input.readInt(true);
                    constraintBones = ((TransformConstraintData)data2).bones.setSize(nn);
                    ii = 0;
                    while (ii < nn) {
                        constraintBones[ii] = bones[input.readInt(true)];
                        ++ii;
                    }
                    ((TransformConstraintData)data2).target = bones[input.readInt(true)];
                    ((TransformConstraintData)data2).local = input.readBoolean();
                    ((TransformConstraintData)data2).relative = input.readBoolean();
                    ((TransformConstraintData)data2).offsetRotation = input.readFloat();
                    ((TransformConstraintData)data2).offsetX = input.readFloat() * scale;
                    ((TransformConstraintData)data2).offsetY = input.readFloat() * scale;
                    ((TransformConstraintData)data2).offsetScaleX = input.readFloat();
                    ((TransformConstraintData)data2).offsetScaleY = input.readFloat();
                    ((TransformConstraintData)data2).offsetShearY = input.readFloat();
                    ((TransformConstraintData)data2).rotateMix = input.readFloat();
                    ((TransformConstraintData)data2).translateMix = input.readFloat();
                    ((TransformConstraintData)data2).scaleMix = input.readFloat();
                    ((TransformConstraintData)data2).shearMix = input.readFloat();
                    o[i3] = data2;
                    ++i3;
                }
                n = input.readInt(true);
                o = skeletonData.pathConstraints.setSize(n);
                i3 = 0;
                while (i3 < n) {
                    data2 = new PathConstraintData(input.readString());
                    ((PathConstraintData)data2).order = input.readInt(true);
                    ((PathConstraintData)data2).skinRequired = input.readBoolean();
                    int nn = input.readInt(true);
                    constraintBones = ((PathConstraintData)data2).bones.setSize(nn);
                    ii = 0;
                    while (ii < nn) {
                        constraintBones[ii] = bones[input.readInt(true)];
                        ++ii;
                    }
                    ((PathConstraintData)data2).target = slots[input.readInt(true)];
                    ((PathConstraintData)data2).positionMode = PathConstraintData.PositionMode.values[input.readInt(true)];
                    ((PathConstraintData)data2).spacingMode = PathConstraintData.SpacingMode.values[input.readInt(true)];
                    ((PathConstraintData)data2).rotateMode = PathConstraintData.RotateMode.values[input.readInt(true)];
                    ((PathConstraintData)data2).offsetRotation = input.readFloat();
                    ((PathConstraintData)data2).position = input.readFloat();
                    if (((PathConstraintData)data2).positionMode == PathConstraintData.PositionMode.fixed) {
                        ((PathConstraintData)data2).position *= scale;
                    }
                    ((PathConstraintData)data2).spacing = input.readFloat();
                    if (((PathConstraintData)data2).spacingMode == PathConstraintData.SpacingMode.length || ((PathConstraintData)data2).spacingMode == PathConstraintData.SpacingMode.fixed) {
                        ((PathConstraintData)data2).spacing *= scale;
                    }
                    ((PathConstraintData)data2).rotateMix = input.readFloat();
                    ((PathConstraintData)data2).translateMix = input.readFloat();
                    o[i3] = data2;
                    ++i3;
                }
                Skin defaultSkin = this.readSkin(input, skeletonData, true, nonessential);
                if (defaultSkin != null) {
                    skeletonData.defaultSkin = defaultSkin;
                    skeletonData.skins.add(defaultSkin);
                }
                int i4 = skeletonData.skins.size;
                n = i4 + input.readInt(true);
                o = skeletonData.skins.setSize(n);
                while (i4 < n) {
                    o[i4] = this.readSkin(input, skeletonData, false, nonessential);
                    ++i4;
                }
                n = this.linkedMeshes.size;
                T[] items = this.linkedMeshes.items;
                int i5 = 0;
                while (i5 < n) {
                    Skin skin;
                    SkeletonJson.LinkedMesh linkedMesh = (SkeletonJson.LinkedMesh)items[i5];
                    Skin skin2 = skin = linkedMesh.skin == null ? skeletonData.getDefaultSkin() : skeletonData.findSkin(linkedMesh.skin);
                    if (skin == null) {
                        throw new SerializationException("Skin not found: " + linkedMesh.skin);
                    }
                    Attachment parent = skin.getAttachment(linkedMesh.slotIndex, linkedMesh.parent);
                    if (parent == null) {
                        throw new SerializationException("Parent mesh not found: " + linkedMesh.parent);
                    }
                    linkedMesh.mesh.setDeformAttachment(linkedMesh.inheritDeform ? (VertexAttachment)parent : linkedMesh.mesh);
                    linkedMesh.mesh.setParentMesh((MeshAttachment)parent);
                    linkedMesh.mesh.updateUVs();
                    ++i5;
                }
                this.linkedMeshes.clear();
                n = input.readInt(true);
                o = skeletonData.events.setSize(n);
                i5 = 0;
                while (i5 < n) {
                    data = new EventData(input.readStringRef());
                    ((EventData)data).intValue = input.readInt(false);
                    ((EventData)data).floatValue = input.readFloat();
                    ((EventData)data).stringValue = input.readString();
                    ((EventData)data).audioPath = input.readString();
                    if (((EventData)data).audioPath != null) {
                        ((EventData)data).volume = input.readFloat();
                        ((EventData)data).balance = input.readFloat();
                    }
                    o[i5] = data;
                    ++i5;
                }
                n = input.readInt(true);
                o = skeletonData.animations.setSize(n);
                i5 = 0;
                while (i5 < n) {
                    o[i5] = this.readAnimation(input, input.readString(), skeletonData);
                    ++i5;
                }
            }
            catch (IOException ex) {
                throw new SerializationException("Error reading skeleton file.", ex);
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return skeletonData;
    }

    @Null
    private Skin readSkin(SkeletonInput input, SkeletonData skeletonData, boolean defaultSkin, boolean nonessential) throws IOException {
        Skin skin;
        int slotCount;
        if (defaultSkin) {
            slotCount = input.readInt(true);
            if (slotCount == 0) {
                return null;
            }
            skin = new Skin("default");
        } else {
            skin = new Skin(input.readStringRef());
            BoneData[] bones = skin.bones.setSize(input.readInt(true));
            T[] items = skeletonData.bones.items;
            int i = 0;
            int n = skin.bones.size;
            while (i < n) {
                bones[i] = items[input.readInt(true)];
                ++i;
            }
            items = skeletonData.ikConstraints.items;
            i = 0;
            n = input.readInt(true);
            while (i < n) {
                skin.constraints.add((ConstraintData)items[input.readInt(true)]);
                ++i;
            }
            items = skeletonData.transformConstraints.items;
            i = 0;
            n = input.readInt(true);
            while (i < n) {
                skin.constraints.add((ConstraintData)items[input.readInt(true)]);
                ++i;
            }
            items = skeletonData.pathConstraints.items;
            i = 0;
            n = input.readInt(true);
            while (i < n) {
                skin.constraints.add((ConstraintData)items[input.readInt(true)]);
                ++i;
            }
            skin.constraints.shrink();
            slotCount = input.readInt(true);
        }
        int i = 0;
        while (i < slotCount) {
            int slotIndex = input.readInt(true);
            int ii = 0;
            int nn = input.readInt(true);
            while (ii < nn) {
                String name = input.readStringRef();
                Attachment attachment = this.readAttachment(input, skeletonData, skin, slotIndex, name, nonessential);
                if (attachment != null) {
                    skin.setAttachment(slotIndex, name, attachment);
                }
                ++ii;
            }
            ++i;
        }
        return skin;
    }

    private Attachment readAttachment(SkeletonInput input, SkeletonData skeletonData, Skin skin, int slotIndex, String attachmentName, boolean nonessential) throws IOException {
        float scale = this.scale;
        String name = input.readStringRef();
        if (name == null) {
            name = attachmentName;
        }
        switch (AttachmentType.values[input.readByte()]) {
            case region: {
                RegionAttachment region;
                String path = input.readStringRef();
                float rotation = input.readFloat();
                float x = input.readFloat();
                float y = input.readFloat();
                float scaleX = input.readFloat();
                float scaleY = input.readFloat();
                float width = input.readFloat();
                float height = input.readFloat();
                int color = input.readInt();
                if (path == null) {
                    path = name;
                }
                if ((region = this.attachmentLoader.newRegionAttachment(skin, name, path)) == null) {
                    return null;
                }
                region.setPath(path);
                region.setX(x * scale);
                region.setY(y * scale);
                region.setScaleX(scaleX);
                region.setScaleY(scaleY);
                region.setRotation(rotation);
                region.setWidth(width * scale);
                region.setHeight(height * scale);
                Color.rgba8888ToColor(region.getColor(), color);
                region.updateOffset();
                return region;
            }
            case boundingbox: {
                int vertexCount = input.readInt(true);
                Vertices vertices = this.readVertices(input, vertexCount);
                int color = nonessential ? input.readInt() : 0;
                BoundingBoxAttachment box = this.attachmentLoader.newBoundingBoxAttachment(skin, name);
                if (box == null) {
                    return null;
                }
                box.setWorldVerticesLength(vertexCount << 1);
                box.setVertices(vertices.vertices);
                box.setBones(vertices.bones);
                if (nonessential) {
                    Color.rgba8888ToColor(box.getColor(), color);
                }
                return box;
            }
            case mesh: {
                MeshAttachment mesh;
                String path = input.readStringRef();
                int color = input.readInt();
                int vertexCount = input.readInt(true);
                float[] uvs = this.readFloatArray(input, vertexCount << 1, 1.0f);
                short[] triangles = this.readShortArray(input);
                Vertices vertices = this.readVertices(input, vertexCount);
                int hullLength = input.readInt(true);
                short[] edges = null;
                float width = 0.0f;
                float height = 0.0f;
                if (nonessential) {
                    edges = this.readShortArray(input);
                    width = input.readFloat();
                    height = input.readFloat();
                }
                if (path == null) {
                    path = name;
                }
                if ((mesh = this.attachmentLoader.newMeshAttachment(skin, name, path)) == null) {
                    return null;
                }
                mesh.setPath(path);
                Color.rgba8888ToColor(mesh.getColor(), color);
                mesh.setBones(vertices.bones);
                mesh.setVertices(vertices.vertices);
                mesh.setWorldVerticesLength(vertexCount << 1);
                mesh.setTriangles(triangles);
                mesh.setRegionUVs(uvs);
                mesh.updateUVs();
                mesh.setHullLength(hullLength << 1);
                if (nonessential) {
                    mesh.setEdges(edges);
                    mesh.setWidth(width * scale);
                    mesh.setHeight(height * scale);
                }
                return mesh;
            }
            case linkedmesh: {
                MeshAttachment mesh;
                String path = input.readStringRef();
                int color = input.readInt();
                String skinName = input.readStringRef();
                String parent = input.readStringRef();
                boolean inheritDeform = input.readBoolean();
                float width = 0.0f;
                float height = 0.0f;
                if (nonessential) {
                    width = input.readFloat();
                    height = input.readFloat();
                }
                if (path == null) {
                    path = name;
                }
                if ((mesh = this.attachmentLoader.newMeshAttachment(skin, name, path)) == null) {
                    return null;
                }
                mesh.setPath(path);
                Color.rgba8888ToColor(mesh.getColor(), color);
                if (nonessential) {
                    mesh.setWidth(width * scale);
                    mesh.setHeight(height * scale);
                }
                this.linkedMeshes.add(new SkeletonJson.LinkedMesh(mesh, skinName, slotIndex, parent, inheritDeform));
                return mesh;
            }
            case path: {
                boolean closed = input.readBoolean();
                boolean constantSpeed = input.readBoolean();
                int vertexCount = input.readInt(true);
                Vertices vertices = this.readVertices(input, vertexCount);
                float[] lengths = new float[vertexCount / 3];
                int i = 0;
                int n = lengths.length;
                while (i < n) {
                    lengths[i] = input.readFloat() * scale;
                    ++i;
                }
                int color = nonessential ? input.readInt() : 0;
                PathAttachment path = this.attachmentLoader.newPathAttachment(skin, name);
                if (path == null) {
                    return null;
                }
                path.setClosed(closed);
                path.setConstantSpeed(constantSpeed);
                path.setWorldVerticesLength(vertexCount << 1);
                path.setVertices(vertices.vertices);
                path.setBones(vertices.bones);
                path.setLengths(lengths);
                if (nonessential) {
                    Color.rgba8888ToColor(path.getColor(), color);
                }
                return path;
            }
            case point: {
                float rotation = input.readFloat();
                float x = input.readFloat();
                float y = input.readFloat();
                int color = nonessential ? input.readInt() : 0;
                PointAttachment point = this.attachmentLoader.newPointAttachment(skin, name);
                if (point == null) {
                    return null;
                }
                point.setX(x * scale);
                point.setY(y * scale);
                point.setRotation(rotation);
                if (nonessential) {
                    Color.rgba8888ToColor(point.getColor(), color);
                }
                return point;
            }
            case clipping: {
                int endSlotIndex = input.readInt(true);
                int vertexCount = input.readInt(true);
                Vertices vertices = this.readVertices(input, vertexCount);
                int color = nonessential ? input.readInt() : 0;
                ClippingAttachment clip = this.attachmentLoader.newClippingAttachment(skin, name);
                if (clip == null) {
                    return null;
                }
                clip.setEndSlot(skeletonData.slots.get(endSlotIndex));
                clip.setWorldVerticesLength(vertexCount << 1);
                clip.setVertices(vertices.vertices);
                clip.setBones(vertices.bones);
                if (nonessential) {
                    Color.rgba8888ToColor(clip.getColor(), color);
                }
                return clip;
            }
        }
        return null;
    }

    private Vertices readVertices(SkeletonInput input, int vertexCount) throws IOException {
        float scale = this.scale;
        int verticesLength = vertexCount << 1;
        Vertices vertices = new Vertices();
        if (!input.readBoolean()) {
            vertices.vertices = this.readFloatArray(input, verticesLength, scale);
            return vertices;
        }
        FloatArray weights = new FloatArray(verticesLength * 3 * 3);
        IntArray bonesArray = new IntArray(verticesLength * 3);
        int i = 0;
        while (i < vertexCount) {
            int boneCount = input.readInt(true);
            bonesArray.add(boneCount);
            int ii = 0;
            while (ii < boneCount) {
                bonesArray.add(input.readInt(true));
                weights.add(input.readFloat() * scale);
                weights.add(input.readFloat() * scale);
                weights.add(input.readFloat());
                ++ii;
            }
            ++i;
        }
        vertices.vertices = weights.toArray();
        vertices.bones = bonesArray.toArray();
        return vertices;
    }

    private float[] readFloatArray(SkeletonInput input, int n, float scale) throws IOException {
        float[] array = new float[n];
        if (scale == 1.0f) {
            int i = 0;
            while (i < n) {
                array[i] = input.readFloat();
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                array[i] = input.readFloat() * scale;
                ++i;
            }
        }
        return array;
    }

    private short[] readShortArray(SkeletonInput input) throws IOException {
        int n = input.readInt(true);
        short[] array = new short[n];
        int i = 0;
        while (i < n) {
            array[i] = input.readShort();
            ++i;
        }
        return array;
    }

    private Animation readAnimation(SkeletonInput input, String name, SkeletonData skeletonData) throws IOException {
        int eventCount;
        int frameLast;
        int frameCount;
        int index;
        int nn;
        int ii;
        Array<Animation.Timeline> timelines = new Array<Animation.Timeline>(input.readInt(true));
        float scale = this.scale;
        int i = 0;
        int n = input.readInt(true);
        while (i < n) {
            int slotIndex = input.readInt(true);
            ii = 0;
            nn = input.readInt(true);
            while (ii < nn) {
                byte timelineType = input.readByte();
                int frameCount2 = input.readInt(true);
                int frameLast2 = frameCount2 - 1;
                switch (timelineType) {
                    case 0: {
                        Animation.Timeline timeline = new Animation.AttachmentTimeline(frameCount2, slotIndex);
                        int frame = 0;
                        while (frame < frameCount2) {
                            ((Animation.AttachmentTimeline)timeline).setFrame(frame, input.readFloat(), input.readStringRef());
                            ++frame;
                        }
                        timelines.add(timeline);
                        break;
                    }
                    case 1: {
                        Animation.Timeline timeline = new Animation.ColorTimeline(frameCount2, input.readInt(true), slotIndex);
                        float time = input.readFloat();
                        float r = (float)input.read() / 255.0f;
                        float g = (float)input.read() / 255.0f;
                        float b = (float)input.read() / 255.0f;
                        float a = (float)input.read() / 255.0f;
                        int frame = 0;
                        int bezier = 0;
                        while (true) {
                            ((Animation.ColorTimeline)timeline).setFrame(frame, time, r, g, b, a);
                            if (frame == frameLast2) break;
                            float time2 = input.readFloat();
                            float r2 = (float)input.read() / 255.0f;
                            float g2 = (float)input.read() / 255.0f;
                            float b2 = (float)input.read() / 255.0f;
                            float a2 = (float)input.read() / 255.0f;
                            switch (input.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(frame);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 0, time, time2, r, r2, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 1, time, time2, g, g2, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 2, time, time2, b, b2, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 3, time, time2, a, a2, 1.0f);
                                }
                            }
                            time = time2;
                            r = r2;
                            g = g2;
                            b = b2;
                            a = a2;
                            ++frame;
                        }
                        timelines.add(timeline);
                        break;
                    }
                    case 2: {
                        Animation.Timeline timeline = new Animation.TwoColorTimeline(frameCount2, input.readInt(true), slotIndex);
                        float time = input.readFloat();
                        float r = (float)input.read() / 255.0f;
                        float g = (float)input.read() / 255.0f;
                        float b = (float)input.read() / 255.0f;
                        float a = (float)input.read() / 255.0f;
                        float r2 = (float)input.read() / 255.0f;
                        float g2 = (float)input.read() / 255.0f;
                        float b2 = (float)input.read() / 255.0f;
                        int frame = 0;
                        int bezier = 0;
                        while (true) {
                            ((Animation.TwoColorTimeline)timeline).setFrame(frame, time, r, g, b, a, r2, g2, b2);
                            if (frame == frameLast2) break;
                            float time2 = input.readFloat();
                            float nr = (float)input.read() / 255.0f;
                            float ng = (float)input.read() / 255.0f;
                            float nb = (float)input.read() / 255.0f;
                            float na = (float)input.read() / 255.0f;
                            float nr2 = (float)input.read() / 255.0f;
                            float ng2 = (float)input.read() / 255.0f;
                            float nb2 = (float)input.read() / 255.0f;
                            switch (input.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(frame);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 0, time, time2, r, nr, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 1, time, time2, g, ng, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 2, time, time2, b, nb, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 3, time, time2, a, na, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 4, time, time2, r2, nr2, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 5, time, time2, g2, ng2, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 6, time, time2, b2, nb2, 1.0f);
                                }
                            }
                            time = time2;
                            r = nr;
                            g = ng;
                            b = nb;
                            a = na;
                            r2 = nr2;
                            g2 = ng2;
                            b2 = nb2;
                            ++frame;
                        }
                        timelines.add(timeline);
                    }
                }
                ++ii;
            }
            ++i;
        }
        i = 0;
        n = input.readInt(true);
        while (i < n) {
            int boneIndex = input.readInt(true);
            ii = 0;
            nn = input.readInt(true);
            while (ii < nn) {
                switch (input.readByte()) {
                    case 0: {
                        timelines.add(this.readTimeline(input, new Animation.RotateTimeline(input.readInt(true), input.readInt(true), boneIndex), 1.0f));
                        break;
                    }
                    case 1: {
                        timelines.add(this.readTimeline(input, new Animation.TranslateTimeline(input.readInt(true), input.readInt(true), boneIndex), scale));
                        break;
                    }
                    case 2: {
                        timelines.add(this.readTimeline(input, new Animation.ScaleTimeline(input.readInt(true), input.readInt(true), boneIndex), 1.0f));
                        break;
                    }
                    case 3: {
                        timelines.add(this.readTimeline(input, new Animation.ShearTimeline(input.readInt(true), input.readInt(true), boneIndex), 1.0f));
                    }
                }
                ++ii;
            }
            ++i;
        }
        i = 0;
        n = input.readInt(true);
        while (i < n) {
            index = input.readInt(true);
            frameCount = input.readInt(true);
            frameLast = frameCount - 1;
            Animation.IkConstraintTimeline timeline = new Animation.IkConstraintTimeline(frameCount, input.readInt(true), index);
            float time = input.readFloat();
            float mix = input.readFloat();
            float softness = input.readFloat() * scale;
            int frame = 0;
            int bezier = 0;
            while (true) {
                timeline.setFrame(frame, time, mix, softness, input.readByte(), input.readBoolean(), input.readBoolean());
                if (frame == frameLast) break;
                float time2 = input.readFloat();
                float mix2 = input.readFloat();
                float softness2 = input.readFloat() * scale;
                switch (input.readByte()) {
                    case 1: {
                        timeline.setStepped(frame);
                        break;
                    }
                    case 2: {
                        this.setBezier(input, timeline, bezier++, frame, 0, time, time2, mix, mix2, 1.0f);
                        this.setBezier(input, timeline, bezier++, frame, 1, time, time2, softness, softness2, scale);
                    }
                }
                time = time2;
                mix = mix2;
                softness = softness2;
                ++frame;
            }
            timelines.add(timeline);
            ++i;
        }
        i = 0;
        n = input.readInt(true);
        while (i < n) {
            index = input.readInt(true);
            frameCount = input.readInt(true);
            frameLast = frameCount - 1;
            Animation.TransformConstraintTimeline timeline = new Animation.TransformConstraintTimeline(frameCount, input.readInt(true), index);
            float time = input.readFloat();
            float rotateMix = input.readFloat();
            float translateMix = input.readFloat();
            float scaleMix = input.readFloat();
            float shearMix = input.readFloat();
            int frame = 0;
            int bezier = 0;
            while (true) {
                timeline.setFrame(frame, time, rotateMix, translateMix, scaleMix, shearMix);
                if (frame == frameLast) break;
                float time2 = input.readFloat();
                float rotateMix2 = input.readFloat();
                float translateMix2 = input.readFloat();
                float scaleMix2 = input.readFloat();
                float shearMix2 = input.readFloat();
                switch (input.readByte()) {
                    case 1: {
                        timeline.setStepped(frame);
                        break;
                    }
                    case 2: {
                        this.setBezier(input, timeline, bezier++, frame, 0, time, time2, rotateMix, rotateMix2, 1.0f);
                        this.setBezier(input, timeline, bezier++, frame, 1, time, time2, translateMix, translateMix2, 1.0f);
                        this.setBezier(input, timeline, bezier++, frame, 2, time, time2, scaleMix, scaleMix2, 1.0f);
                        this.setBezier(input, timeline, bezier++, frame, 3, time, time2, shearMix, shearMix2, 1.0f);
                    }
                }
                time = time2;
                rotateMix = rotateMix2;
                translateMix = translateMix2;
                scaleMix = scaleMix2;
                shearMix = shearMix2;
                ++frame;
            }
            timelines.add(timeline);
            ++i;
        }
        i = 0;
        n = input.readInt(true);
        while (i < n) {
            index = input.readInt(true);
            PathConstraintData data = skeletonData.pathConstraints.get(index);
            int ii2 = 0;
            int nn2 = input.readInt(true);
            while (ii2 < nn2) {
                switch (input.readByte()) {
                    case 0: {
                        timelines.add(this.readTimeline(input, new Animation.PathConstraintPositionTimeline(input.readInt(true), input.readInt(true), index), data.positionMode == PathConstraintData.PositionMode.fixed ? scale : 1.0f));
                        break;
                    }
                    case 1: {
                        timelines.add(this.readTimeline(input, new Animation.PathConstraintSpacingTimeline(input.readInt(true), input.readInt(true), index), data.spacingMode == PathConstraintData.SpacingMode.length || data.spacingMode == PathConstraintData.SpacingMode.fixed ? scale : 1.0f));
                        break;
                    }
                    case 2: {
                        timelines.add(this.readTimeline(input, new Animation.PathConstraintMixTimeline(input.readInt(true), input.readInt(true), index), 1.0f));
                    }
                }
                ++ii2;
            }
            ++i;
        }
        i = 0;
        n = input.readInt(true);
        while (i < n) {
            Skin skin = skeletonData.skins.get(input.readInt(true));
            int ii3 = 0;
            nn = input.readInt(true);
            while (ii3 < nn) {
                int slotIndex = input.readInt(true);
                int iii = 0;
                int nnn = input.readInt(true);
                while (iii < nnn) {
                    String attachmentName = input.readStringRef();
                    VertexAttachment attachment = (VertexAttachment)skin.getAttachment(slotIndex, attachmentName);
                    if (attachment == null) {
                        throw new SerializationException("Vertex attachment not found: " + attachmentName);
                    }
                    boolean weighted = attachment.getBones() != null;
                    float[] vertices = attachment.getVertices();
                    int deformLength = weighted ? vertices.length / 3 << 1 : vertices.length;
                    int frameCount3 = input.readInt(true);
                    int frameLast3 = frameCount3 - 1;
                    Animation.DeformTimeline timeline = new Animation.DeformTimeline(frameCount3, input.readInt(true), slotIndex, attachment);
                    float time = input.readFloat();
                    int frame = 0;
                    int bezier = 0;
                    while (true) {
                        float[] deform;
                        int end;
                        if ((end = input.readInt(true)) == 0) {
                            deform = weighted ? new float[deformLength] : vertices;
                        } else {
                            int v;
                            deform = new float[deformLength];
                            int start = input.readInt(true);
                            end += start;
                            if (scale == 1.0f) {
                                v = start;
                                while (v < end) {
                                    deform[v] = input.readFloat();
                                    ++v;
                                }
                            } else {
                                v = start;
                                while (v < end) {
                                    deform[v] = input.readFloat() * scale;
                                    ++v;
                                }
                            }
                            if (!weighted) {
                                v = 0;
                                int vn = deform.length;
                                while (v < vn) {
                                    int n2 = v;
                                    deform[n2] = deform[n2] + vertices[v];
                                    ++v;
                                }
                            }
                        }
                        timeline.setFrame(frame, time, deform);
                        if (frame == frameLast3) break;
                        float time2 = input.readFloat();
                        switch (input.readByte()) {
                            case 1: {
                                timeline.setStepped(frame);
                                break;
                            }
                            case 2: {
                                this.setBezier(input, timeline, bezier++, frame, 0, time, time2, 0.0f, 1.0f, 1.0f);
                            }
                        }
                        time = time2;
                        ++frame;
                    }
                    timelines.add(timeline);
                    ++iii;
                }
                ++ii3;
            }
            ++i;
        }
        int drawOrderCount = input.readInt(true);
        if (drawOrderCount > 0) {
            Animation.DrawOrderTimeline timeline = new Animation.DrawOrderTimeline(drawOrderCount);
            int slotCount = skeletonData.slots.size;
            int i2 = 0;
            while (i2 < drawOrderCount) {
                float time = input.readFloat();
                int offsetCount = input.readInt(true);
                int[] drawOrder = new int[slotCount];
                int ii4 = slotCount - 1;
                while (ii4 >= 0) {
                    drawOrder[ii4] = -1;
                    --ii4;
                }
                int[] unchanged = new int[slotCount - offsetCount];
                int originalIndex = 0;
                int unchangedIndex = 0;
                int ii5 = 0;
                while (ii5 < offsetCount) {
                    int slotIndex = input.readInt(true);
                    while (originalIndex != slotIndex) {
                        unchanged[unchangedIndex++] = originalIndex++;
                    }
                    drawOrder[originalIndex + input.readInt((boolean)true)] = originalIndex++;
                    ++ii5;
                }
                while (originalIndex < slotCount) {
                    unchanged[unchangedIndex++] = originalIndex++;
                }
                ii5 = slotCount - 1;
                while (ii5 >= 0) {
                    if (drawOrder[ii5] == -1) {
                        drawOrder[ii5] = unchanged[--unchangedIndex];
                    }
                    --ii5;
                }
                timeline.setFrame(i2, time, drawOrder);
                ++i2;
            }
            timelines.add(timeline);
        }
        if ((eventCount = input.readInt(true)) > 0) {
            Animation.EventTimeline timeline = new Animation.EventTimeline(eventCount);
            int i3 = 0;
            while (i3 < eventCount) {
                float time = input.readFloat();
                EventData eventData = skeletonData.events.get(input.readInt(true));
                Event event = new Event(time, eventData);
                event.intValue = input.readInt(false);
                event.floatValue = input.readFloat();
                String string = event.stringValue = input.readBoolean() ? input.readString() : eventData.stringValue;
                if (event.getData().audioPath != null) {
                    event.volume = input.readFloat();
                    event.balance = input.readFloat();
                }
                timeline.setFrame(i3, event);
                ++i3;
            }
            timelines.add(timeline);
        }
        float duration = 0.0f;
        T[] items = timelines.items;
        int i4 = 0;
        int n3 = timelines.size;
        while (i4 < n3) {
            duration = Math.max(duration, ((Animation.Timeline)items[i4]).getDuration());
            ++i4;
        }
        return new Animation(name, timelines, duration);
    }

    private Animation.Timeline readTimeline(SkeletonInput input, Animation.CurveTimeline1 timeline, float scale) throws IOException {
        float time = input.readFloat();
        float value = input.readFloat() * scale;
        int frame = 0;
        int bezier = 0;
        int frameLast = timeline.getFrameCount() - 1;
        while (true) {
            timeline.setFrame(frame, time, value);
            if (frame == frameLast) break;
            float time2 = input.readFloat();
            float value2 = input.readFloat() * scale;
            switch (input.readByte()) {
                case 1: {
                    timeline.setStepped(frame);
                    break;
                }
                case 2: {
                    this.setBezier(input, timeline, bezier++, frame, 0, time, time2, value, value2, 1.0f);
                }
            }
            time = time2;
            value = value2;
            ++frame;
        }
        return timeline;
    }

    private Animation.Timeline readTimeline(SkeletonInput input, Animation.CurveTimeline2 timeline, float scale) throws IOException {
        float time = input.readFloat();
        float value1 = input.readFloat() * scale;
        float value2 = input.readFloat() * scale;
        int frame = 0;
        int bezier = 0;
        int frameLast = timeline.getFrameCount() - 1;
        while (true) {
            timeline.setFrame(frame, time, value1, value2);
            if (frame == frameLast) break;
            float time2 = input.readFloat();
            float nvalue1 = input.readFloat() * scale;
            float nvalue2 = input.readFloat() * scale;
            switch (input.readByte()) {
                case 1: {
                    timeline.setStepped(frame);
                    break;
                }
                case 2: {
                    this.setBezier(input, timeline, bezier++, frame, 0, time, time2, value1, nvalue1, scale);
                    this.setBezier(input, timeline, bezier++, frame, 1, time, time2, value2, nvalue2, scale);
                }
            }
            time = time2;
            value1 = nvalue1;
            value2 = nvalue2;
            ++frame;
        }
        return timeline;
    }

    void setBezier(SkeletonInput input, Animation.CurveTimeline timeline, int bezier, int frame, int value, float time1, float time2, float value1, float value2, float scale) throws IOException {
        timeline.setBezier(bezier, frame, value, time1, value1, input.readFloat(), input.readFloat() * scale, input.readFloat(), input.readFloat() * scale, time2, value2);
    }

    static class SkeletonInput
    extends DataInput {
        private char[] chars = new char[32];
        String[] strings;

        public SkeletonInput(FileHandle file) {
            super(file.read(512));
        }

        @Null
        public String readStringRef() throws IOException {
            int index = this.readInt(true);
            return index == 0 ? null : this.strings[index - 1];
        }

        @Override
        public String readString() throws IOException {
            int byteCount = this.readInt(true);
            switch (byteCount) {
                case 0: {
                    return null;
                }
                case 1: {
                    return "";
                }
            }
            if (this.chars.length < --byteCount) {
                this.chars = new char[byteCount];
            }
            char[] chars = this.chars;
            int charCount = 0;
            int i = 0;
            while (i < byteCount) {
                int b = this.read();
                switch (b >> 4) {
                    case -1: {
                        throw new EOFException();
                    }
                    case 12: 
                    case 13: {
                        chars[charCount++] = (char)((b & 0x1F) << 6 | this.read() & 0x3F);
                        i += 2;
                        break;
                    }
                    case 14: {
                        chars[charCount++] = (char)((b & 0xF) << 12 | (this.read() & 0x3F) << 6 | this.read() & 0x3F);
                        i += 3;
                        break;
                    }
                    default: {
                        chars[charCount++] = (char)b;
                        ++i;
                    }
                }
            }
            return new String(chars, 0, charCount);
        }
    }

    static class Vertices {
        int[] bones;
        float[] vertices;

        Vertices() {
        }
    }
}

