/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import grails.gorm.DetachedCriteria;
import grails.orm.HibernateCriteriaBuilder;
import groovy.lang.Closure;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.metaclass.AbstractStaticMethodInvocation;
import org.codehaus.groovy.grails.orm.hibernate.GrailsHibernateTemplate;
import org.codehaus.groovy.grails.orm.hibernate.HibernateDatastore;
import org.codehaus.groovy.grails.orm.hibernate.HibernateSession;
import org.codehaus.groovy.grails.orm.hibernate.query.HibernateQuery;
import org.grails.datastore.gorm.finders.DynamicFinder;
import org.grails.datastore.gorm.finders.FinderMethod;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.query.Query;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStaticPersistentMethod
extends AbstractStaticMethodInvocation
implements FinderMethod {
    private ClassLoader classLoader;
    private GrailsHibernateTemplate hibernateTemplate;
    protected final GrailsApplication application;

    protected AbstractStaticPersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader, Pattern pattern, GrailsApplication application) {
        Assert.notNull((Object)sessionFactory, (String)"Session factory is required!");
        this.setPattern(pattern);
        this.classLoader = classLoader;
        Assert.notNull((Object)application, (String)"Constructor argument 'application' cannot be null");
        this.application = application;
        this.hibernateTemplate = new GrailsHibernateTemplate(sessionFactory, application);
    }

    protected GrailsHibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    public Object invoke(Class clazz, String methodName, Object[] arguments) {
        return this.invoke(clazz, methodName, (Closure)null, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Class clazz, String methodName, Closure additionalCriteria, Object[] arguments) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Object object = this.doInvokeInternal(clazz, methodName, additionalCriteria, arguments);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Class clazz, String methodName, DetachedCriteria additionalCriteria, Object[] arguments) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Object object = this.doInvokeInternal(clazz, methodName, additionalCriteria, arguments);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    protected Criteria getCriteria(HibernateDatastore datastore, GrailsApplication appliation, Session session, DetachedCriteria detachedCriteria, Closure additionalCriteria, Class<?> clazz) {
        if (additionalCriteria != null) {
            HibernateCriteriaBuilder builder = new HibernateCriteriaBuilder(clazz, session.getSessionFactory());
            builder.setGrailsApplication(appliation);
            return builder.buildCriteria(additionalCriteria);
        }
        Criteria criteria = session.createCriteria(clazz);
        if (detachedCriteria != null) {
            HibernateSession hibernateSession = new HibernateSession(datastore, session.getSessionFactory());
            PersistentEntity persistentEntity = datastore.getMappingContext().getPersistentEntity(clazz.getName());
            if (persistentEntity != null) {
                DynamicFinder.applyDetachedCriteria((Query)new HibernateQuery(criteria, hibernateSession, persistentEntity), (DetachedCriteria)detachedCriteria);
            }
        }
        this.hibernateTemplate.applySettings(criteria);
        return criteria;
    }

    protected abstract Object doInvokeInternal(Class var1, String var2, Closure var3, Object[] var4);

    protected abstract Object doInvokeInternal(Class var1, String var2, DetachedCriteria var3, Object[] var4);
}

