/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.query;

import grails.orm.HibernateCriteriaBuilder;
import grails.orm.RlikeExpression;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.FetchType;
import org.codehaus.groovy.grails.orm.hibernate.HibernateSession;
import org.codehaus.groovy.grails.orm.hibernate.query.HibernateCriterionAdapter;
import org.codehaus.groovy.grails.orm.hibernate.query.HibernateProjectionAdapter;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.query.AssociationQuery;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.ProjectionList;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.query.criteria.FunctionCallingCriterion;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateQuery
extends Query {
    public static final String SIZE_CONSTRAINT_PREFIX = "Size";
    private Criteria criteria;
    private HibernateProjectionList hibernateProjectionList = null;
    private String alias;
    private int aliasCount;
    private Map<String, CriteriaAndAlias> createdAssociationPaths = new HashMap<String, CriteriaAndAlias>();
    private static final String ALIAS = "_alias";
    private static Field opField = ReflectionUtils.findField(SimpleExpression.class, (String)"op");
    private static ConversionService conversionService = new DefaultConversionService();

    public HibernateQuery(Criteria criteria, HibernateSession session, PersistentEntity entity) {
        super((Session)session, entity);
        this.criteria = criteria;
        ReflectionUtils.makeAccessible((Field)opField);
    }

    public HibernateQuery(Criteria subCriteria, HibernateSession session, PersistentEntity associatedEntity, String newAlias) {
        this(subCriteria, session, associatedEntity);
        this.alias = newAlias;
    }

    public Query isEmpty(String property) {
        Criterion criterion = Restrictions.isEmpty((String)this.calculatePropertyName(property));
        this.addToCriteria(criterion);
        return this;
    }

    public Query isNotEmpty(String property) {
        this.addToCriteria(Restrictions.isNotEmpty((String)this.calculatePropertyName(property)));
        return this;
    }

    public Query isNull(String property) {
        this.addToCriteria(Restrictions.isNull((String)this.calculatePropertyName(property)));
        return this;
    }

    public Query isNotNull(String property) {
        this.addToCriteria(Restrictions.isNotNull((String)this.calculatePropertyName(property)));
        return this;
    }

    public void add(Query.Criterion criterion) {
        if (criterion instanceof FunctionCallingCriterion) {
            Criterion sqlRestriction = this.getRestrictionForFunctionCall((FunctionCallingCriterion)criterion, this.entity);
            if (sqlRestriction != null) {
                this.addToCriteria(sqlRestriction);
            }
        } else if (criterion instanceof Query.PropertyCriterion) {
            Query.PropertyCriterion pc = (Query.PropertyCriterion)criterion;
            Object value = pc.getValue();
            if (value instanceof QueryableCriteria) {
                DetachedCriteria hibernateDetachedCriteria = HibernateCriteriaBuilder.getHibernateDetachedCriteria((QueryableCriteria)value);
                pc.setValue((Object)hibernateDetachedCriteria);
            } else {
                HibernateQuery.doTypeConversionIfNeccessary(this.getEntity(), pc);
            }
        }
        Criterion hibernateCriterion = new HibernateCriterionAdapter(this.getEntity(), criterion, this.alias).toHibernateCriterion(this);
        if (hibernateCriterion != null) {
            this.addToCriteria(hibernateCriterion);
        }
    }

    static void doTypeConversionIfNeccessary(PersistentEntity entity, Query.PropertyCriterion pc) {
        if (!pc.getClass().getSimpleName().startsWith(SIZE_CONSTRAINT_PREFIX)) {
            String property = pc.getProperty();
            Object value = pc.getValue();
            PersistentProperty p = entity.getPropertyByName(property);
            if (p != null && !p.getType().isInstance(value)) {
                pc.setValue(conversionService.convert(value, p.getType()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Criterion getRestrictionForFunctionCall(FunctionCallingCriterion criterion, PersistentEntity entity) {
        HibernateTemplate hibernateSession = (HibernateTemplate)this.session.getNativeInterface();
        SessionFactory sessionFactory = hibernateSession.getSessionFactory();
        String property = criterion.getProperty();
        Query.PropertyCriterion datastoreCriterion = criterion.getPropertyCriterion();
        PersistentProperty pp = entity.getPropertyByName(property);
        if (pp == null) {
            throw new InvalidDataAccessResourceUsageException("Cannot execute function defined in query [" + criterion.getFunctionName() + "] on non-existent property [" + property + "] of [" + entity.getJavaClass() + "]");
        }
        String functionName = criterion.getFunctionName();
        SessionFactoryImplementor impl = (SessionFactoryImplementor)sessionFactory;
        Dialect dialect = impl.getDialect();
        SQLFunction sqlFunction = (SQLFunction)dialect.getFunctions().get(functionName);
        if (sqlFunction == null) throw new InvalidDataAccessResourceUsageException("Unsupported function defined in query [" + functionName + "]");
        TypeResolver typeResolver = impl.getTypeResolver();
        BasicType basic = typeResolver.basic(pp.getType().getName());
        if (basic == null) throw new InvalidDataAccessResourceUsageException("Unsupported function [" + functionName + "] defined in query for property [" + property + "] with type [" + pp.getType() + "]");
        if (!(datastoreCriterion instanceof Query.PropertyCriterion)) throw new InvalidDataAccessResourceUsageException("Unsupported function [" + functionName + "] defined in query for property [" + property + "] with type [" + pp.getType() + "]");
        Query.PropertyCriterion pc = datastoreCriterion;
        Criterion hibernateCriterion = new HibernateCriterionAdapter(this.getEntity(), (Query.Criterion)datastoreCriterion, this.alias).toHibernateCriterion(this);
        if (!(hibernateCriterion instanceof SimpleExpression)) throw new InvalidDataAccessResourceUsageException("Unsupported function [" + functionName + "] defined in query for property [" + property + "] with type [" + pp.getType() + "]");
        SimpleExpression expr = (SimpleExpression)hibernateCriterion;
        Object op = ReflectionUtils.getField((Field)opField, (Object)expr);
        PropertyMapping mapping = (PropertyMapping)impl.getEntityPersister(entity.getJavaClass().getName());
        String[] columns = this.alias != null ? mapping.toColumns(this.alias, property) : mapping.toColumns(property);
        String root = sqlFunction.render((Type)basic, Arrays.asList(columns), impl);
        Object value = pc.getValue();
        if (value == null) return Restrictions.sqlRestriction((String)(root + op + "?"), (Object)value, (Type)basic);
        return Restrictions.sqlRestriction((String)(root + op + "?"), (Object)value, (Type)typeResolver.basic(value.getClass().getName()));
    }

    public Query.Junction disjunction() {
        Disjunction disjunction = Restrictions.disjunction();
        this.addToCriteria((Criterion)disjunction);
        return new HibernateJunction((Junction)disjunction, this.alias);
    }

    public Query.Junction negation() {
        Disjunction disjunction = Restrictions.disjunction();
        this.addToCriteria(Restrictions.not((Criterion)disjunction));
        return new HibernateJunction((Junction)disjunction, this.alias);
    }

    public Query eq(String property, Object value) {
        this.addToCriteria((Criterion)Restrictions.eq((String)this.calculatePropertyName(property), (Object)value));
        return this;
    }

    public Query idEq(Object value) {
        this.addToCriteria(Restrictions.idEq((Object)value));
        return this;
    }

    public Query gt(String property, Object value) {
        this.addToCriteria((Criterion)Restrictions.gt((String)this.calculatePropertyName(property), (Object)value));
        return this;
    }

    public Query and(Query.Criterion a, Query.Criterion b) {
        HibernateCriterionAdapter aa = new HibernateCriterionAdapter(this.getEntity(), a, this.alias);
        HibernateCriterionAdapter ab = new HibernateCriterionAdapter(this.getEntity(), a, this.alias);
        this.addToCriteria((Criterion)Restrictions.and((Criterion)aa.toHibernateCriterion(this), (Criterion)ab.toHibernateCriterion(this)));
        return this;
    }

    public Query or(Query.Criterion a, Query.Criterion b) {
        HibernateCriterionAdapter aa = new HibernateCriterionAdapter(this.getEntity(), a, this.alias);
        HibernateCriterionAdapter ab = new HibernateCriterionAdapter(this.getEntity(), a, this.alias);
        this.addToCriteria((Criterion)Restrictions.or((Criterion)aa.toHibernateCriterion(this), (Criterion)ab.toHibernateCriterion(this)));
        return this;
    }

    public Query allEq(Map<String, Object> values) {
        this.addToCriteria(Restrictions.allEq(values));
        return this;
    }

    public Query ge(String property, Object value) {
        this.addToCriteria((Criterion)Restrictions.ge((String)this.calculatePropertyName(property), (Object)value));
        return this;
    }

    public Query le(String property, Object value) {
        this.addToCriteria((Criterion)Restrictions.le((String)this.calculatePropertyName(property), (Object)value));
        return this;
    }

    public Query gte(String property, Object value) {
        this.addToCriteria((Criterion)Restrictions.ge((String)this.calculatePropertyName(property), (Object)value));
        return this;
    }

    public Query lte(String property, Object value) {
        this.addToCriteria((Criterion)Restrictions.le((String)this.calculatePropertyName(property), (Object)value));
        return this;
    }

    public Query lt(String property, Object value) {
        this.addToCriteria((Criterion)Restrictions.lt((String)this.calculatePropertyName(property), (Object)value));
        return this;
    }

    public Query in(String property, List values) {
        this.addToCriteria(Restrictions.in((String)this.calculatePropertyName(property), (Collection)values));
        return this;
    }

    public Query between(String property, Object start, Object end) {
        this.addToCriteria(Restrictions.between((String)this.calculatePropertyName(property), (Object)start, (Object)end));
        return this;
    }

    public Query like(String property, String expr) {
        this.addToCriteria((Criterion)Restrictions.like((String)this.calculatePropertyName(property), (Object)this.calculatePropertyName(expr)));
        return this;
    }

    public Query ilike(String property, String expr) {
        this.addToCriteria(Restrictions.ilike((String)this.calculatePropertyName(property), (Object)this.calculatePropertyName(expr)));
        return this;
    }

    public Query rlike(String property, String expr) {
        this.addToCriteria(new RlikeExpression(this.calculatePropertyName(property), this.calculatePropertyName(expr)));
        return this;
    }

    public AssociationQuery createQuery(String associationName) {
        PersistentProperty property = this.entity.getPropertyByName(this.calculatePropertyName(associationName));
        if (property != null && property instanceof Association) {
            String alias = this.generateAlias(associationName);
            CriteriaAndAlias subCriteria = this.getOrCreateAlias(associationName, alias);
            Association association = (Association)property;
            return new HibernateAssociationQuery(subCriteria.criteria, (HibernateSession)this.getSession(), association.getAssociatedEntity(), association, alias);
        }
        throw new InvalidDataAccessApiUsageException("Cannot query association [" + this.calculatePropertyName(associationName) + "] of entity [" + this.entity + "]. Property is not an association!");
    }

    private CriteriaAndAlias getOrCreateAlias(String associationName, String alias) {
        CriteriaAndAlias subCriteria;
        if (this.createdAssociationPaths.containsKey(associationName)) {
            subCriteria = this.createdAssociationPaths.get(associationName);
        } else {
            Criteria sc = this.criteria.createAlias(associationName, alias);
            subCriteria = new CriteriaAndAlias(sc, alias);
            this.createdAssociationPaths.put(associationName, subCriteria);
        }
        return subCriteria;
    }

    public Query.ProjectionList projections() {
        if (this.hibernateProjectionList == null) {
            this.hibernateProjectionList = new HibernateProjectionList();
        }
        return this.hibernateProjectionList;
    }

    public Query max(int max) {
        this.criteria.setMaxResults(max);
        return this;
    }

    public Query maxResults(int max) {
        this.criteria.setMaxResults(max);
        return this;
    }

    public Query offset(int offset) {
        this.criteria.setFirstResult(offset);
        return this;
    }

    public Query firstResult(int offset) {
        this.offset(offset);
        return this;
    }

    public Query order(Query.Order order) {
        super.order(order);
        this.criteria.addOrder(order.getDirection() == Query.Order.Direction.ASC ? Order.asc((String)this.calculatePropertyName(order.getProperty())) : Order.desc((String)this.calculatePropertyName(order.getProperty())));
        return this;
    }

    public List list() {
        int projectionLength = 0;
        if (this.hibernateProjectionList != null) {
            org.hibernate.criterion.ProjectionList projectionList = this.hibernateProjectionList.getHibernateProjectionList();
            projectionLength = projectionList.getLength();
            this.criteria.setProjection((Projection)projectionList);
        }
        if (projectionLength < 2) {
            this.criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        }
        this.applyFetchStrategies();
        return this.criteria.list();
    }

    private void applyFetchStrategies() {
        for (Map.Entry entry : this.fetchStrategies.entrySet()) {
            switch ((FetchType)entry.getValue()) {
                case EAGER: {
                    this.criteria.setFetchMode((String)entry.getKey(), FetchMode.JOIN);
                    break;
                }
                case LAZY: {
                    this.criteria.setFetchMode((String)entry.getKey(), FetchMode.SELECT);
                }
            }
        }
    }

    protected void flushBeforeQuery() {
    }

    public Object singleResult() {
        if (this.hibernateProjectionList != null) {
            this.criteria.setProjection((Projection)this.hibernateProjectionList.getHibernateProjectionList());
        }
        this.criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        this.applyFetchStrategies();
        return this.criteria.uniqueResult();
    }

    protected List executeQuery(PersistentEntity entity, Query.Junction criteria) {
        return this.list();
    }

    String handleAssociationQuery(Association<?> association, List<Query.Criterion> criteriaList) {
        String associationName = this.calculatePropertyName(association.getName());
        String newAlias = this.generateAlias(associationName);
        CriteriaAndAlias criteriaAndAlias = this.getOrCreateAlias(associationName, newAlias);
        return criteriaAndAlias.alias;
    }

    private void addToCriteria(Criterion criterion) {
        if (criterion != null) {
            this.criteria.add(criterion);
        }
    }

    private String calculatePropertyName(String property) {
        if (this.alias != null) {
            return this.alias + '.' + property;
        }
        return property;
    }

    private String generateAlias(String associationName) {
        return this.calculatePropertyName(associationName) + this.calculatePropertyName(ALIAS) + this.aliasCount++;
    }

    private class CriteriaAndAlias {
        private Criteria criteria;
        private String alias;

        public CriteriaAndAlias(Criteria subCriteria, String alias) {
            this.criteria = subCriteria;
            this.alias = alias;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HibernateAssociationQuery
    extends AssociationQuery {
        private String alias;
        private Junction hibernateJunction;
        private Criteria assocationCriteria;

        public HibernateAssociationQuery(Criteria criteria, HibernateSession session, PersistentEntity associatedEntity, Association association, String alias) {
            super((Session)session, associatedEntity, association);
            this.alias = alias;
            this.assocationCriteria = criteria;
        }

        public Query isEmpty(String property) {
            Criterion criterion = Restrictions.isEmpty((String)HibernateQuery.this.calculatePropertyName(property));
            this.addToCriteria(criterion);
            return this;
        }

        private void addToCriteria(Criterion criterion) {
            if (this.hibernateJunction != null) {
                this.hibernateJunction.add(criterion);
            } else {
                this.assocationCriteria.add(criterion);
            }
        }

        public Query isNotEmpty(String property) {
            this.addToCriteria(Restrictions.isNotEmpty((String)HibernateQuery.this.calculatePropertyName(property)));
            return this;
        }

        public Query isNull(String property) {
            this.addToCriteria(Restrictions.isNull((String)HibernateQuery.this.calculatePropertyName(property)));
            return this;
        }

        public Query isNotNull(String property) {
            this.addToCriteria(Restrictions.isNotNull((String)HibernateQuery.this.calculatePropertyName(property)));
            return this;
        }

        public void add(Query.Criterion criterion) {
            Criterion hibernateCriterion = new HibernateCriterionAdapter(this.getEntity(), criterion, this.alias).toHibernateCriterion(HibernateQuery.this);
            if (hibernateCriterion != null) {
                this.addToCriteria(hibernateCriterion);
            }
        }

        public Query.Junction disjunction() {
            Disjunction disjunction = Restrictions.disjunction();
            this.addToCriteria((Criterion)disjunction);
            return new HibernateJunction((Junction)disjunction, this.alias);
        }

        public Query.Junction negation() {
            Disjunction disjunction = Restrictions.disjunction();
            this.addToCriteria(Restrictions.not((Criterion)disjunction));
            return new HibernateJunction((Junction)disjunction, this.alias);
        }

        public Query eq(String property, Object value) {
            this.addToCriteria((Criterion)Restrictions.eq((String)HibernateQuery.this.calculatePropertyName(property), (Object)value));
            return this;
        }

        public Query idEq(Object value) {
            this.addToCriteria(Restrictions.idEq((Object)value));
            return this;
        }

        public Query gt(String property, Object value) {
            this.addToCriteria((Criterion)Restrictions.gt((String)HibernateQuery.this.calculatePropertyName(property), (Object)value));
            return this;
        }

        public Query and(Query.Criterion a, Query.Criterion b) {
            HibernateCriterionAdapter aa = new HibernateCriterionAdapter(this.getEntity(), a, this.alias);
            HibernateCriterionAdapter ab = new HibernateCriterionAdapter(this.getEntity(), a, this.alias);
            this.addToCriteria((Criterion)Restrictions.and((Criterion)aa.toHibernateCriterion(HibernateQuery.this), (Criterion)ab.toHibernateCriterion(HibernateQuery.this)));
            return this;
        }

        public Query or(Query.Criterion a, Query.Criterion b) {
            HibernateCriterionAdapter aa = new HibernateCriterionAdapter(this.getEntity(), a, this.alias);
            HibernateCriterionAdapter ab = new HibernateCriterionAdapter(this.getEntity(), a, this.alias);
            this.addToCriteria((Criterion)Restrictions.or((Criterion)aa.toHibernateCriterion(HibernateQuery.this), (Criterion)ab.toHibernateCriterion(HibernateQuery.this)));
            return this;
        }

        public Query allEq(Map<String, Object> values) {
            this.addToCriteria(Restrictions.allEq(values));
            return this;
        }

        public Query ge(String property, Object value) {
            this.addToCriteria((Criterion)Restrictions.ge((String)HibernateQuery.this.calculatePropertyName(property), (Object)value));
            return this;
        }

        public Query le(String property, Object value) {
            this.addToCriteria((Criterion)Restrictions.le((String)HibernateQuery.this.calculatePropertyName(property), (Object)value));
            return this;
        }

        public Query gte(String property, Object value) {
            this.addToCriteria((Criterion)Restrictions.ge((String)HibernateQuery.this.calculatePropertyName(property), (Object)value));
            return this;
        }

        public Query lte(String property, Object value) {
            this.addToCriteria((Criterion)Restrictions.le((String)HibernateQuery.this.calculatePropertyName(property), (Object)value));
            return this;
        }

        public Query lt(String property, Object value) {
            this.addToCriteria((Criterion)Restrictions.lt((String)HibernateQuery.this.calculatePropertyName(property), (Object)value));
            return this;
        }

        public Query in(String property, List values) {
            this.addToCriteria(Restrictions.in((String)HibernateQuery.this.calculatePropertyName(property), (Collection)values));
            return this;
        }

        public Query between(String property, Object start, Object end) {
            this.addToCriteria(Restrictions.between((String)HibernateQuery.this.calculatePropertyName(property), (Object)start, (Object)end));
            return this;
        }

        public Query like(String property, String expr) {
            this.addToCriteria((Criterion)Restrictions.like((String)HibernateQuery.this.calculatePropertyName(property), (Object)HibernateQuery.this.calculatePropertyName(expr)));
            return this;
        }

        public Query ilike(String property, String expr) {
            this.addToCriteria(Restrictions.ilike((String)HibernateQuery.this.calculatePropertyName(property), (Object)HibernateQuery.this.calculatePropertyName(expr)));
            return this;
        }

        public Query rlike(String property, String expr) {
            this.addToCriteria(new RlikeExpression(HibernateQuery.this.calculatePropertyName(property), HibernateQuery.this.calculatePropertyName(expr)));
            return this;
        }
    }

    private class HibernateProjectionList
    extends Query.ProjectionList {
        org.hibernate.criterion.ProjectionList projectionList = Projections.projectionList();

        private HibernateProjectionList() {
        }

        public org.hibernate.criterion.ProjectionList getHibernateProjectionList() {
            return this.projectionList;
        }

        public Query.ProjectionList add(Query.Projection p) {
            this.projectionList.add(new HibernateProjectionAdapter(p).toHibernateProjection());
            return this;
        }

        public ProjectionList countDistinct(String property) {
            this.projectionList.add((Projection)Projections.countDistinct((String)HibernateQuery.this.calculatePropertyName(property)));
            return this;
        }

        public ProjectionList distinct(String property) {
            this.projectionList.add(Projections.distinct((Projection)Projections.property((String)HibernateQuery.this.calculatePropertyName(property))));
            return this;
        }

        public ProjectionList rowCount() {
            this.projectionList.add(Projections.rowCount());
            return this;
        }

        public Query.ProjectionList id() {
            this.projectionList.add((Projection)Projections.id());
            return this;
        }

        public Query.ProjectionList count() {
            this.projectionList.add(Projections.rowCount());
            return this;
        }

        public Query.ProjectionList property(String name) {
            this.projectionList.add((Projection)Projections.property((String)HibernateQuery.this.calculatePropertyName(name)));
            return this;
        }

        public Query.ProjectionList sum(String name) {
            this.projectionList.add((Projection)Projections.sum((String)HibernateQuery.this.calculatePropertyName(name)));
            return this;
        }

        public Query.ProjectionList min(String name) {
            this.projectionList.add((Projection)Projections.min((String)HibernateQuery.this.calculatePropertyName(name)));
            return this;
        }

        public Query.ProjectionList max(String name) {
            this.projectionList.add((Projection)Projections.max((String)HibernateQuery.this.calculatePropertyName(name)));
            return this;
        }

        public Query.ProjectionList avg(String name) {
            this.projectionList.add((Projection)Projections.avg((String)HibernateQuery.this.calculatePropertyName(name)));
            return this;
        }

        public Query.ProjectionList distinct() {
            HibernateQuery.this.criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            return this;
        }
    }

    private class HibernateJunction
    extends Query.Junction {
        private Junction hibernateJunction;
        private String alias;

        public HibernateJunction(Junction junction, String alias) {
            this.hibernateJunction = junction;
            this.alias = alias;
        }

        public Query.Junction add(Query.Criterion c) {
            if (c != null) {
                if (c instanceof FunctionCallingCriterion) {
                    Criterion sqlRestriction = HibernateQuery.this.getRestrictionForFunctionCall((FunctionCallingCriterion)c, HibernateQuery.this.entity);
                    if (sqlRestriction != null) {
                        this.hibernateJunction.add(sqlRestriction);
                    }
                } else {
                    HibernateCriterionAdapter adapter = new HibernateCriterionAdapter(HibernateQuery.this.getEntity(), c, this.alias);
                    Criterion criterion = adapter.toHibernateCriterion(HibernateQuery.this);
                    if (criterion != null) {
                        this.hibernateJunction.add(criterion);
                    }
                }
            }
            return this;
        }
    }
}

