/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.grails.orm.hibernate.support.HibernatePersistenceContextInterceptor;
import org.codehaus.groovy.grails.support.PersistenceContextInterceptor;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatePersistenceContextInterceptor
implements PersistenceContextInterceptor,
InitializingBean,
ApplicationContextAware {
    private List<PersistenceContextInterceptor> interceptors = new ArrayList<PersistenceContextInterceptor>();
    private List<String> dataSourceNames = new ArrayList<String>();
    private ApplicationContext applicationContext;

    public boolean isOpen() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            if (!interceptor.isOpen()) continue;
            return true;
        }
        return false;
    }

    public void reconnect() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            interceptor.reconnect();
        }
    }

    public void destroy() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            if (!interceptor.isOpen()) continue;
            interceptor.destroy();
        }
    }

    public void clear() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            interceptor.clear();
        }
    }

    public void disconnect() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            interceptor.disconnect();
        }
    }

    public void flush() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            interceptor.flush();
        }
    }

    public void init() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            interceptor.init();
        }
    }

    public void setReadOnly() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            interceptor.setReadOnly();
        }
    }

    public void setReadWrite() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            interceptor.setReadWrite();
        }
    }

    public void setDataSourceNames(List<String> names) {
        this.dataSourceNames = names;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.applicationContext = ctx;
    }

    public void afterPropertiesSet() {
        for (String name : this.dataSourceNames) {
            String suffix = name == "DEFAULT" ? "" : "_" + name;
            HibernatePersistenceContextInterceptor interceptor = new HibernatePersistenceContextInterceptor();
            String beanName = "sessionFactory" + suffix;
            if (this.applicationContext.containsBean(beanName)) {
                interceptor.setSessionFactory((SessionFactory)this.applicationContext.getBean(beanName));
            }
            this.interceptors.add(interceptor);
        }
    }
}

