/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.engine.internal;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.SortedSet;
import java.util.TreeSet;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;

public class MappingUtils {
    public static String getTargetKey(PersistentProperty property) {
        String tmp;
        PropertyMapping mapping = property.getMapping();
        String targetName = mapping != null && mapping.getMappedForm() != null ? ((tmp = ((Property)mapping.getMappedForm()).getTargetName()) != null ? tmp : property.getName()) : property.getName();
        return targetName;
    }

    public static Collection createConcreteCollection(Class interfaceType) {
        AbstractCollection elements = interfaceType.equals(List.class) ? new ArrayList() : (interfaceType.equals(SortedSet.class) ? new TreeSet() : (interfaceType.equals(Queue.class) ? new ArrayDeque() : new HashSet()));
        return elements;
    }

    public static Class getGenericTypeForProperty(Class javaClass, String propertyName) {
        Class genericClass = null;
        try {
            Type[] typeArguments;
            Field declaredField = javaClass.getDeclaredField(propertyName);
            Type genericType = declaredField.getGenericType();
            if (genericType instanceof ParameterizedType && (typeArguments = ((ParameterizedType)genericType).getActualTypeArguments()).length > 0) {
                genericClass = (Class)typeArguments[0];
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return genericClass;
    }

    public static Class getGenericType(Class propertyType) {
        Type[] bounds;
        Class genericType = null;
        TypeVariable<Class<T>>[] typeParameters = propertyType.getTypeParameters();
        if (typeParameters != null && typeParameters.length > 0 && (bounds = typeParameters[0].getBounds()) != null && bounds.length > 0 && bounds[0] instanceof Class) {
            genericType = (Class)bounds[0];
        }
        return genericType;
    }
}

