/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.model;

import groovy.lang.Closure;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.grails.datastore.mapping.config.groovy.MappingConfigurationBuilder;
import org.grails.datastore.mapping.core.EntityCreationException;
import org.grails.datastore.mapping.model.AbstractClassMapping;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.OneToMany;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistentEntity<T>
implements PersistentEntity {
    protected Class javaClass;
    protected List<PersistentProperty> persistentProperties;
    protected List<Association> associations;
    protected Map<String, PersistentProperty> propertiesByName = new HashMap<String, PersistentProperty>();
    protected MappingContext context;
    protected PersistentProperty identity;
    protected PersistentProperty version;
    protected List<String> persistentPropertyNames;
    private String decapitalizedName;
    protected Set owners;
    private PersistentEntity parentEntity;
    private boolean external;
    private MappingProperties mappingProperties = new MappingProperties();
    private boolean initialized = false;

    public AbstractPersistentEntity(Class javaClass, MappingContext context) {
        Assert.notNull((Object)javaClass, (String)"The argument [javaClass] cannot be null");
        this.javaClass = javaClass;
        this.context = context;
        this.decapitalizedName = Introspector.decapitalize(javaClass.getSimpleName());
    }

    @Override
    public boolean isExternal() {
        return this.external;
    }

    @Override
    public void setExternal(boolean external) {
        this.external = external;
    }

    @Override
    public MappingContext getMappingContext() {
        return this.context;
    }

    @Override
    public void initialize() {
        this.initializeMappingProperties();
        this.owners = this.context.getMappingSyntaxStrategy().getOwningEntities(this.javaClass, this.context);
        this.persistentProperties = this.context.getMappingSyntaxStrategy().getPersistentProperties(this, this.context, this.getMapping());
        this.identity = this.resolveIdentifier();
        this.persistentPropertyNames = new ArrayList<String>();
        this.associations = new ArrayList<Association>();
        for (PersistentProperty persistentProperty : this.persistentProperties) {
            if (!(persistentProperty instanceof OneToMany)) {
                this.persistentPropertyNames.add(persistentProperty.getName());
            }
            if (persistentProperty instanceof Association) {
                this.associations.add((Association)persistentProperty);
            }
            this.propertiesByName.put(persistentProperty.getName(), persistentProperty);
        }
        Class superClass = this.javaClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class) && !Modifier.isAbstract(superClass.getModifiers())) {
            this.parentEntity = this.context.addPersistentEntity(superClass);
        }
        this.getMapping().getMappedForm();
        if (this.mappingProperties.isVersioned()) {
            this.version = this.propertiesByName.get("version");
        }
        this.initialized = true;
    }

    protected PersistentProperty resolveIdentifier() {
        return this.context.getMappingSyntaxStrategy().getIdentity(this.javaClass, this.context);
    }

    @Override
    public boolean hasProperty(String name, Class type) {
        PropertyDescriptor pd = BeanUtils.getPropertyDescriptor((Class)this.getJavaClass(), (String)name);
        return pd != null && pd.getPropertyType().equals(type);
    }

    @Override
    public boolean isIdentityName(String propertyName) {
        return this.getIdentity().getName().equals(propertyName);
    }

    @Override
    public PersistentEntity getParentEntity() {
        return this.parentEntity;
    }

    @Override
    public String getDiscriminator() {
        return this.getJavaClass().getSimpleName();
    }

    @Override
    public PersistentEntity getRootEntity() {
        PersistentEntity root = this;
        for (PersistentEntity parent = this.getParentEntity(); parent != null; parent = parent.getParentEntity()) {
            root = parent;
        }
        return root;
    }

    @Override
    public boolean isRoot() {
        return this.getParentEntity() == null;
    }

    @Override
    public boolean isOwningEntity(PersistentEntity owner) {
        return owner != null && this.owners.contains(owner.getJavaClass());
    }

    @Override
    public String getDecapitalizedName() {
        return this.decapitalizedName;
    }

    @Override
    public List<String> getPersistentPropertyNames() {
        return this.persistentPropertyNames;
    }

    @Override
    public ClassMapping<T> getMapping() {
        return new AbstractClassMapping<T>(this, this.context){

            @Override
            public T getMappedForm() {
                return null;
            }
        };
    }

    @Override
    public Object newInstance() {
        try {
            return this.getJavaClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new EntityCreationException("Unable to create entity of type [" + this.getJavaClass().getName() + "]: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new EntityCreationException("Unable to create entity of type [" + this.getJavaClass().getName() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return this.javaClass.getName();
    }

    @Override
    public PersistentProperty getIdentity() {
        return this.identity;
    }

    @Override
    public PersistentProperty getVersion() {
        return this.version;
    }

    @Override
    public boolean isVersioned() {
        return (!this.initialized || this.version != null) && this.mappingProperties.isVersioned();
    }

    @Override
    public Class getJavaClass() {
        return this.javaClass;
    }

    @Override
    public boolean isInstance(Object obj) {
        return this.getJavaClass().isInstance(obj);
    }

    @Override
    public List<PersistentProperty> getPersistentProperties() {
        return this.persistentProperties;
    }

    @Override
    public List<Association> getAssociations() {
        return this.associations;
    }

    @Override
    public PersistentProperty getPropertyByName(String name) {
        return this.propertiesByName.get(name);
    }

    private void initializeMappingProperties() {
        Object mappingVersion;
        MappingConfigurationBuilder builder = new MappingConfigurationBuilder(this.mappingProperties, MappingProperties.class);
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(this.getJavaClass());
        Closure value = cpf.getStaticPropertyValue("mapping", Closure.class);
        if (value != null) {
            builder.evaluate(value);
        }
        if ((mappingVersion = builder.getProperties().get(MappingConfigurationBuilder.VERSION_KEY)) instanceof Boolean) {
            this.mappingProperties.setVersion((Boolean)mappingVersion);
        }
    }

    public int hashCode() {
        return this.javaClass.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PersistentEntity)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        PersistentEntity other = (PersistentEntity)o;
        return this.javaClass.equals(other.getJavaClass());
    }

    public String toString() {
        return this.javaClass.getName();
    }

    private static class MappingProperties {
        private Boolean version = true;

        private MappingProperties() {
        }

        public void setVersion(boolean version) {
            this.version = version;
        }

        public boolean isVersioned() {
            return this.version == null ? true : this.version;
        }
    }
}

