/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.js.ajax.tiles2;

import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.Definition;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.impl.BasicTilesContainer;
import org.springframework.js.ajax.AjaxHandler;
import org.springframework.js.ajax.SpringJavascriptAjaxHandler;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.JstlUtils;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.servlet.view.tiles2.TilesView;

public class AjaxTilesView
extends TilesView {
    private static final String FRAGMENTS_PARAM = "fragments";
    private AjaxHandler ajaxHandler = new SpringJavascriptAjaxHandler();

    public AjaxHandler getAjaxHandler() {
        return this.ajaxHandler;
    }

    public void setAjaxHandler(AjaxHandler ajaxHandler) {
        this.ajaxHandler = ajaxHandler;
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletContext servletContext = this.getServletContext();
        if (this.ajaxHandler.isAjaxRequest(request, response)) {
            String[] attrNames = this.getRenderFragments(model, request, response);
            if (attrNames.length == 0) {
                this.logger.warn((Object)"An Ajax request was detected, but no fragments were specified to be re-rendered.  Falling back to full page render.  This can cause unpredictable results when processing the ajax response on the client.");
                super.renderMergedOutputModel(model, request, response);
                return;
            }
            BasicTilesContainer container = (BasicTilesContainer)TilesAccess.getContainer((Object)servletContext);
            if (container == null) {
                throw new ServletException("Tiles container is not initialized. Have you added a TilesConfigurer to your web application context?");
            }
            this.exposeModelAsRequestAttributes(model, request);
            JstlUtils.exposeLocalizationContext((RequestContext)new RequestContext(request, servletContext));
            TilesRequestContext tilesRequestContext = container.getContextFactory().createRequestContext(container.getApplicationContext(), new Object[]{request, response});
            Definition compositeDefinition = container.getDefinitionsFactory().getDefinition(this.getUrl(), tilesRequestContext);
            HashMap flattenedAttributeMap = new HashMap();
            this.flattenAttributeMap(container, tilesRequestContext, flattenedAttributeMap, compositeDefinition, request, response);
            request.getSession();
            response.flushBuffer();
            int i = 0;
            while (i < attrNames.length) {
                Attribute attributeToRender = (Attribute)flattenedAttributeMap.get(attrNames[i]);
                if (attributeToRender == null) {
                    throw new ServletException("No tiles attribute with a name of '" + attrNames[i] + "' could be found for the current view: " + (Object)((Object)this));
                }
                container.render(attributeToRender, (Writer)response.getWriter(), new Object[]{request, response});
                ++i;
            }
        } else {
            super.renderMergedOutputModel(model, request, response);
        }
    }

    protected String[] getRenderFragments(Map model, HttpServletRequest request, HttpServletResponse response) {
        String attrName = request.getParameter(FRAGMENTS_PARAM);
        String[] renderFragments = StringUtils.commaDelimitedListToStringArray((String)attrName);
        return StringUtils.trimArrayElements((String[])renderFragments);
    }

    protected void flattenAttributeMap(BasicTilesContainer container, TilesRequestContext requestContext, Map resultMap, Definition compositeDefinition, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (compositeDefinition.getAttributes() != null && compositeDefinition.getAttributes().size() > 0) {
            Iterator i = compositeDefinition.getAttributes().keySet().iterator();
            while (i.hasNext()) {
                Definition nestedDefinition;
                Attribute.AttributeType attrType;
                Object key = i.next();
                Attribute attr = (Attribute)compositeDefinition.getAttributes().get(key);
                Attribute.AttributeType attributeType = attrType = attr.getType() != null ? attr.getType() : this.detectType(container, requestContext, attr);
                if (!Attribute.AttributeType.DEFINITION.equals((Object)attrType) && !Attribute.AttributeType.TEMPLATE.equals((Object)attrType)) continue;
                resultMap.put(key, attr);
                if (!Attribute.AttributeType.DEFINITION.equals((Object)attrType) || (nestedDefinition = container.getDefinitionsFactory().getDefinition(attr.getValue().toString(), requestContext)) == null || nestedDefinition == compositeDefinition) continue;
                this.flattenAttributeMap(container, requestContext, resultMap, nestedDefinition, request, response);
            }
        }
        AttributeContext attributeContext = container.getAttributeContext(new Object[]{request, response});
        Iterator i = attributeContext.getAttributeNames();
        while (i.hasNext()) {
            String key = (String)i.next();
            Attribute attr = attributeContext.getAttribute(key);
            resultMap.put(key, attr);
        }
    }

    private Attribute.AttributeType detectType(BasicTilesContainer container, TilesRequestContext requestContext, Attribute attr) throws DefinitionsFactoryException {
        if (attr.getValue() instanceof String) {
            if (container.getDefinitionsFactory().getDefinition(attr.getValue().toString(), requestContext) != null) {
                return Attribute.AttributeType.DEFINITION;
            }
            if (attr.getValue().toString().startsWith("/")) {
                return Attribute.AttributeType.TEMPLATE;
            }
            return Attribute.AttributeType.STRING;
        }
        return Attribute.AttributeType.OBJECT;
    }
}

